

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetUpdateAgentList.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: List all clients which have this package/apptype installed. It includes deconfigured and restire only agents.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetUpdateAgentList <<<'

IF EXISTS (select * from sysobjects where name='GetUpdateAgentList')
	drop procedure GetUpdateAgentList
IF EXISTS (select * from GxQscripts where name='GetUpdateAgentList')
	delete from GxQscripts where name = 'GetUpdateAgentList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetUpdateAgentList')
	delete from GXDBVersions where aliasname = 'GetUpdateAgentList'
GO
print '... Creating Procedure: GetUpdateAgentList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetUpdateAgentList
  @inputxml XML
AS
SET NOCOUNT ON
DECLARE @userId INT
SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS client FROM    @inputxml.nodes('Api_GetUpdateAgentList/processinginstructioninfo/user') R ( ref )),0)
IF OBJECT_ID('tempdb.dbo.#clientList') IS NOT NULL DROP TABLE #clientList
CREATE TABLE #clientList
(
t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
)
EXEC sec_getIdaObjectsForUser @userId,3,0,1,'#clientList'
SELECT AC.id AS '@clientId',
              AC.NAME  AS '@clientName'
       FROM   app_client AC WITH (NOLOCK)
JOIN patchupdateagentinfo PUA WITH (NOLOCK) ON ac.id = PUA.clientId
JOIN #clientList CLS WITH (NOLOCK) ON  CLS.t_clientId = PUA.clientId
WHERE PUA.isdeleted = 0 AND PUA.clientid <> 2
FOR XML PATH('clients'),ROOT('Api_GetUpdateAgentList')
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetUpdateAgentList')
	delete from GxQscripts where name = 'GetUpdateAgentList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetUpdateAgentList')
	delete from GXDBVersions where aliasname = 'GetUpdateAgentList'
GO

insert into GXDBVersions values(2, 'GetUpdateAgentList',  '00000000000000000000', 'GetUpdateAgentList', '00000000000000000000')
GO

