

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetUAAssocClAndPkgList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- $Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetUAAssocClAndPkgList.sp,v $ $Id: GetUAAssocClAndPkgList.sp,v 1.5.34.1 2017/02/10 19:55:36 sjohnson Exp $";
--  +========================================================================+
--  | Stored Proc:  GetUAAssocClAndPkgList()
--  |
--  | Description: Get Associated Client And package list for the remote cache
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetUAAssocClAndPkgList <<<'

IF EXISTS (select * from sysobjects where name='GetUAAssocClAndPkgList')
	drop procedure GetUAAssocClAndPkgList
IF EXISTS (select * from GxQscripts where name='GetUAAssocClAndPkgList')
	delete from GxQscripts where name = 'GetUAAssocClAndPkgList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetUAAssocClAndPkgList')
	delete from GXDBVersions where aliasname = 'GetUAAssocClAndPkgList'
GO
print '... Creating Procedure: GetUAAssocClAndPkgList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetUAAssocClAndPkgList
  @inUAClientId integer,
  @inOSId integer,
  @inOperationType integer
AS
  DECLARE @UAClientId integer
  DECLARE @releaseId integer	
  DECLARE @updateOSId integer	
  DECLARE @binarySetId integer
  DECLARE @PackageList nvarchar(MAX)
SET NOCOUNT ON
BEGIN
IF object_id('tempdb.dbo.#UA_ClientPackageInfo') IS NOT null DROP TABLE #UA_ClientPackageInfo
IF object_id('tempdb.dbo.#UA_ClientListForUA') IS NOT null DROP TABLE #UA_ClientListForUA
IF object_id('tempdb.dbo.#UA_ClientListOfClientGroup') IS NOT null DROP TABLE #UA_ClientListOfClientGroup
IF object_id('tempdb.dbo.#AU_Temp0') IS NOT null DROP TABLE #AU_Temp0
IF object_id('tempdb.dbo.#AU_Temp1') IS NOT null DROP TABLE #AU_Temp1
IF object_id('tempdb.dbo.#AU_Temp2') IS NOT null DROP TABLE #AU_Temp2
-- create the temp table to maintain the list of OS and packages for the remote caches
CREATE TABLE #UA_ClientPackageInfo
(
	UAClientId	integer	NOT null,
	releaseId   integer NOT null,
	updateOSId	integer	NOT null,
	binarySetId	integer NOT null,
	PackageList	nvarchar(MAX)default null
)
-- create the temp table to maintain the list of associated clientIds
CREATE TABLE #UA_ClientListForUA
(
	clientId	integer	NOT null,
	releaseId	integer NOT null,
	bsId integer NOT null,
	updateOSId integer NOT null
)
-- create the temp table to maintain the list of clientIds of client group
CREATE TABLE #UA_ClientListOfClientGroup
(
	clientId	integer	NOT null
)
-- USED TO HOLD SPLIT RESULTS FROM APPTYPES
 CREATE TABLE #AU_Temp0
 (
   TmpIDStr	VARCHAR(255)
 )
 -- create the temp table to maintain the list of associated OS and pkgIds for a remote cache
CREATE TABLE #AU_Temp1
(
	releaseId   integer NOT null,
	updateOSId	integer	NOT null,
	binarySetId	integer NOT null,
	PackageId	integer NOT null
)
-- create the temp table to maintain the distinct list of OS and packages for the remote caches
CREATE TABLE #AU_Temp2
(
	releaseId   integer NOT null,
	updateOSId	integer	NOT null,
	binarySetId	integer NOT null,
	PackageId	integer NOT null
)
-- Cursor With the list of remote caches for which the associated OS and package list needs to be calcuated
-- If @inOperationType=1, calcuate for all the remote caches
-- Else,calcuate for the given remote cache @inUAClientId
DECLARE @tmpUAClId INTEGER
DECLARE @tmpUAId INTEGER
DECLARE GetOSAndPkgsForAssocClOfUA CURSOR FOR
  SELECT id,clientId FROM PatchUpdateAgentInfo WHERE (@inOperationType = 1 AND clientId > 2) OR (clientId = @inUAClientId)
  OPEN GetOSAndPkgsForAssocClOfUA
  FETCH NEXT FROM  GetOSAndPkgsForAssocClOfUA INTO @tmpUAId,@tmpUAClId
  WHILE @@FETCH_STATUS = 0
  BEGIN
	TRUNCATE TABLE #UA_ClientListForUA
	insert into #UA_ClientListForUA
		select distinct componentnameId,0,0,0 from app_clientProp where attrName = 'UPDATE CACHE AGENT ID' and attrVal = CONVERT(VARCHAR(64),@tmpUAId) and modified=0
	--Cursor to get the list of client group Ids associated with the remote cache
	DECLARE @tmpClGrpId INTEGER
	DECLARE GetClientGroupsForUA CURSOR FOR
		SELECT distinct componentId FROM APP_ComponentProp where propertyTypeId=1300 and componentType=8 and longVal=@tmpUAId and modified=0
		OPEN GetClientGroupsForUA
		FETCH NEXT FROM  GetClientGroupsForUA INTO @tmpClGrpId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			--Get the list of clientIds for the client group and insert in the #UA_ClientListForUA table
			TRUNCATE TABLE #UA_ClientListOfClientGroup
			insert into #UA_ClientListOfClientGroup
				select distinct clientId from APP_ClientGroupAssoc where clientGroupId=@tmpClGrpId and clientId NOT IN(select clientId from #UA_ClientListForUA)
			insert into #UA_ClientListForUA
				select clientId,0,0,0 from #UA_ClientListOfClientGroup
			FETCH NEXT FROM GetClientGroupsForUA INTO @tmpClGrpId
		END
	CLOSE GetClientGroupsForUA
	DEALLOCATE GetClientGroupsForUA
	--delete the client if it is not found in App_Client table
	delete from #UA_ClientListForUA where clientId NOT IN(select id from App_Client)
	--delete the client if it doesn't have any packages on the client
	delete from #UA_ClientListForUA where clientId NOT IN(select distinct clientId from simInstalledPackages)
	--set the release and binary set id
	UPDATE #UA_ClientListForUA SET releaseId=(select releaseId from App_Client where id=clientId),
		bsId=ISNULL((select CONVERT(INT,attrVal) from APP_ClientProp where componentNameId=clientId and attrName='Binary Set ID'),0)
	--delete the client if BinarysetId is not found
	delete from #UA_ClientListForUA where bsId=0
	--set NewUpdateOSID always because this information is used to sync the packages, which will be 10.0+
	UPDATE #UA_ClientListForUA SET updateOSId= P.NewUpdateOSID FROM PatchUpdateOS P where P.BinarySetID = bsId
	--If @inOperationType = 3 process only the given update OS, delete the remaining
	IF (@inOperationType = 3)
	BEGIN
		delete from #UA_ClientListForUA where updateOSId != @inOSId
	END
	--delete the rows from temp tables
	delete from #AU_Temp1
	delete from #AU_Temp2
	--Cursor to get the package list for each client of UA
	DECLARE @tmpClId INTEGER
	DECLARE @tmpupdOsId INTEGER
	DECLARE @tmpBsId INTEGER
	DECLARE @tmpRelId INTEGER
	DECLARE GetOSAndPackagesForClList CURSOR FOR
		SELECT clientId,releaseId,updateOSId,bsId FROM #UA_ClientListForUA
		OPEN GetOSAndPackagesForClList
		FETCH NEXT FROM  GetOSAndPackagesForClList INTO @tmpClId,@tmpRelId,@tmpupdOsId,@tmpBsId
		WHILE @@FETCH_STATUS = 0
		BEGIN
			insert into #AU_Temp1 select @tmpRelId,@tmpupdOsId,@tmpBsId,simPackageId FROM simInstalledPackages where ClientId=@tmpClId
			FETCH NEXT FROM GetOSAndPackagesForClList INTO @tmpClId,@tmpRelId,@tmpupdOsId,@tmpBsId
		END
	CLOSE GetOSAndPackagesForClList
	DEALLOCATE GetOSAndPackagesForClList
	-- #AU_Temp1 table has the package list of all cleints of the remote cache, remove the duplicates
	insert into #AU_Temp2 select distinct * from #AU_Temp1
	-- #AU_Temp2 table has the distinct package list of all cleints of the remote cache, concatinate it by grouping with relId, osId, bsId and insert in the #UA_ClientPackageInfo
	insert into #UA_ClientPackageInfo select distinct @tmpUAClId,releaseId,updateOSId,binarySetId,
											 STUFF((select ','+CONVERT(VARCHAR(64),[PackageId]) from #AU_Temp2 t1
												where t1.updateOSId=t2.updateOSId and t2.binarySetId=t1.binarySetId and t1.releaseId=t2.releaseId
												for xml path(''), type).value('.', 'varchar(max)'), 1, 1, '') from #AU_Temp2 t2
	--If the remote cache is one touch server, include win32 and winx64 OS for all the releases
IF EXISTS ( select * from simInstalledPackages where ClientId=@tmpUAClId and simPackageID=554)
	BEGIN
		DECLARE @relId INTEGER
		DECLARE @win32BsId INTEGER
		DECLARE @winX64BsId INTEGER
		--get the win32 and winx64 bsId
		select  @win32BsId =id from simBinarySet where name='win32'
		select  @winX64BsId =id from simBinarySet where name='winx64'
		select @relId=releaseId from App_Client where id=@tmpUAClId
			--insert win32 for @relId
			IF NOT EXISTS(select * from #UA_ClientPackageInfo where UAClientId=@tmpUAClId and updateOSId=@win32BsId and binarySetId=@win32BsId and releaseId=@relId)
			BEGIN
				--If the win32 is not present for UA, insert it
				insert into #UA_ClientPackageInfo values(@tmpUAClId,@relId,@win32BsId,@win32BsId,'')
			END
			ELSE
			BEGIN
				UPDATE #UA_ClientPackageInfo SET PackageList='' where UAClientId=@tmpUAClId and updateOSId=@win32BsId and binarySetId=@win32BsId and releaseId=@relId
			END
			--insert winx64 for @relId
			IF NOT EXISTS(select * from #UA_ClientPackageInfo where UAClientId=@tmpUAClId and updateOSId=@winX64BsId and binarySetId=@winX64BsId and releaseId=@relId)
			BEGIN
				--If the win32 is not present for UA, insert it
				insert into #UA_ClientPackageInfo values(@tmpUAClId,@relId,@winX64BsId,@winX64BsId,'')
			END
			ELSE
			BEGIN
				UPDATE #UA_ClientPackageInfo SET PackageList='' where UAClientId=@tmpUAClId and updateOSId=@winX64BsId and binarySetId=@winX64BsId and releaseId=@relId
			END
	END
	FETCH NEXT FROM GetOSAndPkgsForAssocClOfUA INTO @tmpUAId,@tmpUAClId
  END
CLOSE GetOSAndPkgsForAssocClOfUA
DEALLOCATE GetOSAndPkgsForAssocClOfUA
select 	* from #UA_ClientPackageInfo
DROP TABLE #UA_ClientPackageInfo
DROP TABLE #UA_ClientListForUA
DROP TABLE #UA_ClientListOfClientGroup
DROP TABLE #AU_Temp0
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetUAAssocClAndPkgList')
	delete from GxQscripts where name = 'GetUAAssocClAndPkgList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetUAAssocClAndPkgList')
	delete from GXDBVersions where aliasname = 'GetUAAssocClAndPkgList'
GO

insert into GXDBVersions values(2, 'GetUAAssocClAndPkgList',  '00010005003400010000', 'GetUAAssocClAndPkgList', '00010005003400010000')
GO

