

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetTargetAppForDCPlan.sp] ---------- 

-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "GetTargetAppForDCPlan"
--	|	This Procedure is used to get all DC plans that satisfies the input conditions
-- 	+-----------------------------------------------------------------------+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='GetTargetAppForDCPlan')
BEGIN
	print '>>> Drop Stored Procedure: GetTargetAppForDCPlan <<<'
	drop procedure GetTargetAppForDCPlan
END
IF EXISTS (select * from GxQscripts where name='GetTargetAppForDCPlan')
	delete from GxQscripts where name = 'GetTargetAppForDCPlan'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetTargetAppForDCPlan')
	delete from GXDBVersions where aliasname = 'GetTargetAppForDCPlan'
GO
print '... Creating Procedure: GetTargetAppForDCPlan'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure GetTargetAppForDCPlan
  @i_PlanId INT
AS
SET NOCOUNT ON
IF (@i_PlanId > 0)
BEGIN
	-- verify if plan is dc plan
IF (EXISTS(SELECT 1 FROM App_Plan (NOLOCK) WHERE id = @i_PlanId AND subType = 117506053))
	BEGIN
		DECLARE @targetApp NVARCHAR(10)
		-- get target app property
SET @targetApp = dbo.AppPlanGetEntityValueV2(@i_PlanId, 'Target app',  default)
		IF (@targetApp IS NULL) -- target is null only for SDG and FSO, other apps always have target app property
		BEGIN
			-- check if entity is enabled
			DECLARE @eePolicyId INT
SET @eePolicyId = dbo.AppPlanGetEntityValueV2(@i_PlanId, 'Data classification policy',  default)
			SELECT 	CASE
						WHEN (ISNULL(@eePolicyId, 0) > 0) THEN 2 -- ContentIndexing_Target_App.CI_TARGET_SDG
						ELSE 1 -- ContentIndexing_Target_App.CI_TARGET_FSO
					END AS TargetApp
		END
		ELSE
		BEGIN
			-- target app property is available, cast to int
			SELECT CAST(@targetApp AS INT) AS TargetApp
		END
	END
	ELSE
	BEGIN
		SELECT -1 AS TargetApp -- invalid, not DC plan
	END
END
ELSE
BEGIN
	SELECT -1 AS TargetApp -- invalid planId
END
GO

IF EXISTS (select * from GxQscripts where name = 'GetTargetAppForDCPlan')
	delete from GxQscripts where name = 'GetTargetAppForDCPlan'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetTargetAppForDCPlan')
	delete from GXDBVersions where aliasname = 'GetTargetAppForDCPlan'
GO

insert into GXDBVersions values(2, 'GetTargetAppForDCPlan',  '00000000000000000000', 'GetTargetAppForDCPlan', '00000000000000000000')
GO

