

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetTMMedia.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetTMMedia.sp,v $ $Id: GetTMMedia.sp,v 1.18.12.2 2018/03/20 19:58:30 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: GetTMMedia()
--  |
--  | Description:  Run the media movement rule to return a list of media.
--  |
--  |	    Input:  integer i_commcellId, i_policyId, i_ruleId
--  |
--  |
--  |      Return:  Return code and error string.
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        awang    Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetTMMedia <<<'

IF EXISTS (select * from sysobjects where name='GetTMMedia')
	drop procedure GetTMMedia
IF EXISTS (select * from GxQscripts where name='GetTMMedia')
	delete from GxQscripts where name = 'GetTMMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetTMMedia')
	delete from GXDBVersions where aliasname = 'GetTMMedia'
GO
print '... Creating Procedure: GetTMMedia'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetTMMedia
  @i_commcellId INTEGER,
  @i_jobId_h INTEGER,
  @i_jobId_l INTEGER
AS
  DECLARE @r_policyId integer;
  DECLARE @r_jobId_l integer;
  DECLARE @r_jobId_h integer;
  DECLARE @r_actionId integer;
  DECLARE @r_mediaId integer;
  DECLARE @r_barCode char(256);
  DECLARE @r_destLocationId integer;
  DECLARE @r_destLocationName char(64);
  DECLARE @r_operation integer;
  DECLARE @r_operationState integer;
  DECLARE @r_flag integer;
  DECLARE @r_exportLocationId integer;
  DECLARE @r_exportLocation NVARCHAR(64);
  DECLARE @r_inTransitId integer;
  DECLARE @r_actionFlag integer;
  DECLARE @r_InMediaExport integer;
SET NOCOUNT ON
	IF OBJECT_ID('tempdb.dbo.#tmpMoveMediaList') IS NOT NULL DROP TABLE #tmpMoveMediaList
	CREATE TABLE #tmpMoveMediaList(PolicyId INT,
					JobId_l INT,
					JobId_h INT,
					ActionId INT,
					MediaId INT,
BarCode varchar(256),
					DestinationId INT,
LocationName varchar(64),
					Operation INT,
					OperationState INT,
					Flag INT,
					ExportLocationId INT,
ExportLocation nvarchar(64),
					InTransitId INT,
					SlotId INT,
					LibraryId INT,
					MediaLocation INT,
					BayId INT,
					vmsSlot integer,
					vmsDirection INT,
					Weight INT,
					ActionFlag INT,
					InMediaExport INT,
					SpareGroupId   INT,
					MediaGroupId   INT,
					Attributes		INT,
					IsAged		INT,
					IsInMediaGroup INT,
					LastWriteLibraryId	INT)
	create index #tmpMoveMediaList_vmsDirection on  #tmpMoveMediaList (vmsDirection, bayId)
	INSERT INTO #tmpMoveMediaList
	SELECT c.PolicyId, c.JobId_l, c.JobId_h, a.ActionId, a.MediaId, b.BarCode, c.DestinationId, '',
	a.Operation, a.OperationState, a.Flag, b.ExportLocationId, e.ExportLocation, c.InTransitId,
	0, b.LibraryId, b.MediaLocation, 0, '', 0, 0, c.Flag, 0, b.SpareGroupId, 0,
	b.Attributes, b.IsAged, b.IsInMediaGroup, b.LastWriteLibraryId
	FROM VTActionMedia a WITH (READUNCOMMITTED), MMMedia b WITH (READUNCOMMITTED),
	VTAction c WITH (READUNCOMMITTED), VTLocation d WITH (READUNCOMMITTED), MMExportLocation e WITH (READUNCOMMITTED)
	WHERE
(a.Operation & (1 | 2 |
8 | 16)) > 0
	AND	b.MediaId = a.MediaId
	AND a.ActionId = c.ActionId
	AND c.DestinationId = d.LocationId
	AND b.ExportLocationId = e.ExportLocationId
	IF	@i_jobId_h != 0
	OR	@i_jobId_l != 0
	BEGIN
		DELETE FROM #tmpMoveMediaList
		WHERE JobId_h != @i_jobId_h
		OR JobId_l != @i_jobId_l
	END
   --Set the libraryId to the lastWritelibararyId for assigned media instead of
   -- going through Volume, MG and SPG tables
	UPDATE #tmpMoveMediaList
	SET	LibraryId = LastWriteLibraryId
	WHERE	LibraryId = 0 AND IsInMediaGroup = 1
   --Update the LibraryId through spareGroup tables for the media which are exported.
	UPDATE #tmpMoveMediaList
	SET	LibraryId = e.LibraryId
	FROM	#tmpMoveMediaList a, MMSpareGroup e WITH (READUNCOMMITTED)
	WHERE	a.LibraryId = 0
	AND a.IsInMediaGroup = 0
	AND a.SpareGroupId = e.SpareGroupId
	UPDATE #tmpMoveMediaList
	SET BayId = ISNULL(g.BayId, 0), vmsSlot = ISNULL(f.StartVMSElementAddress, 0), vmsDirection = ISNULL(f.VMSDirection, 0)
	FROM #tmpMoveMediaList a, MMLibrary f WITH (READUNCOMMITTED), MMBay g WITH (READUNCOMMITTED)
	WHERE a.LibraryId = f.LibraryId
	AND g.LibraryId = f.LibraryId
	AND	a.LibraryId > 0
	AND a.MediaLocation = 1
	UPDATE #tmpMoveMediaList
	SET SlotId = ISNULL(b.SlotId, 0)
	FROM #tmpMoveMediaList a, MMSlot b WITH (READUNCOMMITTED)
	WHERE a.MediaId = b.MediaId
	AND	a.LibraryId > 0
	AND a.MediaLocation = 1
	UPDATE #tmpMoveMediaList
	SET	Weight = (a.SlotId - b.SlotId)
	FROM	#tmpMoveMediaList a, MMSlot b WITH (READUNCOMMITTED)
	WHERE	a.vmsSlot != 0
	AND 	a.vmsSlot = b.ElementAddress
	AND	a.BayId = b.BayId
AND	a.vmsDirection = 1
	AND	a.SlotId > 0
	AND 	a.SlotId >= b.SlotId
	AND		b.SlotType = 1
	UPDATE #tmpMoveMediaList
	SET	Weight = (b.SlotId - a.SlotId) + 1
	FROM	#tmpMoveMediaList a, MMSlot b WITH (READUNCOMMITTED)
	WHERE	a.vmsSlot != 0
	AND 	a.vmsSlot = b.ElementAddress
	AND	a.BayId = b.BayId
AND	a.vmsDirection = 1
	AND	a.SlotId > 0
	AND 	a.SlotId < b.SlotId
	AND		b.SlotType = 1
	UPDATE #tmpMoveMediaList
	SET	Weight = (a.SlotId - b.SlotId) + 1
	FROM	#tmpMoveMediaList a, MMSlot b WITH (READUNCOMMITTED)
	WHERE	a.vmsSlot != 0
	AND 	a.vmsSlot = b.ElementAddress
	AND	a.BayId = b.BayId
AND	a.vmsDirection = 2
	AND	a.SlotId > 0
	AND 	a.SlotId >= b.SlotId
	AND		b.SlotType = 1
	UPDATE #tmpMoveMediaList
	SET	Weight = (b.SlotId - a.SlotId)
	FROM	#tmpMoveMediaList a, MMSlot b WITH (READUNCOMMITTED)
	WHERE	a.vmsSlot != 0
	AND 	a.vmsSlot = b.ElementAddress
	AND	a.BayId = b.BayId
AND	a.vmsDirection = 2
	AND	a.SlotId > 0
	AND 	a.SlotId < b.SlotId
	AND		b.SlotType = 1
	UPDATE #tmpMoveMediaList
	SET	LocationName = b.ExportLocation
	FROM	#tmpMoveMediaList a, MMExportLocation b WITH (READUNCOMMITTED), VTLocation c WITH (READUNCOMMITTED)
	WHERE	c.Value = b.ExportLocationId
	AND 	a.DestinationId = c.LocationId
AND		c.Type = 2
	UPDATE #tmpMoveMediaList
	SET	LocationName = b.AliasName
	FROM	#tmpMoveMediaList a, MMLibrary b WITH (READUNCOMMITTED), VTLocation c WITH (READUNCOMMITTED)
	WHERE	c.Value = b.LibraryId
	AND 	a.DestinationId = c.LocationId
AND		c.Type = 1
	AND		c.Value > 0
	UPDATE #tmpMoveMediaList
	SET	LocationName = f.AliasName
	FROM	#tmpMoveMediaList a, VTLocation c WITH (READUNCOMMITTED), MMLibrary f WITH (READUNCOMMITTED)
	WHERE	a.DestinationId = c.LocationId
AND		c.Type = 1
	AND		c.Value = 0
	AND		a.LibraryId = f.LibraryId
	UPDATE #tmpMoveMediaList
	SET	LocationName = 'virtual mailslot of library ' + b.AliasName
	FROM	#tmpMoveMediaList a, MMLibrary b WITH (READUNCOMMITTED), VTLocation c WITH (READUNCOMMITTED)
	WHERE	b.LibraryId = c.Value
	AND		a.DestinationId = c.LocationId
AND		c.Type = 4
	AND		c.Value > 0
	UPDATE #tmpMoveMediaList
	SET	LocationName = 'virtual mailslot'
	FROM	#tmpMoveMediaList a, VTLocation c WITH (READUNCOMMITTED)
	WHERE	a.DestinationId = c.LocationId
AND		c.Type = 4
	AND		c.Value = 0
	AND		a.LibraryId > 0
	UPDATE #tmpMoveMediaList
	SET	InMediaExport = 1
	FROM	#tmpMoveMediaList
	WHERE	MediaId in (select MediaId from MMMediaExport)
	IF exists (select * from MMConfigs where name = 'MMCONFIG_EXPORT_MEDIA_BY_BARCODE_ORDER' and value = 1)
		SELECT PolicyId, JobId_l, JobId_h, ActionId, MediaId, BarCode, DestinationId,
			LocationName, Operation, OperationState, Flag, ExportLocationId, ExportLocation, InTransitId, ActionFlag, InMediaExport
		FROM #tmpMoveMediaList
		order by Barcode ASC
	else
		SELECT PolicyId, JobId_l, JobId_h, ActionId, MediaId, BarCode, DestinationId,
			LocationName, Operation, OperationState, Flag, ExportLocationId, ExportLocation, InTransitId, ActionFlag, InMediaExport
		FROM #tmpMoveMediaList
		order by Weight DESC, BarCode
	IF OBJECT_ID('tempdb.dbo.#tmpMoveMediaList') IS NOT NULL DROP TABLE #tmpMoveMediaList
	RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'GetTMMedia')
	delete from GxQscripts where name = 'GetTMMedia'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetTMMedia')
	delete from GXDBVersions where aliasname = 'GetTMMedia'
GO

insert into GXDBVersions values(2, 'GetTMMedia',  '00010018001200020000', 'GetTMMedia', '00010018001200020000')
GO

