

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetSybasePhyDevList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Sunil Telagamsetti
--	Date:   07/24/2012
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetSybasePhyDevList.sp,v $ $Id: GetSybasePhyDevList.sp,v 1.4.34.1 2018/03/22 01:34:06 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetSybasePhyDevList <<<'

IF EXISTS (select * from sysobjects where name='GetSybasePhyDevList')
	drop procedure GetSybasePhyDevList
IF EXISTS (select * from GxQscripts where name='GetSybasePhyDevList')
	delete from GxQscripts where name = 'GetSybasePhyDevList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSybasePhyDevList')
	delete from GXDBVersions where aliasname = 'GetSybasePhyDevList'
GO
print '... Creating Procedure: GetSybasePhyDevList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetSybasePhyDevList
  @i_clientId INT = 0,
  @i_instanceId INT = 0
AS
  DECLARE @o_phyDevName VARCHAR(127)
BEGIN
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	IF object_id('tempdb.dbo.#tempJobId') IS NOT null DROP TABLE #tempJobId
	CREATE TABLE #tempJobId ( commcellid INT, jobId INT )
	INSERT INTO #tempJobId
	SELECT	DISTINCT commcellId, jobId
	FROM	archfile AF
			INNER JOIN APP_Application A
				ON AF.appId = A.id
	WHERE	(@i_clientId = 0 OR A.clientId = @i_clientId)
		AND	(@i_instanceId = 0 OR A.instance = @i_instanceId)
		AND	A.appTypeId = 5
		AND	AF.backuplevel = 1 --FULL
		AND (A.subclientStatus & (16 | 4 | 2)) = 0 --(CV_STATUS_DUMMY | CV_STATUS_DELETED | CV_STATUS_UNINSTALLED)
	SELECT	DISTINCT d.sybDevPhyName
	FROM	sybSystemDevices d
			INNER JOIN #tempJobId j
				ON	d.sybBackupJobId_l = j.jobId AND d.commcellId = j.commcellId
	IF object_id('tempdb.dbo.#tempJobId') IS NOT null DROP TABLE #tempJobId
END
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'GetSybasePhyDevList')
	delete from GxQscripts where name = 'GetSybasePhyDevList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSybasePhyDevList')
	delete from GXDBVersions where aliasname = 'GetSybasePhyDevList'
GO

insert into GXDBVersions values(2, 'GetSybasePhyDevList',  '00010004003400010000', 'GetSybasePhyDevList', '00010004003400010000')
GO

