

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetSublientsForUser.sp] ---------- 

--  +-----------------------------------------------------------------------+
--  |           Procedure : "GetSublientsForUser"
--  |   This Procedure is used to get the list of subclients associated with
--  |   the tenant user
--  +-----------------------------------------------------------------------+
SET ANSI_NULLS ON
--Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetSublientsForUser')
BEGIN
	print '>>> Drop Stored Procedure: GetSublientsForUser <<<'
	drop procedure GetSublientsForUser
END
IF EXISTS (select * from GxQscripts where name='GetSublientsForUser')
	delete from GxQscripts where name = 'GetSublientsForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSublientsForUser')
	delete from GXDBVersions where aliasname = 'GetSublientsForUser'
GO
print '... Creating Procedure: GetSublientsForUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetSublientsForUser
--Input Arguments
  @i_userId INT, 
  @i_entityType INT
AS
  DECLARE @clientId INT
  DECLARE @appId INT
  DECLARE @instanceId INT
  DECLARE @backupsetId INT
  DECLARE @subclientId INT
BEGIN TRY
	DECLARE @ErrorCode 	INT = 0
	DECLARE @ErrorMessage VARCHAR(255)
	IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL DROP TABLE tempdb.dbo.#getIdaObjects
	CREATE TABLE tempdb.dbo.#getIdaObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
	EXEC sec_getIdaObjectsForUser @i_userId,@i_entityType,0,1,'tempdb.dbo.#getIdaObjects'
    SELECT temp.clientId as clientId, temp.apptypeId as appId, temp.instanceID as instanceId, temp.backupsetId as backupsetId, temp.subclientID as subclientId from #getIdaObjects temp
	JOIN dbo.APP_APPLICATION app on temp.subclientID = app.id and app.subclientStatus &(2|4) = 0
	IF @ErrorCode <> 0
	GOTO ERROR_EXIT
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @ErrorMessage  = ERROR_MESSAGE()
    SET @ErrorCode = ERROR_NUMBER()
END CATCH
ERROR_EXIT:
BEGIN
	IF OBJECT_ID('tempdb.dbo.#getIdaObjects') IS NOT NULL DROP TABLE tempdb.dbo.#getIdaObjects
END
RETURN
GO

IF EXISTS (select * from GxQscripts where name = 'GetSublientsForUser')
	delete from GxQscripts where name = 'GetSublientsForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSublientsForUser')
	delete from GXDBVersions where aliasname = 'GetSublientsForUser'
GO

insert into GXDBVersions values(2, 'GetSublientsForUser',  '00000000000000000000', 'GetSublientsForUser', '00000000000000000000')
GO

