

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetSubclientMaxRetentionDays.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--	Author: Satya Bhukar
--	Date:   01/16/2018
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetSubclientMaxRetentionDays.sp,v $ $Id: GetSubclientMaxRetentionDays.sp,v 1.1.2.3 2018/04/22 13:50:02 sbhukar Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetSubclientMaxRetentionDays <<<'

IF EXISTS (select * from sysobjects where name='GetSubclientMaxRetentionDays')
	drop procedure GetSubclientMaxRetentionDays
IF EXISTS (select * from GxQscripts where name='GetSubclientMaxRetentionDays')
	delete from GxQscripts where name = 'GetSubclientMaxRetentionDays'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSubclientMaxRetentionDays')
	delete from GXDBVersions where aliasname = 'GetSubclientMaxRetentionDays'
GO
print '... Creating Procedure: GetSubclientMaxRetentionDays'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetSubclientMaxRetentionDays
  @i_xml XML
AS
  DECLARE @outXML xml
DECLARE @attrNameDays NVARCHAR(64) = 'IndexCacheRetentionDays'
DECLARE @attrNameCycle NVARCHAR(64) = 'IndexCacheRetentionCycle'
DECLARE @secInADay INT = 24*60*60
DECLARE @backupSetGuid NVARCHAR(40) = ''
DECLARE @backupSetID INT
DECLARE @minStartTime INT = 0
DECLARE @currentTime INT = dbo.GetUnixTime(dbo.CellLocalToUTCTime(GETDATE(),2))
--In phase 1 we don't care for checkpoint and assume everything is checkpointed
DECLARE @minCheckPointTime INT = @currentTime
IF object_id('tempdb.dbo.#finalResult') is not null
	DROP TABLE #finalResult
CREATE TABLE #finalResult (appId INT, appGUID NVARCHAR(36), cutoffTime INT)
CREATE CLUSTERED INDEX finalResult_appGUID_Idx ON #finalResult (appGUID)
SELECT @backupSetGuid = N.value(N'@backupSetGUID', N'NVARCHAR(40)')	FROM @i_xml.nodes (N'Indexing_AppIdRetentionDetailsReq') AS T(N);
IF LEN(@backupSetGuid) = 0
	GOTO EXIT_POINT
SELECT @backupSetID = bp.id FROM APP_BackupSetName bp WITH (NOLOCK) WHERE bp.GUID = @backupSetGUID
IF object_id('tempdb.dbo.#appIdConfiguration') is not null
	DROP TABLE #appIdConfiguration
CREATE TABLE #appIdConfiguration (appId INT, appGUID NVARCHAR(36), attrName NVARCHAR(64), attrVal INT)
--Handle any configuration set at media agent or backupset level
INSERT INTO #appIdConfiguration
SELECT app.id, app.GUID, cp.attrName, CAST(CP.attrVal AS INT)
FROM APP_ClientProp CP WITH (NOLOCK) JOIN APP_Application app WITH (NOLOCK) ON CP.componentNameId = app.clientId
WHERE app.backupSet = @backupSetID AND cp.attrName IN(@attrNameDays,@attrNameCycle) AND cp.modified = 0
UNION
SELECT app.id, app.GUID, bp.attrName, CAST(bp.attrVal AS INT)
FROM APP_BackupSetProp bp WITH (NOLOCK) JOIN APP_Application app WITH (NOLOCK) ON bp.componentNameId = app.backupSet
WHERE bp.componentNameId = @backupSetID AND attrName IN(@attrNameDays,@attrNameCycle) AND bp.modified = 0
--Find toTime which is the time of last checkpoint for each subclient
--From list of all those time, find minimum time. Pruning time can never exceed this
--SELECT @minCheckPointTime = MIN(toTime) FROM
--(SELECT appGUID, MAX(toTime) AS toTime FROM APP_IndexAppIdCheckpointInfo WITH(NOLOCK) WHERE backupSetGUID = @backupSetGuid GROUP BY appGUID) T
IF object_id('tempdb.dbo.#archGroupIdList') is not null
	DROP TABLE #archGroupIdList
CREATE TABLE #archGroupIdList (appId INT, appGUID NVARCHAR(36), retentionDays INT, cycles INT)
CREATE CLUSTERED INDEX archGroupIdList_appId_Idx ON #archGroupIdList (appId)
--We need to retain minimum 2 cycles. Cycle retention can be infinite also, we should not delete any data in that case
INSERT INTO #archGroupIdList
SELECT appId, appGUID, [IndexCacheRetentionDays] AS retentionDays,
		CASE WHEN [IndexCacheRetentionCycle] = 0 OR [IndexCacheRetentionCycle] = 1 THEN 2 ELSE [IndexCacheRetentionCycle] END AS fullCycles FROM
(
SELECT appId, appGUID, attrName, attrVal FROM #appIdConfiguration) AS T
PIVOT (MAX(attrVal) FOR attrName IN ([IndexCacheRetentionDays],[IndexCacheRetentionCycle])) AS P
--If archGroupIdList is empty implies no configuration set by user so we go by primary copy retention
IF NOT EXISTS(SELECT 1 FROM #archGroupIdList)
BEGIN
	--We are not considering snap copy here, only classic primary
	--We need to retain minimum 2 cycles.
	INSERT INTO #archGroupIdList
	SELECT App.id AS appId, App.GUID AS appGUID, AR.retentionDays, CASE WHEN AR.fullCycles = 0 OR AR.fullCycles = 1 THEN 2 ELSE AR.fullCycles END
	FROM  APP_Application App WITH (NOLOCK)
	JOIN archGroup AG WITH (NOLOCK) ON App.dataArchGrpID = AG.id
	JOIN archGroupCopy AGC WITH (NOLOCK) ON AG.defaultCopy = AGC.id AND isSnapCopy = 0
	JOIN archAgingRule AR WITH (NOLOCK) ON AR.copyId = AGC.id
	WHERE app.backupSet = @backupSetID AND App.subclientStatus&(2|4)  = 0 AND AGC.archGroupId > 1 --HIDE_UNINST, HIDE_DELETED
END
DECLARE @tempJobStatus TABLE(jobStatus INT)
INSERT INTO @tempJobStatus VALUES (1),(3),(14)
DECLARE @tempJobBkpLevel TABLE(bkpLevel INT)
INSERT INTO @tempJobBkpLevel VALUES (1),(64),(128),(1024),(16384),(32768)
IF object_id('tempdb.dbo.#AppidCutoffCycle') is not null
	DROP TABLE #AppidCutoffCycle
CREATE TABLE #AppidCutoffCycle (appId INT, appGUID NVARCHAR(36), cutoffCycle INT)
--Find out the cyclenumber from jmbkpstats table before which we can prune the data.
--If any subclient has ran less cycles than defined in storage policy we pick the least fullCycleNum
INSERT INTO #AppidCutoffCycle
SELECT tmp.appid, tmp.appGUID, CASE WHEN T.MAXcycle <= tmp.cycles OR tmp.cycles < 0 THEN T.Mincycle ELSE T.MAXcycle - tmp.cycles + 1 END AS cutoffCycle
FROM #archGroupIdList tmp JOIN
(SELECT bkpStat.appid, MAX(fullCycleNum) AS MAXcycle , MIN(fullCycleNum) AS Mincycle
FROM JMBkpStats bkpStat WITH (NOLOCK) JOIN #archGroupIdList tmp ON tmp.appId = bkpStat.appid
WHERE bkpStat.bkpLevel IN (SELECT bkpLevel FROM @tempJobBkpLevel) AND bkpStat.status IN (SELECT jobStatus FROM @tempJobStatus)
GROUP BY bkpStat.appId ) T ON tmp.appid = T.appId
IF object_id('tempdb.dbo.#appidRetentionList') is not null
	DROP TABLE #appidRetentionList
CREATE TABLE #appidRetentionList (appId INT, appGUID NVARCHAR(36), cutoffTime INT)
CREATE CLUSTERED INDEX appidRetentionList_appId_Idx ON #appidRetentionList (appId)
--For each subclient find out the minimum time before which we can prune the data in indexing
INSERT INTO #appidRetentionList
SELECT appId, appGUID, MIN(cutoffTime) AS cutoffTime FROM
(
	--join with #AppidCutoffCycle is made to make sure atleast 1 job is present in the jmbkpstats table else we don't have to even consider this subclient
	SELECT tmp.appId, tmp.appGUID, @currentTime - retentionDays*@secInADay AS cutoffTime FROM #archGroupIdList tmp JOIN #AppidCutoffCycle B ON tmp.appId = B.appId
	UNION
	SELECT B.appId, B.appGUID, MAX(servStartDate) as cutoffTime
	FROM JMBkpStats bkpStat WITH (NOLOCK) JOIN #AppidCutoffCycle B ON bkpStat.appId = B.appId WHERE fullCycleNum <= cutoffCycle
	AND bkpStat.bkpLevel IN (SELECT bkpLevel FROM @tempJobBkpLevel) AND bkpStat.status IN (SELECT jobStatus FROM @tempJobStatus)
	GROUP BY B.appId, B.appGUID
) A GROUP BY appId, appGUID
--Find out the time of last full job for each subclient which ran before @minCheckPointTime and time in appidRetentionList table.
INSERT INTO #finalResult
SELECT bkp.appId, tmp.appGUID, MAX(servStartDate) AS cutoffTime FROM JMBkpStats bkp WITH (NOLOCK) JOIN #appidRetentionList tmp ON tmp.appID = bkp.appId AND servStartDate < cutoffTime AND servStartDate <= @minCheckPointTime
WHERE bkpLevel IN (SELECT bkpLevel FROM @tempJobBkpLevel) AND bkp.status IN (SELECT jobStatus FROM @tempJobStatus) GROUP BY bkp.appId, tmp.appGUID
--We need to insert any subclient which could not be inserted in above statement.This can happen if number of cycles on the subclient are less than storage policy retention cycles or days.
MERGE #finalResult AS T
USING #appidRetentionList AS S
ON S.appGUID = T.appGUID
WHEN NOT MATCHED BY TARGET
THEN INSERT (appId, appGUID, cutoffTime )
VALUES(S.appId, S.appGUID, S.cutoffTime)
;
--Find minimum time among all the subclients. We will not delete anything less than this time
SELECT @minStartTime = MIN(cutoffTime) FROM #finalResult
EXIT_POINT:
--firstValidFullJobTime is the time of first full job available for each subclient in index cache after prune time
SET @outXML =
(
	SELECT @minStartTime AS '@dbPruneTime',
	(
		SELECT LOWER(REPLACE(appGUID,'-','')) AS '@appGUID', MIN(servStartDate) AS '@firstValidFullJobTime'
		FROM #finalResult tmp JOIN JMBkpStats bkp WITH (NOLOCK) ON tmp.appID = bkp.appId AND servStartDate >= @minStartTime
		WHERE bkp.bkpLevel IN (SELECT bkpLevel FROM @tempJobBkpLevel) AND bkp.status IN (SELECT jobStatus FROM @tempJobStatus) GROUP BY bkp.appId, tmp.appGUID
		FOR XML PATH('appIdDetails'),TYPE
	)
	FOR XML PATH('Indexing_AppIdRetentionDetailsResp')
)
SELECT @outXML
IF object_id('tempdb.dbo.#archGroupIdList') is not null
	DROP TABLE #archGroupIdList
IF object_id('tempdb.dbo.#appIdConfiguration') is not null
	DROP TABLE #appIdConfiguration
IF object_id('tempdb.dbo.#finalResult') is not null
	DROP TABLE #finalResult
IF object_id('tempdb.dbo.#AppidCutoffCycle') is not null
	DROP TABLE #AppidCutoffCycle
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'GetSubclientMaxRetentionDays')
	delete from GxQscripts where name = 'GetSubclientMaxRetentionDays'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSubclientMaxRetentionDays')
	delete from GXDBVersions where aliasname = 'GetSubclientMaxRetentionDays'
GO

insert into GXDBVersions values(2, 'GetSubclientMaxRetentionDays',  '00010001000200030000', 'GetSubclientMaxRetentionDays', '00010001000200030000')
GO

