

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetSubclientCountForApptypeServer.sp] ---------- 

--  +=====================================================================================================================+
--  |		 		 Name:  GetSubclientCountForApptypeServer()
--  | Description:  Allows for GET subclient count for Server of specified App type with Storage Policy mapped to it
--  +=====================================================================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetSubclientCountForApptypeServer.sp,v $ $Id: GetSubclientCountForApptypeServer.sp,v 1.1.2.9 2020/10/23 13:19:11 njain Exp $";
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetSubclientCountForApptypeServer')
BEGIN
	print '>>> Drop Stored Procedure: GetSubclientCountForApptypeServer <<<'
	drop procedure GetSubclientCountForApptypeServer
END
IF EXISTS (select * from GxQscripts where name='GetSubclientCountForApptypeServer')
	delete from GxQscripts where name = 'GetSubclientCountForApptypeServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSubclientCountForApptypeServer')
	delete from GXDBVersions where aliasname = 'GetSubclientCountForApptypeServer'
GO
print '... Creating Procedure: GetSubclientCountForApptypeServer'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetSubclientCountForApptypeServer
  @i_userId INTEGER,
  @i_apptype INTEGER,
  @i_cloudappType INTEGER,
  @o_clientCount INTEGER OUTPUT,
  @i_filterVendorId INTEGER	=-1
AS
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET NOCOUNT ON
DECLARE @isCommcellLevelAssociation INT = 0
BEGIN TRY
IF object_id('tempdb.dbo.#tempSubclientSecurityObjects') IS NOT Null DROP TABLE #tempSubclientSecurityObjects
create table  #tempSubclientSecurityObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @i_userId, 2009, 0, '#tempSubclientSecurityObjects'			--2009 is for getting all clients for provided User
SELECT @isCommcellLevelAssociation=1 from #tempSubclientSecurityObjects sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
DECLARE @filterAppTypeStr nvarchar(10) = ''
DECLARE @excludeAppTypeStr nvarchar(10) = '1501' --APP_VIRTSERV_KUBERNETES by default do not return the kubernets
IF(@i_filterVendorId > 0)
BEGIN
	SET @filterAppTypeStr = CAST(dbo.MapVSVendorId(@i_filterVendorId, -1) as nvarchar(10))
END
IF(@i_filterVendorId < 1)
BEGIN
	SET @o_clientCount = (
	SELECT COUNT(sc.id)
	FROM APP_APPLICATION sc WITH(NOLOCK)
	LEFT JOIN APP_InstanceProp IP WITH (NOLOCK)  ON IP.componentNameId = SC.instance AND IP.attrName = 'Virtual Server Instance Type' AND IP.modified=0
	--Filtering subclients based on cloudapptype. Cloudapp type is stored in a subclient property. This filter is used when apptype is CloudApps(#134)
	left join  APP_SubClientProp scProp WITH(NOLOCK) on sc.id = scProp.componentNameId and scProp.attrName = 'Cloud Apps Instance Type' and scProp.modified = 0
	WHERE sc.dataArchGrpID <> 1
	AND (@i_apptype=0 OR sc.appTypeId=@i_apptype)
AND sc.subclientStatus  & 0x00004 = 0
AND sc.subclientStatus & 0x00020 =0
	AND (@isCommcellLevelAssociation = 1 OR sc.clientId in (SELECT DISTINCT clientId FROM #tempSubclientSecurityObjects))
	AND (@i_cloudappType = 0 or ((@i_cloudappType != 0) and scProp.attrVal = @i_cloudappType) )
	AND ( IP.attrVal IS NULL OR IP.attrVal<> @excludeAppTypeStr )
	)
END
ELSE
BEGIN
	SET @o_clientCount = (
	SELECT COUNT(sc.id)
	FROM APP_APPLICATION sc WITH(NOLOCK)
	INNER JOIN APP_InstanceProp IP WITH (NOLOCK)  ON IP.componentNameId = SC.instance AND IP.attrName = 'Virtual Server Instance Type' AND IP.modified=0
	WHERE sc.dataArchGrpID <> 1
	AND (@i_apptype=0 OR sc.appTypeId=@i_apptype)
AND sc.subclientStatus  & 0x00004 = 0
AND sc.subclientStatus & 0x00020 =0
	AND (@isCommcellLevelAssociation = 1 OR sc.clientId in (SELECT DISTINCT clientId FROM #tempSubclientSecurityObjects))
	AND IP.attrVal= @filterAppTypeStr
	)
END
IF object_id('tempdb.dbo.#tempSubclientSecurityObjects') IS NOT Null DROP TABLE #tempSubclientSecurityObjects
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @o_clientCount = 0
	GOTO SCRIPT_EXIT
END CATCH
SCRIPT_EXIT:
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetSubclientCountForApptypeServer')
	delete from GxQscripts where name = 'GetSubclientCountForApptypeServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSubclientCountForApptypeServer')
	delete from GXDBVersions where aliasname = 'GetSubclientCountForApptypeServer'
GO

insert into GXDBVersions values(2, 'GetSubclientCountForApptypeServer',  '00010001000200090000', 'GetSubclientCountForApptypeServer', '00010001000200090000')
GO

