

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetSubclientArchiveGroupAssocListForClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetSubclientArchiveGroupAssocListForClients.sp,v $ $Id: GetSubclientArchiveGroupAssocListForClients.sp,v 1.5.48.1 2017/02/10 19:55:36 sjohnson Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		STORED PROCEDURE : "GetSubclientArchiveGroupAssocListForClients"			|
--	|																		|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetSubclientArchiveGroupAssocListForClients <<<'

IF EXISTS (select * from sysobjects where name='GetSubclientArchiveGroupAssocListForClients')
	drop procedure GetSubclientArchiveGroupAssocListForClients
IF EXISTS (select * from GxQscripts where name='GetSubclientArchiveGroupAssocListForClients')
	delete from GxQscripts where name = 'GetSubclientArchiveGroupAssocListForClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSubclientArchiveGroupAssocListForClients')
	delete from GXDBVersions where aliasname = 'GetSubclientArchiveGroupAssocListForClients'
GO
print '... Creating Procedure: GetSubclientArchiveGroupAssocListForClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetSubclientArchiveGroupAssocListForClients
  @i_RestrictUserId integer,
  @i_XmlStr XML
AS
SET NOCOUNT ON
-- send the list of sps to the GUI first.
-- from ArchGroupList sp
if object_id('tempdb.dbo.#SpList') is not NULL	DROP TABLE #SpList
CREATE TABLE #SpList( o_archGroupId integer,
  o_archGroupName NVARCHAR(255),
  o_type integer,
  visibleToUser INT)
DECLARE @l_providerId 	integer
-- restrict showing of archive UMGroups that are visible to user, first do general
-- stuff
DECLARE @clients table(clientId integer	)
DECLARE @client	integer
	INSERT INTO @clients
	SELECT PARAM.value('@clientId','INTEGER')
	FROM @i_XmlStr.nodes('/EVGui_GetSubclientAndStoragePolicyListReq/clients') AS messageXML(param)
-- get all the semi-complex information that needs to be gotten
INSERT INTO #SpList
SELECT  AG.id,  AG.name, AG.type, 0
FROM  archGroup as AG
WHERE id > 1 and origCCcommCellID<3
IF @i_RestrictUserId > 0
BEGIN
		IF OBJECT_ID('tempdb.dbo.#GetSubclientArchiveGroupAssocListForClients_UserObjects') IS NOT NULL DROP TABLE #GetSubclientArchiveGroupAssocListForClients_UserObjects
create table  #GetSubclientArchiveGroupAssocListForClients_UserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
		EXEC sec_getUserObjects @i_RestrictUserId, 2231, 0, '#GetSubclientArchiveGroupAssocListForClients_UserObjects'
		IF EXISTS(
				SELECT 1 FROM #GetSubclientArchiveGroupAssocListForClients_UserObjects Sec
WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
				)					--commcell level associations
			UPDATE #SpList
			SET visibleToUser = 1
		ELSE
		BEGIN
			UPDATE #SpList
			SET visibleToUser = 1
			FROM #SpList as tt INNER JOIN #GetSubclientArchiveGroupAssocListForClients_UserObjects Sec
			ON tt.o_archGroupId = Sec.archGroupId
			WHERE Sec.archGroupId <> 0
		END
		IF OBJECT_ID('tempdb.dbo.#GetSubclientArchiveGroupAssocListForClients_UserObjects') IS NOT NULL DROP TABLE #GetSubclientArchiveGroupAssocListForClients_UserObjects
END
ELSE
BEGIN
		UPDATE #SpList SET visibleToUser = 1
END
DELETE  #SpList
        FROM #SpList as tt
        WHERE tt.visibleToUser = 0
SELECT 1			                 as TAG,
	NULL			                 as Parent,
	NULL			                 as [EVGui_GetSubclientAndStoragePolicyListResp!1],
	NULL			                 as [validScList!2!clientName],
	NULL 			                 as [validScList!2!application],
	NULL			                 as [validScList!2!instance],
	NULL 			                 as [validScList!2!backupset],
	NULL 			                 as [validScList!2!clientId],
	NULL 			                 as [validScList!2!appTypeId],
	NULL 			                 as [validScList!2!instanceId],
	NULL 			                 as [validScList!2!backupsetId],
	NULL 			                 as [validScList!2!subclientId],
	NULL 			                 as [validScList!2!subclient],
	NULL 			                 as [validScList!2!storagePolicy],
	NULL 			                 as [validScList!2!storagePolicyName],
	NULL 			                 as [validScList!2!logSubclient],
	NULL 			                 as [validScList!2!isChanged],
	NULL 			                 as [validScList!2!isTurbo],
	NULL 			                 as [storagePolicies!3!id],
	NULL 			                 as [storagePolicies!3!name]
UNION ALL
--data SP of all valid subclients
SELECT 2, 1, NULL,
	Cli.name, Ida.name,
		(case (select count(*) from APP_AppTypeGroupAssoc where typeOfGroup = 0 and appGroupId =96 and appTypeId = Ida.type)
			when 0 then ''
			else Inst.name
			end),
		(case (select count(*) from APP_AppTypeGroupAssoc where typeOfGroup = 0 and appGroupId =97 and appTypeId = Ida.type)
			when 0 then Bs.name
			else ''
			end),	Cli.id, Ida.type, Inst.id, Bs.id, Sc.id, Sc.subclientname, Sc.dataArchGrpID,
		(case when ag.origCCcommCellID > 2 then ''
		    else Ag.name
		    end),  'data',	NULL, ISNULL(SCP.attrVal, 0), NULL, null
	FROM APP_Client Cli, APP_IdaType Ida, APP_InstanceName Inst, APP_BackupsetName Bs, ArchGroup Ag,@clients c, APP_Application Sc
	LEFT OUTER JOIN (SELECT * FROM APP_SubClientProp WHERE attrName = 'Is Turbo Subclient' and modified =0 ) SCP ON Sc.id = SCP.componentNameId
	WHERE 	  Cli.id = c.clientId and
		  Cli.id = Sc.clientId and
		  Ida.type = Sc.appTypeId and
		  Inst.id = Sc.instance and
		  Bs.id = Sc.backupset and
		  Ag.id = Sc.dataArchGrpID and
		  Sc.id in (SELECT id FROM APP_Application WHERE appTypeId not in (84, 107) AND appTypeId < 600 AND  subclientStatus & 4 <> 4 AND subclientStatus & 16 <> 16 AND subclientStatus & 32 <> 32)
UNION ALL
--log SP for all valid SQL subclients
SELECT 2, 1, NULL,
	Cli.name, Ida.name,
		(case (select count(*) from APP_AppTypeGroupAssoc where typeOfGroup = 0 and appGroupId =96 and appTypeId = Ida.type)
			when 0 then ''
			else Inst.name
			end),
		(case (select count(*) from APP_AppTypeGroupAssoc where typeOfGroup = 0 and appGroupId =97 and appTypeId = Ida.type)
			when 0 then Bs.name
			else ''
			end),	Cli.id, Ida.type, Inst.id, Bs.id, Sc.id, Sc.subclientname, Sc.logArchGrpID,
		(case when ag.origCCcommCellID > 2 then ''
		    else Ag.name
		    end),  'log',NULL, 0, NULL, null
	FROM APP_Client Cli, APP_IdaType Ida, APP_InstanceName Inst, APP_BackupsetName Bs, APP_Application Sc, ArchGroup Ag,@clients c
	WHERE     Cli.id = c.clientId and
		  Cli.id = Sc.clientId and
		  Ida.type = Sc.appTypeId and
		  Inst.id = Sc.instance and
		  Bs.id = Sc.backupset and
		  Ag.id = Sc.logArchGrpID and
		  Sc.id in (SELECT id FROM APP_Application WHERE appTypeId in (81) AND subclientStatus & 4 <> 4 AND subclientStatus & 16 <> 16 AND subclientStatus & 32 <> 32)
UNION ALL
--log SP for all instances of oracle, mysql, SAP, db2,postgre,RAC,sapmaxDB,db2 ,informix
SELECT distinct 2, 1, NULL,
	Cli.name, Ida.name, Inst.name, '', Cli.id, Ida.type, Inst.id, 0, 0, '', Sc.logArchGrpID,
    (case when ag.origCCcommCellID > 2 then ''
		 else Ag.name
		 end),  'log',NULL, 0,  NULL, null
	FROM APP_Client Cli, APP_IdaType Ida, APP_InstanceName Inst, APP_BackupsetName Bs, APP_Application Sc, ArchGroup Ag,@clients c
	WHERE     Cli.id = c.clientId and
		  Cli.id = Sc.clientId and
		  Ida.type = Sc.appTypeId and
		  Ida.type in (22,104,61,37,79,125,80,62,103,3,135) and
		  Inst.id = Sc.instance and
		  Inst.status & 16 <> 16 and
		  Bs.id = Sc.backupset and
		  Ag.id = Sc.logArchGrpID and
		  Sc.id in (SELECT id FROM APP_Application WHERE appTypeId in (22,104,61,37,79,125,80,62,103,3,135)  AND subclientStatus & 8 = 8)
UNION ALL
--log SP for all backupsets of db2
SELECT distinct 2, 1, NULL,
	Cli.name, Ida.name, Inst.name, Bs.name, Cli.id, Ida.type, Inst.id, Bs.id, 0, '', Sc.logArchGrpID,
    (case when ag.origCCcommCellID > 2 then ''
		 else Ag.name
		 end),  'log',NULL, 0,  NULL, null
	FROM APP_Client Cli, APP_IdaType Ida, APP_InstanceName Inst, APP_BackupsetName Bs, APP_Application Sc, ArchGroup Ag,@clients c
	WHERE     Cli.id = c.clientId and
		  Cli.id = Sc.clientId and
		  Ida.type = Sc.appTypeId and
		  Ida.type in (37,62,103) and
		  Inst.id = Sc.instance and
		  Inst.status & 16 <> 16 and
		  Bs.id = Sc.backupset and
		  Bs.status & 16 <>16 and
		  Ag.id = Sc.logArchGrpID and
		  Sc.id in (SELECT id FROM APP_Application WHERE appTypeId in (37,62,103) AND subclientStatus & 8 = 8)
UNION ALL
--data SP for all subclient policy subclients
SELECT 2, 1, NULL,
	'', Ida.name, '', Bs.name, Cli.id, Ida.type, Inst.id, Bs.id, Sc.id, Sc.subclientname, Sc.dataArchGrpID,
		(case when ag.origCCcommCellID > 2 then ''
		 else Ag.name
		 end),   'data',NULL, 0,  NULL, null
	FROM APP_Client Cli, APP_IdaType Ida, APP_InstanceName Inst, APP_BackupsetName Bs, APP_Application Sc, ArchGroup Ag,@clients c
	WHERE     Cli.id = c.clientId and
		  Cli.id = Sc.clientId and
		  Ida.type = Sc.appTypeId and
		  Inst.id = Sc.instance and
		  Bs.id = Sc.backupset and
		  Ag.id = Sc.dataArchGrpID and
		  Sc.id in (SELECT id FROM APP_Application WHERE appTypeId = 1030 AND subclientStatus & 4 <> 4 AND subclientStatus & 16 <> 16 AND subclientStatus & 32 <> 32 )
UNION ALL
-- GUI needs list of SPS in case they are not loaded already
SELECT 3, 1, NULL,
	NULL, NULL,	NULL, NULL,	NULL, NULL,	NULL, NULL,	NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	 o_archGroupId, o_archGroupName
	FROM #SpList
	WHERE o_type =1
ORDER BY [validScList!2!clientName],[validScList!2!application], [validScList!2!instance], [validScList!2!backupset], [validScList!2!subclient], TAG
FOR XML EXPLICIT
--clean up
DROP TABLE #SpList
SET NOCOUNT OFF


IF EXISTS (select * from GxQscripts where name = 'GetSubclientArchiveGroupAssocListForClients')
	delete from GxQscripts where name = 'GetSubclientArchiveGroupAssocListForClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSubclientArchiveGroupAssocListForClients')
	delete from GXDBVersions where aliasname = 'GetSubclientArchiveGroupAssocListForClients'
GO

insert into GXDBVersions values(2, 'GetSubclientArchiveGroupAssocListForClients',  '00010005004800010000', 'GetSubclientArchiveGroupAssocListForClients', '00010005004800010000')
GO

