

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetSubclientArchiveGroupAssocList.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetSubclientArchiveGroupAssocList.sp,v $ $Id: GetSubclientArchiveGroupAssocList.sp,v 1.19.2.2 2017/02/10 19:55:36 sjohnson Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		STORED PROCEDURE : "GetSubclientArchiveGroupAssocList"			|
--	|																		|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetSubclientArchiveGroupAssocList <<<'

IF EXISTS (select * from sysobjects where name='GetSubclientArchiveGroupAssocList')
	drop procedure GetSubclientArchiveGroupAssocList
IF EXISTS (select * from GxQscripts where name='GetSubclientArchiveGroupAssocList')
	delete from GxQscripts where name = 'GetSubclientArchiveGroupAssocList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSubclientArchiveGroupAssocList')
	delete from GXDBVersions where aliasname = 'GetSubclientArchiveGroupAssocList'
GO
print '... Creating Procedure: GetSubclientArchiveGroupAssocList'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetSubclientArchiveGroupAssocList
  @i_RestrictUserId integer
AS
SET NOCOUNT ON
-- send the list of sps to the GUI first.
-- from ArchGroupList sp
if object_id('tempdb.dbo.#SpList') is not NULL	DROP TABLE #SpList
CREATE TABLE #SpList( o_archGroupId integer,
  o_archGroupName NVARCHAR(255),
  o_type integer,
  visibleToUser INT)
DECLARE @l_providerId 	integer
DECLARE @secObjTypeClient	INTEGER = 2009		-- 2009
DECLARE @userIdReceivedInput INTEGER = @i_RestrictUserId
DECLARE @allowAllClients INTEGER = 0
DECLARE @xml XML
-- restrict showing of archive UMGroups that are visible to user, first do general
-- stuff
-- get all the semi-complex information that needs to be gotten
INSERT INTO #SpList
SELECT  AG.id,  AG.name, AG.type, 0
FROM  archGroup as AG
WHERE id > 1
-- remove AGs user can't see
IF @i_RestrictUserId > 0
BEGIN
		IF OBJECT_ID('tempdb.dbo.#GetSubclientArchiveGroupAssocList_UserObjects') IS NOT NULL DROP TABLE #GetSubclientArchiveGroupAssocList_UserObjects
create table  #GetSubclientArchiveGroupAssocList_UserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
		EXEC sec_getUserObjects @i_RestrictUserId, 2231, 0, '#GetSubclientArchiveGroupAssocList_UserObjects'
		IF EXISTS(
				SELECT 1 FROM #GetSubclientArchiveGroupAssocList_UserObjects Sec
WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
				)					--commcell level associations
			UPDATE #SpList
			SET visibleToUser = 1
		ELSE
		BEGIN
			UPDATE #SpList
			SET visibleToUser = 1
			FROM #SpList as tt INNER JOIN #GetSubclientArchiveGroupAssocList_UserObjects Sec
			ON tt.o_archGroupId = Sec.archGroupId
			WHERE Sec.archGroupId <> 0
		END
		IF OBJECT_ID('tempdb.dbo.#GetSubclientArchiveGroupAssocList_UserObjects') IS NOT NULL DROP TABLE #GetSubclientArchiveGroupAssocList_UserObjects
END
ELSE
BEGIN
		UPDATE #SpList SET visibleToUser = 1
END
DELETE  #SpList
        FROM #SpList as tt
        WHERE tt.visibleToUser = 0
--get the list clients which are allowed to view by the user
IF object_id('tempdb.dbo.#tblSecObj_Clients') is not null DROP TABLE #tblSecObj_Clients
create table  #tblSecObj_Clients ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @userIdReceivedInput, @secObjTypeClient, 0, '#tblSecObj_Clients'
IF EXISTS(SELECT 1 FROM #tblSecObj_Clients Sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0))--commcell level associations
BEGIN
	DELETE FROM #tblSecObj_Clients
END
if object_id('tempdb.dbo.#TMP_VNA_forAGList') is not null DROP TABLE #TMP_VNA_forAGList
if object_id('tempdb.dbo.#UMuserGroup')       is not Null DROP TABLE #UMuserGroup
IF object_id('tempdb.dbo.#tblValidSCList') is not null DROP TABLE #tblValidSCList
IF object_id('tempdb.dbo.#tblClientGroupsPerClient') is not null DROP TABLE #tblClientGroupsPerClient
CREATE TABLE #tblValidSCList(tag integer,
							 parent integer,
							 nodeName varchar(255),
							 clientName nvarchar(255),
							 applicationName varchar(255),
							 instance nvarchar(512),
							 backupset nvarchar(128),
							 clientId integer,
							 appTypeId integer,
							 instanceId integer,
							 backupsetId integer,
							 subclientId integer,
							 subclient nvarchar(128),
							 storagePolicy integer,
							 storagePolicyName nvarchar(288),
							 logSubclient varchar(255),
							 isChanged integer,
							 isTurbo integer,
							 spId integer,
							 spName nvarchar(288),
					         assocClientGroups nvarchar(max))
CREATE TABLE #tblClientGroupsPerClient(cid integer,
							 	 associatedClientGroups nvarchar(MAX))
INSERT INTO #tblValidSCList
--data SP of all valid subclients
SELECT 2, 1, NULL,
	Cli.name, Ida.name,
		(case (select count(*) from APP_AppTypeGroupAssoc where typeOfGroup = 0 and appGroupId =96 and appTypeId = Ida.type)
			when 0 then ''
			else Inst.name
			end),
		(case (select count(*) from APP_AppTypeGroupAssoc where typeOfGroup = 0 and appGroupId =97 and appTypeId = Ida.type)
			when 0 then Bs.name
			else ''
			end),	Cli.id, Ida.type, Inst.id, Bs.id, Sc.id, Sc.subclientname, Sc.dataArchGrpID, Ag.name,
		'data',	NULL,
		CASE
			WHEN Sc.subclientStatus & 0x10000 = 0x10000 THEN 1 -- CV_STATUS_REFCOPY_SUB -- For reference copy & PST subclient we need synth full warning
			WHEN ISNULL(SCP.attrVal, 0) <> 0 THEN 1 -- For Turbo subclients we need synth full warning
			ELSE 0
		END ,
		 NULL, null,''
	FROM APP_Client Cli, APP_IdaType Ida, APP_InstanceName Inst, APP_BackupsetName Bs, ArchGroup Ag, APP_Application Sc
	LEFT OUTER JOIN (SELECT * FROM APP_SubClientProp WHERE attrName = 'Is Turbo Subclient' and modified =0 ) SCP ON Sc.id = SCP.componentNameId
	WHERE Cli.id =Sc.clientId and
		  Ida.type = Sc.appTypeId and
		  Inst.id = Sc.instance and
		  Bs.id = Sc.backupset and
		  Ag.id = Sc.dataArchGrpID and
		  Sc.id in (SELECT id FROM APP_Application WHERE appTypeId not in (84, 107) AND appTypeId < 600 AND subclientStatus & 2 <> 2 AND subclientStatus & 4 <> 4 AND subclientStatus & 16 <> 16 AND subclientStatus & 32 <> 32)
UNION ALL
--log SP for all valid SQL
SELECT 2, 1, NULL,
	Cli.name, Ida.name,
		(case (select count(*) from APP_AppTypeGroupAssoc where typeOfGroup = 0 and appGroupId =96 and appTypeId = Ida.type)
			when 0 then ''
			else Inst.name
			end),
		(case (select count(*) from APP_AppTypeGroupAssoc where typeOfGroup = 0 and appGroupId =97 and appTypeId = Ida.type)
			when 0 then Bs.name
			else ''
			end),	Cli.id, Ida.type, Inst.id, Bs.id, Sc.id, Sc.subclientname, Sc.logArchGrpID, Ag.name, 'log',
	NULL, 0, NULL, null,''
	FROM APP_Client Cli, APP_IdaType Ida, APP_InstanceName Inst, APP_BackupsetName Bs, APP_Application Sc, ArchGroup Ag
	WHERE Cli.id =Sc.clientId and
		  Ida.type = Sc.appTypeId and
		  Inst.id = Sc.instance and
		  Bs.id = Sc.backupset and
		  Ag.id = Sc.logArchGrpID and
		  Sc.id in (SELECT id FROM APP_Application WHERE appTypeId in (81) AND subclientStatus & 2 <> 2 AND subclientStatus & 4 <> 4 AND subclientStatus & 16 <> 16 AND subclientStatus & 32 <> 32)
UNION ALL
--log SP for all instances of oracle, mysql, SAP, db2,postgre,RAC,sapmaxDB,db2 ,inofrmix
SELECT distinct 2, 1, NULL,
	Cli.name, Ida.name, Inst.name, '', Cli.id, Ida.type,Inst.id, 0, 0, '', Sc.logArchGrpID, Ag.name, 'log',
	NULL, 0,  NULL, null,''
	FROM APP_Client Cli, APP_IdaType Ida, APP_InstanceName Inst, APP_BackupsetName Bs, APP_Application Sc, ArchGroup Ag
	WHERE Cli.id =Sc.clientId and
		  Ida.type = Sc.appTypeId and
		  Ida.type in (22,104,61,37,79,125,80,62,103,3,135) and
		  Inst.id = Sc.instance and
		  Inst.status & 16 <> 16 and
		  Bs.id = Sc.backupset and
		  Ag.id = Sc.logArchGrpID and
		  Sc.id in (SELECT id FROM APP_Application WHERE appTypeId in (22,104,61,37,125,80,79,62,103,3,135) AND subclientStatus & 8 = 8)
UNION ALL
--log SP for all backupsets of db2
SELECT distinct 2, 1, NULL,
	Cli.name, Ida.name, Inst.name,Bs.name, Cli.id, Ida.type,Inst.id, Bs.id, 0, '', Sc.logArchGrpID, Ag.name, 'log',
	NULL, 0,  NULL, null,''
	FROM APP_Client Cli, APP_IdaType Ida, APP_InstanceName Inst, APP_BackupsetName Bs, APP_Application Sc, ArchGroup Ag
	WHERE Cli.id =Sc.clientId and
		  Ida.type = Sc.appTypeId and
		  Ida.type in (37,62,103) and
		  Inst.id = Sc.instance and
		  Inst.status & 16 <> 16 and
		  Bs.id = Sc.backupset and
		  Bs.status & 16 <>16 and
		  Ag.id = Sc.logArchGrpID and
		  Sc.id in (SELECT id FROM APP_Application WHERE appTypeId in (37,62,103) AND subclientStatus & 8 = 8)
UNION ALL
--data SP for all subclient policy subclients
SELECT 2, 1, NULL,
	'', Ida.name, '', Bs.name, Cli.id, Ida.type, Inst.id, Bs.id, Sc.id, Sc.subclientname, Sc.dataArchGrpID, Ag.name, 'data',
	NULL, 0,  NULL, null,''
	FROM APP_Client Cli, APP_IdaType Ida, APP_InstanceName Inst, APP_BackupsetName Bs, APP_Application Sc, ArchGroup Ag
	WHERE Cli.id =Sc.clientId and
		  Ida.type = Sc.appTypeId and
		  Inst.id = Sc.instance and
		  Bs.id = Sc.backupset and
		  Ag.id = Sc.dataArchGrpID and
		  Sc.id in (SELECT id FROM APP_Application WHERE appTypeId = 1030 AND subclientStatus & 2 <> 2 AND subclientStatus & 4 <> 4 AND subclientStatus & 16 <> 16 AND subclientStatus & 32 <> 32 )
IF EXISTS(SELECT 1 FROM #tblSecObj_Clients WHERE clientId <> 0)
BEGIN
DELETE tmp FROM #tblValidSCList tmp LEFT JOIN #tblSecObj_Clients secClnt ON tmp.clientId = secClnt.clientId WHERE secClnt.clientId IS NULL
END
--Get ClientGroups associated for clients via function
SET @xml  =   (SELECT  DISTINCT clientId AS ClientId FROM #tblValidSCList order by clientId FOR XML PATH ('Clients'))
INSERT INTO #tblClientGroupsPerClient
SELECT * FROM dbo.getClientgroupsPerClient(@xml)
UPDATE #tblValidSCList SET assocClientGroups = associatedClientGroups FROM #tblClientGroupsPerClient
WHERE cid = clientId
--form xml here
SELECT 1			                 as TAG,
	NULL			                 as Parent,
	NULL			                 as [EVGui_GetSubclientAndStoragePolicyListResp!1],
	NULL			                 as [validScList!2!clientName],
	NULL 			                 as [validScList!2!application],
	NULL			                 as [validScList!2!instance],
	NULL 			                 as [validScList!2!backupset],
	NULL 			                 as [validScList!2!clientId],
	NULL 			                 as [validScList!2!appTypeId],
	NULL 			                 as [validScList!2!instanceId],
	NULL 			                 as [validScList!2!backupsetId],
	NULL 			                 as [validScList!2!subclientId],
	NULL 			                 as [validScList!2!subclient],
	NULL 			                 as [validScList!2!storagePolicy],
	NULL 			                 as [validScList!2!storagePolicyName],
	NULL 			                 as [validScList!2!logSubclient],
	NULL 			                 as [validScList!2!isChanged],
	NULL 			                 as [validScList!2!isTurbo],
	NULL 			                 as [validScList!2!assocClientGroups],
	NULL 			                 as [storagePolicies!3!id],
	NULL 			                 as [storagePolicies!3!name]
UNION ALL
SELECT tag, parent, nodeName, clientName, applicationName, instance, backupset, clientId, appTypeId, instanceId,
	   backupsetId, subclientId , subclient, storagePolicy ,storagePolicyName, logSubclient , isChanged ,
	   isTurbo , assocClientGroups, spId , spName
FROM #tblValidSCList
UNION ALL
-- GUI needs list of SPS in case they are not loaded already
SELECT 3, 1, NULL,
	NULL, NULL,	NULL, NULL,	NULL, NULL,	NULL, NULL,	NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
	 o_archGroupId, o_archGroupName
	FROM #SpList
	WHERE o_type =1
ORDER BY [validScList!2!clientName],[validScList!2!application], [validScList!2!instance], [validScList!2!backupset], [validScList!2!subclient], TAG
FOR XML EXPLICIT
--clean up
DROP TABLE #SpList
SET NOCOUNT OFF


IF EXISTS (select * from GxQscripts where name = 'GetSubclientArchiveGroupAssocList')
	delete from GxQscripts where name = 'GetSubclientArchiveGroupAssocList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSubclientArchiveGroupAssocList')
	delete from GXDBVersions where aliasname = 'GetSubclientArchiveGroupAssocList'
GO

insert into GXDBVersions values(2, 'GetSubclientArchiveGroupAssocList',  '00010019000200020000', 'GetSubclientArchiveGroupAssocList', '00010019000200020000')
GO

