

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetStoreApp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetStoreApp.sp,v $ $Id: GetStoreApp.sp,v 1.1.2.8 2018/10/16 14:33:08 aryas Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 		            Procedure   : "GetStoreApp"	         		        |
--  |                 Gets App information for App Builder                  |
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetStoreApp')
BEGIN
	print '>>> Drop Stored Procedure: GetStoreApp <<<'
	drop procedure GetStoreApp
END
IF EXISTS (select * from GxQscripts where name='GetStoreApp')
	delete from GxQscripts where name = 'GetStoreApp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetStoreApp')
	delete from GXDBVersions where aliasname = 'GetStoreApp'
GO
print '... Creating Procedure: GetStoreApp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetStoreApp
  @i_UserId INT = NULL,
  @i_AppId INT
AS
SET NOCOUNT OFF
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @errorCode INT = 0
DECLARE @errorMessage NVARCHAR(MAX) = ''
DECLARE @isUserScheduleAdmin INT = 0
IF OBJECT_ID('tempdb..#AppComponents') IS NOT NULL DROP TABLE #AppComponents
CREATE TABLE #AppComponents
(
    AppId           INT,
    CompId          INT,
    CompRefId       INT,
    CompType        INT,
    CompName        NVARCHAR(MAX),
    CompGuid        NVARCHAR(MAX),
    CompStatus      INT,
    CompFlags       INT,
    CompRevision    NVARCHAR(MAX),
    location        NVARCHAR(MAX),
    metaData        XML
)
IF OBJECT_ID('tempdb..#Apps') IS NOT NULL DROP TABLE #Apps
CREATE TABLE #Apps
(
    appId           INT,
    name            NVARCHAR(MAX),
    description     NVARCHAR(MAX),
    icon            NVARCHAR(MAX),
    version         INT,
    status          INT,
    definition      XML,
    mainComponentId INT
)
BEGIN TRY
    IF @i_AppId != 0 AND NOT EXISTS(SELECT TOP 1 1 FROM Store_App WHERE appId = @i_AppId)
    BEGIN
        SET @errorCode = 1
        SET @errorMessage = 'The app does not exist.'
        GOTO ERROR_EXIT
    END
EXEC sec_checkPermissionOnEntity @i_UserId, '1', @isUserScheduleAdmin OUTPUT, 1, 2
    --Get all apps on which the user has EXECUTE permissions
    IF OBJECT_ID('tempdb.dbo.#ExecutableApps') IS NOT NULL DROP TABLE #ExecutableApps
    CREATE TABLE #ExecutableApps (appId INT)
    IF(@isUserScheduleAdmin = 0 AND @i_AppId != 0)
    BEGIN
        SET @errorCode = 2
        SET @errorMessage = 'The user does not have the permission to view the requested App(s).'
        GOTO ERROR_EXIT
    END
    IF(@isUserScheduleAdmin = 0)
    BEGIN
EXEC sec_getNonIdaObjectsForThisUser @i_UserId, 177, 233, '#ExecutableApps', 0, 1
        INSERT INTO #Apps
SELECT A.appId, A.name, A.description, A.icon, A.version, 0, A.definition, A.mainComponentId
        FROM Store_App A INNER JOIN #ExecutableApps E ON E.appId = A.appId
WHERE A.appId = @i_AppId OR (@i_AppId = 0 AND (A.flags & 1) = 0)
    END
    ELSE
        INSERT INTO #Apps
SELECT A.appId, A.name, A.description, A.icon, A.version, 0, A.definition, A.mainComponentId
        FROM Store_App A
WHERE A.appId = @i_AppId OR (@i_AppId = 0 AND (A.flags & 1) = 0)
    IF OBJECT_ID('tempdb.dbo.#ExecutableApps') IS NOT NULL DROP TABLE #ExecutableApps
    IF NOT EXISTS (SELECT TOP 1 1 FROM #Apps)
    BEGIN
        SET @errorCode = 2
        SET @errorMessage = 'The user does not have the permission to view the requested App(s).'
        GOTO ERROR_EXIT
    END
    -- Get all components of selected Apps
    INSERT INTO #AppComponents
SELECT M.AppId, C.CompId, -1, C.CompType, '', C.CompGuid, 2, C.flags, C.revision, def.comp.value('@location', 'NVARCHAR(MAX)'), def.comp.query('metaData')
    FROM Store_Component C
        INNER JOIN Store_AppComponentAssoc M ON M.compId = C.compId AND (@i_AppId = 0 OR M.appId = @i_AppId)
        INNER JOIN Store_App A ON A.appId = M.appId
        CROSS APPLY A.definition.nodes('/app/components') def(comp)
    WHERE C.CompGuid = def.comp.value('metaData[1]/@guid', 'NVARCHAR(MAX)')
    --Update status and names of available components
    --Reports
    UPDATE C
    SET CompName = R.name,
CompStatus = 0,
        CompRefId = R.reportId,
        compRevision = R.revision
    FROM #AppComponents C INNER JOIN App_Reports R ON R.guid = C.CompGuid
WHERE C.CompType = 2 AND R.type = 0 --App_Reports.type = 0 => Standard Report
    --Workflows
    UPDATE C
    SET CompName = W.name,
CompStatus = 0,
        CompRefId = W.WorkflowId,
        compRevision = W.revision
    FROM #AppComponents C INNER JOIN WF_Definition W ON W.uniqueGuid = C.CompGuid
WHERE C.CompType = 3
    --Alert
    UPDATE C
    SET CompName = A.queryName,
CompStatus = 0,
        CompRefId = A.queryId,
        compRevision = CAST(A.xmlInfo AS XML).value('/App_AdditionalQueryDetails[1]/scriptDescription[1]/@revision', 'NVARCHAR(MAX)')
    FROM #AppComponents C INNER JOIN NTQueryList A ON CAST(A.Guid AS NVARCHAR(MAX)) = C.CompGuid
WHERE C.CompType = 4
    --QuickRunTools
    UPDATE C
    SET CompName = Q.aliasName,
CompStatus = 0,
        CompRefId = Q.id,
        compRevision = Q.commandInfo.value('/App_ToolInfo[1]/customScriptDescription[1]/@revision', 'NVARCHAR(MAX)')
    FROM #AppComponents C INNER JOIN APP_QuickRunTools Q ON Q.commandInfo.value('/App_ToolInfo[1]/customScriptDescription[1]/@guid', 'NVARCHAR(MAX)') = C.CompGuid
WHERE C.CompType = 5
    --Custom Dashboard
    UPDATE C
    SET CompName = D.name,
CompStatus = 0,
        CompRefId = D.reportId,
        compRevision = D.revision
    FROM #AppComponents C INNER JOIN App_Reports D ON D.guid = C.CompGuid
WHERE C.CompType = 6 AND D.type = 2 --App_Reports.type = 2 => Custom Dashboard
    --Datasets
    UPDATE C
    SET CompName = D.name,
CompStatus = 0,
        CompRefId = D.datasetId,
        compRevision = D.revision
    FROM #AppComponents C INNER JOIN APP_DataSet D ON D.guid = C.CompGuid
WHERE C.CompType = 7
    --Datasets
    UPDATE C
    SET CompName = CG.name,
CompStatus = 0,
        CompRefId = CG.id,
        compRevision = ISNULL(P.stringVal, '')
    FROM #AppComponents C INNER JOIN APP_ClientGroup CG ON CG.GUID = C.CompGuid
LEFT OUTER JOIN APP_componentProp P ON P.componentType = 8 AND P.componentId = CG.id
WHERE C.CompType = 8 AND P.propertyTypeId = 3316 AND P.dataType = 1  and P.modified = 0
    --Mark shared non native components as not original
    UPDATE TC
SET CompFlags = CompFlags - 1
    FROM #AppComponents TC
INNER JOIN Store_AppComponentAssoc A ON A.compId = TC.compId AND A.appId != TC.appId AND (TC.CompFlags & 1) != 0
    --Update status of apps
    UPDATE A
    SET status = S.status
    FROM #Apps A
    LEFT OUTER JOIN (SELECT AppId, MAX(CompStatus) AS status FROM #AppComponents GROUP BY AppId) S ON S.AppId = A.AppId
    --Update names of unavailable components from the definition saved in Store_App
    UPDATE C
    SET CompName = app.comp.value('@name', 'nvarchar(max)')
    FROM #AppComponents C
        INNER JOIN Store_App A ON @i_AppId != 0 AND A.appId = @i_AppId
        CROSS APPLY A.definition.nodes('/app/components') AS app(comp)
    WHERE app.comp.value('metaData[1]/@guid', 'nvarchar(max)') = C.CompGuid
AND C.CompStatus = 2
    SELECT
        (SELECT @errorCode AS '@errorCode', @errorMessage AS '@errorMessage' FOR XML PATH ('msg'), TYPE),
        CASE WHEN @errorCode = 0 THEN (
            SELECT A.appId AS '@id',
                A.name AS '@name',
                A.description AS '@description',
                A.icon AS '@icon',
                A.version AS '@version',
                A.status AS '@status',
                CASE
                    WHEN @i_AppId = 0 THEN NULL
                    ELSE (
                    SELECT (
                        SELECT compId AS '@id',compRefId AS '@refId', compType AS '@type', compName AS '@name', compStatus AS '@status', compFlags AS '@flags', location AS '@location',
                            metaData.query('metaData')
                        FROM #AppComponents C
                        FOR XML PATH('components'), TYPE
                    )
                    FOR XML PATH(''), TYPE)
                END,
            A.definition.query('app[1]/metaData'),
            A.definition.query('app[1]/compInstallOrder'),
            A.definition.query('app[1]/scriptInstallOrder'),
            (
                SELECT compId AS '@id',compRefId AS '@refId', compType AS '@type', compName AS '@name', compStatus AS '@status', compFlags AS '@flags',
                    metaData.query('metaData')
                FROM #AppComponents C
                WHERE C.compId = A.mainComponentId AND A.AppId = C.AppId
                FOR XML PATH('mainComponent'), TYPE
            )
            FROM #Apps A
            FOR XML PATH('apps'), TYPE
        )
        ELSE NULL END
    FOR XML PATH('App_StoreAppListResp')
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
    SET @errorCode =  ERROR_NUMBER()
    SET @ErrorMessage = ERROR_MESSAGE()
    GOTO ERROR_EXIT
END CATCH
ERROR_EXIT:
    IF(@errorCode > 0)
        SELECT @errorCode AS '@errorCode', @errorMessage AS '@errorMessage' FOR XML PATH ('msg'), ROOT ('App_StoreAppListResp')
IF OBJECT_ID('tempdb..#AppComponents') IS NOT NULL DROP TABLE #AppComponents
IF OBJECT_ID('tempdb..#Apps') IS NOT NULL DROP TABLE #Apps
GO

IF EXISTS (select * from GxQscripts where name = 'GetStoreApp')
	delete from GxQscripts where name = 'GetStoreApp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetStoreApp')
	delete from GXDBVersions where aliasname = 'GetStoreApp'
GO

insert into GXDBVersions values(2, 'GetStoreApp',  '00010001000200080000', 'GetStoreApp', '00010001000200080000')
GO

