

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetStartedEntitiesProc.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetStartedEntitiesProc.sp,v $ $Id: GetStartedEntitiesProc.sp,v 1.20.2.6.4.1 2021/03/04 22:19:18 mnatarajan Exp $";
--  +========================================================================+
--  | Stored Precedure: List specified no of entities of specified type to be listed in "Get Started" Page from GUI
--  +========================================================================+
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='GetStartedEntitiesProc')
BEGIN
	print '>>> Drop Stored Procedure: GetStartedEntitiesProc <<<'
	drop procedure GetStartedEntitiesProc
END
IF EXISTS (select * from GxQscripts where name='GetStartedEntitiesProc')
	delete from GxQscripts where name = 'GetStartedEntitiesProc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetStartedEntitiesProc')
	delete from GXDBVersions where aliasname = 'GetStartedEntitiesProc'
GO
print '... Creating Procedure: GetStartedEntitiesProc'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure GetStartedEntitiesProc
  @inputxml XML
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
declare @inputRequestList table
(
	expandLevel int,
	entity xml,
	noOfEntities int,
	attributeInfo xml,
	isDefault	 bit,
	statusFilter	int
)
declare @tempSPOutputTable table
(
	output xml
)
declare @responsesList table
(
	response xml
)
declare @expandLevel int
declare @entity xml
declare @xml xml
declare @noOfEntities int
declare @attributeInfo xml
declare @getAssociatedEntities xml
declare @isDefault bit
declare @isDefaultQuery int
declare @statusFilter int
declare @isAttributeFilterPresent int
declare @processingInstructionInfo xml
declare @isVSPseudoClientQuery int
DECLARE @userId int
DECLARE @allAssociations int
set @allAssociations = 0
SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS Agent
          FROM    @inputXml.nodes('App_GetAssociatedEntitiesProc/processinginstructioninfo/user') R ( ref )),1)
-- Retrieve credentials for the userId. So that we can send accessible client list for specific scenarios
IF OBJECT_ID('tempdb.dbo.#gsAssociatedEntities') IS NOT null
   DROP TABLE #gsAssociatedEntities
create table  #gsAssociatedEntities ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
EXEC sec_getUserObjects @userId, 0, 0, '#gsAssociatedEntities'
if exists(select 1 from #gsAssociatedEntities sec
WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
				)
begin
	SET @allAssociations = 1
end
Insert into @inputRequestList (expandLevel,noOfEntities,entity,attributeInfo,isDefault,statusFilter)
select  Tbl.Col.value('@expandLevel','INTEGER') as expandlevel,
		IsNull(Tbl.Col.value('@noOfEntities','INTEGER'),0) as noOfEntities,
		Tbl.Col.query('entity') as entity,
		Tbl.Col.query('attributeInfo') as attributeInfo,
		IsNull(Tbl.Col.value('@isDefault','bit'),0) as isDefault,
		IsNull(Tbl.Col.value('@statusFilter','INTEGER'),0) as statusFilter
from @inputxml.nodes('App_GetAssociatedEntitiesProc/individualReqs') as Tbl(col)
-- Now if isNestedCall parameter is not present as part of processinginstructioninfo , we insert the
-- attribute here and set it to 1.
if (@inputxml.exist('App_GetAssociatedEntitiesProc/processinginstructioninfo/@isNestedCall')=0)
begin
	set @inputxml.modify('insert attribute isNestedCall {1}
			into (/App_GetAssociatedEntitiesProc/processinginstructioninfo)[1]')
end
set @processingInstructionInfo = @inputxml.query('App_GetAssociatedEntitiesProc/processinginstructioninfo')
DECLARE @entitycur CURSOR
set @entitycur = CURSOR
	FOR	SELECT expandLevel,entity,noOfEntities ,attributeInfo,isDefault,statusFilter
		from @inputRequestList
		OPEN @entitycur
			FETCH NEXT FROM @entitycur INTO @expandLevel,@entity,@noOfEntities ,@attributeInfo,@isDefault,@statusFilter
			WHILE @@FETCH_STATUS = 0
			BEGIN
				set @getAssociatedEntities = ''
				delete from @tempSPOutputTable
				set @isDefaultQuery = 0
				-- Now in case of Pseudo clients, we retrieve all VS Pseudo clients first.
				-- And then we query for Instances of these clients. So that we can retrieve appropriate type of VS client
				-- like V-Center or Hyper V etc
				-- We will query for all Virtual Server clients for now.
				-- Whether VMWare or not will be indicated by attribute "Virtual Server Instance type"
if @expandLevel = 88
				begin
					-- Now generate the entity xml with ApptypeId = 106
					set @expandLevel = 5
					if (@entity.value('count(/entity/@*)','int')=0)
					begin
						-- Now set entity list now.
						set @entity	= ( select Distinct c.id as '@clientId',
								idaName.appTypeId as '@applicationId'
							from APP_IDAName idaName with (nolock) inner join APP_Client C with (nolock)
							on c.id = idaName.clientId
							and idaName.appTypeId = 106
							where @allAssociations = 1 OR Exists
									(
										select 1 from #gsAssociatedEntities GSA
										where GSA.clientId = idaName.clientId
										and (idaName.AppTypeId = GSA.appTypeId or GSA.appTypeId = 0)
									)
							for xml path('entity')
							)
					end
				end
				if (@isDefault=1)
				begin
					set @isDefaultQuery = 1
				end
				else
				begin
					set @isDefaultQuery = 0
				end
				if (@attributeInfo.exist('attributeInfo/@name')!=0)
				begin
					set @isAttributeFilterPresent = 1
				end
				else
				begin
					set @isAttributeFilterPresent = 0
				end
if @expandLevel = 109 -- We will query for all pseudo clients for now.
				begin
					set @expandLevel = 4 	-- APPTYPE_ENTITY
					if (@entity.value('count(/entity/@*)','int')=0)
					begin
						-- Now set entity list now. Avoid call to GetAssociatedEntities since it can be expensive.
						set @getAssociatedEntities = (select Distinct top (@noOfEntities) c.id as 'entity/@clientId',
								c.name as 'entity/@clientName',
								idaName.appTypeId as 'entity/@applicationId',
								IdaType.displayName as 'entity/@appName'
							from APP_IDAName idaName with (nolock) inner join APP_Client C with (nolock)
							on ((c.specialClientFlags & 0x2)=0) and --Packages are installed.
							c.id = idaName.clientId
							and idaName.appTypeId = 106
							and (IdaName.status& 0x00010)=0
							and (IdaName.status& 0x00020)=0
							/* Same as below lines from GetAssociatedEntities without first line since getDeconfigured is 1 by default.
NOT ((IdaName.status& 0x00002)<> 0 and T.getDeconfigured = 0)	--	CV_STATUS_UNINSTALLED
AND NOT ((IdaName.status& 0x00010) <> 0 and T.excludeEntity =1) --CV_STATUS_DUMMY
AND NOT ((IdaName.status& 0x00020) <> 0 and T.excludeEntity =1) --CV_STATUS_HIDDEN
							*/
							 and (
                                    @allAssociations = 1 OR Exists
                                    (
                                        select 1 from #gsAssociatedEntities GSA
                                        where GSA.clientId = idaName.clientId
                                        and (idaName.AppTypeId = GSA.appTypeId or GSA.appTypeId = 0)
                                    )
                                )
							inner join App_IdaType IdaType WITH (NOLOCK)
							on IdaType.type = idaName.appTypeId
							for xml path('response'),root('App_GenericResponse')
							)
					end
				end
				-- Now either if its a default Query or query based on Attributes (AttributeInfo filter) ,
				-- then we do the query here itself instead of calling GetAssociatedEntities
				if (@isDefaultQuery = 0 AND @isAttributeFilterPresent = 0)
				begin
					-- Because in above, we compute result using query to avoid calling GetAssociatedEntities.
if (@expandLevel <> 109)
					begin
						set @getAssociatedEntities = (
							select @expandLevel '@expandLevel',
								@noOfEntities '@noOfEntities',
								--@statusFilter '@status',
								@entity,
								@processingInstructionInfo
							for xml path ('App_GetAssociatedEntities')
						)
						exec dbo.GetAssociatedEntities @getAssociatedEntities output
					end
					Insert into @tempSPOutputTable
					select @getAssociatedEntities
				end
				else
				begin
					-- Always assume default filter.
					declare @entityFilterInput table
					(
						commCellId int,
						clientId int,
						appTypeId int,
						instanceId int,
						backupsetId int,
						scId int,
						appGrpId int
					)
					delete from @entityFilterInput
					insert into @entityFilterInput
					SELECT
					ISNULL(Tbl.Col.value('@commCellId', 'int'),2) ,
					ISNULL(Tbl.Col.value('@clientId', 'int'),0),
					ISNULL(Tbl.Col.value('@applicationId', 'int'),0) ,
					ISNULL(Tbl.Col.value('@instanceId', 'int'),0),
					ISNULL(Tbl.Col.value('@backupsetId', 'int'),0),
					ISNULL(Tbl.Col.value('@subclientId', 'int'),0),
					ISNULL(Tbl.Col.value('@appGroupId', 'int'),0) -- App GroupId
					FROM @entity.nodes('/entity') as Tbl(Col)
					declare @clientApptypeList table
					(
						clientId int,
						appType int
					)
					delete from @clientApptypeList
					Insert into @clientApptypeList
					select clientId,appTypeId
					from @entityFilterInput EF
					union
					select idaName.clientid,idaName.appTypeId
					from app_idaname idaname with (nolock) inner join App_AppTypeGroupAssoc atga
					on atga.appTypeid = idaname.appTypeId
					inner join @entityFilterInput EF
					on atga.appGroupId = EF.appGrpId
					where EF.appGrpId!=0
					declare @entityList table
					(
						clientId int,
						clientName nvarchar(max),
						ApplicationId int,
						appName nvarchar(max),
						instanceId int,
						instanceName nvarchar(max),
						backupsetId int,
						backupsetName nvarchar(max),
						SubclientId int,
						SubclientName nvarchar(max),
						entityType int
					)
					declare @entityListtemp table
					(
						clientId int,
						clientName nvarchar(max),
						ApplicationId int,
						appName nvarchar(max),
						instanceId int,
						instanceName nvarchar(max),
						backupsetId int,
						backupsetName nvarchar(max),
						SubclientId int,
						SubclientName nvarchar(max),
						entityType int
					)
					delete from @entityList
					Insert into @entityList
					select distinct
					app.ClientId ,
					NULL,
					app.appTypeId ,
					NULL,
					app.Instance ,
					NULL,
					app.Backupset ,
					bs.name,
					app.id,
					app.subclientName,
					7
					from APP_BackupSetName bs with (nolock) inner join
					APP_Application app with (nolock) on bs.id = app.backupSet
					inner join @clientApptypeList clientapptypeList on
					clientapptypeList.clientId = app.ClientId and
					clientapptypeList.apptype = app.appTypeId
					where ((bs.status & 8)>0
							OR (@isDefaultQuery = 0 AND (bs.status & (4|2))=0))
					AND ((app.subclientStatus & 8)>0)
					And (@isDefaultQuery = 0 OR (App.subclientstatus & (4|2))=0)
					AND (@allAssociations = 1 Or exists(
						select 1 from #gsAssociatedEntities GSA
						where GSA.clientId = app.ClientId
						and (GSA.appTypeId = app.appTypeId or GSA.appTypeId=0)
						and (GSA.instanceId = app.instance or GSA.instanceId=0)
						and (GSA.backupsetId = app.backupset or GSA.backupsetId=0)
						and (GSA.subclientId = app.id or GSA.subclientId=0)
					))
					order by app.id desc
					update T
					set clientName = C.name
					from @entityList T inner join App_client C WITH (NOLOCK)
					on c.id = T.clientid
					update T
					set appName = IdaName.name
					from @entityList T inner join App_IdaType IdaName WITH (NOLOCK)
					on IdaName.type = T.ApplicationId
					update T
					set instanceName = dbo.EncodeInvalidXMLChar(InstName.name)
					from @entityList T inner join App_InstanceName InstName WITH (NOLOCK)
					on InstName.id = T.instanceId
					-- Now check the entity generic response and check for application properly
					-- IDAProp -- 'Enable Archive'
					if @attributeInfo.exist('attributeInfo/@name')!=0
					begin
						declare @queryAttributesInfo table
						(
							Name nvarchar(max),
							Value nvarchar(max)
						)
						delete from @queryAttributesInfo
						Insert into @queryAttributesInfo
							SELECT
							ISNULL(Tbl.Col.value('@name', 'nvarchar(max)'),0) as Name,
							ISNULL(Tbl.Col.value('@value', 'nvarchar(max)'),0) as Value
							FROM @attributeInfo.nodes('attributeInfo') as Tbl(Col)
						declare @genericResponse xml
						set @genericResponse = IsNull((select @xml),'<App_GenericResponse/>')
						declare @AttributesTable table
						(
							id int,
							propertyName nvarchar(max),
							propertyValue nvarchar(max)
						)
						delete from @AttributesTable
						if @expandLevel = 2 OR @expandLevel = 3
						begin
							insert into @AttributesTable
							select componentNameId,attrName,convert(nvarchar(max),attrVal)
							from APP_ClientProp with (nolock)
							where modified=0
							and attrName in
							(
								select distinct Name from @queryAttributesInfo
							)
						end
						if @expandLevel = 7
						begin
							insert into @AttributesTable
							select componentNameId,attrName,convert(nvarchar(max),attrVal)
							from APP_SubClientProp with (nolock)
							where modified=0
							and attrName in
							(
								select distinct Name from @queryAttributesInfo
							)
						end
						if @expandLevel = 4
						begin
							insert into @AttributesTable
							select componentNameId,attrName,convert(nvarchar(max),attrVal)
							from APP_IDAProp with (nolock)
							where modified=0
							and attrName in
							(
								select distinct Name from @queryAttributesInfo
							)
							-- Where there is no value in the DB the default value should be assumed.
							-- Coding for a specific property now since defaults change across properties
							insert into @AttributesTable
							select distinct IDA.id, 'Enable Archive', '0'
							from APP_IDAName IDA with (nolock)
							where IDA.id not in
							(
								select distinct id from @AttributesTable where propertyName = 'Enable Archive'
							)
						end
						if @expandLevel = 5
						begin
							insert into @AttributesTable
							select componentNameId,attrName,convert(nvarchar(max),attrVal)
							from APP_InstanceProp with (nolock)
							where modified=0
							and attrName in
							(
								select distinct Name from @queryAttributesInfo
							)
						end
						delete from @entityListtemp
						Insert into @entityListtemp
						select tbl.*
						from @AttributesTable A , @entityList tbl, @queryAttributesInfo InputQueryAttributes
						where InputQueryAttributes.Name = A.propertyName
						and InputQueryAttributes.Value = A.propertyValue
						and (
								(
									(@expandLevel = 2 OR @expandLevel = 3) AND
									A.id = tbl.ClientId)
								OR  (@expandLevel = 7 and A.id = tbl.SubclientId)
								OR  (@expandLevel = 5 and A.id = tbl.InstanceId)
								OR (@expandLevel = 4 AND Exists
									(
										select * from
										APP_IDAName with (nolock)
										where APP_IDAName.clientId = tbl.ClientId
										and APP_IDAName.appTypeId = tbl.ApplicationId
										and APP_IDAName.id = A.id
									)
								)
							)
						delete from @entityList
						Insert into @entityList
						select distinct * from @entityListtemp
					end
						set @genericResponse = IsNull((SELECT top (@noOfEntities)
								tbl.ClientId as 'entity/@clientId' ,
								tbl.ClientName as 'entity/@clientName',
								7 as 'entity/@_type_',
								tbl.ApplicationId as 'entity/@applicationId',
								tbl.AppName as 'entity/@appName',
								tbl.InstanceId as 'entity/@instanceId',
								tbl.InstanceName as 'entity/@instanceName',
								tbl.BackupsetId as 'entity/@backupsetId',
								tbl.BackupsetName as 'entity/@backupsetName',
								tbl.SubclientId as 'entity/@subclientId',
								tbl.SubclientName as 'entity/@subclientName',
								App_Application.dataArchGrpID AS 'entity/@storagePolicyId',
								case
when (C.status & 0x00002) > 0 then 1
									else 0
								end as 'entity/flags/@disabled'
								from @entityList tbl
								inner join App_Client C on tbl.ClientId = C.id
								LEFT JOIN App_Application (NOLOCK) ON App_Application.Id = tbl.SubclientID
						order by tbl.SubclientId desc
						for xml path('response')),'<response/>')
						set @genericResponse = (select @genericResponse
								for xml path('App_GenericResponse'))
						delete from @AttributesTable
						Insert into @tempSPOutputTable
						select @genericResponse
				end
				-- Now Insert into output table
				Insert into @responsesList
				select output.query('App_GenericResponse/response')
				from @tempSPOutputTable
				FETCH NEXT FROM @entitycur INTO @expandLevel,@entity,@noOfEntities ,@attributeInfo,@isDefault,@statusFilter
			end
	--select * from @responsesList
	DECLARE @temp	XML
	DECLARE @isCommServeCachePresent int
	DECLARE @isVSABackupRun int
	set @isCommServeCachePresent = 0
	set @isVSABackupRun = 0
	if (exists(Select packageStatus from patchUpdateAgentInfo where clientId=2 and packageStatus=1)
	)
	begin
		set @isCommServeCachePresent = 1
	end
	if exists(select 1 from jmBkpStats with (nolock) inner join App_Application with (nolock)
		on jmBkpStats.appType = 106 and jmBkpStats.status = 1 and jmBkpStats.appId = App_Application.id and
		App_Application.instance in
			(
				select componentNameId from App_InstanceProp with (nolock)
				where modified = 0 and attrName='Virtual Server Instance Type'
				and attrVal='101'
			)
		) -- completed successfully
	begin
		set @isVSABackupRun = 1
	end
	declare @nvarcharXml nvarchar(max)
	set @xml = (select ISNULL((select response as 'responses'
		from @responsesList
		for xml path(''), root('App_GenericResponseList')),'<App_GenericResponseList/>'))
	set @nvarcharXml = CONVERT(nvarchar(max),@xml)
	set @nvarcharXml = REPLACE(@nvarcharXml,'<App_GenericResponseList>','<App_GenericResponseList isCommServeCachePresent="'+convert(nvarchar(max),@isCommServeCachePresent)+'" isVSABackupRun="'+convert(nvarchar(max),@isVSABackupRun)+'">')
	set @nvarcharXml = REPLACE(@nvarcharXml,'<App_GenericResponseList/>','<App_GenericResponseList isCommServeCachePresent="'+convert(nvarchar(max),@isCommServeCachePresent)+'" isVSABackupRun="'+convert(nvarchar(max),@isVSABackupRun)+'"/>')
	SET @xml = @nvarcharXml
	SELECT @xml
SET NOCOUNT OFF

IF EXISTS (select * from GxQscripts where name = 'GetStartedEntitiesProc')
	delete from GxQscripts where name = 'GetStartedEntitiesProc'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetStartedEntitiesProc')
	delete from GXDBVersions where aliasname = 'GetStartedEntitiesProc'
GO

insert into GXDBVersions values(2, 'GetStartedEntitiesProc',  'v1.20.2.6.4.1', 'GetStartedEntitiesProc', 'v1.20.2.6.4.1')
GO

