

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetSetWindowsMSSQLPatching.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Get and Set enabled property of MSSQL and Windows patching for a client.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetSetWindowsMSSQLPatching')
BEGIN
	print '>>> Drop Stored Procedure: GetSetWindowsMSSQLPatching <<<'
	drop procedure GetSetWindowsMSSQLPatching
END
IF EXISTS (select * from GxQscripts where name='GetSetWindowsMSSQLPatching')
	delete from GxQscripts where name = 'GetSetWindowsMSSQLPatching'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSetWindowsMSSQLPatching')
	delete from GXDBVersions where aliasname = 'GetSetWindowsMSSQLPatching'
GO
print '... Creating Procedure: GetSetWindowsMSSQLPatching'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetSetWindowsMSSQLPatching
  @inputxml XML
AS
SET NOCOUNT ON
DECLARE @clientId INT
DECLARE @option INT
DECLARE @MSSQLPatching INT
DECLARE @WindowsPatching INT
DECLARE @EligibleForMSSQLPatching INT
DECLARE @EligibleForWindowsOSPatching INT
DECLARE @MSSQLTYPE INT = 1
DECLARE @WINDOWSTYPE INT = 2
SET @option	= ISNULL((SELECT ref.value('@option', 'INTEGER')FROM @inputXML.nodes('App_GetSetWindowsMSSQLPatchingReq') R(ref)), 0)
SET @clientId	= ISNULL((SELECT ref.value('@clientId', 'INTEGER')FROM @inputXML.nodes('App_GetSetWindowsMSSQLPatchingReq') R(ref)), 0)
IF @option = 0 --Get properties.
BEGIN
	SET @MSSQLPatching = ISNULL((SELECT enabled FROM simInstalledThirdPartyCU WITH(NOLOCK) WHERE clientId = @clientId AND type = @MSSQLTYPE), -1)
	SET @WindowsPatching = ISNULL((SELECT enabled FROM simInstalledThirdPartyCU WITH(NOLOCK) WHERE clientId = @clientId AND type = @WINDOWSTYPE), -1)
	SET @EligibleForMSSQLPatching = ISNULL((SELECT eligible FROM simInstalledThirdPartyCU WITH(NOLOCK) WHERE clientId = @clientId AND type = @MSSQLTYPE), -1)
	SET @EligibleForWindowsOSPatching = ISNULL((SELECT eligible FROM simInstalledThirdPartyCU WITH(NOLOCK) WHERE clientId = @clientId AND type = @WINDOWSTYPE), -1)
END
ELSE IF @option = 1 --Update properties with user input.
BEGIN
	SET @MSSQLPatching	= ISNULL((SELECT ref.value('@MSSQLPatching', 'INTEGER')FROM @inputXML.nodes('App_GetSetWindowsMSSQLPatchingReq') R(ref)), 0)
	SET @WindowsPatching	= ISNULL((SELECT ref.value('@WindowsPatching', 'INTEGER')FROM @inputXML.nodes('App_GetSetWindowsMSSQLPatchingReq') R(ref)), 0)
	UPDATE simInstalledThirdPartyCU SET enabled = @MSSQLPatching WHERE clientId = @clientId AND type = @MSSQLTYPE
	UPDATE simInstalledThirdPartyCU SET enabled = @WindowsPatching WHERE clientId = @clientId AND type = @WINDOWSTYPE
END
ELSE IF @option = 2 --Get eligibility for install job option at client level.
BEGIN
	SET @MSSQLPatching = ISNULL((SELECT eligible * enabled FROM simInstalledThirdPartyCU WITH(NOLOCK) WHERE clientId = @clientId AND type = @MSSQLTYPE), -1)
	SET @WindowsPatching = ISNULL((SELECT eligible * enabled FROM simInstalledThirdPartyCU WITH(NOLOCK) WHERE clientId = @clientId AND type = @WINDOWSTYPE), -1)
END
ELSE IF @option = 3 --Get eligibility for install job option at client group level. Here @clientId has Client Group Id.
BEGIN
	SET @MSSQLPatching = ISNULL((SELECT MAX(eligible * enabled) FROM simInstalledThirdPartyCU sim WITH(NOLOCK)
								 JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) on sim.clientId = cga.clientId
								 WHERE sim.type = @MSSQLTYPE AND cga.clientGroupId = @clientId), -1)
	SET @WindowsPatching = ISNULL((SELECT MAX(eligible * enabled) FROM simInstalledThirdPartyCU sim WITH(NOLOCK)
								   JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) on sim.clientId = cga.clientId
								   WHERE sim.type = @WINDOWSTYPE AND cga.clientGroupId = @clientId), -1)
END
ELSE IF @option = 4 --Get eligibility for install job option at commcell level. Here @clientId has no use.
BEGIN
	SET @MSSQLPatching = ISNULL((SELECT MAX(eligible * enabled) FROM simInstalledThirdPartyCU sim WITH(NOLOCK)
								 JOIN APP_Client ap WITH(NOLOCK) on sim.clientId = ap.id
								 WHERE sim.type = @MSSQLTYPE), -1)
	SET @WindowsPatching = ISNULL((SELECT MAX(eligible * enabled) FROM simInstalledThirdPartyCU sim WITH(NOLOCK)
								   JOIN APP_Client ap WITH(NOLOCK) on sim.clientId = ap.id
								   WHERE sim.type = @WINDOWSTYPE), -1)
END
SELECT  @MSSQLPatching AS 'MSSQLPatching',
		@WindowsPatching AS 'WindowsPatching',
		@EligibleForMSSQLPatching AS 'EligibleForMSSQLPatching',
		@EligibleForWindowsOSPatching AS 'EligibleForWindowsOSPatching'
		FOR XML PATH(''), ROOT('App_GetSetWindowsMSSQLPatchingReq')
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetSetWindowsMSSQLPatching')
	delete from GxQscripts where name = 'GetSetWindowsMSSQLPatching'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSetWindowsMSSQLPatching')
	delete from GXDBVersions where aliasname = 'GetSetWindowsMSSQLPatching'
GO

insert into GXDBVersions values(2, 'GetSetWindowsMSSQLPatching',  '00000000000000000000', 'GetSetWindowsMSSQLPatching', '00000000000000000000')
GO

