

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetSetIdxSrvrForExchOnePassApp.sp] ---------- 

SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetSetIdxSrvrForExchOnePassApp')
BEGIN
	print '>>> Drop Stored Procedure: GetSetIdxSrvrForExchOnePassApp <<<'
	drop procedure GetSetIdxSrvrForExchOnePassApp
END
IF EXISTS (select * from GxQscripts where name='GetSetIdxSrvrForExchOnePassApp')
	delete from GxQscripts where name = 'GetSetIdxSrvrForExchOnePassApp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSetIdxSrvrForExchOnePassApp')
	delete from GXDBVersions where aliasname = 'GetSetIdxSrvrForExchOnePassApp'
GO
print '... Creating Procedure: GetSetIdxSrvrForExchOnePassApp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetSetIdxSrvrForExchOnePassApp
  @i_bsGuid nvarchar(36),
  @i_dbGuid nvarchar(36),
  @i_clname nvarchar(1024),
  @i_type INT,
  @i_idxAppType INT,
  @outXml XML OUTPUT
AS
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
CREATE TABLE #getIndexServers
					(     serverURL NVARCHAR(512),
							clientId INT,
							clientName NVARCHAR(256),
							cloudId INT,
							hostName NVARCHAR(256),
							basePort INT,
							engineName  NVARCHAR(256),
							serverType INT,
							indexServerClientId INT,
							internalCloudName NVARCHAR(256)
					)
DECLARE @idxSrvrClId INT = 0
DECLARE  @engineType INT  = 2/*LUCENE*/
DECLARE  @solrServerType INT = 1 -- Standalone
DECLARE @errCode INT = 0
DECLARE @errString	NVARCHAR(MAX)=N''
DECLARE @newIdxServerName NVARCHAR(1024)
DECLARE @oldIdxServerName NVARCHAR(1024)
DECLARE @bsId INT
DECLARE @pseudoISClientId INT
SELECT @bsId = BS.id from APP_BackupSetName as BS WITH(NOLOCK) where BS.GUID = @i_bsGuid
	SET @engineType = 2/*LUCENE*/
	SET @solrServerType = 1 -- Standalone
	SET @pseudoISClientId = ISNULL((
									SELECT CAST(attrVal AS INT) FROM App_IdaProp WITH(NOLOCK) WHERE componentNameId in(
									SELECT A.id FROM App_IdaName A WITH(NOLOCK), App_Application B WITH(NOLOCK) WHERE B.clientId = A.clientId AND A.appTypeId = B.appTypeID AND
									B.id = (SELECT TOP 1 id FROM App_Application WITH(NOLOCK) WHERE backupSet in (SELECT id FROM APP_BackupSetName WITH(NOLOCK) WHERE CAST(GUID AS VARCHAR(64)) = @i_bsGuid)))
									AND attrName = 'OnePass Index Server' AND modified = 0), 0)
	IF @pseudoISClientId > 0
	BEGIN
			SET @solrServerType = (SELECT cloudType FROM Dm2Cloud WITH(NOLOCK) WHERE pseudoClientId = @pseudoISClientId)
	END
	EXEC DM2GetIndexServers  '', @pseudoISClientId
	SELECT @idxSrvrClId = ( SELECT TOP 1 clientId FROM #getIndexServers)
	DELETE FROM #getIndexServers
	IF @idxSrvrClId IS NULL OR @idxSrvrClId = 0
	BEGIN
		SET @errCode = 1
		SET @errString = 'Unable to fetch the index server'
		SET @outXml = (
			select   @errCode as '@errorCode', @errString as '@errorString'
			FOR XML PATH('App_SetIdxSrvrForDbResp'), type)
		GOTO CX_EXIT
	END
	-- For the SOLR Cloud populate the Index Server Pseudo client Id.
	IF (@solrServerType IN(4/*SolrEmbeddedCloud*/, 5/*SolrClusterCloud*/))
	BEGIN
		IF NOT EXISTS (select 1 from App_IndexDBInfo where dbName = @i_dbGuid and backupSetGuid = @i_bsGuid and currentIdxServer = @pseudoISClientId AND isPrimary = 1)
		BEGIN
			SELECT @newIdxServerName = name FROM APP_Client WITH (NOLOCK) WHERE id = @pseudoISClientId
			SET @oldIdxServerName = ISNULL((SELECT name FROM App_IndexDBInfo A WITH (NOLOCK) JOIN APP_Client B WITH (NOLOCK) ON a.currentIdxServer = B.id
			WHERE dbName=@i_dbGuid AND backupSetGUID=@i_bsGuid AND isPrimary = 1), '')
			IF LEN(@oldIdxServerName) > 0
			BEGIN
				UPDATE App_IndexDBInfo
				SET currentIdxServer = @pseudoISClientId
				WHERE dbName = @i_dbGuid AND backupSetGuid = @i_bsGuid AND isPrimary = 1
			END
			ELSE
			BEGIN
				INSERT INTO App_IndexDBInfo (dbName, type, idxDbEngineType, backupSetId, currentIdxServer, backupSetGUID, properties, isPrimary, committedTransactionId)
				VALUES (@i_dbGuid, @i_type, @engineType, @bsId, @pseudoISClientId, @i_bsGuid, NULL, 1/*IsPrimary*/, 0/*Committed TranscationID*/)
			END
			IF @oldIdxServerName <> @newIdxServerName
				EXEC AppAuditIdxServerChange @oldIdxServerName, @newIdxServerName
		END
	END
	SET @outXml = (
		select(
			select CL.name as '@clientName' , CL.net_hostname as '@hostName', CL.cvdPort as '@cvdPort', CL.evmgrcPort as '@evmgrcPort', @engineType as '@idxDbEngineType', CL.id as '@clientId'
			from  App_client as CL WITH(NOLOCK) WHERE CL.id = @idxSrvrClId
			FOR XML PATH ('idxSrvrClientInfos'), type
		) FOR XML PATH('App_SetIdxSrvrForDbResp'), type)
CX_EXIT:
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
GO

IF EXISTS (select * from GxQscripts where name = 'GetSetIdxSrvrForExchOnePassApp')
	delete from GxQscripts where name = 'GetSetIdxSrvrForExchOnePassApp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSetIdxSrvrForExchOnePassApp')
	delete from GXDBVersions where aliasname = 'GetSetIdxSrvrForExchOnePassApp'
GO

insert into GXDBVersions values(2, 'GetSetIdxSrvrForExchOnePassApp',  '00000000000000000000', 'GetSetIdxSrvrForExchOnePassApp', '00000000000000000000')
GO

