

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetSetDynamicIdxSrvrForDb.sp] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='GetSetDynamicIdxSrvrForDb')
BEGIN
	print '>>> Drop Stored Procedure: GetSetDynamicIdxSrvrForDb <<<'
	drop procedure GetSetDynamicIdxSrvrForDb
END
IF EXISTS (select * from GxQscripts where name='GetSetDynamicIdxSrvrForDb')
	delete from GxQscripts where name = 'GetSetDynamicIdxSrvrForDb'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSetDynamicIdxSrvrForDb')
	delete from GXDBVersions where aliasname = 'GetSetDynamicIdxSrvrForDb'
GO
print '... Creating Procedure: GetSetDynamicIdxSrvrForDb'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure GetSetDynamicIdxSrvrForDb
  @i_bsGuid nvarchar(36),
  @i_dbGuid nvarchar(36),
  @i_clname nvarchar(1024),
  @i_type INT,
  @i_idxAppType INT,
  @o_idxSrvrClId INT OUTPUT
AS
DECLARE @clId INT
DECLARE @engineType INT = 2
DECLARE @srcClientId INT = 0
DECLARE @bsId INT
SELECT @clId = id FROM app_client WITH(NOLOCK) WHERE name = @i_clname
SELECT @bsId = BS.id from APP_BackupSetName as BS WITH(NOLOCK) where BS.GUID = @i_bsGuid
SELECT TOP(1) @srcClientId = clientId from APP_Application WITH(NOLOCK) WHERE backupSet = @bsId
DECLARE @isCloudLaptop INT = 0
IF EXISTS (SELECT 1 FROM APP_SubClientProp SCP WITH(NOLOCK)
			INNER JOIN APP_Application APP WITH(NOLOCK) ON SCP.componentNameId = APP.id
			WHERE SCP.attrName = 'Cloud Mode Enabled' AND SCP.attrVal = N'1' AND SCP.modified = 0 AND APP.backupset = @bsId)
	SET @isCloudLaptop = 1
IF ((@isCloudLaptop = 1) OR @i_idxAppType = 200115)
BEGIN
	IF @isCloudLaptop = 1
		SET @clId = NULL
	-- for cloud laptop try getting indexserver id from associated plan.
		DECLARE @planId INT = 0
		SELECT @planId = ACP.attrVal FROM APP_ClientProp ACP WITH(NOLOCK)
WHERE ACP.attrName = N'Associated Plan' AND ACP.componentNameId = @srcClientId AND ACP.modified = 0
		--
		-- GET INDEX SERVER FROM RESOURCE POOL ASSOCIATED TO THE PLAN -----------------------------------------------------------------------------------------
DECLARE @isCloudModeEnabledForPlan INT = dbo.AppPlanGetEntityValueV2(@planId, 'Cloud Mode Enabled', default)
		IF @isCloudModeEnabledForPlan = 1
		BEGIN
DECLARE @storagePolicyId INT = ISNULL((SELECT dataArchGrpId FROM App_Application WITH(NOLOCK) WHERE backupset=@bsId AND subclientStatus&0x00008=0x00008), 0)
			DECLARE @x_xmlData XML
EXEC AppResourcePoolGetForEntity @storagePolicyId, 17, 12/*Api::ResourcePoolApptype_CLOUD_LAPTOP*/, 0/*return no result set*/, @x_xmlData OUTPUT
			SET @clId = (SELECT ref.value('@clientId', 'INT') AS [clientGroupId]
											FROM @x_xmlData.nodes('Api_GetResourcePoolDetailsResp/resourcePool/indexServer') R ( ref ))
		END
		-- GET INDEX SERVER FROM RESOURCE POOL ASSOCIATED TO THE PLAN -----------------------------------------------------------------------------------------
		--
	IF @clId IS NULL
-- for cloud laptop engine type is solr and pick the index server from client property.
		SELECT @clId  = CP.longval FROM  APP_CLIENTGROUPASSOC CGA  WITH(NOLOCK)
				JOIN APP_COMPONENTPROP CP  WITH(NOLOCK) ON  CP.componentId = CGA.clientGroupId
WHERE CP.propertyTypeId = 3609 AND  CGA.clientId = @srcClientId AND CP.componentType = 8
	IF @clId IS NOT NULL
	BEGIN
		IF  NOT EXISTS (select currentIdxServer from App_IndexDBInfo WITH(NOLOCK) where dbName = @i_dbGuid and backupSetGuid = @i_bsGuid AND isPrimary = 1)
		BEGIN
			INSERT INTO App_IndexDBInfo (dbName, type, idxDbEngineType, backupSetId, currentIdxServer, backupSetGUID, properties, isPrimary, committedTransactionId)
				SELECT @i_dbGuid, @i_idxAppType,  @engineType, @bsId, @clId, @i_bsGuid, NULL, 1, 0  WHERE NOT EXISTS(select currentIdxServer from App_IndexDBInfo where dbName = @i_dbGuid and backupSetGuid = @i_bsGuid AND isPrimary = 1)
		END
		-- update existing, existing laptop converted to cloud mode.
		ELSE IF NOT EXISTS (select currentIdxServer from App_IndexDBInfo WITH(NOLOCK) WHERE dbName = @i_dbGuid and backupSetGuid = @i_bsGuid AND isPrimary = 1 AND currentIdxServer = @clId AND idxDbEngineType = @engineType)
		BEGIN
				UPDATE App_IndexDBInfo SET idxDbEngineType = @engineType, currentIdxServer = @clId WHERE dbName = @i_dbGuid and backupSetGuid = @i_bsGuid AND isPrimary = 1
		END
	END
END
SELECT @o_idxSrvrClId = currentIdxServer from App_IndexDBInfo WITH(NOLOCK) WHERE dbName = @i_dbGuid and backupSetGuid = @i_bsGuid AND isPrimary = 1
GO

IF EXISTS (select * from GxQscripts where name = 'GetSetDynamicIdxSrvrForDb')
	delete from GxQscripts where name = 'GetSetDynamicIdxSrvrForDb'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSetDynamicIdxSrvrForDb')
	delete from GXDBVersions where aliasname = 'GetSetDynamicIdxSrvrForDb'
GO

insert into GXDBVersions values(2, 'GetSetDynamicIdxSrvrForDb',  '00000000000000000000', 'GetSetDynamicIdxSrvrForDb', '00000000000000000000')
GO

