

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetSetClassicIdxSrvrForDb.sp] ---------- 

SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='GetSetClassicIdxSrvrForDb')
BEGIN
	print '>>> Drop Stored Procedure: GetSetClassicIdxSrvrForDb <<<'
	drop procedure GetSetClassicIdxSrvrForDb
END
IF EXISTS (select * from GxQscripts where name='GetSetClassicIdxSrvrForDb')
	delete from GxQscripts where name = 'GetSetClassicIdxSrvrForDb'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSetClassicIdxSrvrForDb')
	delete from GXDBVersions where aliasname = 'GetSetClassicIdxSrvrForDb'
GO
print '... Creating Procedure: GetSetClassicIdxSrvrForDb'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure GetSetClassicIdxSrvrForDb
  @i_bsGuid nvarchar(36),
  @i_dbGuid nvarchar(36),
  @i_clname nvarchar(1024),
  @i_type INT,
  @i_idxAppType INT,
  @i_forceSwitch INT,
  @i_copyId INT,
  @i_primary INT,
  @i_userRequest INT,
  @i_jobId INT,
  @o_idxSrvrClId INT OUTPUT
AS
DECLARE @idxSrvrOfflineHardThreshold INT = 259200 -- 3 days in seconds
DECLARE @idxSrvrOfflineSoftThreshold INT = 600 --10 mins
DECLARE @idxSrvrSwitchEnabled INT = 1
DECLARE @engineType INT = 1
DECLARE @clId INT
DECLARE @bsId INT
DECLARE @dbId INT
DECLARE @oldIdxServerId INT
DECLARE @reason INT = 0
DECLARE @newIdxServerName NVARCHAR(1024)
DECLARE @oldIdxServerName NVARCHAR(1024)
DECLARE @tempAvailIdxMas TABLE (clientId int, OfflineTimeStamp int, offlineReason int, isPowerManagedVM bit, markedOffline int, loadStatus int, loadCapacity float, currentLoad float, predictedCapacity float, assignCount int, usePreferredDataPath INT)
SELECT @bsId = BS.id from APP_BackupSetName as BS WITH(NOLOCK) where BS.GUID = @i_bsGuid
DECLARE @appId INT = 0
DECLARE @ownClientId INT = 0 -- Client that is represented by this index
DECLARE @subclientIndexEnabled INT = dbo.isSubClientIndexEnabled(@bsId)
SELECT TOP 1 @appId = App.id, @ownClientId = App.clientId from App_Application App WITH(NOLOCK) WHERE App.backupset = @bsId AND (@subclientIndexEnabled = 0 OR App.GUID = @i_dbGuid)
SELECT @idxSrvrOfflineHardThreshold = value FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'IdxSrvrOfflineHardThreshold'
SELECT @idxSrvrOfflineSoftThreshold = value FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'IdxSrvrOfflineSoftThreshold'
SELECT @idxSrvrSwitchEnabled = value FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'EnableIdxSrvrSwitch'
DECLARE @idxSrvrSwitchEnabledForUserBrowse INT = 0
SELECT @idxSrvrSwitchEnabledForUserBrowse = value FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'EnableIdxSrvrSwitchForUserBrowse'
--In case of a user driven browse or recall, switch IndexServer when it is offline for more than 5 minutes. This will be made default behaviour in SP23.
IF (@i_userRequest = 1 AND @idxSrvrSwitchEnabledForUserBrowse = 1 AND  @idxSrvrOfflineHardThreshold > 300)
BEGIN
	SET @idxSrvrOfflineHardThreshold = 300
END
--Values:
--0 - switch disabled
--1 - default
--2 - switch is enabled within primary copy only (same behaviour as with default copy precedence)
--3  disabled and limited to the primary copy - RE: TR - SP17 - Qisda Corporation - 10021E - Browsing failed with Index Issue - 191210-67 CVLT::0457023492
-- 4  Unless it is a user driven operation like browse or recall, disable switching MA on hard threshold and increase soft threshold to a day - Metallic
IF  @idxSrvrSwitchEnabled = 2
BEGIN
	SET @i_copyId = 0
	SET @idxSrvrSwitchEnabled = 1
END
ELSE IF @idxSrvrSwitchEnabled = 3
BEGIN
	SET @i_copyId = 0
	SET @idxSrvrSwitchEnabled = 0
END
ELSE IF @idxSrvrSwitchEnabled  = 4
BEGIN
	IF @i_userRequest <> 1
	BEGIN
		SET @idxSrvrSwitchEnabled = 0
		SET @idxSrvrOfflineSoftThreshold = 86400
	END
END
-- Use Index servers from the Index server client if they are selected by user
SELECT CAST(CAST(APROP.ATTRVAL AS VARCHAR(4096)) AS XML) IdxSrvXML INTO #tmpIdxSrvListXML
FROM archGroup AG WITH (NOLOCK)
JOIN APP_ClientProp CP WITH (NOLOCK) ON CP.attrName = 'Index Server ArchGroup Id' AND CP.attrVal = AG.id
JOIN APP_Application APP2 WITH (NOLOCK) ON APP2.clientId = CP.componentNameId
JOIN APP_SubClientProp APROP WITH (NOLOCK) ON
APROP.attrName = N'Data Access Nodes' AND APROP.cs_attrName = CHECKSUM(N'Data Access Nodes') AND APROP.modified = 0
AND APP2.id = APROP.componentNameId
WHERE AG.id IN (SELECT DISTINCT APP.dataArchGrpID FROM APP_Application APP WITH (NOLOCK) WHERE APP.backupSet = @bsId)
SELECT DISTINCT X.xmlcol.value('@clientId','integer') IdxSrvClientId INTO #tmpIdxSrvList FROM #tmpIdxSrvListXML T
CROSS APPLY T.IdxSrvXML.nodes('/App_DataAccessNodes/dataAccessNodes') X(xmlcol)
DECLARE @useIdxSrvList INT = (SELECT COUNT(*) FROM #tmpIdxSrvList where IdxSrvClientId is not NULL and IdxSrvClientId<>0)
-- Index server must be one of the active media agents of any of the primary/input copy storage policies of the backupset
INSERT INTO @tempAvailIdxMas
				SELECT DISTINCT MM.clientId,
				CASE WHEN (MmHostSoftState < 1 OR MmHostEnabled < 1) THEN MM.OfflineTimeStamp ELSE 0 END,
				OfflineReason,
CASE WHEN ((Attribute & 32768) = 32768) THEN 1 ELSE 0 END,
CASE WHEN ((Attribute & 16) = 16) THEN 1 ELSE 0 END,
				ISNULL(ISL.classification, 2),
				ISNULL(ISL.capacity, 0),
				ISNULL(ISL.load, 0),
				ISNULL(ISL.predictedCapacity, 0),
				ISNULL(ISL.assignCount, 0),
1 - SIGN(ISNULL(AGC.flags, 0) & (512 | 8 | 16)) -- usePreferredDataPath
				FROM mmhost AS MM WITH(NOLOCK)
				LEFT JOIN IdxServerLoad ISL WITH(NOLOCK) ON MM.ClientId = ISL.clientId
				INNER JOIN MMDrivePool MMDP WITH(NOLOCK) ON MM.clientId = MMDP.ClientId
				INNER JOIN MMDataPath MMD WITH(NOLOCK) ON MMD.DrivePoolId = MMDP.DrivePoolId AND MMD.Flag & 4 = 4
				INNER JOIN archGroupCopy AGC WITH(NOLOCK) ON MMD.CopyId = AGC.id
				INNER JOIN archGroup AG WITH(NOLOCK) ON
				CASE WHEN @i_copyId = 0  AND AGC.id = AG.defaultCopy THEN 1
					WHEN  @i_copyId <> 0 AND AGC.id = @i_copyId AND AGC.archGroupId = AG.id THEN 1
					ELSE 0 END = 1 AND AG.type = 1
				INNER JOIN APP_Application APP WITH(NOLOCK) ON AG.id = APP.dataArchGrpID AND APP.backupSet = @bsId AND APP.subclientStatus & 4 = 0 AND (@subclientIndexEnabled = 0 OR App.id = @appId)
				WHERE (@useIdxSrvList = 0 OR MM.clientId IN (SELECT IdxSrvClientId FROM #tmpIdxSrvList where IdxSrvClientId is not NULL and IdxSrvClientId<>0))
					AND (@subclientIndexEnabled = 1 OR NOT EXISTS (SELECT 1 FROM JMJobAction WITH(NOLOCK) WHERE clientId = 1 AND mediaAgentID = 1 AND appType = 0 AND optype = 4 AND appId = APP.id AND action = 1)) -- Get all MAs from storage policies used by subclients with enabled backup
-- if disabled switching then order of preference:
--   currentIndexServer if configured
--   same as "enabled switch" case
-- if enabled switching then order of preference:
--   specified MA if force switch or is no IndexServers configured
--   currentIndexServer if online
--   any online MA with least load
--   any MA with least load
select @clId = currentIdxServer from App_IndexDBInfo WITH(NOLOCK) where dbName = @i_dbGuid and backupSetGuid = @i_bsGuid AND isPrimary = @i_primary AND idxDbEngineType=@engineType
if @idxSrvrSwitchEnabled<>0 OR @clId IS NULL
BEGIN
    IF @i_forceSwitch=1 OR @clId IS NULL
        SELECT @clId = id FROM app_client WITH(NOLOCK) WHERE name = @i_clname
    IF @clId IS NULL OR (@i_forceSwitch=0 AND NOT EXISTS (SELECT 1 FROM @tempAvailIdxMas WHERE OfflineTimeStamp=0 AND  @clId = clientId))
    BEGIN
		-- If use preferred data-path is set, and index's client is media agent with index role, !!!ALWAYS!!!! use it as index server.
		-- if client's not in the available media agents to use (not lan-free), select one from the availables.
		SET @clId = ISNULL((SELECT TOP 1 clientId FROM @tempAvailIdxMas WHERE clientId = @ownClientId AND usePreferredDataPath = 1), NULL)
        -- pick online MA with least load
		IF @clId IS NULL
			SELECT TOP 1 @clId = clientId FROM @tempAvailIdxMas WHERE OfflineTimeStamp=0 ORDER BY loadStatus ASC, predictedCapacity DESC, loadCapacity DESC, currentLoad ASC, NEWID() DESC
        --pick any MA with least load - should be executed only if no IndexServer configured and all MAs on the copy are offline
        IF @clId IS NULL
            SELECT TOP 1 @clId = clientId FROM @tempAvailIdxMas ORDER BY  loadStatus ASC, OfflineTimeStamp DESC, predictedCapacity DESC, loadCapacity DESC, currentLoad ASC, NEWID() DESC
    END
END
DECLARE @currAppType INT = @i_type
-- If an index server was not already associated choose one now
IF @clId IS NOT NULL AND NOT EXISTS (select currentIdxServer from App_IndexDBInfo WITH(NOLOCK) where dbName = @i_dbGuid and backupSetGuid = @i_bsGuid AND isPrimary = @i_primary AND idxDbEngineType=@engineType)
BEGIN
	-- there can be only one primary, if primary was already set with different engine type and we are switching it, update existing
	IF @i_primary = 1 AND  EXISTS(select currentIdxServer from App_IndexDBInfo WITH(NOLOCK) where dbName = @i_dbGuid and backupSetGuid = @i_bsGuid AND isPrimary = @i_primary)
		UPDATE App_IndexDBInfo SET idxDbEngineType = @engineType, currentIdxServer=@clId WHERE dbName = @i_dbGuid and backupSetGuid = @i_bsGuid AND isPrimary = @i_primary
	ELSE
	INSERT INTO App_IndexDBInfo (dbName, type, idxDbEngineType, backupSetId, currentIdxServer, backupSetGUID, properties, isPrimary, committedTransactionId)
		SELECT @i_dbGuid, @i_idxAppType,  @engineType, @bsId, @clId, @i_bsGuid, NULL, 1, 0  WHERE NOT EXISTS(select currentIdxServer from App_IndexDBInfo where dbName = @i_dbGuid and backupSetGuid = @i_bsGuid AND isPrimary = @i_primary AND idxDbEngineType=@engineType)
	--For new installs this row is not present. To make it consistent with existing client which are converted to subclient index we insert this row.
	IF @subclientIndexEnabled > 0 AND NOT EXISTS(SELECT 1 FROM App_IndexDBInfo WHERE dbName = @i_bsGuid and backupSetGuid = @i_bsGuid AND isPrimary = @i_primary AND idxDbEngineType=@engineType)
	INSERT INTO App_IndexDBInfo (dbName, type, idxDbEngineType, backupSetId, currentIdxServer, backupSetGUID, properties, isPrimary, committedTransactionId)
		SELECT @i_bsGuid, @i_idxAppType,  @engineType, @bsId, @clId, @i_bsGuid, NULL, 1, 0  WHERE NOT EXISTS(select currentIdxServer from App_IndexDBInfo where dbName = @i_bsGuid and backupSetGuid = @i_bsGuid AND isPrimary = @i_primary AND idxDbEngineType=@engineType)
END
DECLARE @currEngineType INT = 0
SELECT @o_idxSrvrClId = currentIdxServer, @currAppType = type, @currEngineType = idxDbEngineType from App_IndexDBInfo WITH(NOLOCK) WHERE dbName = @i_dbGuid and backupSetGuid = @i_bsGuid AND isPrimary = @i_primary AND idxDbEngineType=@engineType
--Update the app type in App_IndexDBInfo if incorrect app type set
IF (@currAppType <> @i_idxAppType)
	BEGIN
		UPDATE App_IndexDBInfo SET type = @i_idxAppType WHERE dbName = @i_dbGuid and backupsetGuid = @i_bsGuid
	END
IF @clId IS NOT NULL
BEGIN
	DECLARE @currentIdxServer INT = 0
	SELECT @currentIdxServer = currentIdxServer FROM App_IndexDBInfo WITH (NOLOCK)
WHERE dbName = @i_dbGuid and backupSetGuid = @i_bsGuid AND isPrimary=@i_primary AND idxDbEngineType=@engineType AND flags & 2 > 0
	IF (@currentIdxServer > 0)
	BEGIN
		SET @o_idxSrvrClId = @currentIdxServer
	END
	ELSE
	BEGIN
		-- Index Server is not part of any of the dataPaths of that backupSet or It is offline for more than certain hard threshold and its not powered down because of power mangement enabled(offline reason = 7), Make a hard switch to available MA.
		IF NOT EXISTS (select 1 FROM @tempAvailIdxMas WHERE clientId = @o_idxSrvrClId AND (OfflineTimeStamp = 0 OR OfflineTimeStamp > (dbo.GetUnixTime(GETUTCDATE()) - @idxSrvrOfflineHardThreshold) OR (offlineReason = 7))) OR @i_forceSwitch = 1
			BEGIN
				IF  @idxSrvrSwitchEnabled = 1
				BEGIN
					SELECT @dbId = A.id, @oldIdxServerId = B.id, @oldIdxServerName = name FROM App_IndexDBInfo A WITH (NOLOCK) JOIN APP_Client B WITH (NOLOCK) ON a.currentIdxServer = B.id
					WHERE dbName=@i_dbGuid and backupSetGUID=@i_bsGuid
					SELECT @newIdxServerName = name FROM APP_Client WITH (NOLOCK) WHERE id = @clId
					IF @oldIdxServerName <> @newIdxServerName
						EXEC AppAuditIdxServerChange @oldIdxServerName, @newIdxServerName
					UPDATE App_IndexDBInfo SET currentIdxServer = @clId where dbName = @i_dbGuid and backupSetGuid = @i_bsGuid AND isPrimary=@i_primary AND idxDbEngineType=@engineType
					SET @o_idxSrvrClId = @clId
					IF EXISTS (SELECT 1 FROM IdxServerLoad WHERE clientId = @clId)
					BEGIN
						UPDATE IdxServerLoad SET assignCount += 1 WHERE clientId = @clId
					END
					IF @dbId IS NOT NULL
					BEGIN
						-- Update IdxServerMigration table with the current index server change
						IF @i_forceSwitch = 1
SET @reason = 4
						ELSE IF NOT EXISTS (SELECT 1 FROM @tempAvailIdxMas WHERE clientId = @oldIdxServerId AND (OfflineTimeStamp > (dbo.GetUnixTime(GETUTCDATE()) - @idxSrvrOfflineHardThreshold) OR (offlineReason = 7)))
SET @reason = 3
						ELSE
SET @reason = 1
						IF EXISTS (SELECT 1 FROM IdxServerMigrations WITH(NOLOCK) WHERE indexId = @dbId AND jobId = @i_jobId AND endTime = -1 AND isMigrated = 2)
							UPDATE IdxServerMigrations SET endTime = dbo.GetUnixTime(GETUTCDATE()), isMigrated = 1, reason = @reason
							WHERE indexId = @dbId AND jobId = @i_jobId AND endTime = -1 AND isMigrated = 2
						ELSE
							INSERT INTO IdxServerMigrations(indexId, fromClientId, toClientId, isMigrated, jobId, startTime, endTime, reason)
								VALUES (@dbId, @oldIdxServerId, @clId, 1, @i_jobId, dbo.GetUnixTime(GETUTCDATE()), dbo.GetUnixTime(GETUTCDATE()), @reason)
					END
				END
			END
		-- Index Server is part of datapaths however it is offline for a limited period and its not powered down because of power mangement enabled(offline reason = 7), Return available MA temporarily.
		ELSE IF EXISTS(select 1 FROM @tempAvailIdxMas WHERE clientId = @o_idxSrvrClId AND  OfflineTimeStamp != 0 AND OfflineTimeStamp < (dbo.GetUnixTime(GETUTCDATE()) - @idxSrvrOfflineSoftThreshold) AND offlineReason <> 7)
			SET @o_idxSrvrClId = @clId
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'GetSetClassicIdxSrvrForDb')
	delete from GxQscripts where name = 'GetSetClassicIdxSrvrForDb'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSetClassicIdxSrvrForDb')
	delete from GXDBVersions where aliasname = 'GetSetClassicIdxSrvrForDb'
GO

insert into GXDBVersions values(2, 'GetSetClassicIdxSrvrForDb',  '00000000000000000000', 'GetSetClassicIdxSrvrForDb', '00000000000000000000')
GO

