

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetSearchMonikerNames.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetSearchMonikerNames <<<'

IF EXISTS (select * from sysobjects where name='GetSearchMonikerNames')
	drop procedure GetSearchMonikerNames
IF EXISTS (select * from GxQscripts where name='GetSearchMonikerNames')
	delete from GxQscripts where name = 'GetSearchMonikerNames'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSearchMonikerNames')
	delete from GXDBVersions where aliasname = 'GetSearchMonikerNames'
GO
print '... Creating Procedure: GetSearchMonikerNames'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetSearchMonikerNames
  @i_monikerType INT ,
  @i_localeId INT = 0
AS
	DECLARE @monikerList TABLE (MonikerType INT, Name NVARCHAR(255), ResourceName NVARCHAR(255), t_LocaleMsgId INT, DisplayName NVARCHAR(MAX))
	--localized entityName
	INSERT INTO @monikerList (MonikerType, Name, ResourceName, DisplayName, t_LocaleMsgId)
	SELECT MonikerType, Name, ResourceName, '', CASE
WHEN ResourceName ='Last_X_Days' THEN (3403 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN ResourceName ='Last_1_Month' THEN (3402 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN ResourceName ='Last_X_Months' THEN (3404 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN ResourceName ='Last_1_Year' THEN (3406 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN ResourceName ='Last_X_Years' THEN (3405 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN ResourceName ='Beyond_1_Year' THEN (3401 | (CAST(POWER(2, 24) AS BIGINT) * 35))
WHEN ResourceName ='Beyond_X_Years' THEN (3400 | (CAST(POWER(2, 24) AS BIGINT) * 35))
                     END
	FROM SearchMonikerInfo WITH(NOLOCK)
	WHERE MonikerType = @i_monikerType
	-- GUI msg are defined as Beyond [X] Years
	--if id exists in msg table, use them and replace [X] with 2nd part of Name. i.e Use 3 inplace of [X] Last_3_Month
	-- incase gui msg doesnt exists, we replace _ with ' ' and use them as display name
	--
	UPDATE @monikerList
	SET DisplayName =	ISNULL(
							replace
							(
								dbo.fn_EvFormatEventMsgText(0, @i_localeId, t_LocaleMsgId, 0,2),
								'[X]',
								ISNULL((select Data from dbo.SplitString(Name, '_') where id=2),'')
							),
							replace(Name, '_', ' ')
						)
	SELECT Name, DisplayName from @monikerList
SET NOCOUNT OFF
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--  END
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
GO

IF EXISTS (select * from GxQscripts where name = 'GetSearchMonikerNames')
	delete from GxQscripts where name = 'GetSearchMonikerNames'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSearchMonikerNames')
	delete from GXDBVersions where aliasname = 'GetSearchMonikerNames'
GO

insert into GXDBVersions values(2, 'GetSearchMonikerNames',  '00000000000000000000', 'GetSearchMonikerNames', '00000000000000000000')
GO

