

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetSchedulePattern.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2009  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetSchedulePattern.sp,v $ $Id: GetSchedulePattern.sp,v 1.16.88.2 2017/02/10 19:55:36 sjohnson Exp $";
-- =============================================
-- Author:		Mohit Khullar
-- Create date: 10/19/2009
-- TODO: Remove hardcoded values which are being used in .cs file.
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetSchedulePattern <<<'

IF EXISTS (select * from sysobjects where name='GetSchedulePattern')
	drop procedure GetSchedulePattern
IF EXISTS (select * from GxQscripts where name='GetSchedulePattern')
	delete from GxQscripts where name = 'GetSchedulePattern'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSchedulePattern')
	delete from GXDBVersions where aliasname = 'GetSchedulePattern'
GO
print '... Creating Procedure: GetSchedulePattern'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetSchedulePattern
  @pid INTEGER,
  @locale INTEGER,
  @forLaptop INTEGER=0
AS
  DECLARE @o_pattern nvarchar(1024)
SET NOCOUNT ON
DECLARE @outputText		nvarchar(1024)
DECLARE @freq_type		INTEGER
DECLARE @Freq_interval		INTEGER
DECLARE @Freq_relative_interval		INTEGER
DECLARE @freq_recurrence_factor		INTEGER
DECLARE @secondsin12hours		INTEGER
DECLARE @secondsin1hour		INTEGER
DECLARE @secondsin1minute		INTEGER
DECLARE @minInterval NVARCHAR(12) = ''
DECLARE @minIntervalMin		NVARCHAR(12) = ''
DECLARE @maxInterval NVARCHAR(12) = ''
DECLARE @maxIntervalMin		NVARCHAR(12) = ''
DECLARE @subTaskId			INTEGER = 0
DECLARE @outputPattern		NVARCHAR(512) = ''
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
    SET @secondsin12hours = 43200
    SET @secondsin1hour = 3600
    SET @secondsin1minute = 60
    DECLARE @localeId					integer
    DECLARE @starting		nvarchar(256)
SET @starting = dbo.fn_EvFormatEventMsgText(0, @localeId, (2310 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
    SET @localeId = @locale
    select @freq_type=freq_type, @freq_interval=freq_interval, @freq_relative_interval=freq_relative_interval,
    @freq_recurrence_factor=freq_recurrence_factor
    FROM tm_pattern WITH (NOLOCK) WHERE patternId = @pid
    SET @outputText = ''
if (@Freq_type = 1) BEGIN
SET @outputText = dbo.fn_EvFormatEventMsgText(0, @localeId, (2421 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) + ' ' +
dbo.fn_EvFormatEventMsgText(0, @localeId, (2453 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
      SET @starting = ''
    END
else if (@Freq_type = 2) BEGIN
SET @outputText = dbo.fn_EvFormatEventMsgText(0, @localeId, (1042 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) + ' ' +
dbo.fn_EvFormatEventMsgText(0, @localeId, (2453 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
      SET @starting = ''
    END
if (@Freq_type = 4)
      if (@freq_recurrence_factor = 1)
SET @outputText = dbo.fn_EvFormatEventMsgText(0, @localeId, (2422 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) + ' ' +
dbo.fn_EvFormatEventMsgText(0, @localeId, (2454 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
      else
SET @outputText = dbo.fn_EvFormatEventMsgText(0, @localeId, (2450 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) + ' ' +
                                convert(varchar, @freq_recurrence_factor) + ' ' +
dbo.fn_EvFormatEventMsgText(0, @localeId, (530 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) + ' '+
dbo.fn_EvFormatEventMsgText(0, @localeId, (2454 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
if (@Freq_type = 8)
          if (@freq_recurrence_factor = 1)
SET @outputText = dbo.fn_EvFormatEventMsgText(0, @localeId, (2423 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) + ' ' +
dbo.fn_EvFormatEventMsgText(0, @localeId, (2453 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
          else
SET @outputText = dbo.fn_EvFormatEventMsgText(0, @localeId, (2450 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) + ' ' +
                                convert(varchar, @freq_recurrence_factor) + ' ' +
dbo.fn_EvFormatEventMsgText(0, @localeId, (2451 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) + ' '+
dbo.fn_EvFormatEventMsgText(0, @localeId, (2453 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
if (@Freq_type = 16 or @Freq_type = 32)
	  if (@freq_recurrence_factor = 1)
SET @outputText = dbo.fn_EvFormatEventMsgText(0, @localeId, (2424 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) + ' ' +
dbo.fn_EvFormatEventMsgText(0, @localeId, (2453 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
          else
SET @outputText = dbo.fn_EvFormatEventMsgText(0, @localeId, (2450 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) + ' ' +
                                convert(varchar, @freq_recurrence_factor) + ' ' +
dbo.fn_EvFormatEventMsgText(0, @localeId, (2452 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) + ' '+
dbo.fn_EvFormatEventMsgText(0, @localeId, (2453 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
if (@Freq_type = 64 OR @Freq_type = 128)
SET @outputText = dbo.fn_EvFormatEventMsgText(0, @localeId, (2425 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) + ' ' +
dbo.fn_EvFormatEventMsgText(0, @localeId, (2453 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
if (@freq_type = 8) BEGIN
		if ((@Freq_interval & 0x1) = 0x1)
SET @outputText = @outputText + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (521 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) + ','
		if ((@Freq_interval & 0x2) = 0x2)
SET @outputText = @outputText + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (522 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) + ','
		if ((@Freq_interval & 0x4) = 0x4)
SET @outputText = @outputText + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (523 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) + ','
		if ((@Freq_interval & 0x8) = 0x8)
SET @outputText = @outputText + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (524 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) + ','
		if ((@Freq_interval & 0x10) = 0x10)
SET @outputText = @outputText + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (525 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) + ','
		if ((@Freq_interval & 0x20) = 0x20)
SET @outputText = @outputText + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (526 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) + ','
		if ((@Freq_interval & 0x40) = 0x40)
SET @outputText = @outputText + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (527 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) + ','
		if ((@Freq_interval & 0x80) = 0x80)
SET @outputText = @outputText + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (2420 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) + ','
		if ((@Freq_interval & 0x100) = 0x100)
SET @outputText = @outputText + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (2418 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) + ','
		if ((@Freq_interval & 0x200) = 0x200)
SET @outputText = @outputText + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (2419 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) + ','
		SET @outputText = LEFT(@outputText, LEN(@outputText) - 1)
SET @outputText = @outputText + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (2454 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
	END
if (@freq_type = 16 or @freq_type = 64)
	BEGIN
SET @outputText = @outputText + ' ' +  dbo.fn_EvFormatEventMsgText(0, @localeId, (2420 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) + ' ' + convert(varchar, @Freq_interval)
if (@freq_type = 16)
SET @outputText = @outputText + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (2454 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
	END
if (@freq_type = 32 or @freq_type = 128)
	BEGIN
		if(@Freq_relative_interval = 1)
			SET @outputText = @outputText + ' ' +
dbo.fn_EvFormatEventMsgText(0, @localeId, (2455 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
		if(@Freq_relative_interval = 2)
			SET @outputText = @outputText + ' ' +
dbo.fn_EvFormatEventMsgText(0, @localeId, (2456 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
		if(@Freq_relative_interval = 3)
			SET @outputText = @outputText + ' ' +
dbo.fn_EvFormatEventMsgText(0, @localeId, (2457 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
		if(@Freq_relative_interval = 4)
			SET @outputText = @outputText + ' ' +
dbo.fn_EvFormatEventMsgText(0, @localeId, (2458 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
		if(@Freq_relative_interval = 5)
			SET @outputText = @outputText + ' ' +
dbo.fn_EvFormatEventMsgText(0, @localeId, (2459 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
		if (@Freq_interval = 1)
SET @outputText = @outputText + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (521 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
		if (@Freq_interval = 2)
SET @outputText = @outputText + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (522 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
		if (@Freq_interval = 3)
SET @outputText = @outputText + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (523 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
		if (@Freq_interval = 4)
SET @outputText = @outputText + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (524 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
		if (@Freq_interval = 5)
SET @outputText = @outputText + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (525 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
		if (@Freq_interval = 6)
SET @outputText = @outputText + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (526 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
		if (@Freq_interval = 7)
SET @outputText = @outputText + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (527 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
		if (@Freq_interval = 8)
SET @outputText = @outputText + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (2420 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
		if (@Freq_interval = 9)
SET @outputText = @outputText + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (2418 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
		if (@Freq_interval = 10)
SET @outputText = @outputText + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (2419 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
SET @outputText = @outputText + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (2454 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
	END
if (@freq_type = 64 or @freq_type = 128)
	BEGIN
		if (@freq_recurrence_factor = 1)
SET @outputText = @outputText + ' of ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (1029 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
		if (@freq_recurrence_factor = 2)
SET @outputText = @outputText + ' of ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (1030 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
		if (@freq_recurrence_factor = 3)
SET @outputText = @outputText + ' of ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (1031 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
		if (@freq_recurrence_factor = 4)
SET @outputText = @outputText + ' of ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (1032 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
		if (@freq_recurrence_factor = 5)
SET @outputText = @outputText + ' of ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (1033 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
		if (@freq_recurrence_factor = 6)
SET @outputText = @outputText + ' of ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (1034 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
		if (@freq_recurrence_factor = 7)
SET @outputText = @outputText + ' of ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (1035 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
		if (@freq_recurrence_factor = 8)
SET @outputText = @outputText + ' of ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (1036 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
		if (@freq_recurrence_factor = 9)
SET @outputText = @outputText + ' of ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (1037 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
		if (@freq_recurrence_factor = 10)
SET @outputText = @outputText + ' of ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (1038 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
		if (@freq_recurrence_factor = 11)
SET @outputText = @outputText + ' of ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (1039 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
		if (@freq_recurrence_factor = 12)
SET @outputText = @outputText + ' of ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (1040 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
SET @outputText = @outputText + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (2454 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
	END
-- Insert statements for procedure here
IF (@Freq_type = 1024)
	BEGIN
		SET @subTaskId = (SELECT subTaskId FROM TM_PatternAssoc WITH (NOLOCK) WHERE patternId = @pid)
		SET @minInterval = (SELECT value
			FROM TM_SubTaskOptions WITH (NOLOCK) WHERE subTaskId = @subTaskId
AND optionId IN (1611532840)
		)
		SET @minIntervalMin = (SELECT value
			FROM TM_SubTaskOptions WITH (NOLOCK) WHERE subTaskId = @subTaskId
AND optionId IN (1110217321)
		)
		SET @maxInterval = (SELECT value
			FROM TM_SubTaskOptions WITH (NOLOCK) WHERE subTaskId = @subTaskId
AND optionId IN (703512134)
		)
		SET @maxIntervalMin = (SELECT value
			FROM TM_SubTaskOptions WITH (NOLOCK) WHERE subTaskId = @subTaskId
AND optionId IN (1384124987)
		)
		IF @forLaptop = 0
		BEGIN
SET @outputText = dbo.fn_EvFormatEventMsgText(0, @localeId, (2916 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
			SET @outputText = @outputText + '. ' +
dbo.fn_EvFormatEventMsgText(0, @localeId, (2450 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) + ' '
			-- INTERVAL WITH NOT MINUTES. USE OLD FORMAT STRING
			IF @minInterval != 0 AND @minIntervalMin = 0 AND @maxInterval != 0 AND @maxIntervalMin = 0
			BEGIN
				SET @outputText = @outputText + @minInterval
				SET @outputText = @outputText + ' - ' + @maxInterval
SET @outputText = @outputText + ' '  + dbo.fn_EvFormatEventMsgText(0, @localeId, (529 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
			END
			-- INTERVAL WITH ONLY MINUTES. USE NEW FORMAT STRING
			ELSE IF @minInterval = 0 AND @minIntervalMin != 0 AND @maxInterval = 0 AND @maxIntervalMin != 0
			BEGIN
				SET @outputText = @outputText + @minIntervalMin
				SET @outputText = @outputText + ' - ' + @maxIntervalMin
SET @outputText = @outputText + ' '  + dbo.fn_EvFormatEventMsgText(0, @localeId, (528 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
			END
			ELSE
			-- USE NEW FORMAT. HIDE VALUES THAT ARE 0
			BEGIN
				IF @minInterval = 0
					SET @minInterval = ''
				ELSE
SET @minInterval = @minInterval + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (529 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
				IF @minIntervalMin = 0
					SET @minIntervalMin = ''
				ELSE
SET @minIntervalMin = @minIntervalMin + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (528 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
				IF @maxInterval = 0
					SET @maxInterval = ''
				ELSE
SET @maxInterval = @maxInterval + ' ' +dbo.fn_EvFormatEventMsgText(0, @localeId, (529 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
				IF @maxIntervalMin = 0
					SET @maxIntervalMin = ''
				ELSE
SET @maxIntervalMin = @maxIntervalMin + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (528 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
				SET @outputText = @outputText + @minInterval + ' ' + @minIntervalMin
				SET @outputText = @outputText + ' - ' + @maxInterval + ' ' + @maxIntervalMin
			END
			SELECT @outputText
		END
		ELSE
		BEGIN
SET @outputText = (SELECT Message FROM EvLocaleMsgs WITH (NOLOCK) WHERE MessageID=(3362 | (CAST(POWER(2, 24) AS BIGINT) * 61)) AND LocaleID=@localeId) --dbo.fn_EvFormatEventMsgText(0, @localeId, (3362 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
			-- INTERVAL WITH NOT MINUTES. USE OLD FORMAT STRING
			IF @minInterval != 0 AND @minIntervalMin = 0 AND @maxInterval != 0 AND @maxIntervalMin = 0
			BEGIN
SET @outputText = (SELECT Message FROM EvLocaleMsgs WITH (NOLOCK) WHERE MessageID=(3161 | (CAST(POWER(2, 24) AS BIGINT) * 61)) AND LocaleID=@localeId) --dbo.fn_EvFormatEventMsgText(0, @localeId, (3161 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
			SET @outputText = REPLACE(@outputText, '^1%d', @minInterval)
			SET @outputText = REPLACE(@outputText, '^2%d', @maxInterval)
			END
			-- INTERVAL WITH ONLY MINUTES. USE NEW FORMAT STRING AS Automatically every 10 to 55 Minutes
			ELSE IF @minInterval = 0 AND @minIntervalMin != 0 AND @maxInterval = 0 AND @maxIntervalMin != 0
			BEGIN
				SET @outputText = REPLACE(@outputText, '^1%s', @minIntervalMin)
				SET @outputText = REPLACE(@outputText, '^2%s', '')
				SET @outputText = REPLACE(@outputText, '^3%s', @maxIntervalMin)
SET @outputText = REPLACE(@outputText, '^4%s', dbo.fn_EvFormatEventMsgText(0, @localeId, (528 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2))
			END
			ELSE
			-- USE NEW FORMAT. HIDE VALUES THAT ARE 0
			BEGIN
				IF @minInterval = 0
					SET @minInterval = ''
				ELSE
SET @minInterval = @minInterval + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (529 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
				IF @minIntervalMin = 0
					SET @minIntervalMin = ''
				ELSE
SET @minIntervalMin = @minIntervalMin + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (528 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
				IF @maxInterval = 0
					SET @maxInterval = ''
				ELSE
SET @maxInterval = @maxInterval + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (529 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
				IF @maxIntervalMin = 0
					SET @maxIntervalMin = ''
				ELSE
SET @maxIntervalMin = @maxIntervalMin + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (528 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
				SET @outputText = REPLACE(@outputText, '^1%s', @minInterval)
				SET @outputText = REPLACE(@outputText, '^2%s', @minIntervalMin)
				SET @outputText = REPLACE(@outputText, '^3%s', @maxInterval)
				SET @outputText = REPLACE(@outputText, '^4%s', @maxIntervalMin)
			END
			SELECT @outputText
		END
	END
ELSE IF (@Freq_type = 4096)
	BEGIN
SET @outputText = (SELECT Message FROM EvLocaleMsgs WITH (NOLOCK) WHERE MessageID=(3650 | (CAST(POWER(2, 24) AS BIGINT) * 61)) AND LocaleID=@localeId) --dbo.fn_EvFormatEventMsgText(0, @localeId, (3362 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
		-- @freq_interval has the frequency of when to start job once completed.
		SET @outputText = REPLACE(@outputText, '^1%d', @freq_interval)
		SELECT @outputText
	END
	ELSE
		SELECT @outputText + ' ' +
		case when (active_start_time >= @secondsin12hours) then
			case ((active_start_time-@secondsin12hours)/@secondsin1hour)
			when 0 then
'12' + ':' + RIGHT('0' + CONVERT(varchar(2), (active_start_time-@secondsin12hours) % @secondsin1hour / @secondsin1minute), 2) + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (2218 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
			else
				convert(varchar, ((active_start_time-@secondsin12hours)/@secondsin1hour)) + ':' +
RIGHT('0' + CONVERT(varchar(2), (active_start_time-@secondsin12hours) % @secondsin1hour / @secondsin1minute), 2) + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (2218 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
			end
		when (((active_start_time)/@secondsin1hour) < 1) then
			convert(varchar, ((active_start_time)/@secondsin1hour)+12) + ':' +
RIGHT('0' + CONVERT(varchar(2), (active_start_time) % @secondsin1hour / @secondsin1minute), 2) + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (2217 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
		else
			convert(varchar, ((active_start_time)/@secondsin1hour)) + ':' +
RIGHT('0' + CONVERT(varchar(2), (active_start_time) % @secondsin1hour / @secondsin1minute), 2) + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (2217 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
		end +
		case when (@forLaptop = 0) then
			' ' + @starting +
			' ' + convert(char(11), active_start_date) + ' ' +
			case when (Freq_subday_interval > 0) then
+ ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (2460 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,3) + ' ' +
				+ convert(varchar, Freq_subday_interval/@secondsin1hour) + ' hr(s) ' +
				+ convert(varchar, Freq_subday_interval/@secondsin1minute - (Freq_subday_interval/@secondsin1hour) * @secondsin1minute) + ' min(s) '
			else ' '
			end +
			case when (active_end_time > 0) then
' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (2461 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,3) + ' ' +
				case when (active_end_time > @secondsin12hours) then
					convert(varchar, ((active_end_time-@secondsin12hours)/@secondsin1hour)) + ':' +
RIGHT('0' + CONVERT(varchar(2), (active_end_time-@secondsin12hours) % @secondsin1hour / @secondsin1minute), 2) + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (2218 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
				else
					convert(varchar, ((active_end_time)/@secondsin1hour)) + ':' +
RIGHT('0' + CONVERT(varchar(2), (active_end_time) % @secondsin1hour / @secondsin1minute), 2) + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (2217 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
				end
			else ''
			end +
			case when active_end_occurence > 0 then
' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (2770 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) + ' ' + CAST(active_end_occurence AS NVARCHAR(10)) + ' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (2771 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2)
			else ''
			end +
			case when local_end_date > 0 then
' ' + dbo.fn_EvFormatEventMsgText(0, @localeId, (2769 | (CAST(POWER(2, 24) AS BIGINT) * 61)), 0,2) + ' ' + CAST(dbo.getdatetime(local_end_date) AS NVARCHAR(100))
			else ''
			end
		else ''
		end
		FROM tm_pattern WITH (NOLOCK)
		WHERE patternId = @pid;
END

IF EXISTS (select * from GxQscripts where name = 'GetSchedulePattern')
	delete from GxQscripts where name = 'GetSchedulePattern'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSchedulePattern')
	delete from GXDBVersions where aliasname = 'GetSchedulePattern'
GO

insert into GXDBVersions values(2, 'GetSchedulePattern',  '00010016008800020000', 'GetSchedulePattern', '00010016008800020000')
GO

