

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetSRMClientAgents.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetSRMClientAgents.sp,v $ $Id: GetSRMClientAgents.sp,v 1.1.274.2 2018/03/22 01:39:31 jiechen Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetSRMClientAgents <<<'

IF EXISTS (select * from sysobjects where name='GetSRMClientAgents')
	drop procedure GetSRMClientAgents
IF EXISTS (select * from GxQscripts where name='GetSRMClientAgents')
	delete from GxQscripts where name = 'GetSRMClientAgents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSRMClientAgents')
	delete from GXDBVersions where aliasname = 'GetSRMClientAgents'
GO
print '... Creating Procedure: GetSRMClientAgents'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetSRMClientAgents
-- Input
AS
  DECLARE @o_xmlText XML
	--This is to enumerate All SRM Agents and SRM Enabled Backup Agents
	SELECT	1			as TAG,
			NULL		as Parent,
			NULL		as [QSMGui_GetSRMClientsResp!1!],
			NULL 		as [srmAgentList!2!clientId],
			NULL		as [srmAgentList!2!applicationId]
	Union 	All
	--List of all SRM Agents
	SELECT 2, 1, NULL, agents.clientId, agents.appTypeId
		FROM APP_Client AS client
		INNER JOIN APP_IDAName AS agents ON
			client.id = agents.clientId
AND agents.appTypeId >= 600
AND agents.appTypeId <= 654
	UNION
	--List of all SRM Enabled Agents
	SELECT 2, 1, NULL, agents.clientId, agents.appTypeId
		FROM APP_Client AS client
		INNER JOIN APP_IDAName AS agents ON
			client.id = agents.clientId
			AND (agents.status & 2) <> 2		--NOT Uninstalled
			AND (agents.status & 16) <> 16		--NOT DUMMY
		INNER JOIN APP_IDAProp AS props ON
			props.componentNameId = agents.id
			AND props.attrName LIKE 'SRM Data Collection Enabled'
			AND props.attrVal = 1
			AND props.modified = 0
	FOR XML EXPLICIT
GO

IF EXISTS (select * from GxQscripts where name = 'GetSRMClientAgents')
	delete from GxQscripts where name = 'GetSRMClientAgents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSRMClientAgents')
	delete from GXDBVersions where aliasname = 'GetSRMClientAgents'
GO

insert into GXDBVersions values(2, 'GetSRMClientAgents',  '00010001027400020000', 'GetSRMClientAgents', '00010001027400020000')
GO

