

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetSPCUVersion.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: Return SP and CU information from DB.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetSPCUVersion')
BEGIN
	print '>>> Drop Stored Procedure: GetSPCUVersion <<<'
	drop procedure GetSPCUVersion
END
IF EXISTS (select * from GxQscripts where name='GetSPCUVersion')
	delete from GxQscripts where name = 'GetSPCUVersion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSPCUVersion')
	delete from GXDBVersions where aliasname = 'GetSPCUVersion'
GO
print '... Creating Procedure: GetSPCUVersion'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetSPCUVersion
  @inReleaseID integer,
  @inClientID integer,
  @inOSId integer
AS
  DECLARE @o_OSId integer
  DECLARE @o_HighestSp varchar(100)
  DECLARE @o_CUNum varchar(100)
  DECLARE @o_AdditionalUpdates varchar(max)
  DECLARE @o_PackagesInCache varchar(max)
SET NOCOUNT ON
IF ISNULL(@inClientID,0) > 1 OR ISNULL(@inReleaseID,0) > 0
BEGIN
	IF @inReleaseID < 16
	BEGIN
		SELECT pmc.OSId, pmc.HighestSp, '0' AS 'CUNum', pmc.AddUpdates AS 'AdditionalUpdates', '' AS 'PackagesInCache'
		FROM PatchMultiCache pmc WITH(NOLOCK) WHERE pmc.ReleaseId = @inReleaseID AND pmc.ClientId = @inClientID AND pmc.OSId = @inOSId
	END
	ELSE
	BEGIN
		IF object_id('tempdb.dbo.#SoftwareCacheDetails') IS NOT NULL DROP TABLE #SoftwareCacheDetails
		CREATE TABLE #SoftwareCacheDetails(cacheID INTEGER, OSId INTEGER, HighestSp VARCHAR(100), CUNum VARCHAR(255), AdditionalUpdates VARCHAR(MAX), PackagesInCache VARCHAR(MAX))
		IF object_id('tempdb.dbo.#UPAdditionalUpdates') IS NOT NULL DROP TABLE #UPAdditionalUpdates
		CREATE TABLE #UPAdditionalUpdates(OSId INTEGER, UpdateID INTEGER, UpdateName VARCHAR(255) NOT NULL, UNIQUE CLUSTERED (UpdateID, UpdateName))
		INSERT INTO #UPAdditionalUpdates
		SELECT ini.OSId, puppm.UpdatePackID, ini.PatchName FROM PatchUpdatePackPatchesMap puppm WITH(NOLOCK) INNER JOIN PatchINI ini WITH(NOLOCK) ON puppm.UpdateID = ini.id WHERE puppm.bIsAdditionalUpdate = 1
		--Include cache details of loose updates at "LooseUpdates/CU#/Updates" location.
		INSERT INTO #SoftwareCacheDetails
		SELECT pmc.id, pmc.osid AS 'OSId',S1.SPMajor, U.UPNumber,
		(SELECT STUFF((SELECT ', ' + upau.UpdateName
		FROM #UPAdditionalUpdates upau WITH(NOLOCK)
		WHERE upau.UpdateID = U.UPVersionID AND upau.OSId = pmc.osid
		ORDER BY upau.UpdateName
		FOR XML PATH('')), 1, 2, '')) AS 'AddtionalUpdates',
		(SELECT
			CASE WHEN pu.PackagesinCache = 'All' THEN pu.PackagesinCache
			ELSE STUFF((SELECT ', ' + sm.DisplayName
						FROM PatchUAContentConfig pua
						CROSS APPLY dbo.SplitString(pua.PackagesinCache, ',') sc
						JOIN simPackage sm ON sm.id = sc.Data
						WHERE pua.UAClientId = @inClientID AND pua.OSId = @inOSId
						FOR XML PATH('')), 1, 2, '')
			END
			FROM PatchUAContentConfig pu
			WHERE pu.UAClientId = @inClientID AND pu.OSId = @inOSId
		) AS 'PackagesInCache'
		FROM PatchMultiCache pmc WITH(NOLOCK)
		JOIN PatchSPVersion S1 WITH(NOLOCK) ON pmc.spVersionId = S1.id
		LEFT JOIN PatchCacheUpdatePackMap pcup WITH(NOLOCK) ON pmc.id = pcup.CacheID
		LEFT JOIN PatchUPVersion U WITH(NOLOCK) ON pcup.UpdatePackID = U.UPVersionID
		WHERE @inReleaseID = S1.Release AND pmc.OSId = @inOSId AND pmc.ClientId = @inClientID AND U.UPNumber IS NOT NULL
		--Include cache details of loose updates at "LooseUpdates/Updates" location.
		INSERT INTO #SoftwareCacheDetails
		SELECT DISTINCT pmc.id,  pmc.OSId, S1.SPMajor, '',
		(SELECT STUFF((SELECT ', ' + ini.PatchName
		FROM PatchCacheUpdateMap pcum WITH(NOLOCK)
		INNER JOIN PatchINI ini WITH(NOLOCK) ON ini.id = pcum.UpdateID
		WHERE pmc.id = pcum.CacheID
		ORDER BY ini.PatchId, ini.AliasName
		FOR XML PATH('')),1,2, '')),
		(SELECT
			CASE WHEN pu.PackagesinCache = 'All' THEN pu.PackagesinCache
			ELSE STUFF((SELECT ', ' + sm.DisplayName
						FROM PatchUAContentConfig pua
						CROSS APPLY dbo.SplitString(pua.PackagesinCache, ',') sc
						JOIN simPackage sm ON sm.id = sc.Data
						WHERE pua.UAClientId = @inClientID AND pua.OSId = @inOSId
						FOR XML PATH('')), 1, 2, '')
			END
			FROM PatchUAContentConfig pu
			WHERE pu.UAClientId = @inClientID AND pu.OSId = @inOSId
		) AS 'PackagesInCache'
		FROM PatchMultiCache pmc WITH(NOLOCK)
		JOIN PatchSPVersion S1 WITH(NOLOCK) ON pmc.spVersionId = S1.id
		LEFT JOIN PatchCacheUpdateMap pcum WITH(NOLOCK) ON pmc.id = pcum.CacheID
		WHERE @inReleaseID = S1.Release AND pmc.OSId = @inOSId AND pmc.ClientId = @inClientID
		DECLARE @isSingleRow INTEGER = (SELECT COUNT(*) FROM #SoftwareCacheDetails WITH(NOLOCK))
		SELECT OSId, HighestSp, MAX(COALESCE(CUNum, 0)) AS 'CUNum', MAX(COALESCE(AdditionalUpdates, '')) AS 'AdditionalUpdates', MAX(COALESCE(PackagesInCache, '')) AS 'PackagesInCache' FROM #SoftwareCacheDetails WITH(NOLOCK)
		GROUP BY OSId, HighestSp
		ORDER BY HighestSP DESC
		DROP TABLE #SoftwareCacheDetails
		DROP TABLE #UPAdditionalUpdates
	END
END

IF EXISTS (select * from GxQscripts where name = 'GetSPCUVersion')
	delete from GxQscripts where name = 'GetSPCUVersion'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSPCUVersion')
	delete from GXDBVersions where aliasname = 'GetSPCUVersion'
GO

insert into GXDBVersions values(2, 'GetSPCUVersion',  '00000000000000000000', 'GetSPCUVersion', '00000000000000000000')
GO

