

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetSILServerList.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: List all SIL Servers.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetSILServerList <<<'

IF EXISTS (select * from sysobjects where name='GetSILServerList')
	drop procedure GetSILServerList
IF EXISTS (select * from GxQscripts where name='GetSILServerList')
	delete from GxQscripts where name = 'GetSILServerList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSILServerList')
	delete from GXDBVersions where aliasname = 'GetSILServerList'
GO
print '... Creating Procedure: GetSILServerList'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetSILServerList
  @inputxml XML
AS
SET NOCOUNT ON
IF OBJECT_ID('tempdb.dbo.#silServerList') IS NOT NULL DROP TABLE #silServerList
Select Distinct componentNameId into #silServerList from APP_ClientProp WITH(nolock) where attrName = 'Hosted Mount Path' and modified = 0
SELECT ac.id, ac.name, acp.attrVal as 'currentMountPath' FROM APP_ClientProp as acp WITH(nolock)
	INNER JOIN #silServerList sList
		on acp.componentNameId = sList.componentNameId
		and acp.attrName = 'Current Mount Path'
		INNER JOIN APP_Client as ac WITH(nolock)
			on ac.id = acp.componentNameId FOR XML PATH('silServer'), ROOT('App_GetSILServersListResp')
Drop table #silServerList
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetSILServerList')
	delete from GxQscripts where name = 'GetSILServerList'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSILServerList')
	delete from GXDBVersions where aliasname = 'GetSILServerList'
GO

insert into GXDBVersions values(2, 'GetSILServerList',  '00000000000000000000', 'GetSILServerList', '00000000000000000000')
GO

