

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetSIDBStoreDetailsForJob.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetSIDBStoreDetailsForJob.sp,v $ $Id: GetSIDBStoreDetailsForJob.sp,v 1.1.2.2 2018/11/20 13:18:14 snandhini Exp $";
--
--  +========================================================================+
--  |   Procedure:  GetSIDBStoreDetailsForJob()
--  |
--  | Description:  SP returns SIDB store details for job
--  |
--  |       Input:  jobId
-- 	|
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetSIDBStoreDetailsForJob')
BEGIN
	print '>>> Drop Stored Procedure: GetSIDBStoreDetailsForJob <<<'
	drop procedure GetSIDBStoreDetailsForJob
END
IF EXISTS (select * from GxQscripts where name='GetSIDBStoreDetailsForJob')
	delete from GxQscripts where name = 'GetSIDBStoreDetailsForJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSIDBStoreDetailsForJob')
	delete from GXDBVersions where aliasname = 'GetSIDBStoreDetailsForJob'
GO
print '... Creating Procedure: GetSIDBStoreDetailsForJob'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetSIDBStoreDetailsForJob
  @jobId INT
AS
  DECLARE @subStoreId INT; 
  DECLARE @sidbStoreId INT;
  DECLARE @sidbStoreName VARCHAR(255);
  DECLARE @clientId INT;
  DECLARE @applicationId INT;
  DECLARE @isDDBBackupRunning INT;
  DECLARE @DDBjobId INT;
  DECLARE @avgQiTime INT;
  DECLARE @DDBBackupTime BIGINT;
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	DECLARE @spId INT = (select currentpolicy from runningbackups where jobid=@jobId)
	DECLARE @avgQITimeThreshold INT = 1800 --in milliseconds
	IF OBJECT_ID('tempdb.dbo.#DDBMA') IS NOT NULL
	DROP TABLE #DDBMA
	CREATE TABLE #DDBMA
	(
		subStoreId int,
		sidbStoreId int,
		sidbStoreName varchar(255),
		clientId int,
		applicationId int,
		isDDBBackupRunning int,
		DDBjobId int,
		avgQiTime int,
		DDBBackupTime int
	)
	DECLARE @pendingReason VARCHAR(MAX)=''
	INSERT INTO #DDBMA
	SELECT DISTINCT Substore.substoreID,Substore.SIDBStoreId,Store.SIDBStoreName, Substore.ClientId,0,0,0,0,0
		FROM archGroup SP
		INNER JOIN archGroupCopy SPCopy   ON SPCopy.id = Sp.defaultCopy AND @spId=Sp.id
		INNER JOIN Idxsidbsubstore Substore   ON SPCopy.sidbstoreid = SubStore.sidbstoreid
		INNER JOIN IdxSIDBStore Store ON Store.SIDBStoreId=SPCopy.sidbstoreid
		WHERE Store.SIDBStoreId<>0
	UPDATE DDB SET applicationId = componentNameID
	FROM #DDBMA DDB
INNER JOIN APP_Application SC   ON SC.clientId=DDB.clientId AND  SC.subclientStatus & (CAST(0x00002 AS int) | CAST(0x00004 AS int)) = 0
	INNER JOIN APP_SubClientProp SCP   ON SCP.componentNameId=SC.id AND SCP.attrName = 'DDB Backup' AND SCP.modified=0
	UPDATE DDB SET isDDBBackupRunning=1, DDBjobId=jobId
	FROM #DDBMA DDB
	INNER JOIN JMBkpJobInfo BKP   ON BKP.applicationId=DDB.applicationId
	UPDATE DDB 	SET avgQiTime=T.avgQiTime
	FROM #DDBMA DDB
	INNER JOIN (SELECT Idx.SubStoreId, Idx.avgQiTime,
					  ROW_NUMBER() OVER (PARTITION BY Idx.SubStoreId ORDER BY modifiedTime DESC) AS RN
					  FROM idxsidbusagehistory  Idx
					  INNER JOIN #DDBMA T2 ON T2.substoreId=Idx.SubStoreid AND historytype=0)T
	ON T.substoreId = DDB.substoreId AND RN = 1
	UPDATE DDB SET DDBBackupTime = T.backuptime
	FROM #DDBMA DDB
	INNER JOIN (SELECT appId,duration,AVG(cast(duration AS BIGINT)) OVER (PARTITION BY appId ORDER BY modifiedTime DESC ROWS BETWEEN CURRENT ROW AND 2 FOLLOWING ) AS backupTime,
	                  ROW_NUMBER() OVER (PARTITION BY appId ORDER BY modifiedTime DESC) AS RN
	                  FROM jmbkpstats Stat
					  INNER JOIN #DDBMA T2 ON T2.applicationId = Stat.appId)T
	ON T.appId = DDB.applicationId AND T.RN = 1
	SELECT subStoreId,sidbStoreId,sidbStoreName,clientId,applicationId,isDDBBackupRunning,DDBjobId,avgQiTime,DDBBackupTime
	FROM #DDBMA
	WHERE (isDDBBackupRunning=1 OR avgQiTime > @avgQITimeThreshold) AND applicationId > 0
	IF OBJECT_ID('tempdb.dbo.#DDBMA') IS NOT NULL
	DROP TABLE #DDBMA
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetSIDBStoreDetailsForJob')
	delete from GxQscripts where name = 'GetSIDBStoreDetailsForJob'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetSIDBStoreDetailsForJob')
	delete from GXDBVersions where aliasname = 'GetSIDBStoreDetailsForJob'
GO

insert into GXDBVersions values(2, 'GetSIDBStoreDetailsForJob',  '00010001000200020000', 'GetSIDBStoreDetailsForJob', '00010001000200020000')
GO

