

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetRunningJobsOnClient.sp] ---------- 

--  +========================================================================+
--  | Name        :  GetRunningJobsOnClient()                                |
--  | Description :  Get the running jobs given a client                     |
--  +========================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetRunningJobsOnClient <<<'

IF EXISTS (select * from sysobjects where name='GetRunningJobsOnClient')
	drop procedure GetRunningJobsOnClient
IF EXISTS (select * from GxQscripts where name='GetRunningJobsOnClient')
	delete from GxQscripts where name = 'GetRunningJobsOnClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetRunningJobsOnClient')
	delete from GXDBVersions where aliasname = 'GetRunningJobsOnClient'
GO
print '... Creating Procedure: GetRunningJobsOnClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetRunningJobsOnClient
  @i_xmlText XML
AS
  DECLARE @o_ErrorCode integer=0
  DECLARE @o_ErrorString NVARCHAR(1024)
  DECLARE @o_xmlText XML
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	DECLARE @i_clientId 	INT
	DECLARE @i_userId		INT
	DECLARE @i_bkpVisible	INT
	DECLARE @i_rstVisible	INT
	SET     @o_ErrorCode  = 0
	SET     @o_xmlText    = '<App_GetRunningJobsOnClientResp />'
	SET     @i_clientId   = ISNULL((SELECT ref.value('@clientId','int')
									FROM @i_xmlText.nodes('App_GetRunningJobsOnClientReq/clientEntity') R ( ref )), 0)
	SET     @i_userId   = ISNULL((SELECT ref.value('@userId','int')
									FROM @i_xmlText.nodes('App_GetRunningJobsOnClientReq/userEntity') R ( ref )), 0)
	IF @i_clientId = 0
	BEGIN
		SET @o_ErrorCode   = 1
		SET @o_ErrorString = 'Client ID not found. Invalid client.'
		GOTO EXIT_PROC
	END
	IF @i_userId = 0
	BEGIN
		SET @o_ErrorCode   = 2
		SET @o_ErrorString = 'User ID not found. Invalid User.'
		GOTO EXIT_PROC
	END
	SET		@i_bkpVisible = dbo.isBkpJobVisible(@i_userId,0,@i_clientId,0,0,0,0)
	SET		@i_rstVisible = dbo.isRstJobVisible(@i_userId,0,@i_clientId,0,0,0,0)
	IF @i_bkpVisible = 0 AND @i_rstVisible = 0
	BEGIN
		SET @o_ErrorCode   = 3
		SET @o_ErrorString = 'User doesnt have required privileges to view jobs.'
		GOTO EXIT_PROC
	END
	SET @o_xmlText =
	(
		SELECT
			(SELECT j.jobid as "@jobId", j.opType as "@opType",
					a.subclientName as "@subclientName",
					b.bkpLevel as "@jobType", j.currentPhaseName as "@curPhase",
					j.state as "@curStatus", j.percentcomplete as "@progressPercent"
						FROM JMJobInfo j JOIN JMBkpJobInfo b
							ON j.jobId = b.jobId
				 		JOIN APP_Application a
				 			ON b.applicationId = a.id AND a.clientId = @i_clientId WHERE dbo.isBkpJobVisible(@i_userId,0,@i_clientId,0,0,0,0) = 1
				FOR XML PATH('runningJobs'), TYPE
			),
			(SELECT j.jobid as "@jobId", j.opType as "@opType",
					j.currentPhaseName as "@curPhase",
					j.state as "@curStatus", j.percentcomplete as "@progressPercent"
						FROM JMJobInfo j JOIN JMRstJobInfo r
							ON j.jobId = r.jobId AND r.srcClientId = @i_clientId WHERE dbo.isRstJobVisible(@i_userId,0,@i_clientId,0,0,0,0) = 1
				FOR XML PATH('runningJobs'), TYPE
			)
			FOR XML PATH(''), ROOT('App_GetRunningJobsOnClientResp'), TYPE
	)
	EXIT_PROC:
    IF @o_ErrorCode > 0
    BEGIN
        SET @o_xmlText =
        (
            SELECT @o_ErrorCode '@errorCode',
                    @o_ErrorString '@errorMessage'
            FOR XML PATH ('error'), ROOT('App_GetRunningJobsOnClientResp')
        )
    END
    SELECT @o_xmlText
END
SET NOCOUNT ON
GO

IF EXISTS (select * from GxQscripts where name = 'GetRunningJobsOnClient')
	delete from GxQscripts where name = 'GetRunningJobsOnClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetRunningJobsOnClient')
	delete from GXDBVersions where aliasname = 'GetRunningJobsOnClient'
GO

insert into GXDBVersions values(2, 'GetRunningJobsOnClient',  '00000000000000000000', 'GetRunningJobsOnClient', '00000000000000000000')
GO

