

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetReportGuidFromId.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetReportGuidFromId.sp,v $ $Id: GetReportGuidFromId.sp,v 1.1.2.1 2020/07/17 23:51:15 dkraplanee Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetReportGuidFromId')
BEGIN
	print '>>> Drop Stored Procedure: GetReportGuidFromId <<<'
	drop procedure GetReportGuidFromId
END
IF EXISTS (select * from GxQscripts where name='GetReportGuidFromId')
	delete from GxQscripts where name = 'GetReportGuidFromId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetReportGuidFromId')
	delete from GXDBVersions where aliasname = 'GetReportGuidFromId'
GO
print '... Creating Procedure: GetReportGuidFromId'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetReportGuidFromId
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @reportId nvarchar(MAX)
AS
  DECLARE @reportGUID NVARCHAR(256)
select @reportGUID = 'NA'
--if it is a decimal number, it might be a reportid
IF (ISNUMERIC(Replace(Replace(@reportId,'+','A'),'-','A') + '.0e0') = 1)
	SELECT @reportGUID = guid FROM APP_Reports WHERE reportId = CONVERT(INT, @reportId)
--the reportid may be the userReportId
ELSE IF EXISTS(SELECT 1 FROM APP_Reports WHERE userReportId = @reportId)
	SELECT @reportGUID = guid FROM APP_Reports WHERE userReportId = @reportId
--the report id may be the guid itself
ELSE IF EXISTS(SELECT 1 FROM APP_Reports WHERE guid = @reportId)
	SELECT @reportGUID = @reportId
--otherwise return 'NA'
ELSE
	SELECT @reportGUID = 'NA'
SELECT @reportGUID
GO

IF EXISTS (select * from GxQscripts where name = 'GetReportGuidFromId')
	delete from GxQscripts where name = 'GetReportGuidFromId'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetReportGuidFromId')
	delete from GXDBVersions where aliasname = 'GetReportGuidFromId'
GO

insert into GXDBVersions values(2, 'GetReportGuidFromId',  '00010001000200010000', 'GetReportGuidFromId', '00010001000200010000')
GO

