

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetRebootStatusForClusterNodes.sp] ---------- 

--
--  +========================================================================+
--  | Stored Precedure: GetRebootStatusForClusterNodes()
--  +========================================================================+
--
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetRebootStatusForClusterNodes <<<'

IF EXISTS (select * from sysobjects where name='GetRebootStatusForClusterNodes')
	drop procedure GetRebootStatusForClusterNodes
IF EXISTS (select * from GxQscripts where name='GetRebootStatusForClusterNodes')
	delete from GxQscripts where name = 'GetRebootStatusForClusterNodes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetRebootStatusForClusterNodes')
	delete from GXDBVersions where aliasname = 'GetRebootStatusForClusterNodes'
GO
print '... Creating Procedure: GetRebootStatusForClusterNodes'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetRebootStatusForClusterNodes
  @i_XML XML
AS
  DECLARE @o_XML XML;
SET NOCOUNT ON
DECLARE @pClientId INT
DECLARE @VMToPM TABLE(physicalClientId INT, virtualClientId INT, rebootStatus INT, clientName NVARCHAR(1024))
SET @pClientId = (SELECT  A.ref.value('@clientId', 'int') FROM @i_XML.nodes('/Api_GetRebootStatusForClusterNodesReqResp/cluster') A(ref))
INSERT INTO @VMToPM (virtualClientId, physicalClientId) (SELECT VMClientId, PMClientId FROM APP_VMToPMMap WHERE VMClientId = @pClientId)
--Update the reboot status
UPDATE @VMToPM SET rebootStatus = CLNTPROP.attrVal
FROM APP_ClientProp CLNTPROP INNER JOIN @VMToPM T_VMToPM ON T_VMToPM.physicalClientId = CLNTPROP.componentNameId
WHERE CLNTPROP.attrName = 'QSnap installed'
--Update the name
UPDATE @VMToPM SET clientName = T_APPCLNT.name
FROM APP_Client T_APPCLNT INNER JOIN @VMToPM T_VMToPM ON T_VMToPM.physicalClientId = T_APPCLNT.id
SET @i_XML =
(SELECT @pClientId AS 'cluster/@clientId',
                    (SELECT physicalClientId AS 'clusterNode/@clientId',
                                                                clientName AS 'clusterNode/@clientName',
                                                    rebootStatus AS 'rebootStatus'
                                                    FROM @VMToPM
                                                    FOR XML PATH('clusterNodesList'), TYPE)
FOR XML PATH('Api_GetRebootStatusForClusterNodesReqResp'))
SET @o_XML = @i_XML
SELECT @i_XML
GO

IF EXISTS (select * from GxQscripts where name = 'GetRebootStatusForClusterNodes')
	delete from GxQscripts where name = 'GetRebootStatusForClusterNodes'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetRebootStatusForClusterNodes')
	delete from GXDBVersions where aliasname = 'GetRebootStatusForClusterNodes'
GO

insert into GXDBVersions values(2, 'GetRebootStatusForClusterNodes',  '00000000000000000000', 'GetRebootStatusForClusterNodes', '00000000000000000000')
GO

