

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetRMDLPProp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
--When client ask for his setting, implement the following logic:
--1)	If this client has enableRmDLP=1 in the DB, return the clients settings
--2)	If the client doesnt have enableRmDLP=1, enumerate all the groups that have this client. For every group that has enableRmDLP=1, take dlp RM prop and combine them in one as:
--		a.	enableRmDLP - OR together
--		b.	dlpRmOfflineDays - take Max Offline days
--		c.	dlpRmNow - This prop is on client only, it is not available on client group. So don't have to do anything while combining prop of client groups.
--		d.	dlpRmContents  by concatenating strings together
--		e.	dlpRmFilters  by concatenating strings together
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetRMDLPProp.sp,v $ $Id: GetRMDLPProp.sp,v 1.3.60.1 2017/02/10 19:55:36 sjohnson Exp $";
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetRMDLPProp <<<'

IF EXISTS (select * from sysobjects where name='GetRMDLPProp')
	drop procedure GetRMDLPProp
IF EXISTS (select * from GxQscripts where name='GetRMDLPProp')
	delete from GxQscripts where name = 'GetRMDLPProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetRMDLPProp')
	delete from GXDBVersions where aliasname = 'GetRMDLPProp'
GO
print '... Creating Procedure: GetRMDLPProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetRMDLPProp
  @clientId INT
AS
  DECLARE @errorCode INT = 0
  DECLARE @enableRmDLP INT = 0
  DECLARE @dlpRmOfflineDays INT = 30
  DECLARE @dlpRmNow INT = 0
  DECLARE @dlpRmContents NVARCHAR(MAX) = ''
  DECLARE @dlpRmFilters NVARCHAR(MAX) = ''
  DECLARE @errorString VARCHAR(MAX) = 'Success'
BEGIN TRY
	--Req 1.
	IF EXISTS (SELECT * FROM APP_ClientProp WITH(NOLOCK) where componentNameId = @clientId AND attrName = 'enableRmDLP' AND attrVal = '1')
	BEGIN
		SET @enableRmDLP = 1
		SET @dlpRmOfflineDays = ISNULL((SELECT attrval FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @clientId AND attrName = 'dlpRmOfflineDays'), 30)
		SET @dlpRmNow = ISNULL((SELECT attrval FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @clientId AND attrName = 'dlpRmNow'), 0)
		SET @dlpRmContents = ISNULL((SELECT attrval FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @clientId AND attrName = 'dlpRmContents'), '')
		SET @dlpRmFilters = ISNULL((SELECT attrval FROM APP_ClientProp WITH(NOLOCK) WHERE componentNameId = @clientId AND attrName = 'dlpRmFilters'), '')
	END
	ELSE
	BEGIN
		--Req 2a.
		SELECT @enableRmDLP = @enableRmDLP | CAST(ISNULL(attrVal, 0) AS INT) FROM DlpGroupProp WITH(NOLOCK) WHERE groupid IN (( SELECT groupid FROM DlpGroupProp WITH(NOLOCK) WHERE groupid IN( SELECT id FROM APP_ClientGroup CG WITH(NOLOCK), APP_ClientGroupAssoc CGA WITH(NOLOCK)
																										WHERE CGA.clientId = @clientId
																											AND CGA.clientGroupId = CG.id )
																								 AND attrName = 'enableRmDLP'
																								 AND attrVal = '1' )) AND attrName = 'enableRmDLP' AND modified = 0
		--Req 2b.
		SET @dlpRmOfflineDays = ISNULL( (SELECT MAX( CAST(ISNULL(attrVal, 0) AS INT) ) FROM DlpGroupProp WITH(NOLOCK) WHERE groupid IN (( SELECT groupid FROM DlpGroupProp WITH(NOLOCK) WHERE groupid IN( SELECT id FROM APP_ClientGroup CG WITH(NOLOCK), APP_ClientGroupAssoc CGA WITH(NOLOCK)
																										WHERE CGA.clientId = @clientId
																											AND CGA.clientGroupId = CG.id )
																								 AND attrName = 'enableRmDLP'
																								 AND attrVal = '1' )) AND attrName = 'dlpRmOfflineDays' AND modified = 0), 30)
		--Req 2d.
		SELECT @dlpRmContents = @dlpRmContents + attrVal FROM DlpGroupProp WITH(NOLOCK) WHERE groupid IN( SELECT groupid FROM DlpGroupProp WITH(NOLOCK) WHERE groupid IN( SELECT id FROM APP_ClientGroup CG WITH(NOLOCK), APP_ClientGroupAssoc CGA WITH(NOLOCK)
																										WHERE CGA.clientId = @clientId
																											AND CGA.clientGroupId = CG.id )
																								 AND attrName = 'enableRmDLP'
																								 AND attrVal = '1' ) AND attrName = 'dlpRmContents' AND modified = 0
		--Req 2e.
		SELECT @dlpRmFilters = @dlpRmFilters  + attrVal FROM DlpGroupProp WITH(NOLOCK) WHERE groupid IN( SELECT groupid FROM DlpGroupProp WITH(NOLOCK) WHERE groupid IN( SELECT id FROM APP_ClientGroup CG WITH(NOLOCK), APP_ClientGroupAssoc CGA WITH(NOLOCK)
																										WHERE CGA.clientId = @clientId
																											AND CGA.clientGroupId = CG.id )
																								 AND attrName = 'enableRmDLP'
																								 AND attrVal = '1' ) AND attrName = 'dlpRmFilters' AND modified = 0
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
   SET @errorCode = ERROR_NUMBER()
   SET @errorString = 'Problems executing [' +ERROR_PROCEDURE() +'], Line['
					+ CONVERT(nvarchar(10),ERROR_LINE()) + '] :' +ERROR_MESSAGE()
END	  CATCH
SELECT @errorCode, @enableRmDLP, @dlpRmOfflineDays, @dlpRmNow, @dlpRmContents, @dlpRmFilters, @errorString
GO

IF EXISTS (select * from GxQscripts where name = 'GetRMDLPProp')
	delete from GxQscripts where name = 'GetRMDLPProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetRMDLPProp')
	delete from GXDBVersions where aliasname = 'GetRMDLPProp'
GO

insert into GXDBVersions values(2, 'GetRMDLPProp',  '00010003006000010000', 'GetRMDLPProp', '00010003006000010000')
GO

