

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetPermissionsOnEntityWrapper.sp] ---------- 

-- 	+-----------------------------------------------------------------------------------------------------------------------------------+
--	| 	Procedure : "GetPermissionsOnEntityWrapper.sp"
--	|	Description:
--	|	This sp is used to invoke a CLR function defined in C#, which would make a REST call to graph DB.
--	|	The graph DB would compute the permissions for the intended user which was previously taken care in sec_getNonIdaObjectsForUser.
--	|	The returned results would be in form of xml, where it may have nodes containing the ida objects or a flag indicating user has permissions on all entities of given type
--	|	Author: suraj shankar
-- 	+-----------------------------------------------------------------------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetPermissionsOnEntityWrapper')
BEGIN
	print '>>> Drop Stored Procedure: GetPermissionsOnEntityWrapper <<<'
	drop procedure GetPermissionsOnEntityWrapper
END
IF EXISTS (select * from GxQscripts where name='GetPermissionsOnEntityWrapper')
	delete from GxQscripts where name = 'GetPermissionsOnEntityWrapper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetPermissionsOnEntityWrapper')
	delete from GXDBVersions where aliasname = 'GetPermissionsOnEntityWrapper'
GO
print '... Creating Procedure: GetPermissionsOnEntityWrapper'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetPermissionsOnEntityWrapper
--Inputs
  @tableOutput NVARCHAR(MAX),
  @userId INTEGER,
  @entityType1 INTEGER,
  @entityId1 INTEGER,
  @entityType2 INTEGER = 0,
  @entityId2 INTEGER = 0,
  @entityType3 INTEGER = 0,
  @entityId3 INTEGER = 0,
  @entityType4 INTEGER = 0,
  @entityId4 INTEGER = 0,
  @entityType5 INTEGER = 0,
  @entityId5 INTEGER = 0,
  @inheritFromChildren INTEGER = 0,
  @includeNotMappedPermission INT = 0,
  @skipClassicPermissions INT = 0,
  @skipOwnerPermissions INT = 0
AS
DECLARE @returnVal NVARCHAR(MAX), @x XML,@isAllAssoc INT = 0
BEGIN
		IF @userId = 0
			RETURN
		IF @entityType1 = 0
			RETURN
END
exec getPermissionsOnEntity_GraphAPI @userId,@entityType1,@entityId1,@entityType2,@entityId2,@entityType3,@entityId3,@entityType4,@entityId4,@entityType5,@entityId5,@inheritFromChildren,@includeNotMappedPermission,@skipClassicPermissions,@skipOwnerPermissions,@returnVal OUTPUT
SET @x = (SELECT CAST(REPLACE(@returnVal,'UTF-8','UTF-16') AS XML))
create table #graphTempOutput (id1 int)
insert into #graphTempOutput select t.c.value('(@val)[1]','int') as id1 from  @x.nodes('/apis_NonIDAEntityResult/entityIds') t(c)
declare @stmt nvarchar(max) = 'insert into ' +@tableOutput + ' select * from #graphTempOutput'
exec (@stmt)
GO

IF EXISTS (select * from GxQscripts where name = 'GetPermissionsOnEntityWrapper')
	delete from GxQscripts where name = 'GetPermissionsOnEntityWrapper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetPermissionsOnEntityWrapper')
	delete from GXDBVersions where aliasname = 'GetPermissionsOnEntityWrapper'
GO

insert into GXDBVersions values(2, 'GetPermissionsOnEntityWrapper',  '00000000000000000000', 'GetPermissionsOnEntityWrapper', '00000000000000000000')
GO

