

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetPatchUAContentConfig.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- $Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetPatchUAContentConfig.sp,v $ $Id: GetPatchUAContentConfig.sp,v 1.2.86.2 2020/05/01 18:04:51 kgao Exp $";
--  +========================================================================+
--  | Stored Proc:  GetPatchUAContentConfig()
--  |
--  | Description: Get Cache content info for a given update agent given client id
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetPatchUAContentConfig')
BEGIN
	print '>>> Drop Stored Procedure: GetPatchUAContentConfig <<<'
	drop procedure GetPatchUAContentConfig
END
IF EXISTS (select * from GxQscripts where name='GetPatchUAContentConfig')
	delete from GxQscripts where name = 'GetPatchUAContentConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetPatchUAContentConfig')
	delete from GXDBVersions where aliasname = 'GetPatchUAContentConfig'
GO
print '... Creating Procedure: GetPatchUAContentConfig'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetPatchUAContentConfig
  @inOperationType integer,
  @inClientId integer,
  @inReleaseId integer,
  @inOSId integer
AS
  DECLARE @outputXML XML
SET NOCOUNT ON
BEGIN
DECLARE @bUseNewSync INT = 0
SELECT @bUseNewSync = value FROM GxGlobalParam WITH(NOLOCK) WHERE name = 'Patch Use New Sync'
-- if operation type is 1, return all rows present in the table
-- if operation type is 2, return all rows specific to a remote cache
-- if operation type is 3, return all rows specific to a remote cache, release
-- if operation type is 4, return all rows specific to a remote cache, release
IF @bUseNewSync = 0
	-- old sync code starts here
	SET @outputXML = (SELECT
							  (SELECT P.UAClientId AS '@UAClientId',
												P.ReleaseId AS '@ReleaseId',
												P.OSId AS '@OSId',
												P.SyncPackages AS '@SyncPackages',
												P.SyncUpdates AS '@SyncUpdates',
												CASE WHEN P.SelectedPackageList   IS NULL THEN '0' ELSE P.SelectedPackageList END AS '@SelectedPackageList',
												CASE WHEN P.PackagesInCache IS NULL THEN '0' ELSE P.PackagesInCache END AS '@PackagesInCache'
												FROM PatchUAContentConfig P
												--WHERE   (@inClientId = 0 OR
														  --    (P.UAClientId = @inClientId
														  --          (AND @inReleaseId = 0 OR
														  --                (P.ReleaseId = @inReleaseId
														  --                      AND (@inOSId = 0 OR P.OsId = @inOSId)))))
											  WHERE      (@inOperationType = 1)
														  OR (@inOperationType = 2 AND P.UAClientId = @inClientId )
														  OR (@inOperationType = 3 AND P.UAClientId = @inClientId AND P.ReleaseId = @inReleaseId )
														  OR (@inOperationType = 4 AND P.UAClientId = @inClientId AND P.ReleaseId = @inReleaseId AND P.OSId = @inOSId)
									ORDER BY P.UAClientId, P.ReleaseId , P.OSId DESC
					  FOR XML PATH ('uaInfoList'),TYPE, ROOT ('EVGui_PatchUAContentConfigs')))
ELSE
BEGIN
	-- new sync code starts here
	SET @outputXML = (SELECT
							  (SELECT P.UAClientId AS '@UAClientId',
												P.ReleaseId AS '@ReleaseId',
												P.OSId AS '@OSId',
												P.SyncPackages AS '@SyncPackages',
												0 AS '@SyncUpdates',
												(
													SELECT LEFT(RCPkgConfig.PkgList, LEN(RCPkgConfig.PkgList) - 1)
													FROM
													(
														SELECT
														(
															SELECT CAST(RT1.simPackageId AS VARCHAR(255)) + ','
															FROM PatchUAPackageConfig RT1
															WHERE RT1.UAClientId = P.UAClientId AND RT1.OSId = P.OSId
															FOR XML PATH('')
														) [PkgList]
													) [RCPkgConfig]
												)
												AS '@SelectedPackageList',
												(
															SELECT TOP 1 RT1.PackagesinCache
															FROM PatchUAContentConfig RT1
															WHERE RT1.UAClientId = P.UAClientId AND RT1.OSId = P.OSId AND P.ReleaseId = RT1.ReleaseId
															AND EXISTS(SELECT id FROM PatchMultiCache pmc
																		WHERE pmc.ClientId = P.UAClientId AND pmc.ReleaseId = P.ReleaseId AND pmc.OSId = P.OSId)
												)
												AS '@PackagesInCache'
												FROM PatchUAContentConfig P WITH(NOLOCK)
											  WHERE      (@inOperationType = 1)
														  OR (@inOperationType = 2 AND P.UAClientId = @inClientId )
														  OR (@inOperationType = 3 AND P.UAClientId = @inClientId AND P.ReleaseId = @inReleaseId )
														  OR (@inOperationType = 4 AND P.UAClientId = @inClientId AND P.ReleaseId = @inReleaseId AND P.OSId = @inOSId)
									ORDER BY P.UAClientId, P.ReleaseId , P.OSId DESC
					  FOR XML PATH ('uaInfoList'),TYPE, ROOT ('EVGui_PatchUAContentConfigs')))
END
IF ( @outputXML IS NULL)
   SET @outputXML = '<UpdatePatches_PatchUAContentConfigs />'
SELECT @outputXML
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetPatchUAContentConfig')
	delete from GxQscripts where name = 'GetPatchUAContentConfig'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetPatchUAContentConfig')
	delete from GXDBVersions where aliasname = 'GetPatchUAContentConfig'
GO

insert into GXDBVersions values(2, 'GetPatchUAContentConfig',  '00010002008600020000', 'GetPatchUAContentConfig', '00010002008600020000')
GO

