

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetPatchMultiCacheInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetPatchMultiCacheInfo.sp,v $ $Id: GetPatchMultiCacheInfo.sp,v 1.5.66.8 2020/05/01 18:04:51 kgao Exp $";
--  +========================================================================+
--  | Stored Proc:  GetPatchMultiCacheInfo()
--  |
--  | Description: Get Cache info for a given update agent given its client id
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetPatchMultiCacheInfo')
BEGIN
	print '>>> Drop Stored Procedure: GetPatchMultiCacheInfo <<<'
	drop procedure GetPatchMultiCacheInfo
END
IF EXISTS (select * from GxQscripts where name='GetPatchMultiCacheInfo')
	delete from GxQscripts where name = 'GetPatchMultiCacheInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetPatchMultiCacheInfo')
	delete from GXDBVersions where aliasname = 'GetPatchMultiCacheInfo'
GO
print '... Creating Procedure: GetPatchMultiCacheInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetPatchMultiCacheInfo
  @inUAClientId integer,
  @inReleaseID integer,
  @inOSType integer,
  @inCacheLevel integer=0,
  @inClientId integer
AS
  DECLARE @oUpdateAgentId integer
  DECLARE @oRelease integer
  DECLARE @oOSType integer
  DECLARE @oHighestSP varchar(100)
  DECLARE @oIsSPValid integer
  DECLARE @oAddUpdates varchar(max)
  DECLARE @oTransactionId integer
  DECLARE @oRevisionId integer
  DECLARE @oUpdatePackNumber integer
  DECLARE @oFriendlyName varchar(64)
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
BEGIN
	DECLARE @SPVersionID INT = ISNULL((select MAX(SPVersionID) from SimInstalledPackages NOLOCK where clientID = @inClientId), 0)
	SELECT 	UpdateAgentId,
			Release,
			OSType,
			HighestSP,
			IsSPValid,
			AddUpdates,
			TransactionId,
			RevisionId,
			UpdatePackNumber,
			UpdatePackFriendlyName
	FROM dbo.patchGetCacheInfoByLevel(@inUAClientId, @inReleaseId, @SPVersionID, @inOSType, @inCacheLevel)
END
GO

IF EXISTS (select * from GxQscripts where name = 'GetPatchMultiCacheInfo')
	delete from GxQscripts where name = 'GetPatchMultiCacheInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetPatchMultiCacheInfo')
	delete from GXDBVersions where aliasname = 'GetPatchMultiCacheInfo'
GO

insert into GXDBVersions values(2, 'GetPatchMultiCacheInfo',  '00010005006600080000', 'GetPatchMultiCacheInfo', '00010005006600080000')
GO

