

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetPatchLevelOfClientsInCloud.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetPatchLevelOfClientsInCloud.sp,v $ $Id: GetPatchLevelOfClientsInCloud.sp,v 1.7.210.1 2018/03/22 03:16:13 jiechen Exp $";
--  +========================================================================================+
--  | Stored Proc:  GetPatchLevelOfClientsInCloud()
--  |
--  | Description: Gets the patch level of common AppType across all clients in a given cloud
--  +=========================================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetPatchLevelOfClientsInCloud <<<'

IF EXISTS (select * from sysobjects where name='GetPatchLevelOfClientsInCloud')
	drop procedure GetPatchLevelOfClientsInCloud
IF EXISTS (select * from GxQscripts where name='GetPatchLevelOfClientsInCloud')
	delete from GxQscripts where name = 'GetPatchLevelOfClientsInCloud'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetPatchLevelOfClientsInCloud')
	delete from GXDBVersions where aliasname = 'GetPatchLevelOfClientsInCloud'
GO
print '... Creating Procedure: GetPatchLevelOfClientsInCloud'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetPatchLevelOfClientsInCloud
  @inCloudId integer			
AS
  DECLARE @oClientId integer
  DECLARE @oAppTypeId integer
  DECLARE @oHighestSP integer
  DECLARE @oAdditionalUpdates nvarchar(max)
  DECLARE @oMissingUpdates nvarchar(max)
  DECLARE @oSPMinorVersion integer
  DECLARE @oError integer
  DECLARE @oErrorStr nvarchar(max)
DECLARE @inCId  nvarchar(1024)
set @inCId=convert(nvarchar(1024),@inCloudId)
DECLARE @iCliId		INTEGER
DECLARE @iCountRec      INTEGER
DECLARE @error_l		INTEGER
DECLARE @errorStr	nvarchar(1024)
SET @error_l=0
SET @errorStr= ' '
IF object_id('tempdb.dbo.#AppType') is not null
        DROP TABLE #AppType
CREATE	TABLE #AppType (apptype INT)
INSERT	INTO #AppType (apptype)
SELECT DISTINCT simPackageID from simInstalledPackages WHERE ClientId IN
(SELECT DISTINCT componentNameId from App_ClientProp WHERE attrName='CLOUD_ID' AND attrVal=@inCId)
SET @iCountRec = (SELECT COUNT(DISTINCT ReleaseId) FROM App_Client WHERE Id IN (SELECT DISTINCT componentNameId from App_ClientProp WHERE attrName='CLOUD_ID' AND attrVal=@inCId) )
IF @iCountRec = 1
BEGIN
 SET @iCountRec = (SELECT COUNT(DISTINCT attrVal) FROM App_ClientProp WHERE componentNameId IN
     (SELECT DISTINCT componentNameId from App_ClientProp WHERE attrName='CLOUD_ID' AND attrVal=@inCId)
  AND attrName='Galaxy Build')
    IF @iCountRec = 1
    BEGIN
        DECLARE CommonAppTypeCur cursor for
            SELECT DISTINCT componentNameId from App_ClientProp WHERE attrName='CLOUD_ID' AND attrVal=@inCId
        OPEN CommonAppTypeCur
        FETCH NEXT FROM CommonAppTypeCur INTO @iCliId
          WHILE @@FETCH_STATUS = 0
           BEGIN
             DELETE #AppType WHERE apptype IN(
              SELECT apptype FROM #AppType WHERE apptype NOT IN(
                  SELECT TL.simPackageID FROM simInstalledPackages AS TL WHERE TL.clientid=@iCliId))
             FETCH NEXT FROM CommonAppTypeCur INTO @iCliId
           END
        CLOSE CommonAppTypeCur
        DEALLOCATE CommonAppTypeCur
        SET @iCountRec  =      (SELECT COUNT(*) FROM #AppType)
        IF @iCountRec > 0
        BEGIN
            SELECT clientId,simPackageID,HighestSP,AdditionalPatches,MissingPatches,SpMinorVersion, 0 As Error, ' ' As ErrorStr FROM simInstalledPackages WHERE clientId IN
              (SELECT DISTINCT componentNameId FROM app_clientprop WHERE attrName='CLOUD_ID' AND attrVal=@inCId)
              AND simPackageID IN  (SELECT apptype FROM #AppType) ORDER BY clientId,simPackageID
        END
        ELSE
		BEGIN
			SET @error_l=-1
			SET @errorStr= 'There are no packages found in the simInstalledPackages table for the clients in the given cloud.'
		END
     END
     ELSE
	BEGIN
		SET @error_l=-1
		SET @errorStr= 'Clients have different build numbers in the given cloud.'
	END
END
ELSE
BEGIN
	SET @error_l=-1
	SET @errorStr= 'Clients have different release numbers in the given cloud.'
END
IF @error_l <> 0
BEGIN
	SELECT 0,0,0,' ',' ',0,@error_l As Error,@errorStr As ErrorStr
END
DROP TABLE #AppType
GO

IF EXISTS (select * from GxQscripts where name = 'GetPatchLevelOfClientsInCloud')
	delete from GxQscripts where name = 'GetPatchLevelOfClientsInCloud'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetPatchLevelOfClientsInCloud')
	delete from GXDBVersions where aliasname = 'GetPatchLevelOfClientsInCloud'
GO

insert into GXDBVersions values(2, 'GetPatchLevelOfClientsInCloud',  '00010007021000010000', 'GetPatchLevelOfClientsInCloud', '00010007021000010000')
GO

