

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetPatchINIInfo.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetPatchINIInfo.sp,v $ $Id: GetPatchINIInfo.sp,v 1.15.86.2 2019/02/14 11:03:07 bsingha Exp $";
--  +========================================================================+
--  | Stored Proc:  GetPatchINIInfo()
--  |
--  | Description: Gets the patch INI info
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetPatchINIInfo')
BEGIN
	print '>>> Drop Stored Procedure: GetPatchINIInfo <<<'
	drop procedure GetPatchINIInfo
END
IF EXISTS (select * from GxQscripts where name='GetPatchINIInfo')
	delete from GxQscripts where name = 'GetPatchINIInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetPatchINIInfo')
	delete from GXDBVersions where aliasname = 'GetPatchINIInfo'
GO
print '... Creating Procedure: GetPatchINIInfo'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetPatchINIInfo
  @inPatchName varchar(256),
  @isPatchId integer,
  @inReleaseID integer,
  @inOSType integer,
  @inSP varchar(20),
  @inAppID integer			
AS
  DECLARE @oRelease integer
  DECLARE @oOSType integer
  DECLARE @oUpdateName varchar(256)
  DECLARE @oPatchId integer
  DECLARE @oAliasName varchar(256)
  DECLARE @oServicePacks varchar(100)
  DECLARE @oAppTypeList varchar(2048)
  DECLARE @oRebootPkg varchar(256)
  DECLARE @oObsoletes varchar(2048)
  DECLARE @oSpaceReqd integer
  DECLARE @oRequires varchar(MAX)
DECLARE @oTempTable table ( tempSp varchar(MAX))
DECLARE @oTempSpString varchar(100)
DECLARE @len integer
DECLARE @inAppType varchar(5)
set @inAppType=convert(varchar(5),@inAppID)
set @len=LEN(@inPatchName)
if @len =0 or @isPatchId =1
begin
      IF object_id('tempdb.dbo.#AU_DistinctServicepack') IS NOT null DROP TABLE #AU_DistinctServicepack
      CREATE  TABLE #AU_DistinctServicepack
      (
            servicePackString [nvarchar] (255)
      )
      insert into #AU_DistinctServicepack select distinct Servicepacks from PatchINI where ReleaseId = @inReleaseID and OSId = @inOSType
      declare distinctSpString cursor for select servicePackString from #AU_DistinctServicepack
      open distinctSpString
      fetch next from distinctSpString into @oTempSpString
      while @@FETCH_STATUS = 0
      begin
            insert into @oTempTable select @oTempSpString as tempSp  where exists (select _ID  from dbo.SplitIDString(@oTempSpString) where _ID = @inSP)
            fetch next from distinctSpString into @oTempSpString
      end
end
if @len =0
begin
      if @inAppType=0
            begin
                  select PI.ReleaseId,PI.OSId,PI.PatchName,PI.PatchId,PI.AliasName,PI.Servicepacks,PI.AppTypeList,PI.RebootPkgList,PI.Obsoletes,PI.SpaceRequired,PI.Requires
                    from PatchINI PI WITH(NOLOCK) where PI.ReleaseId=@inReleaseID and PI.OSId =@inOSType and exists (select tempSp from @oTempTable where tempSp = PI.Servicepacks)
            end
      else
            begin
                  select PI.ReleaseId,PI.OSId,PI.PatchName,PI.PatchId,PI.AliasName,PI.Servicepacks,PI.AppTypeList,PI.RebootPkgList,PI.Obsoletes,PI.SpaceRequired,PI.Requires
                  from PatchINI PI WITH(NOLOCK) where PI.ReleaseId=@inReleaseID and PI.OsId =@inOSType and  exists (select tempSp from @oTempTable where tempSp = PI.Servicepacks) and @inAppType In (select * from dbo.SplitIDString(PI.AppTypeList))
            end
end
else
      begin
      if @isPatchId=1
            if @inAppType=0
                  begin
                        select PI.ReleaseId,PI.OSId,PI.PatchName,PI.PatchId,PI.AliasName,PI.Servicepacks,PI.AppTypeList,PI.RebootPkgList,PI.Obsoletes,PI.SpaceRequired,PI.Requires
                              from PatchINI PI WITH(NOLOCK) where PI.ReleaseId=@inReleaseID and PI.OSId =@inOSType and PI.PatchName like ('%'+'_'+@inPatchName) and exists (select tempSp from @oTempTable where tempSp = PI.Servicepacks)
                  END
            else
                  begin
                        select PI.ReleaseId,PI.OSId,PI.PatchName,PI.PatchId,PI.AliasName,PI.Servicepacks,PI.AppTypeList,PI.RebootPkgList,PI.Obsoletes,PI.SpaceRequired,PI.Requires
                        from PatchINI PI WITH(NOLOCK) where PI.ReleaseId=@inReleaseID and PI.OSId =@inOSType and PI.PatchName like ('%'+'_'+@inPatchName) and  exists (select tempSp from @oTempTable where tempSp = PI.Servicepacks) and @inAppType In (select * from dbo.SplitIDString(PI.AppTypeList))
                  end
      else
                  select PI.ReleaseId,PI.OSId,PI.PatchName,PI.PatchId,PI.AliasName,PI.Servicepacks,PI.AppTypeList,PI.RebootPkgList,PI.Obsoletes,PI.SpaceRequired,PI.Requires
                    from PatchINI PI WITH(NOLOCK) where PI.PatchName like @inPatchName
end
GO

IF EXISTS (select * from GxQscripts where name = 'GetPatchINIInfo')
	delete from GxQscripts where name = 'GetPatchINIInfo'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetPatchINIInfo')
	delete from GXDBVersions where aliasname = 'GetPatchINIInfo'
GO

insert into GXDBVersions values(2, 'GetPatchINIInfo',  '00010015008600020000', 'GetPatchINIInfo', '00010015008600020000')
GO

