

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetParentsForGivenEntity.sp] ---------- 

-- 	+-----------------------------------------------------------------------------------------------------------------------------------+
--	| 	Procedure : "GetParentsForGivenEntity.sp"
--	|	Description:
--	|	This sp returns the parents for a given entity.
--	|	Author: suraj shankar
-- 	+-----------------------------------------------------------------------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetParentsForGivenEntity')
BEGIN
	print '>>> Drop Stored Procedure: GetParentsForGivenEntity <<<'
	drop procedure GetParentsForGivenEntity
END
IF EXISTS (select * from GxQscripts where name='GetParentsForGivenEntity')
	delete from GxQscripts where name = 'GetParentsForGivenEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetParentsForGivenEntity')
	delete from GXDBVersions where aliasname = 'GetParentsForGivenEntity'
GO
print '... Creating Procedure: GetParentsForGivenEntity'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetParentsForGivenEntity
  @entityType INT,
  @entityId1 INT,
  @entityId2 INT = 0,
  @entityId3 INT = 0,
  @entityId4 INT = 0,
  @entityId5 INT = 0,
  @parents XML OUTPUT
AS
BEGIN
declare @associationQuery nvarchar(MAX) = ''
IF OBJECT_ID('tempdb.dbo.#parentEntities') is not null
			drop table #parentEntities
create table #parentEntities (parentEntityType int,parentId int)
IF OBJECT_ID('tempdb.dbo.#tempTable') is not null
			drop table #tempTable
IF OBJECT_ID('tempdb.dbo.#nonIdaTempTable') is not null
			drop table #nonIdaTempTable
create table #tempTable (parentEntityType int,parentId int,childEntityType int, childId int, childId2 int default 0, childId3 int default 0,childId4 int default 0, childId5 int default 0)
create table #nonIdaTempTable (parentEntityType int,parentId int,childEntityType int, childId int)
declare @tableToInsert nvarchar(max) = ''
IF @entityType >= 3 and @entityType <= 7
	BEGIN
		set @tableToInsert = '#tempTable'
	END
ELSE
	BEGIN
		set @tableToInsert = '#nonIdaTempTable'
	END
if not exists (select 1 from App_EntityParentAssociation where childEntityType = @entityType)
	BEGIN
	set @parents = ''
	return
	END
declare db_cursor CURSOR for
select associationQuery from App_EntityParentAssociation where childEntityType = @entityType
OPEN db_cursor
fetch next from db_cursor into @associationQuery
WHILE @@FETCH_STATUS = 0
BEGIN
	declare @stmt nvarchar(max) = 'insert into ' +@tableToInsert + '  ' + @associationQuery
	exec (@stmt)
	FETCH NEXT FROM db_cursor into @associationQuery
END
declare @outputStmt nvarchar(max)
IF @entityType = 3
	BEGIN
SET @outputStmt = 'insert into #parentEntities select parentEntityType,parentId from #tempTable where childEntityType = ' + STR(3) + ' and childId = ' + STR(@entityId1)
	END
ELSE IF @entityType = 4
	BEGIN
SET @outputStmt = 'insert into #parentEntities select parentEntityType,parentId from #tempTable where childEntityType = ' +  STR(4) + ' and childId = ' + STR(@entityId1) + ' and childId2 = ' + STR(@entityId2)
	END
ELSE If @entityType = 5
	BEGIN
SET @outputStmt = 'insert into #parentEntities select parentEntityType,parentId from #tempTable where childEntityType = ' + STR(5) + ' and childId = ' + STR(@entityId1) + ' and childId2 = ' + STR(@entityId2) + ' and childId3 = ' +STR(@entityId3)
	END
ELSE IF @entityType = 6
	BEGIN
SET @outputStmt = 'insert into #parentEntities select parentEntityType,parentId from #tempTable where childEntityType = ' + STR(6) + ' and childId = ' + STR(@entityId1) + ' and childId2 = ' + STR(@entityId2) + ' and childId3 = ' +STR(@entityId3) + ' and childId4 = ' +STR(@entityId4)
	END
ELSE IF @entityType = 7
	BEGIN
SET @outputStmt = 'insert into #parentEntities select parentEntityType,parentId from #tempTable where childEntityType = ' + STR(7) + ' and childId = ' + STR(@entityId1) + ' and childId2 = ' + STR(@entityId2) + ' and childId3 = ' +STR(@entityId3) + ' and childId4 = ' +STR(@entityId4) + ' and childId5 = ' +STR(@entityId5)
	END
ELSE IF @entityType > 7
	BEGIN
	SET @outputStmt = 'insert into #parentEntities select parentEntityType,parentId from #nonIdaTempTable where childEntityType = ' + STR(@entityType) +' and childId = ' + STR(@entityId1)
	END
EXEC (@outputStmt)
set @parents = (select parentEntityType as ParentEntityType,parentId as ParentId from #parentEntities as parent  for XML auto,ROOT('Parents'))
close db_cursor
deallocate db_cursor
END
GO

IF EXISTS (select * from GxQscripts where name = 'GetParentsForGivenEntity')
	delete from GxQscripts where name = 'GetParentsForGivenEntity'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetParentsForGivenEntity')
	delete from GXDBVersions where aliasname = 'GetParentsForGivenEntity'
GO

insert into GXDBVersions values(2, 'GetParentsForGivenEntity',  '00000000000000000000', 'GetParentsForGivenEntity', '00000000000000000000')
GO

