

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetPackageListForClient.sp] ---------- 

--  +========================================================================+
--  | Stored Precedure: List all clients which have this package/apptype installed. It includes deconfigured and restire only agents.
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetPackageListForClient')
BEGIN
	print '>>> Drop Stored Procedure: GetPackageListForClient <<<'
	drop procedure GetPackageListForClient
END
IF EXISTS (select * from GxQscripts where name='GetPackageListForClient')
	delete from GxQscripts where name = 'GetPackageListForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetPackageListForClient')
	delete from GXDBVersions where aliasname = 'GetPackageListForClient'
GO
print '... Creating Procedure: GetPackageListForClient'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetPackageListForClient
  @inputxml XML
AS
SET NOCOUNT ON
DECLARE @dropTempTable INT = 0
IF OBJECT_ID('tempdb.dbo.#PackagesForClient_tmp__Clients') IS NULL
BEGIN
    -- temporary table does not exist in execution context. create one
    CREATE TABLE #PackagesForClient_tmp__Clients (packageId INT PRIMARY KEY)
    -- and set flag that indicates that it should be dropped
    SET @dropTempTable = 1
END
DECLARE @clientId  INT = ISNULL((SELECT ref.value('@clientId', 'INT')     FROM @inputxml.nodes('App_GetPackageListForClientReq') R(ref)), 0)
BEGIN
    INSERT INTO #PackagesForClient_tmp__Clients
		    SELECT  DISTINCT SIP.simPackageId
		    FROM    simInstalledPackages SIP WITH (NOLOCK) INNER JOIN APP_Client C WITH(NOLOCK) ON C.id = SIP.ClientId
		   WHERE   C.id = @clientId
END
-- if there was temporary table it means that this stored proc called from another one which will use whatever is in #ClientsForPackage_tmp__Clients table
-- otherwise build xml message and select result set
IF @dropTempTable = 1
BEGIN
    DECLARE @rv XML = (SELECT packageId
		               FROM #PackagesForClient_tmp__Clients
		               FOR XML PATH('packages'),ROOT('App_GetPackageListForClientResp'))
    DROP TABLE #PackagesForClient_tmp__Clients
    SELECT @rv
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetPackageListForClient')
	delete from GxQscripts where name = 'GetPackageListForClient'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetPackageListForClient')
	delete from GXDBVersions where aliasname = 'GetPackageListForClient'
GO

insert into GXDBVersions values(2, 'GetPackageListForClient',  '00000000000000000000', 'GetPackageListForClient', '00000000000000000000')
GO

