

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetOraTableSpace.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------+
--	| 						SP: "GetOraTableSpace"							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetOraTableSpace')
BEGIN
	print '>>> Drop Stored Procedure: GetOraTableSpace <<<'
	drop procedure GetOraTableSpace
END
IF EXISTS (select * from GxQscripts where name='GetOraTableSpace')
	delete from GxQscripts where name = 'GetOraTableSpace'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetOraTableSpace')
	delete from GXDBVersions where aliasname = 'GetOraTableSpace'
GO
print '... Creating Procedure: GetOraTableSpace'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetOraTableSpace
-- ---------------------------------------------------------------
-- Function is used to lookup the client list using specified condition
-- ---------------------------------------------------------------
  @instId integer,
  @backupsetId integer = 0,
  @pointInTime integer = 0,
  @PointInTimeFlag integer = 0
AS
  DECLARE @sc_id integer
  DECLARE @sc_name varchar(255)
  DECLARE @pdbName varchar(255)
  DECLARE @o_name varchar(255)
  DECLARE @b_name varchar(255)
  DECLARE @status integer
  DECLARE @opType integer
  DECLARE @highwatermark integer
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	IF(@PointInTimeFlag = 0)
	BEGIN
		SELECT distinct app.id, app.subclientName, isnull(pdbs.name, ''), tblspace.name, tblspace.bkpNode,tblspace.status, tblspace.opType, tblspace.highwatermark FROM oracleTableSpaces tblspace
		LEFT JOIN OraclePluggableDbs pdbs on tblSpace.pdbId = pdbs.pdbId
		LEFT JOIN oracleObjects obj ON  obj.instId = @instId and  ( (obj.objId = tblspace.id and obj.type =5)
			OR (isnull(tblspace.pdbId, 0) != 0 and obj.objId = pdbs.pdbId  and obj.type = 20) )
		LEFT  JOIN APP_Application app ON app.id = obj.subClientId
		WHERE tblspace.instId = @instId AND tblSpace.deleteFlag = 0 AND
		(backupsetId = @backupsetId or @backupsetId = 0)
		ORDER BY isnull(pdbs.name, ''), tblspace.name
	END
	ELSE
	BEGIN
		SELECT distinct app.id, app.subclientName, isnull(pdbs.name, ''), tblspace.name, tblspace.bkpNode,tblspace.status, tblspace.opType, tblspace.highwatermark FROM oracleTableSpaces tblspace
        	LEFT JOIN OraclePluggableDbs pdbs on tblSpace.pdbId = pdbs.pdbId
		LEFT JOIN oracleObjects obj ON obj.instId = @instId and ((obj.objId = tblspace.id and obj.type =5)
			OR	(isnull(tblspace.pdbId, 0) != 0 and obj.objId = pdbs.pdbId  and obj.type = 20))
        	LEFT  JOIN APP_Application app ON app.id = obj.subClientId
        	WHERE tblspace.instId = @instId AND
        	(backupsetId = @backupsetId or @backupsetId = 0)AND
        	(tblSpace.created < @pointInTime)
         	AND (tblSpace.deleted > @pointInTime or tblSpace.deleted = 0)
         	ORDER BY isnull(pdbs.name, ''), tblspace.name
	END
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetOraTableSpace')
	delete from GxQscripts where name = 'GetOraTableSpace'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetOraTableSpace')
	delete from GXDBVersions where aliasname = 'GetOraTableSpace'
GO

insert into GXDBVersions values(2, 'GetOraTableSpace',  '00000000000000000000', 'GetOraTableSpace', '00000000000000000000')
GO

