

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetOraPDBs.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------+
--	| 						SP: "GetOraPDBs"							|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetOraPDBs <<<'

IF EXISTS (select * from sysobjects where name='GetOraPDBs')
	drop procedure GetOraPDBs
IF EXISTS (select * from GxQscripts where name='GetOraPDBs')
	delete from GxQscripts where name = 'GetOraPDBs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetOraPDBs')
	delete from GXDBVersions where aliasname = 'GetOraPDBs'
GO
print '... Creating Procedure: GetOraPDBs'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetOraPDBs
-- ---------------------------------------------------------------
-- Function is used to lookup the client list using specified condition
-- ---------------------------------------------------------------
  @instId integer,
  @pointInTime integer = 0,
  @PointInTimeFlag integer = 0,
  @objType integer = 20,
  @pdbName varchar(31) = ''
AS
  DECLARE @sc_id integer
  DECLARE @sc_name varchar(255)
  DECLARE @pdbId integer
  DECLARE @name varchar(255)
  DECLARE @opType integer
	SET NOCOUNT ON
	IF (@objType = 20)
	BEGIN
		SELECT distinct app.id, app.subclientName, pdbId, isnull(pdbs.name, '') as pdb_name,  pdbs.opType FROM   OraclePluggableDbs pdbs
		LEFT JOIN oracleObjects obj ON  ( obj.instId = @instId and obj.objId = pdbs.pdbId and obj.type = @objType)
			  	LEFT  JOIN APP_Application app ON app.id = obj.subClientId
        	WHERE  pdbs.instId = @instId
        	AND ( (@PointInTimeFlag = 0 and pdbs.deleteFlag = 0 ) OR
        		 (pdbs.created < @pointInTime 	AND (pdbs.deleted > @pointInTime or pdbs.deleted = 0) ) )
         	ORDER BY pdb_name
   	END
	ELSE
	BEGIN
		SELECT distinct app.id, app.subclientName, tblSpace.pdbId, tblspace.name,  tblspace.opType FROM oracleTableSpaces tblspace
		INNER JOIN OraclePluggableDbs pdbs on tblSpace.pdbId = pdbs.pdbId
		LEFT JOIN oracleObjects obj ON  obj.instId = @instId and  obj.objId = tblspace.id and obj.type = @objType
		LEFT  JOIN APP_Application app ON app.id = obj.subClientId
		WHERE tblspace.instId = @instId  AND pdbs.name = @pdbName
		AND	    ( (@PointInTimeFlag = 0 and tblSpace.deleteFlag = 0 )
			   OR ( tblSpace.created < @pointInTime AND
			   (tblSpace.deleted > @pointInTime OR tblSpace.deleted = 0) ) )
		ORDER BY  tblSpace.pdbId, tblspace.name
	END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetOraPDBs')
	delete from GxQscripts where name = 'GetOraPDBs'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetOraPDBs')
	delete from GXDBVersions where aliasname = 'GetOraPDBs'
GO

insert into GXDBVersions values(2, 'GetOraPDBs',  '00000000000000000000', 'GetOraPDBs', '00000000000000000000')
GO

