

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetOnePassMemberServersRequest.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='getOnePassMemberServersRequest')
BEGIN
	print '>>> Drop Stored Procedure: getOnePassMemberServersRequest <<<'
	drop procedure getOnePassMemberServersRequest
END
IF EXISTS (select * from GxQscripts where name='getOnePassMemberServersRequest')
	delete from GxQscripts where name = 'getOnePassMemberServersRequest'
GO

IF EXISTS (select * from GXDBVersions where aliasname='getOnePassMemberServersRequest')
	delete from GXDBVersions where aliasname = 'getOnePassMemberServersRequest'
GO
print '... Creating Procedure: getOnePassMemberServersRequest'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure getOnePassMemberServersRequest
  @xmlText XML OUTPUT
AS
DECLARE @brAlertTrace AS varchar(256) = (select value from gxglobalParam (NOLOCK) Where name = 'bralertTrace')
IF @brAlertTrace <> 0
BEGIN
	DECLARE @nowTime  DATETIME = GETDATE()
	DECLARE @inputString   NVARCHAR(MAX) = CAST(@xmlText AS NVARCHAR(MAX))
	EXEC br_ntTrace '.. [getOnePassMemberServersRequest]', 0, @nowTime, 0, 0, @inputString
END
DECLARE @showAllIndexServers INT = ISNULL((SELECT CAST(value AS NVARCHAR(MAX)) FROM GXGlobalParam WITH (NOLOCK) WHERE name='showAllIndexServersForExchangeOnePass'), 0)
	DECLARE @SOLRCLOUD_STANDALONE INT = 1 -- App_CloudServerType::AnalyticsEngine
	DECLARE @SOLRCLOUD_EMBEDDED INT = 4 -- App_CloudServerType::SolrEmbeddedCloud
	DECLARE @SOLRCLOUD_CLUSTER INT = 5 -- App_CloudServerType::SolrClusterCloud
	DECLARE @defaultVal INT = 0
	--Get values from XML
	DECLARE @userId INT = 0
	DECLARE @reqType INT = 0
	DECLARE @isCommcellLevelAssociation INT = 0
	DECLARE @bkTypeToCreate INT = 0 -- Takes values defined in App_ExchangeOnePassBackupsetType enum [USER_MAILBOXES=1, JOURNAL_MAILBOXES=2, CONTENTSTORE_MAILBOX=3]
	SELECT  @userId = ISNULL(ref.value('processinginstructioninfo[1]/user[1]/@userId', 'int'), @userId),
			@reqType = ISNULL(ref.value('@reqType','INT'), @reqType),
			@bkTypeToCreate  = ISNULL(ref.value('@backupSetTypeToCreate', 'INT'), @bkTypeToCreate)
		FROM @xmlText.nodes ('App_GetOnePassMemberServersRequest') R(ref)
	IF OBJECT_ID('tempdb.dbo.#GetIndexServers') IS NOT NULL     DROP TABLE #GetIndexServers
	CREATE TABLE #GetIndexServers
	(
		serverURL NVARCHAR(512),
		clientId INT,
		clientName NVARCHAR(256),
		cloudId INT,
		hostName NVARCHAR(256),
		basePort INT,
		engineName  NVARCHAR(256),
		serverType INT,
		indexServerClientId INT,
		internalCloudName NVARCHAR(256)
	)
	DECLARE @indexServers TABLE
    (
        clientId INT PRIMARY KEY,
		v2Schema INT,
		serverType INT,
		name	NVARCHAR(256)
    )
	DECLARE @memberServers TABLE
	(
		exVersion INT,
		clientId INT,
		clientName NVARCHAR(MAX),
		clientType INT
	)
	IF OBJECT_ID('tempdb.dbo.#getOnePassMembersClientListTmp') IS NOT NULL
		DROP TABLE #getOnePassMembersClientListTmp
	CREATE TABLE #ExchangeClientToBackupsetMap
	(
		clientId INT,
		backupsetType INT,
		indexServerClientId INT
	)
	CREATE CLUSTERED INDEX #ExchangeClientToBackupsetMap_Index1 ON #ExchangeClientToBackupsetMap ([clientId], [backupsetType], [indexServerClientId])
	--Get Security Associations
	IF OBJECT_ID('tempdb.dbo.#getOnePassMembersClientListTmp') IS NOT null
	DROP TABLE #getOnePassMembersClientListTmp
create table  #getOnePassMembersClientListTmp ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 2009, 0, '#getOnePassMembersClientListTmp'
SELECT @isCommcellLevelAssociation=1 from #getOnePassMembersClientListTmp sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
	-- Get all the index servers #GetIndexServers
	EXEC DM2GetIndexServers
	;WITH indexServersCTE AS
	(
	SELECT indexServerClientId, ROW_NUMBER() OVER(PARTITION BY indexServerClientId ORDER BY indexServerClientId) AS RowNum
	FROM #GetIndexServers
	)
	-- Keep the first node.
	DELETE From indexServersCTE Where RowNum > 1;
	-- Figureout V1Schema or V2Schema
	INSERT INTO @indexServers
	SELECT
	IServer.indexServerClientId,
	CASE WHEN IServer.serverType IN(@SOLRCLOUD_EMBEDDED, @SOLRCLOUD_CLUSTER) THEN 1
		 WHEN @bkTypeToCreate IN(2/*Journal*/, 3/*Content store*/) THEN 0/*V1Schema*/
WHEN IServer.serverType = @SOLRCLOUD_STANDALONE AND Cli.releaseId = 16 AND (SELECT  max(HighestSP) FROM simInstalledPackages Where clientId = IServer.clientId) < 22 THEN 0
		 ELSE 1 END,
	IServer.serverType,
	IServer.engineName
	FROM #GetIndexServers IServer, App_Client Cli
	WHERE IServer.clientId = Cli.id
	DELETE FROM #GetIndexServers
	-- Get IndexServers with Exchange Index role enabled.
	EXEC DM2GetIndexServers 'Exchange Index'
	-- Delete V1Schema index servers without the Exchange Role installed.
	DELETE FROM @indexServers
	WHERE v2Schema = 0 AND clientId NOT IN(SELECT DISTINCT indexServerClientId FROM #GetIndexServers)
	-- For the v1Schema index servers without the showAllIndexServers set to 1
	-- When bkpTypeToCreate is passed then show all the index servers which didn't consume it.
	-- When bkpTypeToCreate is not passed(Backward compatability) then exclude all already consumed index servers.
	IF @showAllIndexServers = 0
	BEGIN
		INSERT INTO #ExchangeClientToBackupsetMap(clientId, backupsetType, indexServerClientId)
		SELECT A.clientId as clientId, B.attrVal as backupsetType , cast(P.attrVal as INT) as indexServerClientId
		FROM APP_Application A (NOLOCK)
		INNER JOIN APP_BACKUPSETPROP B (NOLOCK) ON B.componentNameId = A.backupSet AND B.attrName = 'Exchange OnePass BackupSet Type' and B.modified = 0
		INNER JOIN APP_IDAName (NOLOCK) I ON A.clientId = I.clientId
		INNER JOIN APP_IDAProp (NOLOCK) P ON I.id = P.componentNameId and P.attrName =  'OnePass Index Server'  and P.modified = 0
WHERE A.apptypeId = 137
AND (A.subclientStatus & 0x00004 != 0x00004) AND (A.subclientStatus & 0x00002 != 0x00002)
		-- backupsetType = @bkTypeToCreate -> Delete already consumed index servers for the given backupset type
		-- backupsetType = 0 -> Any consumed index server if the caller didn't pass the backupsetType.
		DELETE FROM @indexServers
		WHERE v2Schema = 0 AND clientId IN
		(SELECT indexServerClientId FROM #ExchangeClientToBackupsetMap WHERE backupsetType = @bkTypeToCreate OR @bkTypeToCreate = 0)
	END
	INSERT INTO @memberServers
	SELECT R.attrVal, C.id, C.name,
	(CASE I.appTypeId
WHEN 54 THEN 3
	END)
	FROM APP_Client C (NOLOCK)
JOIN APP_IDAName I (NOLOCK) ON C.id = I.clientId AND I.appTypeId = 54
JOIN simInstalledPackages S (NOLOCK) ON I.clientId = S.ClientId AND S.simPackageID = 152 -- filter out based on installed package
	LEFT OUTER JOIN APP_IDAProp R (NOLOCK) ON R.componentNameId = I.id AND R.attrName ='IDA Version' AND R.modified = 0
	WHERE C.status & 2 = 0
	AND C.specialClientFlags & 2 =0
AND C.releaseId >= 16
	UNION
	SELECT @defaultVal, CL.id, CL.name, @defaultVal
	FROM APP_Client CL, simInstalledPackages sim, PatchSPVersion psp
	WHERE sim.simPackageID = 151 AND sim.ClientId = CL.id AND sim.SPVersionID = psp.id AND psp.Release >= 16 AND psp.SPMajor >= 12
	IF @isCommcellLevelAssociation = 0
	BEGIN
		DECLARE @disableUseProxyCheck INT = 0
SET @disableUseProxyCheck = ISNULL((SELECT CAST(value AS INT) FROM GxGlobalParam WHERE name = 'DisableUseProxyCheck'),0)
		IF @disableUseProxyCheck = 1
		BEGIN
			--delete all client where this user doesnt have access to
			DELETE FROM @memberServers WHERE clientId NOT IN (SELECT clientId FROM #getOnePassMembersClientListTmp) -- This is replaced by the "Use Proxy" check below
		END
		DELETE FROM @indexServers WHERE clientId NOT IN (SELECT clientId FROM #getOnePassMembersClientListTmp)
		IF @disableUseProxyCheck = 0
		BEGIN
IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_InputTable') IS NOT NULL DROP TABLE #getPermissionsOnEntities_InputTable CREATE TABLE #getPermissionsOnEntities_InputTable ( entityId1 INT, entityId2 INT DEFAULT 0, entityId3 INT DEFAULT 0, entityId4 INT DEFAULT 0, entityId5 INT DEFAULT 0 ) IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_OutputTable') IS NOT NULL DROP TABLE #getPermissionsOnEntities_OutputTable CREATE TABLE #getPermissionsOnEntities_OutputTable ( entityId1 INT, entityId2 INT, entityId3 INT, entityId4 INT, entityId5 INT, permissionsString VARCHAR(512), isChildRow BIT DEFAULT 0	        )
			INSERT INTO #getPermissionsOnEntities_InputTable (entityId1, entityId2, entityId3, entityId4, entityId5)
			SELECT clientId, 0, 0, 0,0 FROM @memberServers
EXEC sec_getPermissionsOnEntities @userId, 3
			DELETE FROM #getPermissionsOnEntities_OutputTable
WHERE (SUBSTRING(permissionsString,252,1) != CAST(1 AS NVARCHAR(1))) AND
(SUBSTRING(permissionsString,2,1) != CAST(1 AS NVARCHAR(1)))
			DELETE FROM @memberServers
			WHERE clientId NOT IN(SELECT entityId1 FROM #getPermissionsOnEntities_OutputTable)
		END
	END
	--1 : Means CI job Request
	IF @reqType = 1
DELETE FROM  @memberServers where clientId NOT IN (select ClientId from simInstalledPackages (NOLOCK) where simPackageID = 151 INTERSECT select ClientId from simInstalledPackages (NOLOCK) where simPackageID IN (263, 252))
SET @xmlText =
	(
		SELECT
		(
			SELECT
			(
				SELECT
				(
				SELECT DISTINCT exVersion AS '@exchangeVersion', clientId AS 'client/@clientId', clientName AS 'client/@clientName', clientType AS 'client/@_type_'
				FROM	@memberServers
				FOR XML PATH('memberServers'), TYPE)
			FOR XML PATH(''), TYPE)
			),
			(
				SELECT
				I.clientId	'@mediaAgentId',
				I.name		'@mediaAgentName',
11 '@_type_'
				FROM @indexServers I
				FOR XML PATH('indexServers'), TYPE
			)
		FOR XML PATH(''),
		ROOT('App_GetOnePassMemberServersResponse')
	)
	SELECT @xmlText
	IF OBJECT_ID('tempdb.dbo.#getOnePassMembersClientListTmp') IS NOT null
		DROP TABLE #getOnePassMembersClientListTmp
GO

IF EXISTS (select * from GxQscripts where name = 'GetOnePassMemberServersRequest')
	delete from GxQscripts where name = 'GetOnePassMemberServersRequest'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetOnePassMemberServersRequest')
	delete from GXDBVersions where aliasname = 'GetOnePassMemberServersRequest'
GO

insert into GXDBVersions values(2, 'GetOnePassMemberServersRequest',  '00000000000000000000', 'GetOnePassMemberServersRequest', '00000000000000000000')
GO

