

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetOffice365SPV2PseudoClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2018  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +===========================================================================+
--  |			GetOffice365SPV2PseudoClients									|
--  |   Procedure to get Office365 SharePoint v2 all Pseudo Clients				|
--  +===========================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetOffice365SPV2PseudoClients')
BEGIN
	print '>>> Drop Stored Procedure: GetOffice365SPV2PseudoClients <<<'
	drop procedure GetOffice365SPV2PseudoClients
END
IF EXISTS (select * from GxQscripts where name='GetOffice365SPV2PseudoClients')
	delete from GxQscripts where name = 'GetOffice365SPV2PseudoClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetOffice365SPV2PseudoClients')
	delete from GXDBVersions where aliasname = 'GetOffice365SPV2PseudoClients'
GO
print '... Creating Procedure: GetOffice365SPV2PseudoClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetOffice365SPV2PseudoClients
-----------------------------------------------------------
---    PARAMETERS				                         ---
  @inXmlReq XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
    DECLARE @errorCode              INT = 0
    DECLARE @errorString            NVARCHAR(1024) = ''
	DECLARE @i_userId				INT = 0
	DECLARE @OutXmlReq				XML = NULL
	IF OBJECT_ID('tempdb.dbo.#tmpOffice365ClientList') IS NOT NULL
		DROP TABLE #tmpOffice365ClientList
	CREATE TABLE #tmpOffice365ClientList (clientId INT , clientName NVARCHAR(MAX))
	CREATE CLUSTERED INDEX #tmpOffice365ClientList_clientId_Idx1 ON #tmpOffice365ClientList (clientId)
	SET @i_userId = ISNULL((select @inXmlReq.value('(Ida_GetOffice365SPV2PseudoClientsReq/processinginstructioninfo/user/@userId)[1]', 'INT')), 0)
	--Security
	IF OBJECT_ID('tempdb.dbo.#tempclientSecurityObjects') IS NOT Null DROP TABLE #tempclientSecurityObjects
	create table  #tempclientSecurityObjects (clientId INT, apptypeId INT, instanceID INT, backupsetId INT, subclientID INT)
	CREATE CLUSTERED INDEX #tempclientSecurityObjects_clientId_Idx1 ON #tempclientSecurityObjects (clientId)
EXEC sec_getIdaObjectsForUser @i_userId,3,0,0,'#tempclientSecurityObjects'
	INSERT INTO #tmpOffice365ClientList ( clientId, clientName)
	SELECT C.id as clientId, C.displayName as clientName
	FROM APP_Application (NOLOCK) SC
	INNER JOIN APP_Client(NOLOCK) C ON C.id = SC.clientId
	INNER JOIN APP_BackupSetName(NOLOCK) BK ON SC.backupSet = BK.id
	INNER JOIN	APP_ClientProp (NOLOCK) AC ON SC.clientId = AC.componentNameId AND AC.attrName = 'Office 365 Pseudo Client' AND AC.attrval = 1 AND AC.modified = 0
	--INNER JOIN #tempclientSecurityObjects TT ON TT.clientId = C.id
WHERE SC.appTypeId = 78 AND (BK.status & 0x80000 = 0x80000)
AND (C.status & 0x00002 != 0x00002 /*UNINSTALLED*/
AND C.status & 0x00004 != 0x00004 /*DELETE*/
AND C.status & 0x00020 != 0x00020 /*Hidden*/)
	IF @i_userId!=0
	BEGIN
		DELETE FROM  #tmpOffice365ClientList WHERE clientId NOT IN (SELECT clientId FROM #tempclientSecurityObjects)
	END
	SET @errorCode = @@ERROR
	IF @errorCode != 0
	BEGIN
		GOTO ERROR_EXIT
	END
	DECLARE @clientList table(clientId int, clientName nvarchar(256))
	INSERT INTO @clientList SELECT DISTINCT clientId, clientName FROM #tmpOffice365ClientList
	SET @OutXmlReq = (
						SELECT
							(
								SELECT   clientId as '@clientId', clientName as '@clientName'
								FROM @clientList C
							FOR XML PATH ('pseudoClients'), type
							)
					FOR XML PATH('Ida_GetOffice365SPV2PseudoClientsResp'))
ERROR_EXIT:
    IF @errorCode <> 0
        SET @OutXmlReq = (SELECT ISNULL(@errorCode,0) AS '@errorCode', ISNULL(@errorString,'')
								AS '@errorMessage' FOR XML PATH('Ida_GetOffice365SPV2PseudoClientsResp'))
	IF @OutXmlReq IS NULL
		SET @OutXmlReq = '<Ida_GetOffice365SPV2PseudoClientsResp />'
	SELECT @OutXmlReq
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetOffice365SPV2PseudoClients')
	delete from GxQscripts where name = 'GetOffice365SPV2PseudoClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetOffice365SPV2PseudoClients')
	delete from GXDBVersions where aliasname = 'GetOffice365SPV2PseudoClients'
GO

insert into GXDBVersions values(2, 'GetOffice365SPV2PseudoClients',  '00000000000000000000', 'GetOffice365SPV2PseudoClients', '00000000000000000000')
GO

