

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetOffice365SPV2MemberServer.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2018  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +===================================================================+
--  |		GetOffice365SPV2MemberServer								|
--  |   Procedure to get SharePoint v2 Member Servers					|
--  +===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetOffice365SPV2MemberServer')
BEGIN
	print '>>> Drop Stored Procedure: GetOffice365SPV2MemberServer <<<'
	drop procedure GetOffice365SPV2MemberServer
END
IF EXISTS (select * from GxQscripts where name='GetOffice365SPV2MemberServer')
	delete from GxQscripts where name = 'GetOffice365SPV2MemberServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetOffice365SPV2MemberServer')
	delete from GXDBVersions where aliasname = 'GetOffice365SPV2MemberServer'
GO
print '... Creating Procedure: GetOffice365SPV2MemberServer'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetOffice365SPV2MemberServer
-----------------------------------------------------------
---    PARAMETERS                         ---
  @inXmlReq XML,
  @inUserId INT = 0
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
    DECLARE @errorCode              INT = 0
    DECLARE @errorString            NVARCHAR(MAX) = ''
	DECLARE @i_userId				INT = 0
	DECLARE @ClientId				INT = 0
	DECLARE @OutXmlReq				XML = NULL
	DECLARE @getOnlyMemberServers	INT = 0
	SET @getOnlyMemberServers =  @inXmlReq.exist('/Ida_GetOffice365SPV2MemberServerReq')
	IF @getOnlyMemberServers = 1
	BEGIN
		SET @i_userId = ISNULL((select @inXmlReq.value('(Ida_GetOffice365SPV2MemberServerReq/processinginstructioninfo/user/@userId)[1]', 'INT')), 0)
		SET @ClientId = ISNULL((select @inXmlReq.value('(Ida_GetOffice365SPV2MemberServerReq/@clientId)[1]', 'INT')), 0)
	END
	ELSE
	BEGIN
	SET @ClientId = ISNULL((SELECT  ref.value('@clientId', 'INTEGER')
      FROM    @inXmlReq.nodes('entity') R ( ref )),0)
	SET @i_userId = @inUserId
	END
	IF OBJECT_ID('tempdb.dbo.#tmpOffice365SPMemberServerList') IS NOT NULL
		DROP TABLE #tmpOffice365SPMemberServerList
	CREATE TABLE #tmpOffice365SPMemberServerList ( clientId INT , clientName NVARCHAR(255))
	CREATE CLUSTERED INDEX #tmpOffice365SPMemberServerList_clientId_Idx1 ON #tmpOffice365SPMemberServerList (clientId)
	DECLARE @disableUseProxyCheck INT = 0
SET @disableUseProxyCheck = ISNULL((SELECT CAST(value AS INT) FROM GxGlobalParam WHERE name = 'DisableUseProxyCheck'),0)
	DECLARE @tmpMemberserverXML XML = CAST(REPLACE(( SELECT AP.attrVal
									FROM APP_IDAName (NOLOCK) AI
									INNER JOIN APP_IDAProp (NOLOCK) AP ON AP.componentNameId = AI.id
									WHERE AI.clientId = @ClientId AND AP.attrName = 'Sharepoint Member Servers' AND AP.modified = 0 AND AP.attrType = 1
									),'encoding="UTF-8"','encoding="UTF-16"') AS XML)
	IF @tmpMemberserverXML IS NULL
	BEGIN
		SET @errorString = 'Sharepoint Member Servers, property doesnt present in App_IDAProp'
		SET @errorCode = 1
	    GOTO ERROR_EXIT
	END
	DECLARE @XMLMemberList table(clientId int, clientName nvarchar(MAX))
	INSERT INTO @XMLMemberList (clientId, clientName)
		SELECT
			ISNULL(NA.value('@clientId','INT'),0) clientId,
			ISNULL(NA.value('@clientName','NVARCHAR(MAX)'),'') clientName
		FROM @tmpMemberserverXML.nodes('App_MemberServers/memberServers') I(MA)
		CROSS APPLY MA.nodes('./client') M(NA)
	SET @errorCode = @@ERROR
	IF @errorCode != 0
	BEGIN
		GOTO ERROR_EXIT
	END
	DECLARE @XMLClientGroupList table(clientGroupId int, clientGroupName nvarchar(MAX))
	INSERT INTO @XMLClientGroupList (clientGroupId, clientGroupName)
		SELECT
			ISNULL(NA.value('@clientGroupId','INT'),0) clientGroupId,
			ISNULL(NA.value('@clientGroupName','NVARCHAR(MAX)'),'') clientGroupName
		FROM @tmpMemberserverXML.nodes('App_MemberServers/memberServers') I(MA)
		CROSS APPLY MA.nodes('./client') M(NA)
	SET @errorCode = @@ERROR
	IF @errorCode != 0
	BEGIN
		GOTO ERROR_EXIT
	END
	DELETE FROM @XMLMemberList where clientId = 0 OR clientName IS NULL OR clientName = ''
	DELETE FROM @XMLClientGroupList where clientGroupId = 0 OR clientGroupName IS NULL OR clientGroupName = ''
	INSERT INTO #tmpOffice365SPMemberServerList (clientId,clientName)
	SELECT DISTINCT CA.clientId,CA.clientName
	FROM
	(
		SELECT XM.clientId,XM.clientName
		FROM @XMLMemberList XM
		INNER JOIN APP_Client AC (NOLOCK) ON AC.id = XM.clientId AND AC.name = XM.clientName
INNER JOIN simInstalledPackages SP (NOLOCK) ON SP.ClientId = AC.id AND SP.simPackageID IN (734, 101)
WHERE	AC.status &  0x00002 != 0x00002 /*UNINSTALLED*/
AND AC.status & 0x00004 != 0x00004 /*DELETE*/
AND AC.status  & 0x00020 != 0x00020 /*Hidden*/
		UNION
		SELECT AC.id,AC.name
		FROM @XMLClientGroupList XG
		INNER JOIN APP_ClientGroup CG (NOLOCK) ON XG.clientGroupId = CG.id
		JOIN APP_ClientGroupAssoc CGA (NOLOCK) ON CGA.clientGroupId = CG.id
		JOIN APP_Client AC (NOLOCK) ON AC.id = CGA.clientId
JOIN simInstalledPackages SP (NOLOCK) ON SP.ClientId = AC.id AND SP.simPackageID IN (734, 101)
WHERE AC.status &  0x00002 != 0x00002 /*UNINSTALLED*/
AND AC.status & 0x00004 != 0x00004 /*DELETE*/
AND AC.status  & 0x00020 != 0x00020 /*Hidden*/
	)CA
	SET @errorCode = @@ERROR
	IF @errorCode != 0
	BEGIN
		GOTO ERROR_EXIT
	END
	DECLARE @MemberServersTable TABLE (clientId INT,clientName NVARCHAR(255))
	IF @disableUseProxyCheck = 1
	BEGIN
		INSERT INTO @MemberServersTable (clientId,clientName)
		SELECT MS.clientId,MS.clientName
			FROM #tmpOffice365SPMemberServerList MS
	END
	IF @disableUseProxyCheck != 1
	BEGIN
		DECLARE @ownersTable TABLE (userId INT)
        DECLARE @expandOwners INT = 1
		IF @i_userId!=0
		BEGIN
			INSERT INTO @ownersTable (userId) VALUES (@i_userId)
		END
		ELSE
		BEGIN
			INSERT INTO @ownersTable
			SELECT userId FROM sec_getClientOwnersWithParam(@ClientId,0,@expandOwners)
				WHERE userId != 0 AND clientId = @ClientId
		END
IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_InputTable') IS NOT NULL DROP TABLE #getPermissionsOnEntities_InputTable CREATE TABLE #getPermissionsOnEntities_InputTable ( entityId1 INT, entityId2 INT DEFAULT 0, entityId3 INT DEFAULT 0, entityId4 INT DEFAULT 0, entityId5 INT DEFAULT 0 ) IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_OutputTable') IS NOT NULL DROP TABLE #getPermissionsOnEntities_OutputTable CREATE TABLE #getPermissionsOnEntities_OutputTable ( entityId1 INT, entityId2 INT, entityId3 INT, entityId4 INT, entityId5 INT, permissionsString VARCHAR(512), isChildRow BIT DEFAULT 0	        )
		INSERT INTO #getPermissionsOnEntities_InputTable (entityId1, entityId2, entityId3, entityId4, entityId5)
					SELECT ClientId, 0, 0, 0,0 FROM #tmpOffice365SPMemberServerList
		DECLARE @currOwnerId INT = 0
		DECLARE ownerCursor CURSOR FOR SELECT userId FROM @ownersTable
		OPEN ownerCursor
		FETCH NEXT FROM ownerCursor INTO @currOwnerId
		WHILE @@FETCH_STATUS = 0
		BEGIN
EXEC sec_getPermissionsOnEntities @currOwnerId, 3
			DELETE FROM #getPermissionsOnEntities_OutputTable
WHERE (SUBSTRING(permissionsString,252,1) != CAST(1 AS NVARCHAR(1))) AND
(SUBSTRING(permissionsString,2,1) != CAST(1 AS NVARCHAR(1)))
			IF EXISTS(SELECT entityId1 FROM #getPermissionsOnEntities_OutputTable INTERSECT SELECT clientId FROM  #tmpOffice365SPMemberServerList)
			BEGIN
				DELETE FROM #tmpOffice365SPMemberServerList
	               WHERE clientId NOT IN (SELECT entityId1 from #getPermissionsOnEntities_OutputTable)
				BREAK
			END
			FETCH NEXT FROM ownerCursor INTO @currOwnerId
		END
		CLOSE ownerCursor
        DEALLOCATE ownerCursor
	END
	SET @errorCode = @@ERROR
	IF @errorCode != 0
	BEGIN
		GOTO ERROR_EXIT
	END
	IF @getOnlyMemberServers = 1
	SET @OutXmlReq = (
						SELECT
							(
								SELECT TT.clientId AS '@clientId', TT.clientName AS '@clientName'
								FROM #tmpOffice365SPMemberServerList TT
								--INNER JOIN #tempclientSecurityObjects TS ON TS.clientId = TT.clientId
								FOR XML PATH('memberServers'), TYPE
							)
						FOR XML PATH('Ida_GetOffice365SPV2MemberServerResp')
					)
	ELSE
	SET @OutXmlReq = (SELECT
				(SELECT
                        IP.attrval AS '@mediaAgentId',
                        C.displayName AS '@mediaAgentName',
                        11 as '@_type_'
                        FROM  APP_IDAName N (NOLOCK)
                        JOIN APP_IDAProp IP (NOLOCK) ON IP.componentNameId = N.id AND IP.attrName = 'Sharepoint Index Server' AND IP.modified = 0
                        JOIN APP_CLIENT C (NOLOCK) ON  CAST(IP.attrval AS INT) = C.id
                        WHERE N.clientId = @ClientId
                        FOR XML PATH('indexServer') , TYPE),
						(SELECT @tmpMemberserverXML.query('/App_MemberServers/*')
                        FOR XML PATH('spMemberServers'), TYPE)
              FOR XML PATH ('sharepointPseudoClientProperties'),TYPE)
ERROR_EXIT:
	IF OBJECT_ID('tempdb.dbo.#tmpOffice365SPMemberServerList') IS NOT NULL  DROP TABLE #tmpOffice365SPMemberServerList
    IF LEN(@errorString) > 0
        SET @OutXmlReq = (SELECT ISNULL(@errorCode,0) AS '@errorCode', ISNULL(@errorString,'')
								AS '@errorMessage' FOR XML PATH('Ida_GetOffice365SPV2MemberServerResp'))
	IF @OutXmlReq IS NULL
		SET @OutXmlReq = '<Ida_GetOffice365SPV2MemberServerResp />'
	SELECT @OutXmlReq
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetOffice365SPV2MemberServer')
	delete from GxQscripts where name = 'GetOffice365SPV2MemberServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetOffice365SPV2MemberServer')
	delete from GXDBVersions where aliasname = 'GetOffice365SPV2MemberServer'
GO

insert into GXDBVersions values(2, 'GetOffice365SPV2MemberServer',  '00000000000000000000', 'GetOffice365SPV2MemberServer', '00000000000000000000')
GO

