

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetOffice365SLA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2018  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +===================================================================+
--  |   GetOffice365SLA                                   |
--  |   Procedure to get Office365 SLA       |
--  +===================================================================+
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetOffice365SLA.sp,v $ $Id: GetOffice365SLA.sp,v 1.1.8.3.20.1 2021/02/26 05:21:10 nuppu Exp $"
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='GetOffice365SLA')
BEGIN
	print '>>> Drop Stored Procedure: GetOffice365SLA <<<'
	drop procedure GetOffice365SLA
END
IF EXISTS (select * from GxQscripts where name='GetOffice365SLA')
	delete from GxQscripts where name = 'GetOffice365SLA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetOffice365SLA')
	delete from GXDBVersions where aliasname = 'GetOffice365SLA'
GO
print '... Creating Procedure: GetOffice365SLA'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure GetOffice365SLA
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS                         ---
  @inOutXmlReq XML OUTPUT
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
	DECLARE @errorCode              INT = 0
    DECLARE @errorString            NVARCHAR(1024) = ''
	DECLARE @i_companyId		INT = 0
	DECLARE @i_backupsetId		INT = 0
	DECLARE	@i_appType		INT = 0
	DECLARE	@i_numberOfDays 	INT = 0
	DECLARE @i_mode			INT = 0	--	0: ALL SLA Numbers Of given Company.	 1: Total users of given backupset.
							--2: SLA-not-Met Users of given backupset. 3: Meet-SLA Users of given backupset.
	DECLARE @DISCOVERTYPE_USER                                                  INT = 1
    DECLARE @DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES                       INT = 6
    DECLARE @DISCOVERTYPE_TEAM                                                  INT = 12
    DECLARE @DISCOVERTYPE_DYNAMICS_365_ENTITY                                   INT = 14
		SET @i_companyId = ISNULL (( SELECT ref.value('@companyId', 'INT')
								FROM @inOutXmlReq.nodes ('/App_GetOffice365SLA') R(ref)),0)
		SET @i_mode = ISNULL (( SELECT ref.value('@mode', 'INT')
								FROM @inOutXmlReq.nodes ('/App_GetOffice365SLA') R(ref)),0)
		SET @i_backupsetId = ISNULL (( SELECT ref.value('@backupsetId', 'INT')
								FROM @inOutXmlReq.nodes ('/App_GetOffice365SLA') R(ref)),0)
		SET @i_appType = ISNULL (( SELECT ref.value('@appType', 'INT')
								FROM @inOutXmlReq.nodes ('/App_GetOffice365SLA') R(ref)),0)
		SET @i_numberOfDays = ISNULL (( SELECT ref.value('@numberOfDays', 'INT')
								FROM @inOutXmlReq.nodes ('/App_GetOffice365SLA') R(ref)),0)
		IF @i_numberOfDays = 0 SET @i_numberOfDays = 1 --default ref time is 1 day\24 hrs
		--Temp office365 SLA Clients
		IF OBJECT_ID('tempdb.dbo.#SLAClients') IS NOT NULL DROP TABLE #SLAClients
		Create table #SLAClients (clientId INT,  clientName NVARCHAR(80),  backupsetId INT, subclientid INT, agent  INT, instanceType INT,
		lastArchiveJobRunTime INT DEFAULT 0, TotalUsers INT DEFAULT 0, UsersNotMetSLA INT DEFAULT 0, UsersMetSLA INT DEFAULT 0)
		IF OBJECT_ID('tempdb.dbo.#ExSLAClients') IS NOT NULL DROP TABLE #ExSLAClients
		Create table #ExSLAClients (clientId INT, backupsetId INT, TotalUsers INT DEFAULT 0, UsersNotMetSLA INT DEFAULT 0, UsersMetSLA INT DEFAULT 0)
		IF OBJECT_ID ('tempdb.dbo.#tmpApplication') IS NOT NULL   DROP TABLE #tmpApplication
		CREATE TABLE #tmpApplication (id INT, clientId INT, instance INT, appTypeId INT);
		IF OBJECT_ID('tempdb.dbo.#SpSLAClients') IS NOT NULL DROP TABLE #SpSLAClients
		Create table #SpSLAClients (clientId INT, clientName  NVARCHAR(80), backupsetId INT, subclientId INT, lastArchTime INT DEFAULT 0)
		IF OBJECT_ID('tempdb.dbo.#cloudAppClients') IS NOT NULL DROP TABLE #cloudAppClients
        Create table #cloudAppClients (clientId INT, subclientid INT, instanceType INT, backupsetId INT, TotalUsers INT DEFAULT 0, UsersNotMetSLA INT DEFAULT 0, UsersMetSLA INT DEFAULT 0)
		CREATE CLUSTERED INDEX cloudAppClients_Index  On #cloudAppClients(subclientid)
		IF OBJECT_ID('tempdb.dbo.#SpV2Clients') IS NOT NULL DROP TABLE #SpV2Clients
        Create table #SpV2Clients (clientId INT, subclientId INT,  backupsetId INT, TotalUsers INT DEFAULT 0, UsersNotMetSLA INT DEFAULT 0, UsersMetSLA INT DEFAULT 0)
		CREATE CLUSTERED INDEX spV2Clients_Index  On #SpV2Clients(subclientId)
	BEGIN TRY
		DECLARE @spSLA TABLE (clientId INT, backupsetId INT, TotalSubclients INT DEFAULT 0 , SCsNotMetSLA INT DEFAULT 0, SCsMetSLA INT DEFAULT 0 )
		DECLARE @defaultRefTime INT = dbo.getunixtime(dateadd(hour,-@i_numberOfDays*24,getutcdate()))
		IF @i_mode = 0
		BEGIN
			--Get clients That belong to Input CompanyId
			DECLARE @OrgClients table (clientId INT)
			INSERT INTO @OrgClients (clientId)
			SELECT ACGA.clientId FROM APP_ClientGroupAssoc ACGA WITH(NOLOCK)
			INNER JOIN App_CompanyProp ACP WITH(NOLOCK) ON
			ACP.attrValInt=ACGA.clientGroupId AND ACP.attrName='Associated Smart Client Group' AND ACP.componentNameId=@i_companyId AND ACP.modified=0 AND ACP.cs_attrName = checksum('Associated Smart Client Group')
			--If there are no clients in the Company, Exit.
			IF NOT EXISTS (SELECT TOP 1 clientId FROM @OrgClients) GOTO ERROR_EXIT
			--Get V2 clients
			DECLARE @V2Clients TABLE (clientid INT)
			INSERT INTO @V2Clients
			SELECT CP.componentNameid
			FROM @OrgClients O
			JOIN App_Clientprop CP (NOLOCK) ON CP.componentNameId = O.clientId
			WHERE CP.attrname = 'Office 365 Pseudo Client' AND CP.attrVal = 1 AND Cp.modified = 0
			--Get OneDrive clients, backupsets and subclients  of given company
			INSERT INTO #SLAClients (clientId ,  clientName , backupsetId , subclientid , agent , instanceType )
			SELECT C.id, C.name, A.backupSet, A.id , A.appTypeId, 0
			FROM APP_Client C (NOLOCK)
			JOIN @OrgClients O ON O.clientId = C.id
			JOIN APP_Application A (NOLOCK) ON A.clientId = C.id
WHERE A.appTypeId = 134 AND O.clientId = A.clientid 	AND A.clientId NOT in (SELECT clientId FROM @V2Clients)
			--Sharepoint backupset Security
 	   		DECLARE @tenantAdminGroupId INT = 0
		    	IF OBJECT_ID('tempdb.dbo.#tempSharepointSecurityObjects') IS NOT Null DROP TABLE #tempSharepointSecurityObjects
create table  #tempSharepointSecurityObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
SELECT @tenantAdminGroupId=UG.id FROM UMGroups UG where UG.groupFlags&0x10000 <> 0 and UG.umdsProviderId=@i_companyId
            		DECLARE @tenantAdminId INT = ISNULL((SELECT TOP 1 userId FROM UMUserGroup WHERE groupId=@tenantAdminGroupId),0)
            		IF(@tenantAdminId > 0) -- This procedure will raise an error if the userId was 0.
            		BEGIN
                    		EXEC sec_getUserObjects @tenantAdminId, 2013, 0, '#tempSharepointSecurityObjects'
            		END
			--get Sharepoint O365 Backupsets of given Company
			INSERT INTO #SpSLAClients(clientId ,  clientName , backupsetId , subclientid)
			SELECT C.id, C.name, BK.id, SC.id
			FROM APP_Application SC (NOLOCK)
			INNER JOIN APP_Client(NOLOCK) C ON C.id = SC.clientId
			INNER JOIN APP_BackupSetName(NOLOCK) BK ON SC.backupSet = BK.id
WHERE  SC.appTypeId = 78 AND (SC.subclientStatus & 0x00004 != 0x00004)
AND SC.appTypeId = 78
AND (BK.status & 0x80000 = 0x80000)
			AND C.id NOT in (SELECT clientId FROM @V2Clients)
			AND  BK.id IN (SELECT DISTINCT backupsetId  FROM #tempSharepointSecurityObjects
WHERE (capabilities & CONVERT(bigint, (POWER(2.0, 13  -1))) <> 0 )
AND (capabilities & CONVERT(bigint, (POWER(2.0, 20  -1))) <> 0 )
AND (capabilities & CONVERT(bigint, (POWER(2.0,  22  -1))) <> 0 ))
			--Get all Exchange V2 clients of given Company
			INSERT INTO #ExSLAClients (clientId)
			SELECT distinct O.clientId
			FROM @OrgClients O
			JOIN @V2Clients V ON V.clientid = O.clientId
			JOIN APP_EmailConfigPolicyAssoc A (NOLOCK) ON A.clientId = V.clientId
			WHERE A.smtpAdrress IS NOT NULL AND (A.mailBoxType = 1 OR A.mailBoxType = 2 OR A.mailBoxType = 3) AND A.modified = 0
			--Get Sharepoint V2 clients for given company
			INSERT INTO #SpV2Clients (clientId, subclientId)
            SELECT distinct O.clientId, A.subClientId
            FROM @OrgClients O
            JOIN @V2Clients V ON V.clientid = O.clientId
			JOIN App_Application APP (NOLOCK) ON APP.clientId = V.clientId
            JOIN APP_CloudAppUserDetails A (NOLOCK) ON A.subclientId = APP.id
WHERE APP.appTypeId = 78 AND App.subclientStatus & 0x02 != 0x02 /*UNINSTALLED*/ AND App.subclientStatus & 0x04 != 0x04 /*DELETED*/ AND App.subclientStatus & 0x00020 != 0x00020 /*HIDDEN*/
			--Get all CloudApp clients of V2 for given Company
            INSERT INTO #cloudAppClients (clientId, subclientId, instanceType)
            SELECT distinct O.clientId, A.subclientId, CAST(prop.attrVal AS INT)
            FROM @OrgClients O
            JOIN @V2Clients V ON V.clientid = O.clientId
			JOIN App_Application APP (NOLOCK) ON APP.clientId = V.clientId
            JOIN APP_CloudAppUserDetails A (NOLOCK) ON A.subclientId = APP.id
			JOIN APP_InstanceProp Prop (NOLOCK) ON APP.instance = Prop.componentNameId AND prop.attrName = 'Cloud Apps Instance Type'
WHERE APP.appTypeId = 134 AND App.subclientStatus & 0x02 != 0x02 /*UNINSTALLED*/ AND App.subclientStatus & 0x04 != 0x04 /*DELETED*/ AND App.subclientStatus & 0x00020 != 0x00020 /*HIDDEN*/  AND LEN(prop.attrVal) > 0
			--Share point V1 SLA are counted in terms of Number of Subclients, whereas OneDrive V1 and Exchange V2 SLA are counted in terms of Number of Users.
			IF EXISTS (SELECT TOP 1 * FROM #SpSLAClients)
			BEGIN
				 --Update last archive Job run time per subclient
				UPDATE #SpSLAClients
				SET lastArchTime =  ISNULL(( SELECT JT.lastJobTime
				FROM
				(	SELECT MAX(J.servendDate) as lastJobTime , J.appId as  scId
					FROM  #SpSLAClients T
					JOIN JMBkpStats (NOLOCK) J ON J.appId = T.subclientId AND J.status in (1/*JMSUCCESS*/, 3/*PARTIALSUCCESS*/, 14/*JMSUCCESSWITHWARNINGS*/)
					GROUP BY J.appId
				) JT
				WHERE subclientId = JT.scId ), 0)
				-- Total Subclients of Sharepoint per client & backupset
				INSERT INTO @spSLA (clientId, backupsetId) SELECT Distinct clientId, backupsetId from #SpSLAClients
				Update @spSLA
				SET TotalSubclients = ISNULL( SpSubclients, 0)
				FROM @spSLA A
				INNER JOIN
				(
					SELECT clientId, backupsetId,  COUNT(DISTINCT subclientId) as SpSubclients
					FROm #SpSLAClients
					Group BY clientId, backupsetId
				) B On B.clientId = A.clientId AND B.backupsetId = A.backupsetId
				--Number of Subclients Not Met SLA
				Update @spSLA
				SET SCsNotMetSLA = ISNULL(spNotMet, 0)
				FROM 			@spSLA A
				INNER JOIN
				(
					SELECT clientId, backupsetid, COUNT(DISTINCT subclientId) as spNotMet
					FROM #SpSLAClients
					WHERE lastArchTime < @defaultRefTime
					GROUP BY clientId, backupsetId
				)B On B.clientId = A.clientId AND B.backupsetId = A.backupsetId
				--Number of Subclients Meet SLA
				Update @spSLA
				SET SCsMetSLA = ISNULL(spMet, 0)
				FROM 			@spSLA A
				INNER JOIN
				(
					SELECT clientId, backupsetid, COUNT(DISTINCT subclientId) as spMet
					FROM #SpSLAClients
					WHERE lastArchTime >= @defaultRefTime
					GROUP BY clientId, backupsetId
				)B On B.clientId = A.clientId AND B.backupsetId = A.backupsetId
			END
IF EXISTS (SELECT TOP 1 * FROM #SLAClients WHERE agent = 134)
			BEGIN
			--OneDrive Subclients
			INSERT INTO #tmpApplication
			 SELECT APP.id, APP.clientId, APP.instance, APP.appTypeId
			 FROM APP_Application APP (NOLOCK)
			 JOIN #SLAClients S ON S.clientId = APP.clientId
			 JOIN APP_InstanceProp Prop (NOLOCK) ON APP.instance = Prop.componentNameId AND prop.attrName = 'Cloud Apps Instance Type'
WHERE APP.appTypeId = 134 AND App.subclientStatus & 0x02 != 0x02 /*UNINSTALLED*/ AND App.subclientStatus & 0x04 != 0x04 /*DELETED*/ AND App.subclientStatus & 0x00020 != 0x00020 /*HIDDEN*/
			 AND LEN(prop.attrVal) > 0  AND prop.attrVal = '7'   /*OneDrive Instance Type */
			 --Update instanceType for onedrive V1
			 UPDATE #SLAClients SET instanceType = 7 FROM #tmpApplication WHERE #tmpApplication.clientId = #SLAClients.clientId
				 --Update last archive Job run time per subclient
				UPDATE #SLAClients
				SET lastArchiveJobRunTime =  ISNULL(( SELECT JT.lastJobTime
				FROM
				(	SELECT MAX(J.servendDate) as lastJobTime , J.appId as  scId
					FROM  #tmpApplication T
					JOIN JMBkpStats (NOLOCK) J ON J.appId = T.id AND J.status in (1/*JMSUCCESS*/, 3/*PARTIALSUCCESS*/, 14/*JMSUCCESSWITHWARNINGS*/)
					GROUP BY J.appId
				) JT
				WHERE subclientId = JT.scId ), 0)
				--Update Total Users of OneDrive V1
				Update #SLAClients
				SET TotalUsers = B.OdTotalUsers
				FROm #SLAClients A
				INNER JOIN
				(	SELECT SP.componentNameId as subclientId, count(DISTINCT(SP.attrName)) AS OdTotalUsers
					FROM APP_SubclientProp (NOLOCK) SP
					JOIN #tmpApplication T ON T.id = SP.componentNameId
WHERE T.appTypeId = 134 AND  SP.attrType = 134 /*PROPERTY_CLOUD_APPS*/ AND SP.modified = 0 AND LEN(SP.attrName) > 0
					GROUP BY Sp.componentNameId
				)B ON A.subclientid = B.subclientId
				--OneDrive SLA not met, based on refTime. reftime < default 24 hrs
				Update #SLAClients
				SET UsersNotMetSLA = TotalUsers
where agent = 134 AND lastArchiveJobRunTime < @defaultRefTime
				-- OneDrive SLA met. reftime >= default 24 hrs
				Update #SLAClients
				SET UsersMetSLA = TotalUsers
where agent = 134 AND lastArchiveJobRunTime >= @defaultRefTime
			END
			IF EXISTS (SELECT TOP 1 * FROM #ExSLAClients)
			BEGIN
				--Update Total Users of Exchange V2
				UPDATE #ExSLAClients
				SET TotalUsers = B.ExTotalUsers
				FROM #ExSLAClients A
				INNER JOIN
				(	SELECT clientId, COUNT(DISTINCT(smtpAdrress)) AS ExTotalUsers
					FROM APP_EmailConfigPolicyAssoc A (NOLOCK)
					WHERE A.smtpAdrress IS NOT NULL AND A.modified = 0 AND (A.mailboxType = 1 OR A.mailBoxType = 2 OR A.mailBoxType = 3)
					GROUP BY A.clientId
				) B  ON A.clientId= B.clientId
				--Exchange V2 SLA Not Met
				UPDATE #ExSLAClients
				SET UsersNotMetSLA = B.ExNotMetSLA
				FROM #ExSLAClients A
				INNER JOIN
				(	SELECT clientId, COUNT(DISTINCT(smtpAdrress)) AS ExNotMetSLA
					FROM APP_EmailConfigPolicyAssoc A (NOLOCK)
					WHERE  A.smtpAdrress IS NOT NULL AND A.modified = 0 AND (A.mailboxType = 1 OR A.mailBoxType = 2 OR A.mailBoxType = 3)
					AND  (A.backupReferenceTime IS NULL OR A.backupReferenceTime < @defaultRefTime)
					GROUP BY clientId
				) B  ON A.clientId= B.clientId
				--Exchange V2 SLA Met
				UPDATE #ExSLAClients
				SET UsersMetSLA = B.ExMetSLA
				FROM #ExSLAClients A
				INNER JOIN
				(	SELECT clientId, COUNT(DISTINCT(smtpAdrress)) AS ExMetSLA
					FROM APP_EmailConfigPolicyAssoc A (NOLOCK)
					WHERE A.smtpAdrress IS NOT NULL AND  A.modified = 0 AND (A.mailboxType = 1 OR A.mailBoxType = 2 OR A.mailBoxType = 3)
					AND  A.backupReferenceTime >= @defaultRefTime
					GROUP BY clientId
				) B  ON A.clientId = B.clientId
			END
			IF EXISTS (SELECT TOP 1 * FROM #CloudAppClients)
            BEGIN
                --Update Total Users
                UPDATE #CloudAppClients
                SET TotalUsers = B.ExTotalUsers
                FROM #CloudAppClients A
                INNER JOIN
                (   SELECT App.clientId, COUNT(DISTINCT(A.smtpAddress)) AS ExTotalUsers
                    FROM APP_CloudAppUserDetails A (NOLOCK)
					JOIN #CloudAppClients APP (NOLOCK) On APP.subclientId  = A.subclientId
                    WHERE A.smtpAddress IS NOT NULL AND A.modified = 0 AND (A.discoverByType = @DISCOVERTYPE_USER OR A.discoverByType = @DISCOVERTYPE_TEAM OR A.discoverByType = @DISCOVERTYPE_DYNAMICS_365_ENTITY)
                    GROUP BY APP.clientId
                ) B  ON A.clientId= B.clientId
                --SLA Not Met
                UPDATE #CloudAppClients
                SET UsersNotMetSLA = B.ExNotMetSLA
                FROM #CloudAppClients A
                INNER JOIN
                (   SELECT App.clientId, COUNT(DISTINCT(A.smtpAddress)) AS ExNotMetSLA
                    FROM APP_CloudAppUserDetails A (NOLOCK)
					JOIN #CloudAppClients APP (NOLOCK) On APP.subClientId = A.subclientId
                    WHERE  A.smtpAddress IS NOT NULL AND A.modified = 0 AND (A.discoverByType = @DISCOVERTYPE_USER OR A.discoverByType = @DISCOVERTYPE_TEAM OR A.discoverByType = @DISCOVERTYPE_DYNAMICS_365_ENTITY)
                    AND  (A.backupReferenceTime IS NULL OR A.backupReferenceTime < @defaultRefTime)
                    GROUP BY clientId
                ) B  ON A.clientId= B.clientId
                --V2 SLA Met
                UPDATE #CloudAppClients
                SET UsersMetSLA = B.ExMetSLA
                FROM #CloudAppClients A
                INNER JOIN
                (   SELECT App.clientId, COUNT(DISTINCT(A.smtpAddress)) AS ExMetSLA
                    FROM APP_CloudAppUserDetails A (NOLOCK)
					JOIN #CloudAppClients APP (NOLOCK) On APP.subClientId = A.subclientId
                    WHERE A.smtpAddress IS NOT NULL AND  A.modified = 0 AND (A.discoverByType = @DISCOVERTYPE_USER OR A.discoverByType = @DISCOVERTYPE_TEAM OR A.discoverByType = @DISCOVERTYPE_DYNAMICS_365_ENTITY)
                    AND  A.backupReferenceTime >= @defaultRefTime
                    GROUP BY clientId
                ) B  ON A.clientId = B.clientId
            END
			IF EXISTS (SELECT TOP 1 * FROM #SpV2Clients)
            BEGIN
                --Update Total Users
                UPDATE #SpV2Clients
                SET TotalUsers = B.ExTotalUsers
                FROM #SpV2Clients A
                INNER JOIN
                (   SELECT App.clientId, COUNT(DISTINCT(A.smtpAddress)) AS ExTotalUsers
                    FROM APP_CloudAppUserDetails A (NOLOCK)
					JOIN #SpV2Clients APP (NOLOCK) On APP.subclientId  = A.subclientId
                    WHERE A.smtpAddress IS NOT NULL AND A.modified = 0 AND A.discoverByType = @DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES
                    GROUP BY APP.clientId
                ) B  ON A.clientId= B.clientId
                --SLA Not Met
                UPDATE #SpV2Clients
                SET UsersNotMetSLA = B.ExNotMetSLA
                FROM #SpV2Clients A
                INNER JOIN
                (   SELECT App.clientId, COUNT(DISTINCT(smtpAddress)) AS ExNotMetSLA
                    FROM APP_CloudAppUserDetails A (NOLOCK)
					JOIN #SpV2Clients APP (NOLOCK) On APP.subClientId = A.subclientId
                    WHERE  A.smtpAddress IS NOT NULL AND A.modified = 0 AND A.discoverByType = @DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES
                    AND  (A.backupReferenceTime IS NULL OR A.backupReferenceTime < @defaultRefTime)
                    GROUP BY clientId
                ) B  ON A.clientId= B.clientId
                --V2 SLA Met
                UPDATE #SpV2Clients
                SET UsersMetSLA = B.ExMetSLA
                FROM #SpV2Clients A
                INNER JOIN
                (   SELECT App.clientId, COUNT(DISTINCT(smtpAddress)) AS ExMetSLA
                    FROM APP_CloudAppUserDetails A (NOLOCK)
					JOIN #SpV2Clients APP (NOLOCK) On APP.subClientId = A.subclientId
                    WHERE A.smtpAddress IS NOT NULL AND  A.modified = 0 AND A.discoverByType = @DISCOVERTYPE_ASSOCIATED_SHAREPOINT_WEB_SITES
                    AND  A.backupReferenceTime >= @defaultRefTime
                    GROUP BY clientId
                ) B  ON A.clientId = B.clientId
            END
			--Consolidate SLA's of Exch, oneDrive
			DECLARE @SLAFinal TABLE (clientId INT, clientName NVARCHAR(80), backupsetId INT , agent INT, TotalUsers INT, UsersNotMetSLA INT, UsersMetSLA INT, instanceType INT)
				INSERT INTO @SLAFinal
				SELECT clientId, clientName, backupsetId, agent, SUM(TotalUsers), SUM(UsersNotMetSLA), SUM(UsersMetSLA), 7 /*OneDrive*/ FROM #SLAClients
				GROUP BY clientId, clientName, backupsetId, agent
				INSERT INTO @SLAFinal
SELECT clientId, C.name, backupsetId, 137, TotalUsers, UsersNotMetSLA, UsersMetSLA, 0 FROM #ExSLAClients E
				JOIN App_Client C (NOLOCK) ON C.id = E.clientId
				INSERT INTO @SLAFinal
SELECT clientId, C.name, backupsetId, 134, TotalUsers, UsersNotMetSLA, UsersMetSLA, instanceType FROM #cloudAppClients A
                JOIN App_Client C (NOLOCK) ON C.id = A.clientId
				INSERT INTO @SLAFinal
SELECT clientId, C.name, backupsetId, 78, TotalUsers, UsersNotMetSLA, UsersMetSLA,0 FROM #SpV2Clients A
                JOIN App_Client C (NOLOCK) ON C.id = A.clientId
			SET @inOutXmlReq = (SELECT
								(SELECT  clientId as '@clientId', clientName as '@clientName', backupsetId as '@backupsetId', agent as '@appType',
									TotalUsers as '@totalUsers', UsersNotMetSLA as '@needAttention',	UsersMetSLA as '@meetSLA', instanceType as '@instanceType'
									FROM @SLAFinal F
									FOR XML PATH ('o365SLA'), TYPE),
(SELECT clientId as '@clientId', C.name as '@clientName', backupsetId as '@backupsetId', 78 as '@appType',
									TotalSubclients as '@totalSubclients', SCsNotMetSLA as '@needAttention', SCsMetSLA as '@meetSLA'
									FROM @spSLA	A
									JOIN App_Client C (NOLOCK) ON C.id = A.clientId
									FOR XML PATH ('o365SLA'), TYPE)
								FOR XML PATH('App_GetOffice365SLAResp'))
		END
		IF @i_mode > 0
		BEGIN
		--Get all subclients of input backupset
		DECLARE @tmpSubclients TABLE(id INT, lastArchTime INT DEFAULT 0)
		INSERT INTO @tmpSubclients
		SELECT distinct id , 0
		FROM APP_Application A (NOLOCK)
		WHERE backupset = @i_backupsetId
		DECLARE @Content TABLE(users NVARCHAR(MAX))
		--Get list of all Users of given backupset
			IF @i_mode = 1
			BEGIN
IF @i_appType = 134
					INSERT INTO @content SELECT DISTINCT(SP.attrName)
					FROM APP_SubclientProp (NOLOCK) SP	JOIN @tmpSubclients T ON T.id = SP.componentNameId
					WHERE SP.attrType = 134 /*PROPERTY_CLOUD_APPS*/ AND SP.modified = 0 AND LEN(SP.attrName) > 0
ELSE IF @i_appType = 78
					INSERT INTO @content SELECT S.fileName
					FROM App_scFilterFile (NOLOCK) S
					JOIN @tmpSubclients T ON T.id = S.componentNameId
					WHERE  S.type = 21 AND S.modified = 0
ELSE IF @i_appType = 137
					INSERT INTO @content SELECT DISTINCT smtpadrress
					FROM APP_EmailConfigPolicyAssoc (NOLOCK) A JOIN @tmpSubclients T ON T.id = A.subClientId
					WHERE A.smtpAdrress IS NOT NULL AND A.modified = 0 AND A.mailBoxType IN (1, 2, 3)
			END
			--get list of Users need attention for given backupset
			IF @i_mode = 2
			BEGIN
IF @i_appType IN (134, 78)
				BEGIN
					UPDATE @tmpSubclients
					SET lastArchTime =  ISNULL(( SELECT JT.lastJobTime
					FROM
					(	SELECT MAX(J.servendDate) as lastJobTime , J.appId as  scId
						FROM  @tmpSubclients T
						JOIN JMBkpStats (NOLOCK) J ON J.appId = T.id AND J.status in (1/*JMSUCCESS*/, 3/*PARTIALSUCCESS*/, 14/*JMSUCCESSWITHWARNINGS*/)
						GROUP BY J.appId
					) JT
					WHERE id = JT.scId ), 0)
IF @i_appType = 134
					INSERT INTO @content SELECT DISTINCT(SP.attrName)
						FROM APP_SubclientProp (NOLOCK) SP	JOIN @tmpSubclients T ON T.id = SP.componentNameId
						WHERE T.lastArchTime < @defaultRefTime AND  SP.attrType = 134 /*PROPERTY_CLOUD_APPS*/ AND SP.modified = 0 AND LEN(SP.attrName) > 0
ELSE IF @i_appType = 78
					INSERT INTO @content SELECT S.fileName
						FROM App_ScFilterFile (NOLOCK) S	JOIN @tmpSubclients T ON T.id = S.componentNameId
						WHERE T.lastArchTime < @defaultRefTime AND  S.type = 21 /*Sharepoint Content*/ AND S.modified = 0
				END
ELSE IF @i_appType = 137
					INSERT INTO @content SELECT DISTINCT smtpadrress
					FROM APP_EmailConfigPolicyAssoc (NOLOCK) A JOIN @tmpSubclients T ON T.id = A.subClientId
					WHERE (A.backupReferenceTime IS NULL OR A.backupReferenceTime < @defaultRefTime) AND A.smtpAdrress IS NOT NULL AND A.modified = 0 AND A.mailBoxType IN (1, 2, 3)
			END
			--get list of Users meet SLA for given backupset
			IF @i_mode = 3
			BEGIN
IF @i_appType IN (134, 78)
				BEGIN
					UPDATE @tmpSubclients
					SET lastArchTime =  ISNULL(( SELECT JT.lastJobTime
					FROM
					(	SELECT MAX(J.servendDate) as lastJobTime , J.appId as  scId
						FROM  @tmpSubclients T
						JOIN JMBkpStats (NOLOCK) J ON J.appId = T.id AND J.status in (1/*JMSUCCESS*/, 3/*PARTIALSUCCESS*/, 14/*JMSUCCESSWITHWARNINGS*/)
						GROUP BY J.appId
					) JT
					WHERE id = JT.scId ), 0)
IF @i_appType = 134
						INSERT INTO @content SELECT DISTINCT(SP.attrName)
						FROM APP_SubclientProp (NOLOCK) SP	JOIN @tmpSubclients T ON T.id = SP.componentNameId
						WHERE T.lastArchTime >= @defaultRefTime AND  SP.attrType = 134 /*PROPERTY_CLOUD_APPS*/ AND SP.modified = 0 AND LEN(SP.attrName) > 0
ELSE IF @i_appType = 78
						INSERT INTO @content SELECT S.fileName
						FROM App_ScFilterFile (NOLOCK) S	JOIN @tmpSubclients T ON T.id = S.componentNameId
						WHERE T.lastArchTime >= @defaultRefTime AND  S.type = 21 /*Sharepoint Content*/ AND S.modified = 0
				END
ELSE IF @i_appType = 137
					INSERT INTO @content SELECT DISTINCT smtpadrress
					FROM APP_EmailConfigPolicyAssoc (NOLOCK) A JOIN @tmpSubclients T ON T.id = A.subClientId
					WHERE (A.backupReferenceTime IS NOT NULL AND A.backupReferenceTime >= @defaultRefTime) AND A.smtpAdrress IS NOT NULL AND A.modified = 0 AND A.mailBoxType IN (1, 2, 3)
			END
			SET @inOutXmlReq =(SELECT (SELECT  users as '@val'
				FROM @Content FOR XML PATH ('content'), TYPE)
				FOR XML PATH('App_GetOffice365SLAResp'), TYPE)
		END
END TRY
    BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
        SELECT @errorCode = ERROR_NUMBER(), @errorString = ERROR_MESSAGE()
    END CATCH
ERROR_EXIT:
	IF OBJECT_ID('tempdb.dbo.#SLAClients') IS NOT NULL DROP TABLE #SLAClients
	IF OBJECT_ID('tempdb.dbo.#ExSLAClients') IS NOT NULL DROP TABLE #ExSLAClients
	IF OBJECT_ID ('tempdb.dbo.#tmpApplication ') IS NOT NULL   DROP TABLE #tmpApplication
	IF OBJECT_ID('tempdb.dbo.#SpSLAClients') IS NOT NULL DROP TABLE #SpSLAClients
	IF OBJECT_ID('tempdb.dbo.#tempSharepointSecurityObjects') IS NOT Null DROP TABLE #tempSharepointSecurityObjects
	IF OBJECT_ID('tempdb.dbo.#cloudAppClients') IS NOT NULL DROP TABLE #cloudAppClients
	IF OBJECT_ID('tempdb.dbo.#SpV2Clients') IS NOT NULL DROP TABLE #SpV2Clients
    IF @errorCode <> 0
        SET @inOutXmlReq = (SELECT ISNULL(@errorCode,0) AS '@errorCode', ISNULL(@errorString,'')
                                AS '@errorMessage' FOR XML PATH('App_GetOffice365SLAResp'))
    SELECT @inOutXmlReq
END
SET NOCOUNT OFF

IF EXISTS (select * from GxQscripts where name = 'GetOffice365SLA')
	delete from GxQscripts where name = 'GetOffice365SLA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetOffice365SLA')
	delete from GXDBVersions where aliasname = 'GetOffice365SLA'
GO

insert into GXDBVersions values(2, 'GetOffice365SLA',  'v1.1.8.3.20.1', 'GetOffice365SLA', 'v1.1.8.3.20.1')
GO

