

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetOffice365OneDriveV2MemberServer.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2018  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
--  +===================================================================+
--  |		GetOffice365OneDriveV2MemberServer								|
--  |   Procedure to get OneDrive v2 Member Servers					|
--  +===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetOffice365OneDriveV2MemberServer')
BEGIN
	print '>>> Drop Stored Procedure: GetOffice365OneDriveV2MemberServer <<<'
	drop procedure GetOffice365OneDriveV2MemberServer
END
IF EXISTS (select * from GxQscripts where name='GetOffice365OneDriveV2MemberServer')
	delete from GxQscripts where name = 'GetOffice365OneDriveV2MemberServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetOffice365OneDriveV2MemberServer')
	delete from GXDBVersions where aliasname = 'GetOffice365OneDriveV2MemberServer'
GO
print '... Creating Procedure: GetOffice365OneDriveV2MemberServer'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetOffice365OneDriveV2MemberServer
-----------------------------------------------------------
---    PARAMETERS                         ---
  @inXmlReq XML
-----------------------------------------------------------
AS
SET NOCOUNT ON
BEGIN
    DECLARE @errorCode              INT = 0
    DECLARE @errorString            NVARCHAR(MAX) = ''
	DECLARE @i_userId				INT = 0
	DECLARE @ClientId				INT = 0
	DECLARE @OutXmlReq				XML = NULL
DECLARE @PkgId					INT = 730
	SET @i_userId = ISNULL((select @inXmlReq.value('(Ida_GetOffice365OneDriveV2MemberServerReq/processinginstructioninfo/user/@userId)[1]', 'INT')), 0)
	SET @ClientId = ISNULL((select @inXmlReq.value('(Ida_GetOffice365OneDriveV2MemberServerReq/@clientId)[1]', 'INT')), 0)
	IF OBJECT_ID('tempdb.dbo.#tmpOffice365SPMemberServerList') IS NOT NULL
		DROP TABLE #tmpOffice365SPMemberServerList
	CREATE TABLE #tmpOffice365SPMemberServerList ( clientId INT , clientName NVARCHAR(255))
	CREATE CLUSTERED INDEX #tmpOffice365SPMemberServerList_clientId_Idx1 ON #tmpOffice365SPMemberServerList (clientId)
	DECLARE @disableUseProxyCheck INT = 0
SET @disableUseProxyCheck = ISNULL((SELECT CAST(value AS INT) FROM GxGlobalParam WHERE name = 'DisableUseProxyCheck'),0)
	DECLARE @tmpMemberserverXML XML = CAST(REPLACE(( SELECT TOP 1 IP.attrVal
									FROM APP_InstanceProp IP
JOIN APP_Application AA ON AA.instance = IP.componentNameId AND (AA.subclientStatus & 0x00002 != 0x00002 /*UNINSTALLED*/ AND AA.subclientStatus &  0x00004 !=  0x00004 /*DELETE*/ AND AA.subclientStatus & 0x00020 != 0x00020 /*Hidden*/)
									WHERE AA.clientId = @ClientId AND IP.attrName = 'Proxy Clients' AND IP.modified = 0 AND IP.attrType = 1
									),'encoding="UTF-8"','encoding="UTF-16"') AS XML)
	IF @tmpMemberserverXML IS NULL
	BEGIN
		SET @errorString = 'OneDrive V2 Proxy Client, property doesnt present in App_InstanceProp'
		SET @errorCode = 1
	    GOTO ERROR_EXIT
	END
	IF EXISTS(SELECT TOP 1 1 from APP_ClientProp where componentNameId=@ClientId and attrName = 'Office 365 Pseudo Client' and attrVal = 1 and modified = 0)
	 BEGIN
SET @PkgId = 734
	 END
	DECLARE @XMLMemberList table(clientId int, clientName nvarchar(MAX))
	INSERT INTO @XMLMemberList (clientId, clientName)
		SELECT
			ISNULL(NA.value('@clientId','INT'),0) clientId,
			ISNULL(NA.value('@clientName','NVARCHAR(MAX)'),'') clientName
		FROM @tmpMemberserverXML.nodes('App_GeneralCloudProperties') I(MA)
		CROSS APPLY MA.nodes('./proxyServers') M(NA)
	INSERT INTO @XMLMemberList (clientId, clientName)
		SELECT
			ISNULL(NA.value('@clientId','INT'),0) clientId,
			ISNULL(NA.value('@clientName','NVARCHAR(MAX)'),'') clientName
		FROM @tmpMemberserverXML.nodes('App_GeneralCloudProperties/memberServers') I(MA)
		CROSS APPLY MA.nodes('./client') M(NA)
	SET @errorCode = @@ERROR
	IF @errorCode != 0
	BEGIN
		GOTO ERROR_EXIT
	END
	DECLARE @XMLClientGroupList table(clientGroupId int, clientGroupName nvarchar(MAX))
	INSERT INTO @XMLClientGroupList (clientGroupId, clientGroupName)
		SELECT
			ISNULL(NA.value('@clientGroupId','INT'),0) clientGroupId,
			ISNULL(NA.value('@clientGroupName','NVARCHAR(MAX)'),'') clientGroupName
		FROM @tmpMemberserverXML.nodes('App_GeneralCloudProperties/memberServers') I(MA)
		CROSS APPLY MA.nodes('./client') M(NA)
	SET @errorCode = @@ERROR
	IF @errorCode != 0
	BEGIN
		GOTO ERROR_EXIT
	END
	DELETE FROM @XMLMemberList where clientId = 0 OR clientName IS NULL OR clientName = ''
	DELETE FROM @XMLClientGroupList where clientGroupId = 0 OR clientGroupName IS NULL OR clientGroupName = ''
	INSERT INTO #tmpOffice365SPMemberServerList (clientId,clientName)
	SELECT DISTINCT CA.clientId,CA.clientName
	FROM
	(
		SELECT XM.clientId,XM.clientName
		FROM @XMLMemberList XM
		INNER JOIN APP_Client AC (NOLOCK) ON AC.id = XM.clientId AND AC.name = XM.clientName
		INNER JOIN simInstalledPackages SP (NOLOCK) ON SP.ClientId = AC.id AND SP.simPackageID = @PkgId
WHERE	AC.status &  0x00002 != 0x00002 /*UNINSTALLED*/
AND AC.status & 0x00004 != 0x00004 /*DELETE*/
AND AC.status  & 0x00020 != 0x00020 /*Hidden*/
		UNION
		SELECT AC.id,AC.name
		FROM @XMLClientGroupList XG
		INNER JOIN APP_ClientGroup CG (NOLOCK) ON XG.clientGroupId = CG.id
		JOIN APP_ClientGroupAssoc CGA (NOLOCK) ON CGA.clientGroupId = CG.id
		JOIN APP_Client AC (NOLOCK) ON AC.id = CGA.clientId
		JOIN simInstalledPackages SP (NOLOCK) ON SP.ClientId = AC.id AND SP.simPackageID = @PkgId
WHERE AC.status &  0x00002 != 0x00002 /*UNINSTALLED*/
AND AC.status & 0x00004 != 0x00004 /*DELETE*/
AND AC.status  & 0x00020 != 0x00020 /*Hidden*/
	)CA
	SET @errorCode = @@ERROR
	IF @errorCode != 0
	BEGIN
		GOTO ERROR_EXIT
	END
	DECLARE @MemberServersTable TABLE (clientId INT,clientName NVARCHAR(255))
	IF @disableUseProxyCheck = 1
	BEGIN
		INSERT INTO @MemberServersTable (clientId,clientName)
		SELECT MS.clientId,MS.clientName
			FROM #tmpOffice365SPMemberServerList MS
	END
	IF @disableUseProxyCheck != 1
	BEGIN
		DECLARE @ownersTable TABLE (userId INT)
        DECLARE @expandOwners INT = 1
		IF @i_userId!=0
		BEGIN
			INSERT INTO @ownersTable (userId) VALUES (@i_userId)
		END
		ELSE
		BEGIN
			INSERT INTO @ownersTable
			SELECT userId FROM sec_getClientOwnersWithParam(@ClientId,0,@expandOwners)
				WHERE userId != 0 AND clientId = @ClientId
		END
IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_InputTable') IS NOT NULL DROP TABLE #getPermissionsOnEntities_InputTable CREATE TABLE #getPermissionsOnEntities_InputTable ( entityId1 INT, entityId2 INT DEFAULT 0, entityId3 INT DEFAULT 0, entityId4 INT DEFAULT 0, entityId5 INT DEFAULT 0 ) IF OBJECT_ID('tempdb.dbo.#getPermissionsOnEntities_OutputTable') IS NOT NULL DROP TABLE #getPermissionsOnEntities_OutputTable CREATE TABLE #getPermissionsOnEntities_OutputTable ( entityId1 INT, entityId2 INT, entityId3 INT, entityId4 INT, entityId5 INT, permissionsString VARCHAR(512), isChildRow BIT DEFAULT 0	        )
		INSERT INTO #getPermissionsOnEntities_InputTable (entityId1, entityId2, entityId3, entityId4, entityId5)
					SELECT ClientId, 0, 0, 0,0 FROM #tmpOffice365SPMemberServerList
		DECLARE @currOwnerId INT = 0
		DECLARE ownerCursor CURSOR FOR SELECT userId FROM @ownersTable
		OPEN ownerCursor
		FETCH NEXT FROM ownerCursor INTO @currOwnerId
		WHILE @@FETCH_STATUS = 0
		BEGIN
EXEC sec_getPermissionsOnEntities @currOwnerId, 3
			DELETE FROM #getPermissionsOnEntities_OutputTable
WHERE (SUBSTRING(permissionsString,252,1) != CAST(1 AS NVARCHAR(1))) AND
(SUBSTRING(permissionsString,2,1) != CAST(1 AS NVARCHAR(1)))
			IF EXISTS(SELECT entityId1 FROM #getPermissionsOnEntities_OutputTable INTERSECT SELECT clientId FROM  #tmpOffice365SPMemberServerList)
			BEGIN
				DELETE FROM #tmpOffice365SPMemberServerList
				WHERE clientId NOT IN (SELECT entityId1 from #getPermissionsOnEntities_OutputTable)
				BREAK
			END
			FETCH NEXT FROM ownerCursor INTO @currOwnerId
		END
		CLOSE ownerCursor
        DEALLOCATE ownerCursor
	END
	SET @errorCode = @@ERROR
	IF @errorCode != 0
	BEGIN
		GOTO ERROR_EXIT
	END
	SET @OutXmlReq = (
						SELECT
							(
								SELECT TT.clientId AS '@clientId', TT.clientName AS '@clientName'
								FROM #tmpOffice365SPMemberServerList TT
								FOR XML PATH('memberServers'), TYPE
							),
							(
								SELECT id '@subclientId', subclientName '@subclientName', backupSet as '@backupsetId', instance '@instanceId', clientId AS '@clientId'
								FROM APP_Application
								WHERE clientId = @ClientId
AND subclientStatus & 0x00002 != 0x00002 /*UNINSTALLED*/
AND subclientStatus &  0x00004 !=  0x00004 /*DELETE*/
AND subclientStatus & 0x00020 != 0x00020 /*Hidden*/
								FOR XML PATH('subclientEntity'), TYPE
							)
						FOR XML PATH('Ida_GetOffice365OneDriveV2MemberServerResp')
					)
ERROR_EXIT:
    IF OBJECT_ID('tempdb.dbo.#tmpOffice365SPMemberServerList') IS NOT NULL	DROP TABLE #tmpOffice365SPMemberServerList
	IF LEN(@errorString) > 0
        SET @OutXmlReq = (SELECT ISNULL(@errorCode,0) AS '@errorCode', ISNULL(@errorString,'')
								AS '@errorMessage' FOR XML PATH('Ida_GetOffice365OneDriveV2MemberServerResp'))
	IF @OutXmlReq IS NULL
		SET @OutXmlReq = '<Ida_GetOffice365OneDriveV2MemberServerResp />'
	SELECT @OutXmlReq
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetOffice365OneDriveV2MemberServer')
	delete from GxQscripts where name = 'GetOffice365OneDriveV2MemberServer'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetOffice365OneDriveV2MemberServer')
	delete from GXDBVersions where aliasname = 'GetOffice365OneDriveV2MemberServer'
GO

insert into GXDBVersions values(2, 'GetOffice365OneDriveV2MemberServer',  '00000000000000000000', 'GetOffice365OneDriveV2MemberServer', '00000000000000000000')
GO

