

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetOffice365MemberServers.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='GetOffice365MemberServers')
BEGIN
	print '>>> Drop Stored Procedure: GetOffice365MemberServers <<<'
	drop procedure GetOffice365MemberServers
END
IF EXISTS (select * from GxQscripts where name='GetOffice365MemberServers')
	delete from GxQscripts where name = 'GetOffice365MemberServers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetOffice365MemberServers')
	delete from GXDBVersions where aliasname = 'GetOffice365MemberServers'
GO
print '... Creating Procedure: GetOffice365MemberServers'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure GetOffice365MemberServers
  @userId INT ,
  @i_cloudType INT ,
  @xmlText XML OUTPUT
AS
	DECLARE @isCommcellLevelAssociation INT = 0
	DECLARE @defaultVal INT = 0
	DECLARE @memberServers TABLE
	(
		appType INT,
		version INT,
		clientId INT,
		clientName NVARCHAR(MAX),
		clientType INT
	)
	--Get Security Associations
	IF OBJECT_ID('tempdb.dbo.#getO365MemberClientListTmp') IS NOT null	DROP TABLE #getO365MemberClientListTmp
create table  #getO365MemberClientListTmp ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 2009, 0, '#getO365MemberClientListTmp'
SELECT @isCommcellLevelAssociation=1 from #getO365MemberClientListTmp sec WHERE (sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0)
	-- get Exchange Member servers
	INSERT INTO @memberServers
	SELECT I.appTypeId, R.attrVal, C.id, C.name,
	(CASE I.appTypeId
WHEN 54 THEN 3
	END)
	FROM APP_Client C (NOLOCK)
JOIN APP_IDAName I (NOLOCK) ON C.id = I.clientId AND I.appTypeId = 54
JOIN simInstalledPackages S (NOLOCK) ON I.clientId = S.ClientId AND S.simPackageID = 152
	LEFT OUTER JOIN APP_IDAProp R (NOLOCK) ON R.componentNameId = I.id AND R.attrName ='IDA Version' AND R.modified = 0
WHERE C.status & 0x00002 = 0
AND C.specialClientFlags & 0x2 =0
AND C.releaseId >= 16
	UNION
SELECT 54, @defaultVal, CL.id, CL.name, 3
	FROM APP_Client CL(NOLOCK)
	JOIN simInstalledPackages sim (NOLOCK) ON sim.ClientId = CL.id
	JOIN PatchSPVersion psp (NOLOCK) ON sim.SPVersionID = psp.id
WHERE sim.simPackageID = 151 AND psp.Release >= 16 AND psp.SPMajor >= 12
AND CL.status & 0x00002 = 0	AND CL.specialClientFlags & 0x2 =0
	-- get Sharepoint Member Servers
	INSERT INTO @memberServers
SELECT DISTINCT 78, @defaultVal, C.id, C.name, 3
		FROM APP_Client C (NOLOCK)
INNER JOIN simInstalledPackages S (NOLOCK) ON C.Id = S.ClientId AND S.simPackageID IN (734, 101)
WHERE C.status & 0x00002 = 0 AND C.specialClientFlags & 0x2 =0
	-- get OneDrive& V2CloudApps Member Servers
	INSERT INTO @memberServers
SELECT DISTINCT 134, @defaultVal, C.id, C.name, 3
		FROM APP_Client C (NOLOCK)
INNER JOIN simInstalledPackages S (NOLOCK) ON C.Id = S.ClientId AND S.simPackageID = 734
WHERE C.status & 0x00002 = 0 AND C.specialClientFlags & 0x2 =0
	-- get Azure AD Member Servers
	INSERT INTO @memberServers
SELECT DISTINCT 139, @defaultVal, C.id, C.name, 3
		FROM APP_Client C (NOLOCK)
INNER JOIN simInstalledPackages S (NOLOCK) ON C.Id = S.ClientId AND S.simPackageID = 703
WHERE C.status & 0x00002 = 0 AND C.specialClientFlags & 0x2 =0
	-- get Solr cloud Index Servers
	DECLARE @o_xmlText XML
	 IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
        CREATE TABLE #getIndexServers
            (     serverURL NVARCHAR(512),
                  clientId INT,
                  clientName NVARCHAR(256),
                  cloudId INT,
                  hostName NVARCHAR(256),
                  basePort INT,
                  engineName  NVARCHAR(256),
                  serverType INT,
                  indexServerClientId INT,
                  internalCloudName NVARCHAR(256)
            )
	EXEC DM2GetIndexServers '',0/*i_indexServerClientId*/,0/*i_cloudId*/,0/*i_nodeClientId*/,1/*i_status*/
	IF @isCommcellLevelAssociation = 0
	BEGIN
		--delete all client where this user doesnt have access to
		DELETE FROM @memberServers WHERE clientId NOT IN (SELECT clientId FROM #getO365MemberClientListTmp)
		DELETE FROM #getIndexServers WHERE indexServerClientId NOT IN (SELECT clientId FROM #getO365MemberClientListTmp)
	END
SET @xmlText =
	(	SELECT
		(
			SELECT
			(
				SELECT
				(
				SELECT DISTINCT  appType as '@o365MemberType', version AS '@exchangeVersion', clientId AS 'client/@clientId', clientName AS 'client/@clientName', clientType AS 'client/@_type_'
				FROM	@memberServers
				FOR XML PATH('memberServers'), TYPE)
			FOR XML PATH(''), TYPE)
		),
		(
			SELECT DISTINCT T.indexServerClientId AS '@clientId', T.engineName AS '@clientName',3 AS '@_type_'
			FROM #getIndexServers T
			WHERE T.serverType = @i_cloudType
			FOR XML PATH ('indexServers'),TYPE
		)
		FOR XML PATH(''),
	ROOT('App_GetO365MemberServersResponse')
	)
	IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
	IF OBJECT_ID('tempdb.dbo.#getO365MemberClientListTmp') IS NOT null	DROP TABLE #getO365MemberClientListTmp
	SELECT @xmlText
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetOffice365MemberServers')
	delete from GxQscripts where name = 'GetOffice365MemberServers'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetOffice365MemberServers')
	delete from GXDBVersions where aliasname = 'GetOffice365MemberServers'
GO

insert into GXDBVersions values(2, 'GetOffice365MemberServers',  '00000000000000000000', 'GetOffice365MemberServers', '00000000000000000000')
GO

