

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetOffice365ClientsSLA.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2018  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetOffice365ClientsSLA')
BEGIN
	print '>>> Drop Stored Procedure: GetOffice365ClientsSLA <<<'
	drop procedure GetOffice365ClientsSLA
END
IF EXISTS (select * from GxQscripts where name='GetOffice365ClientsSLA')
	delete from GxQscripts where name = 'GetOffice365ClientsSLA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetOffice365ClientsSLA')
	delete from GXDBVersions where aliasname = 'GetOffice365ClientsSLA'
GO
print '... Creating Procedure: GetOffice365ClientsSLA'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetOffice365ClientsSLA
  @i_numberOfDays INT
AS
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
    /*
        Input/Output table #Office365ClientsSLA
        Table schema #Office365ClientsSLA(clientId INT, backupsetId INT, subclientId INT, appType INT, isOffice365V2Client INT, slaStatus INT, agent INT)
    */
	DECLARE @EXCHANGE_ONLINE           INT = 1
	DECLARE @SHAREPOINT_ONLINE         INT = 2
	DECLARE @ONEDRIVE					INT = 3
	DECLARE @ALL_AGENTS				INT = 4
	DECLARE @D365					INT = 5
	DECLARE @TEAMS					INT = 6
	--V2 CloudApps Instance Types
	DECLARE @ONEDRIVE_Instance INT = 7
	DECLARE @D365_Instance INT = 35
	DECLARE @TEAMS_Instance INT = 36
	/*Set number of days to 3 by default*/
	IF @i_numberOfDays = 0 SET @i_numberOfDays = 3
	/*Set unix reference time*/
	DECLARE @refTime INT = dbo.getunixtime(DATEADD(HOUR, -@i_numberOfDays*24 , GETUTCDATE()))
	BEGIN TRY
		/*If input table is not created, creating a empty table to eliminate errors*/
		IF OBJECT_ID('tempdb.dbo.#Office365ClientsSLA') IS NULL
			CREATE TABLE #Office365ClientsSLA(clientId INT, backupsetId INT, subclientId INT, appType INT, isOffice365V2Client INT, slaStatus INT, agent INT)
		IF NOT EXISTS (SELECT TOP 1 clientId FROM #Office365ClientsSLA)
			GOTO ERROR_EXIT
		/*Insert clients to check sla status (for which the sp has support for)*/
		DECLARE @Clients TABLE (clientId INT, subclientId INT, appType INT, isOffice365V2Client INT, slaStatus INT, UNIQUE CLUSTERED (clientId, subclientId))
		-- Insert Exchange and SharePoint V2 Clients
		INSERT INTO @Clients
		SELECT clientId, subclientId, appType, isOffice365V2Client, slaStatus
		FROM #Office365ClientsSLA
WHERE (appType = 137) OR (appType = 78 AND isOffice365V2Client = 1)
		-- Insert OneDrive V2 Clients
		INSERT INTO @Clients
		SELECT S.clientId, subclientId, appType, isOffice365V2Client, slaStatus
		FROM #Office365ClientsSLA S
		INNER JOIN App_Application(NOLOCK) AA ON S.subclientId = AA.id
		INNER JOIN APP_InstanceProp(NOLOCK) AI ON AA.instance = AI.componentNameId
WHERE S.appType = 134 AND S.isOffice365V2Client = 1
		AND AI.attrName = 'Cloud Apps Instance Type' AND (AA.subclientStatus&8=8)
		AND AI.attrVal  = (CASE WHEN S.agent = @ONEDRIVE THEN @ONEDRIVE_Instance
											WHEN S.agent = @D365 THEN @D365_Instance
											WHEN S.agent = @TEAMS  THEN @TEAMS_Instance END)
		IF NOT EXISTS (SELECT TOP 1 clientId FROM @Clients)
			GOTO ERROR_EXIT
		/*Get subclient entities (mailboxes/users/sites) which have not met sla*/
		IF OBJECT_ID('tempdb.dbo.#SLANotMetEntities') IS NOT NULL
			DROP TABLE #SLANotMetEntities
		CREATE TABLE #SLANotMetEntities (smtpAddress NVARCHAR(255), subclientId INT)
		CREATE CLUSTERED INDEX #Idx_SLANotMetEntities_smtp_subclientId ON #SLANotMetEntities(smtpAddress, subclientId)
		-- Insert Exchange users
		INSERT INTO #SLANotMetEntities (smtpAddress, subclientId)
		SELECT smtpAdrress, subClientId
		FROM APP_EmailConfigPolicyAssoc(NOLOCK)
WHERE subClientId IN (SELECT subclientId FROM @Clients WHERE appType = 137)
		AND status = 0/*Active*/ AND discoverByType = 1 /*Exchange DiscoverType Mailboxes*/ AND modified = 0 AND smtpAdrress IS NOT NULL
		AND (backupReferenceTime IS NULL OR backupReferenceTime < @refTime)
		-- Insert SharePoint V2 sites
		INSERT INTO #SLANotMetEntities (smtpAddress, subclientId)
		SELECT smtpAddress, subclientId
		FROM App_CloudAppUserDetails(NOLOCK)
WHERE subclientId IN (SELECT subclientId FROM @Clients WHERE appType = 78 AND isOffice365V2Client = 1)
		AND (flags&2=0) AND status = 0/*Active*/ AND discoverByType = 6 /*SharePoint DiscoverType Associated WebSites*/ AND modified = 0 AND smtpAddress IS NOT NULL
		AND (backupReferenceTime IS NULL OR backupReferenceTime < @refTime)
		-- Insert OneDrive V2 users  ,  D365 Entities and Teams
		INSERT INTO #SLANotMetEntities (smtpAddress, subclientId)
		SELECT smtpAddress, subclientId
		FROM App_CloudAppUserDetails(NOLOCK)
WHERE subclientId IN (SELECT subclientId FROM @Clients WHERE appType  = 134 AND isOffice365V2Client = 1)
		AND status = 0/*Active*/ AND discoverByType IN (1 /*OneDrive DiscoverType Users*/, 12 /*D365 Entity*/, 14 /*Teams*/) AND modified = 0 AND smtpAddress IS NOT NULL
		AND (backupReferenceTime IS NULL OR backupReferenceTime < @refTime)
		/*Get xml data per job of every subclient in the last n days*/
		IF OBJECT_ID('tempdb.dbo.#SLAJobEntities') IS NOT NULL
			DROP TABLE #SLAJobEntities
		CREATE TABLE #SLAJobEntities (subclientId INT, jobId INT, data XML)
		INSERT INTO #SLAJobEntities (subclientId, jobId, data)
		SELECT appId, JS.jobId, JM.data
		FROM JMBkpStats(NOLOCK) JS
		INNER JOIN JMMisc(NOLOCK) JM ON JS.jobId = JM.jobId AND (JS.servStartDate > @refTime)
		WHERE JS.appId IN (SELECT subclientId FROM @Clients)
		AND JS.opType = 4 /*Backup*/ AND itemType = 28
		/*Get subclient entities which are skipped in the last n days*/
		IF OBJECT_ID('tempdb.dbo.#SLASkippedEntities') IS NOT NULL
			DROP TABLE #SLASkippedEntities
		CREATE TABLE #SLASkippedEntities (smtpAddress NVARCHAR(255), subclientId INT, jobId INT)
		CREATE CLUSTERED INDEX #Idx_SLASkippedEntites_smtp_subclientId ON #SLASkippedEntities(smtpAddress, subclientId)
		INSERT INTO #SLASkippedEntities (smtpAddress, subclientId, jobId)
		SELECT M.NA.value('@SMTP', 'NVARCHAR(MAX)'), subclientId, jobId
		FROM #SLAJobEntities
		CROSS APPLY data.nodes('./JobManager_ExchMbJobInfo/SourceMailboxStats') M(NA)
		WHERE M.NA.value('@status', 'INT') = 2 /*Skipped*/ AND M.NA.value('@SMTP', 'NVARCHAR(MAX)') <> '' /*Exclude Exchange PST*/
		/*Filter duplicate skipped entities*/
		DELETE dup FROM
		(SELECT ROW_NUMBER() OVER (PARTITION BY smtpAddress, subclientId ORDER BY jobId DESC) cnt FROM #SLASkippedEntities) dup
		WHERE dup.cnt > 1
		/*Delete skipped entities from sla not met entities*/
		DELETE #SLANotMetEntities
		FROM #SLANotMetEntities N INNER JOIN #SLASkippedEntities S ON N.smtpAddress = S.smtpAddress AND N.subclientId = S.subclientId
		/*Update sla status for clients*/
		UPDATE @Clients
		SET slaStatus = (CASE WHEN subclientId IN (SELECT DISTINCT subclientId FROM #SLANotMetEntities) THEN 2 /*SLA Missed*/ ELSE 1 /*SLA Met*/ END)
		/*Update input/output table*/
		UPDATE #Office365ClientsSLA
		SET slaStatus = C.slaStatus
		FROM #Office365ClientsSLA S
		LEFT JOIN @Clients C ON S.subclientId = C.subclientId
	END TRY
	BEGIN CATCH
		GOTO ERROR_EXIT
	END CATCH
	ERROR_EXIT:
		IF OBJECT_ID('tempdb.dbo.#SLANotMetEntities') IS NOT NULL
			DROP TABLE #SLANotMetEntities
		IF OBJECT_ID('tempdb.dbo.#SLAJobEntities') IS NOT NULL
			DROP TABLE #SLAJobEntities
		IF OBJECT_ID('tempdb.dbo.#SLASkippedEntities') IS NOT NULL
			DROP TABLE #SLASkippedEntities
GO

IF EXISTS (select * from GxQscripts where name = 'GetOffice365ClientsSLA')
	delete from GxQscripts where name = 'GetOffice365ClientsSLA'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetOffice365ClientsSLA')
	delete from GXDBVersions where aliasname = 'GetOffice365ClientsSLA'
GO

insert into GXDBVersions values(2, 'GetOffice365ClientsSLA',  '00000000000000000000', 'GetOffice365ClientsSLA', '00000000000000000000')
GO

