

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetNonIDAObjectsGraph_Wrapper.sp] ---------- 

-- 	+-----------------------------------------------------------------------------------------------------------------------------------+
--	| 	Procedure : "GetNonIDAObjectsGraph_Wrapper.sp"
--	|	Description:
--	|	This sp is used to invoke a CLR function defined in C#, which would make a REST call to graph DB.
--	|	The graph DB would compute the permissions for the intended user which was previously taken care in sec_getNonIdaObjectsForUser.
--	|	The returned results would be in form of xml, where it may have nodes containing the ida objects or a flag indicating user has permissions on all entities of given type
--	|	Author: suraj shankar
-- 	+-----------------------------------------------------------------------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetNonIDAObjectsGraph_Wrapper')
BEGIN
	print '>>> Drop Stored Procedure: GetNonIDAObjectsGraph_Wrapper <<<'
	drop procedure GetNonIDAObjectsGraph_Wrapper
END
IF EXISTS (select * from GxQscripts where name='GetNonIDAObjectsGraph_Wrapper')
	delete from GxQscripts where name = 'GetNonIDAObjectsGraph_Wrapper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetNonIDAObjectsGraph_Wrapper')
	delete from GXDBVersions where aliasname = 'GetNonIDAObjectsGraph_Wrapper'
GO
print '... Creating Procedure: GetNonIDAObjectsGraph_Wrapper'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetNonIDAObjectsGraph_Wrapper
--Inputs
  @userId INT,
  @entityTypeReq INT,			
  @permissionId INT,
  @tableOutput NVARCHAR(MAX) = '',
  @includeNotMappedPermission INT = 0,
  @honorParentAssociations INT = 1
AS
DECLARE @returnVal NVARCHAR(MAX), @x XML,@isAllAssoc INT = 0
DECLARE @permissions VARCHAR(MAX)
BEGIN
		IF @userId = 0
				RETURN
		IF @permissionID = -1
		BEGIN
			BEGIN
			IF OBJECT_ID('tempdb.dbo.#getNonIdaObjects_InputPermissionsTbl') IS NULL
				BEGIN
					RAISERROR ('#getNonIdaObjects_InputPermissionsTbl not passed as input to sec_getNonIdaObjectsForThisUser.',16,1)
					RETURN
			END
			ELSE
				BEGIN
					SELECT @permissions = COALESCE(@permissions + ',', '') + CAST(iPermissionId AS VARCHAR)
					FROM   #getNonIdaObjects_InputPermissionsTbl
				END
			END
		END
		ELSE
			BEGIN
				select @permissions = convert(nvarchar(max),@permissionId)
			END
END
exec getNonIdaObjectsForUser_GraphAPI @userId,@entityTypeReq,@permissions,@honorParentAssociations,@includeNotMappedPermission,@returnVal OUTPUT
SET @x = (SELECT CAST(REPLACE(@returnVal,'UTF-8','UTF-16') AS XML))
set @isAllAssoc = (select t.c.value('(@permissionsOnAllEntities)[1]','int') as allassoc from @x.nodes('/apis_NonIDAEntityResult') t(c))
IF @isAllAssoc = 1
	BEGIN
		DECLARE @idColName VARCHAR(128) = ''
				,@tableName VARCHAR(128) = ''
				,@whereClause VARCHAR(512) = ''
				,@entityFlags INT = 0
		SELECT @idColName = idColName, @tableName = tableName, @whereClause = whereClause, @entityFlags = flags
		FROM APP_Entity
		WHERE
			entityType = @entityTypeReq
		IF @whereClause = ''
			SET @whereClause = '1=1'
		IF (@idColName <> '') AND (@tableName <> '') AND @whereClause <> ''
		BEGIN
				DECLARE @outputstatement nvarchar(max) = 'insert into ' +@tableOutput
				SET @outputStatement += ' SELECT '+ @idColName +' FROM '+ @tableName +' WHERE '+ @whereClause
		END
		EXEC (@outputStatement)
	END
ELSE
	BEGIN
		IF OBJECT_ID('tempdb.dbo.#graphTempOutput') is not null
			drop table #graphTempOutput
		create table #graphTempOutput (id1 int)
		insert into #graphTempOutput select t.c.value('(@val)[1]','int') as id1 from  @x.nodes('/apis_NonIDAEntityResult/entityIds') t(c)
		declare @stmt nvarchar(max) = 'insert into ' +@tableOutput + ' select * from #graphTempOutput'
		exec (@stmt)
	END
GO

IF EXISTS (select * from GxQscripts where name = 'GetNonIDAObjectsGraph_Wrapper')
	delete from GxQscripts where name = 'GetNonIDAObjectsGraph_Wrapper'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetNonIDAObjectsGraph_Wrapper')
	delete from GXDBVersions where aliasname = 'GetNonIDAObjectsGraph_Wrapper'
GO

insert into GXDBVersions values(2, 'GetNonIDAObjectsGraph_Wrapper',  '00000000000000000000', 'GetNonIDAObjectsGraph_Wrapper', '00000000000000000000')
GO

