

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetNextEmptyVMS.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetNextEmptyVMS.sp,v $ $Id: GetNextEmptyVMS.sp,v 1.8.304.2 2018/03/20 19:56:38 jiechen Exp $";
--
--  +========================================================================+
--  | Stored Precedure: GetNextEmptyVMS()
--  |
--  | Description:  Run the media movement rule to return a list of media.
--  |
--  |	    Input:  integer i_commcellId, i_policyId, i_ruleId
--  |
--  |
--  |      Return:  Return code and error string.
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  |   1.0        awang    Initial Edit
--  +========================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetNextEmptyVMS <<<'

IF EXISTS (select * from sysobjects where name='GetNextEmptyVMS')
	drop procedure GetNextEmptyVMS
IF EXISTS (select * from GxQscripts where name='GetNextEmptyVMS')
	delete from GxQscripts where name = 'GetNextEmptyVMS'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetNextEmptyVMS')
	delete from GXDBVersions where aliasname = 'GetNextEmptyVMS'
GO
print '... Creating Procedure: GetNextEmptyVMS'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetNextEmptyVMS
  @i_libraryId INTEGER,
  @i_mediaId INTEGER
AS
  DECLARE @r_retFlag integer;
  DECLARE @r_retString char(255);
  DECLARE @r_availVMSSlotId integer;
  DECLARE @r_availVMSSlotName char(255);
  DECLARE @r_availVMSElementAddress integer;
  DECLARE @r_mediaIdToMove integer;
  DECLARE @r_mediaToSlotId integer;
  DECLARE @r_mediaToSlotName char(255);
  DECLARE @r_mediaToElementAddress integer;
SET NOCOUNT ON
	DECLARE @startVMS 	integer
	DECLARE @libraryId 	integer
	DECLARE @mediaLocation integer
	DECLARE @retFlag 	integer
DECLARE @retString 	varchar(255)
	DECLARE @vmsSlotId 	integer
	DECLARE @startVMSSlotId 	integer
DECLARE @vmsSlot 	varchar(32)
	DECLARE @vmsElementAddress integer
	DECLARE @slotId 	integer
	DECLARE @mediaId 	integer
	DECLARE @vmsDirection 	integer
	DECLARE @bayId 	integer
	DECLARE @actualLibraryId 	integer
	DECLARE @MediaIdtoMove 	integer
	DECLARE @MediaToSlotId 	integer
DECLARE @MediaToSlotName 	varchar(32)
	DECLARE @MediaToElementAddress integer
	DECLARE @MediaPresent 	integer
	DECLARE @maxSlotId1 	integer
	DECLARE @maxSlotId2 	integer
	DECLARE @minSlotId1 	integer
	DECLARE @minSlotId2 	integer
	SET @vmsSlot = ''
	SET @vmsElementAddress = 0
	SET @vmsSlotId = 0
	SET @startVMSSlotId = 0
	SET @slotId = 0
	SET @retFlag = 0
	SET @retString = ''
	SET @libraryId = @i_libraryId
	SET @mediaId = @i_mediaId
	SET @MediaIdtoMove = 0
	SET @MediaToSlotId = 0
	SET @MediaToSlotName = ''
	SET @MediaToElementAddress = 0
	SET @MediaPresent = 0
	SELECT @startVMS = isnull(StartVMSElementAddress, 0)
	FROM	MMLibrary
	WHERE	LibraryId = @libraryId
	SELECT	@actualLibraryId = LibraryId, @mediaLocation = MediaLocation
	FROM	MMMedia
	WHERE	MediaId = @mediaId
	SELECT	@slotId = isnull(SlotId, 0)
	FROM	MMSlot
	WHERE	MediaId = @mediaId
	IF @actualLibraryId != @libraryId
	OR @mediaLocation = 3
	BEGIN
		SET	@retFlag = -1
		SET	@retString = 'Media is outside or in wrong library'
	END
	ELSE
	BEGIN
	IF	@slotId = 0
	BEGIN
		SET	@retFlag = -1
		SET	@retString = 'Media is not in slot'
	END
	ELSE
	BEGIN
		IF	@startVMS != 0
		BEGIN
			SELECT	@startVMSSlotId = a.SlotId, @vmsDirection = b.VMSDirection, @bayId = a.BayId
			FROM	MMSlot a, MMLibrary b, MMBay c
			WHERE	a.BayId = c.BayId
			AND		c.LibraryId = b.LibraryId
			AND		b.StartVMSElementAddress = a.ElementAddress
			AND		b.LibraryId = @libraryId
			AND		a.SlotType = 1
			IF EXISTS ( select * from sysobjects where name='#availSlots1' )
 				drop table #availSlots1
			IF EXISTS ( select * from sysobjects where name='#availSlots2' )
 				drop table #availSlots2
			CREATE TABLE #availSlots1 (ID INT IDENTITY(1, 1), SlotId INT, MediaId INT, IsOccupied INT)
			CREATE TABLE #availSlots2 (ID INT IDENTITY(1, 1), SlotId INT, MediaId INT, IsOccupied INT)
IF @vmsDirection = 1
			BEGIN
				INSERT INTO #availSlots1
				SELECT SlotId, MediaId, IsOccupied
				FROM	MMSlot
				WHERE SlotId >= @startVMSSlotId
				AND	BayId = @bayId
				AND SlotType = 1
				ORDER BY SlotId ASC
				INSERT INTO #availSlots2
				SELECT SlotId, MediaId, IsOccupied
				FROM	MMSlot
				WHERE SlotId < @startVMSSlotId
				AND	BayId = @bayId
				AND SlotType = 1
				ORDER BY SlotId DESC
			END
IF @vmsDirection = 2
			BEGIN
				INSERT INTO #availSlots1
				SELECT SlotId, MediaId, IsOccupied
				FROM	MMSlot
				WHERE SlotId <= @startVMSSlotId
				AND	BayId = @bayId
				AND SlotType = 1
				ORDER BY SlotId DESC
				INSERT INTO #availSlots2
				SELECT SlotId, MediaId, IsOccupied
				FROM	MMSlot
				WHERE SlotId > @startVMSSlotId
				AND	BayId = @bayId
				AND SlotType = 1
				ORDER BY SlotId ASC
			END
			DELETE FROM #availSlots1
			WHERE MediaId > 0
			AND	MediaId IN (	SELECT MediaId
								FROM MMMedia
								WHERE LibraryId = @libraryId
								AND MediaLocation = 1
AND	 (Attributes & 1 > 0)
					   )
			AND	MediaId != @mediaId
			DELETE FROM #availSlots2
			WHERE MediaId > 0
			AND	MediaId IN (	SELECT MediaId
								FROM MMMedia
								WHERE LibraryId = @libraryId
								AND MediaLocation = 1
AND	 (Attributes & 1 > 0)
					   )
			AND	MediaId != @mediaId
			SELECT 	@maxSlotId1 = ISNULL(MAX(ID), 0) FROM #availSlots1
			SELECT 	@maxSlotId2 = ISNULL(MAX(ID), 0) FROM #availSlots2
			SELECT 	@minSlotId1 = ISNULL(MIN(ID), 0) FROM #availSlots1
			SELECT 	@minSlotId2 = ISNULL(MIN(ID), 0) FROM #availSlots2
			IF	@minSlotId1 != 0
			BEGIN
				SELECT	@vmsSlotId = s.SlotId, @vmsSlot = s.SlotName, @vmsElementAddress = s.ElementAddress, @MediaIdtoMove = s.MediaId, @MediaPresent = s.IsOccupied
				FROM	MMSlot s, #availSlots1 a
				WHERE	s.SlotId = a.SlotId
				AND 	a.ID = @minSlotId1
				AND		s.SlotType = 1
			END
			ELSE
			BEGIN
				IF @maxSlotId2 != 0
				BEGIN
					SELECT	@vmsSlotId = s.SlotId, @vmsSlot = s.SlotName,  @vmsElementAddress = s.ElementAddress, @MediaIdtoMove = s.MediaId, @MediaPresent = s.IsOccupied
					FROM	MMSlot s, #availSlots1 a
					WHERE	s.SlotId = a.SlotId
					AND 	a.ID = @maxSlotId2
					AND		s.SlotType = 1
				END
			END
			IF	@MediaIdtoMove = @mediaId
			BEGIN
				SET	@MediaIdtoMove = 0
				SET	@vmsSlotId = 0
				SET	@vmsSlot = ''
				SET @vmsElementAddress = 0
				SET	@MediaPresent = 0
			END
			IF	@MediaIdtoMove != 0 OR @MediaPresent != 0
			BEGIN
				SELECT 	@maxSlotId1 = ISNULL(MAX(ID), 0)
				FROM #availSlots1
				WHERE	IsOccupied = 0
				SELECT 	@maxSlotId2 = ISNULL(MAX(ID), 0)
				FROM #availSlots2
				WHERE	IsOccupied = 0
				IF @maxSlotId1 > @maxSlotId2
				BEGIN
					SELECT	@MediaToSlotId = s.SlotId, @MediaToSlotName = s.SlotName, @MediaToElementAddress = s.ElementAddress
					FROM	MMSlot s, #availSlots1 a
					WHERE	s.SlotId = a.SlotId
					AND 	a.ID = @maxSlotId1
					AND		s.SlotType = 1
				END
				ELSE
				BEGIN
					SELECT	@MediaToSlotId = s.SlotId, @MediaToSlotName = s.SlotName, @MediaToElementAddress = s.ElementAddress
					FROM	MMSlot s, #availSlots2 a
					WHERE	s.SlotId = a.SlotId
					AND 	a.ID = @maxSlotId2
					AND		s.SlotType = 1
				END
			END
			DROP TABLE #availSlots1
			DROP TABLE #availSlots2
		END
		ELSE
		BEGIN
			SET	@retFlag = -1
			SET	@retString = 'Virtual mailslot is not set'
		END
	END
	END
	SELECT	@retFlag, @retString, @vmsSlotId, @vmsSlot,  @vmsElementAddress, @MediaIdtoMove, @MediaToSlotId, @MediaToSlotName, @MediaToElementAddress
--  	:INTO  r_retFlag, r_retString, r_vmsSlotId, r_vmsSlot, r_vmsElementAddress, r_MediaIdtoMove, r_MediaToSlotId, r_MediaToSlotName, r_MediaToElementAddress	--skip for mssql7--
--  	return r_retFlag, r_retString, r_vmsSlotId, r_vmsSlot, r_vmsElementAddress, r_MediaIdtoMove, r_MediaToSlotId, r_MediaToSlotName, r_MediaToElementAddress	--skip for mssql7--
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetNextEmptyVMS')
	delete from GxQscripts where name = 'GetNextEmptyVMS'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetNextEmptyVMS')
	delete from GXDBVersions where aliasname = 'GetNextEmptyVMS'
GO

insert into GXDBVersions values(2, 'GetNextEmptyVMS',  '00010008030400020000', 'GetNextEmptyVMS', '00010008030400020000')
GO

