

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetMediaContents.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetMediaContents.sp,v $ $Id: GetMediaContents.sp,v 1.80.32.11 2020/08/24 14:15:26 pnara Exp $";
-- 	+-----------------------------------------------------------------------+
--	| 			PROCEDURE: "GetMediaContents"								|
--	|																		|
--	|This procedure is used for View Contents of a media or mount path and  |
--	|used for Media Properties -> Data on Media.							|
--	|																		|
--	|This procedure returns information for backup jobs in the given media  |
--	|or mount path including all succeeded, failed, killed or active jobs   |
--	|and no matter jobs are aged or not. It also returns the total size of  |
--	|chunks on each side of media. It tells whether the media is needed for |
--	|auxiliary copy and when the media can be recycled.						|
-- 	+-----------------------------------------------------------------------+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetMediaContents')
BEGIN
	print '>>> Drop Stored Procedure: GetMediaContents <<<'
	drop procedure GetMediaContents
END
IF EXISTS (select * from GxQscripts where name='GetMediaContents')
	delete from GxQscripts where name = 'GetMediaContents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetMediaContents')
	delete from GXDBVersions where aliasname = 'GetMediaContents'
GO
print '... Creating Procedure: GetMediaContents'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetMediaContents
  @mediaId integer,
  @userId integer = 0
AS
  DECLARE @o_jobId integer
  DECLARE @o_backupLevel integer
  DECLARE @o_fullCycleNum integer
  DECLARE @o_cycleSeqNum integer
  DECLARE @o_jobStartTime integer
  DECLARE @o_jobStatus integer
  DECLARE @o_jobDataStatus integer
  DECLARE @o_jobDataFlags integer
  DECLARE @o_retentionDays integer
  DECLARE @o_pinJobEndTime bigint
  DECLARE @o_archFileId integer
  DECLARE @o_archFileName NVARCHAR(2048)
  DECLARE @o_archFileType integer
  DECLARE @o_archFileCreateTime integer
  DECLARE @o_isValidData integer
  DECLARE @o_sizeOnMedia bigint
  DECLARE @o_sizeOfBackup bigint
  DECLARE @o_mediaSideId integer
  DECLARE @o_clientId integer
  DECLARE @o_clientName varchar(255)
  DECLARE @o_appTypeId integer
  DECLARE @o_appTypeName varchar(255)
  DECLARE @o_instanceId integer
  DECLARE @o_instanceName varchar(255)
  DECLARE @o_backupSetId integer
  DECLARE @o_backupSetName varchar(255)
  DECLARE @o_appId integer
  DECLARE @o_subclientName NVARCHAR(255)
  DECLARE @o_archGroupId integer
  DECLARE @o_archGroupName NVARCHAR(255)
  DECLARE @o_copyId integer
  DECLARE @o_copyName NVARCHAR(255)
  DECLARE @o_mediaSideName varchar(255)
  DECLARE @o_sizeOfApplication bigint
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
--Assigned user id as 1 to act as admin user for do not chnage old behavior
if object_id('tempdb.dbo.#tempChunk') is not null DROP TABLE #tempChunk
CREATE	TABLE #tempChunk (
		mediaSideId		int,
		id				bigint,
		commCellId		int,
		physicalSize	bigint,
		PRIMARY KEY(id, commCellId)
		)
if object_id('tempdb.dbo.#tempAFCopy') is not null DROP TABLE #tempAFCopy
CREATE	TABLE #tempAFCopy(
		mediaSideId		int,
		archFileId		int,
		commCellId		int,
		archCopyId		int,
		aged			int,
		physicalOffset	bigint,
		physicalSize	bigint,
		dedupedSize		bigint,
		unCompSize		bigint,
		PRIMARY KEY(mediaSideId, archFileId, commCellId, archCopyId)
		)
if object_id('tempdb.dbo.#tempAFJob') is not null DROP TABLE #tempAFJob
CREATE	TABLE #tempAFJob (
		mediaSideId		int,
		jobId			int,
		archFileId		int,
		commCellId		int,
		archCopyId		int,
		archGroupId		int,
name			NVARCHAR(2048),
		appId			int,
		fileType		int,
		cTime			int,
		backupLevel		int,
		isValid			int,
		sizeOnMedia		bigint,
		instanceId		int,
		jobStartTime	int,
		jobStatus		int,
		fullCycleNum	int,
		cycleSeqNum		int,
		jobDataStatus	int,
		jobDataFlags	int,
		backupSize		bigint,
		isDMAppType		int,
		extRetFlags		int,
		pinEndTime		bigint,
		retentionDays	int,
		applicationSize	bigint,
		isVSAParentJob int,
		jobNotInMedia  int,
		PRIMARY KEY(mediaSideId, jobId, archFileId, commCellId, archCopyId, fileType, isValid)
		)
if object_id('tempdb.dbo.#toBeCopiedJobs') is not null DROP TABLE #toBeCopiedJobs
CREATE	TABLE #toBeCopiedJobs (
		jobId			int,
		archGrpCopyId	int,
		dataType		int,
		commCellId		int,
		PRIMARY KEY(jobId, archGrpCopyId, dataType, commCellId)
		)
if object_id('tempdb.dbo.#tempARExt') is not null DROP TABLE #tempARExt
CREATE	TABLE #tempARExt (
		copyId			int,
		retentionDays	int,
		retentionRule	int)
if object_id('tempdb.dbo.#tmpAssociatedCopy') is not null DROP TABLE #tmpAssociatedCopy
CREATE	TABLE #tmpAssociatedCopy (copyId int)
CREATE CLUSTERED INDEX tmpAssociatedCopy_copyId_Idx ON #tmpAssociatedCopy (copyId)
if object_id('tempdb.dbo.#tmpAssociatedSubClients') is not null DROP TABLE #tmpAssociatedSubClients
CREATE	TABLE #tmpAssociatedSubClients (
		clientId int,
		appTypeId int,
		instanceId int,
		backupsetId int,
		subClientId int
		)
CREATE CLUSTERED INDEX tmpAssociatedSubClients_subClientId_Idx ON #tmpAssociatedSubClients (subClientId)
IF @userId = 0
BEGIN
SELECT top 1 @userId = id FROM UMUsers WITH (NOLOCK) where (flags & 0x040) > 0
END
exec sec_getNonIdaObjectsForThisUser @userId, 18, 0, '#tmpAssociatedCopy'
exec sec_getIdaObjectsForUser @userId, 7, 0, 1, '#tmpAssociatedSubClients'
DECLARE	@l_MediaTypeId	INT = 0
SELECT	@l_MediaTypeId	= MediaTypeId FROM MMMedia WITH (NOLOCK) WHERE MediaId = @mediaId
DECLARE	@l_sizeOnDisk	BIGINT = 0
IF	@l_MediaTypeId = 10001
BEGIN
	SELECT 	@l_sizeOnDisk = M.UsedSpaceInBytes
	FROM	MMMediaSide MS WITH(READUNCOMMITTED),
			MMMountPath MP WITH(READUNCOMMITTED),
			MMMetallicStorage M WITH(READUNCOMMITTED)
	WHERE	MS.MediaId = @mediaId
			AND MS.MediaSideId = MP.MediaSideId
			AND MP.MountPathId = M.MountPathId
	IF @@ROWCOUNT = 0
	BEGIN
		SELECT	@l_sizeOnDisk = SUM(CAST(PhysicalBytesMB AS BIGINT))*1024*1024
		FROM	MMVolume WITH (NOLOCK)
		WHERE	MediaId = @mediaId AND SiloStatus <> 3
	END
END
INSERT	INTO #tempChunk
SELECT	V.MediaSideId, AC.id, AC.commCellId, AC.physicalSize
FROM	archChunk AC WITH (NOLOCK)
	INNER JOIN MMVolume V WITH (NOLOCK) ON AC.volumeId = V.volumeId
	INNER JOIN MMMediaSide MS WITH (NOLOCK) ON V.MediaSideId = MS.MediaSideId
WHERE	MS.MediaId = @mediaId
INSERT	INTO #tempAFCopy
SELECT	B.mediaSideId, A.archFileId, A.commCellId, A.archCopyId, MIN(A.flags & 256),
		MAX(A.physicalOffset+A.physicalSize), SUM(A.physicalSize), SUM(A.dedupedSize), SUM(A.unCompSize)
FROM	archChunkMapping A WITH (NOLOCK), #tempChunk B
WHERE	A.archChunkId = B.id AND A.chunkCommCellId = B.commCellId
GROUP BY B.mediaSideId, A.archFileId, A.commCellId, A.archCopyId
INSERT INTO #tempAFJob
SELECT	A.mediaSideId, B.jobId, A.archFileId, A.commCellId, A.archCopyId, B.archGroupId, B.name, B.appId, B.fileType,
		B.cTime, B.backupLevel, B.isValid, A.dedupedSize, 0, 0, 3, 0, 0, 0, A.aged, 0, 0, 0, 0, 0, A.unCompSize, 0, 0
FROM	#tempAFCopy A
		INNER JOIN archFile B WITH (NOLOCK)
			ON A.archFileId = B.id AND A.commCellId = B.commCellId --AND B.isValid > -1
		INNER JOIN APP_Application C WITH (NOLOCK)
			ON B.appId = C.id AND C.appTypeId IN (2,3,5,22,23,37,61,62,79,80,103)
UPDATE	#tempAFJob SET instanceId = B.instanceId
FROM	#tempAFJob A, archFileOracle B WITH (NOLOCK)
WHERE	A.archFileId = B.archFileId AND A.commCellId = B.commCellId
-- Get all the arch files with valid / invalid data
INSERT	INTO #tempAFJob
SELECT	A.mediaSideId, B.jobId, MIN(A.archFileId), A.commCellId, A.archCopyId, B.archGroupId, '', B.appId, B.fileType,
		MIN(B.cTime), B.backupLevel, B.isValid,
		SUM(A.dedupedSize), 0, 0, 3, 0, 0, 0,
		MIN(A.aged), 0, 0, 0, 0, 0, SUM(A.unCompSize), 0, 0
FROM	#tempAFCopy A
		INNER JOIN archFile B WITH (NOLOCK)
			ON A.archFileId = B.id AND A.commCellId = B.commCellId --AND B.isValid > -1
		INNER JOIN APP_Application C WITH (NOLOCK)
			ON B.appId = C.id AND C.appTypeId NOT IN (2,3,5,22,23,37,61,62,79,80,103)
GROUP BY A.mediaSideId, B.jobId, A.commCellId, A.archCopyId, B.archGroupId, B.appId, B.fileType, B.backupLevel, B.isValid
DECLARE @computeVSAJobRetention int = 0
SELECT @computeVSAJobRetention = ISNULL(value, 0)
FROM MMConfigs WITH(NOLOCK)
WHERE name = 'MMCONFIG_COMPUTE_VSA_JOB_RETENTION_BASED_ON_VM_JOBS'
IF @computeVSAJobRetention = 1
BEGIN
	--Set a flag to identify VSA parent jobs
	UPDATE T
	SET isVSAParentJob = 1
	FROM #tempAFJob T INNER JOIN JMJobDataLink JDL WITH(NOLOCK) ON T.jobId = JDL.parentJobId AND T.commcellId = JDL.commcellId
WHERE JDL.linkType IN (7, 8)
	--Populate child VM jobs for parent VSA job
	INSERT INTO #tempAFJob
	SELECT 0, JDS.jobId, 0, JDS.commcellId, JDS.archGrpCopyId, JDS.archGrpId, N'', JDS.appId, JDS.dataType, 0, 0, 1 /*isValid*/, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 /*JobNotInMedia*/
	FROM #tempAFJob T1 INNER JOIN JMJobDataLink JDL WITH(NOLOCK) ON T1.jobId = JDL.parentJobId AND T1.commcellId = JDL.commcellId
	INNER JOIN JMJobDataStats JDS WITH(NOLOCK) ON JDL.childJobId = JDS.jobId AND JDL.commcellId = JDS.commcellId AND T1.archCopyId = JDS.archGrpCopyId
	LEFT OUTER JOIN #tempAFJob T2 ON JDS.jobId = T2.jobId AND JDS.commcellId = T2.commcellid AND JDS.archGrpCopyId = T2.archCopyId AND JDS.dataType = T2.fileType
WHERE (JDS.disabled & 256) = 0 AND JDS.status IN (100, 102, 103) AND JDL.linkType IN (7, 8) AND T2.jobId IS NULL
END
-- Get job information
UPDATE	#tempAFJob
SET		backupLevel = B.bkpLevel,
		jobStartTime = B.servStartDate,
		jobStatus = B.status,
		fullCycleNum = B.fullCycleNum,
		cycleSeqNum = B.cycleSequence,
		backupSize = B.totalBackupSize,
		isDMAppType = isnull(I.isDMAppType, 0)
FROM	#tempAFJob A
		INNER JOIN	JMBkpStats B WITH (NOLOCK) ON A.jobId = B.jobId AND A.commCellId = B.commCellId
		LEFT  JOIN	APP_IDATypeHandlingInfo I WITH (NOLOCK) ON I.appTypeId = B.appType
UPDATE	#tempAFJob
SET		backupLevel = B.ER_BkpLevel,
		jobStartTime = B.servStart,
		jobStatus = B.status,
		backupSize = B.totalBackupSize,
		fullCycleNum = B.fullCycleNum
FROM	#tempAFJob A, JMAdminJobStatsTable B WITH (NOLOCK)
WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId
UPDATE	#tempAFJob
SET		jobDataStatus = B.status,
		jobDataFlags = (jobDataFlags | B.disabled),
		extRetFlags = B.retentionFlags,
		pinEndTime = B.manualRetentionEndTime
FROM	#tempAFJob A, JMJobDataStats B WITH (NOLOCK)
WHERE	B.jobId = A.jobId
	AND B.dataType = A.fileType
	AND B.archGrpCopyId = A.archCopyId
	AND B.commCellId = A.commCellId
	AND A.jobStatus IN (1, 2, 3, 4, 14)
	AND B.status IN (100, 101, 102, 103, 3)
-- Running jobs
UPDATE	#tempAFJob
SET		jobStartTime = B.jobStartTime,
		jobStatus = 0,
		jobDataStatus = 1
FROM	#tempAFJob A, JMJobInfo B WITH (NOLOCK)
WHERE	A.jobId = B.jobId AND A.commCellId = B.commCellId
--DELETE	FROM #tempAFJob
--WHERE	(jobStatus <> 0 AND isValid = 0)
-- Check if this media is needed for Aux Copy
DECLARE @l_neededForAuxCopy INT
	SET @l_neededForAuxCopy = 0
DECLARE @copyList TABLE (copyId INT, destCopyId int)
INSERT	INTO @copyList
SELECT	T.archCopyId, AGC.id
FROM	(SELECT	DISTINCT archCopyId, archGroupId
		FROM	#tempAFJob) T,
		archGroup AG WITH (NOLOCK),
		archGroupCopy AGC WITH (NOLOCK)
WHERE	AG.id = T.archGroupId
	AND AGC.archGroupId = T.archGroupId AND AGC.id <> T.archCopyId AND AGC.type <> 3
	AND (T.archCopyId = AG.defaultCopy AND AGC.sourceCopyId = 0 OR AGC.sourceCopyId = T.archCopyId)
INSERT	INTO #toBeCopiedJobs
SELECT	J.jobId, J.archGrpCopyId, J.dataType, J.commCellId
FROM	#tempAFJob AS A, JMJobDataStats J WITH (NOLOCK), @copyList AS C
WHERE	A.isValid = 1 AND A.jobDataStatus = 100 AND (A.jobDataFlags & (1 + 256)) = 0
	AND	J.jobId = A.jobId AND J.commCellId = A.commCellId AND J.dataType = A.fileType
	AND	J.archGrpCopyId = C.destCopyId AND C.copyId = A.archCopyId
	AND J.status IN (101, 102, 103) AND J.disabled & (1+256) = 0
GROUP BY J.jobId, J.archGrpCopyId, J.dataType, J.commCellId
IF	EXISTS (SELECT * FROM #toBeCopiedJobs)
AND EXISTS (
	SELECT	*
	FROM	#tempAFCopy A
			LEFT JOIN (
			SELECT	AFC.archFileId, AFC.commCellId, AFC.archCopyId, AFC.physicalsize
			FROM	#toBeCopiedJobs J, archFile AF WITH (NOLOCK), archFileCopy AFC WITH (NOLOCK)
			WHERE	AF.jobId = J.jobId AND AF.commCellId = J.commCellId AND AF.fileType = J.dataType AND AF.isValid = 1
				AND AFC.archFileId = AF.id AND AFC.commCellId = AF.commCellId AND AFC.archCopyId = J.archGrpCopyId
				AND AFC.isValid = 0 AND (AFC.flags & 256) = 0) B
		ON	A.archFileId = B.archFileId AND A.commCellId = B.commCellId AND A.archCopyId = B.archCopyId
	WHERE	B.archFileId IS NULL OR B.physicalsize < A.physicalOffset
	)
BEGIN
	SET @l_neededForAuxCopy = 1
END
-- Update job's retentionDays based on basic and extended retention rules.
UPDATE	#tempAFJob
SET		retentionDays = (case when #tempAFJob.isDMAppType = 0 then AR.retentionDays else AR.archiverRetDays end)
FROM	archAgingRule AR WITH (NOLOCK)
WHERE	#tempAFJob.archCopyId = AR.copyId
INSERT	INTO #tempARExt
SELECT	ARE.copyId, ARE.retentionDays, ARE.retentionRule
FROM	(SELECT	DISTINCT archCopyId FROM #tempAFJob) T,
		archAgingRuleExtended ARE WITH (NOLOCK)
WHERE	ARE.copyId = T.archCopyId
IF @@ERROR = 0 AND @@ROWCOUNT > 0
BEGIN
	UPDATE	#tempAFJob
	SET		extRetFlags = (
			CASE
								WHEN (extRetFlags & (64|4096)) <> 0		AND (T.retentionRules & 64) <> 0 THEN 64 			/*EXTENDED_YEAR | EXTENDED_GRACE_YEAR*/
								WHEN (extRetFlags & (32|2048)) <> 0		AND (T.retentionRules & 32) <> 0 THEN 32 			/*EXTENDED_HALFYEAR | EXTENDED_GRACE_HALFYEAR*/
								WHEN (extRetFlags & (16|1024)) <> 0		AND (T.retentionRules & 16) <> 0 THEN 16 			/*EXTENDED_QUARTER | EXTENDED_GRACE_QUARTER*/
								WHEN (extRetFlags & (8|512)) <> 0		AND (T.retentionRules & 8) <> 0 THEN 8 				/*EXTENDED_MONTH | EXTENDED_GRACE_MONTH*/
								WHEN (extRetFlags & (4|256)) <> 0		AND (T.retentionRules & 4) <> 0 THEN 4 				/*EXTENDED_WEEK | EXTENDED_GRACE_WEEK*/
								WHEN (extRetFlags & (524288)) <> 0		AND (T.retentionRules & 524288) <> 0 THEN 524288 	/*EXTENDED_GRACE_DAY*/
								WHEN (extRetFlags & (262144)) <> 0		AND (T.retentionRules & 262144) <> 0 THEN 262144 	/*EXTENDED_GRACE_HOUR*/
								WHEN (extRetFlags & (2))<> 0			AND (T.retentionRules & 2) <> 0 THEN 2				/*EXTENDED_ALLFULL*/
								ELSE 0
							END)
	FROM	(SELECT copyId, SUM(retentionRule) AS retentionRules FROM #tempARExt GROUP BY copyId) T
	WHERE	#tempAFJob.archCopyId = T.copyId
		AND #tempAFJob.retentionDays >= 0 AND #tempAFJob.extRetFlags <> 0
	UPDATE	#tempAFJob
	SET		retentionDays = b.retentionDays
	FROM	#tempAFJob a, #tempARExt b
	WHERE	a.extRetFlags = b.retentionRule AND a.archCopyId = b.copyId
		AND a.retentionDays >= 0 AND (a.retentionDays < b.retentionDays OR b.retentionDays < 0)
END
--Find last in cycle jobs
IF OBJECT_ID('tempdb..#lastJobInCycle') IS NOT NULL
		DROP TABLE #lastJobInCycle
CREATE TABLE #lastJobInCycle(
		appId int, copyId int, fullCycleNum int, jobStartTime int, jobId int, commcellId int, extRetFlags int, retentionDays bigint)
IF @computeVSAJobRetention = 1
BEGIN
	--Don't do this for VSA parent jobs
	INSERT INTO #lastJobInCycle
	SELECT J.appId, J.archCopyId, J.fullCycleNum, MAX(JBKP.servStartDate), 0, 0, 0, 0
	FROM (SELECT distinct appId, archCopyId, fullCycleNum FROM #tempAFJob WHERE fileType <> 4 AND isDMAppType = 0 AND isVSAParentJob = 0) J INNER JOIN
	JMBkpStats JBKP WITH(NOLOCK) ON J.appId = JBKP.appId AND J.fullCycleNum = JBKP.fullCycleNum
	INNER JOIN JMJobDataStats JDS WITH(NOLOCK) ON JBKP.jobId = JDS.jobId AND JBKP.commcellId = JDS.commcellId AND JDS.archGrpCopyId = J.archCopyId
	AND (JDS.disabled & 256) = 0 AND JDS.Status IN(100, 102, 103) AND JDS.dataType <> 4
	GROUP BY J.appId, J.archCopyId, J.fullCycleNum
END
ELSE
BEGIN
	INSERT INTO #lastJobInCycle
	SELECT J.appId, J.archCopyId, J.fullCycleNum, MAX(JBKP.servStartDate), 0, 0, 0, 0
	FROM (SELECT distinct appId, archCopyId, fullCycleNum FROM #tempAFJob WHERE fileType <> 4 AND isDMAppType = 0) J INNER JOIN
	JMBkpStats JBKP WITH(NOLOCK) ON J.appId = JBKP.appId AND J.fullCycleNum = JBKP.fullCycleNum
	INNER JOIN JMJobDataStats JDS WITH(NOLOCK) ON JBKP.jobId = JDS.jobId AND JBKP.commcellId = JDS.commcellId AND JDS.archGrpCopyId = J.archCopyId
	AND (JDS.disabled & 256) = 0 AND JDS.Status IN(100, 102, 103) AND JDS.dataType <> 4
	GROUP BY J.appId, J.archCopyId, J.fullCycleNum
END
INSERT INTO #lastJobInCycle
SELECT J.appId, J.archCopyId, J.fullCycleNum, MAX(AJ.servStart), 0, 0, 0, 0
FROM (SELECT distinct appId, archCopyId, fullCycleNum FROM #tempAFJob WHERE fileType <> 4 AND isDMAppType = 0) J INNER JOIN
JMAdminJobStatsTable AJ WITH(NOLOCK) ON J.appId = AJ.appId AND J.fullCycleNum = AJ.fullCycleNum
INNER JOIN JMJobDataStats JDS WITH(NOLOCK) ON AJ.jobId = JDS.jobId AND AJ.commcellId = JDS.commcellId AND JDS.archGrpCopyId = J.archCopyId
AND (JDS.disabled & 256) = 0 AND JDS.Status IN(100, 102, 103) AND JDS.dataType <> 4
GROUP BY J.appId, J.archCopyId, J.fullCycleNum
UPDATE #lastJobInCycle
SET jobId = JBKP.jobId, commcellId = JBKP.commcellId, extRetFlags = JDS.retentionFlags
FROM #lastJobInCycle J INNER JOIN JMBkpStats JBKP WITH(NOLOCK) ON J.appId = JBKP.appId AND J.jobStartTime = JBKP.servStartDate
INNER JOIN JMJobDataStats JDS WITH(NOLOCK) ON JBKP.jobId = JDS.jobId AND JBKP.commcellId = JDS.commcellId AND JDS.archGrpCopyId = J.copyId
AND (JDS.disabled & 256) = 0 AND JDS.Status IN(100, 102, 103) AND JDS.dataType <> 4
UPDATE #lastJobInCycle
SET jobId = AJ.jobId, commcellId = AJ.commcellId, extRetFlags = JDS.retentionFlags
FROM #lastJobInCycle J INNER JOIN JMAdminJobStatsTable AJ WITH(NOLOCK) ON J.appId = AJ.appId AND J.jobStartTime = AJ.servStart
INNER JOIN JMJobDataStats JDS WITH(NOLOCK) ON AJ.jobId = JDS.jobId AND AJ.commcellId = JDS.commcellId AND JDS.archGrpCopyId = J.copyId
AND (JDS.disabled & 256) = 0 AND JDS.Status IN(100, 102, 103) AND JDS.dataType <> 4
-- Update job's retentionDays
UPDATE	#lastJobInCycle
SET		retentionDays = AR.retentionDays
FROM	archAgingRule AR WITH (NOLOCK)
WHERE	#lastJobInCycle.copyId = AR.copyId
IF EXISTS(SELECT 1 FROM #tempARExt)
BEGIN
	UPDATE	#lastJobInCycle
		SET		extRetFlags = (
				CASE
								WHEN (extRetFlags & (64|4096)) <> 0		AND (T.retentionRules & 64) <> 0 THEN 64 			/*EXTENDED_YEAR | EXTENDED_GRACE_YEAR*/
								WHEN (extRetFlags & (32|2048)) <> 0		AND (T.retentionRules & 32) <> 0 THEN 32 			/*EXTENDED_HALFYEAR | EXTENDED_GRACE_HALFYEAR*/
								WHEN (extRetFlags & (16|1024)) <> 0		AND (T.retentionRules & 16) <> 0 THEN 16 			/*EXTENDED_QUARTER | EXTENDED_GRACE_QUARTER*/
								WHEN (extRetFlags & (8|512)) <> 0		AND (T.retentionRules & 8) <> 0 THEN 8 				/*EXTENDED_MONTH | EXTENDED_GRACE_MONTH*/
								WHEN (extRetFlags & (4|256)) <> 0		AND (T.retentionRules & 4) <> 0 THEN 4 				/*EXTENDED_WEEK | EXTENDED_GRACE_WEEK*/
								WHEN (extRetFlags & (524288)) <> 0		AND (T.retentionRules & 524288) <> 0 THEN 524288 	/*EXTENDED_GRACE_DAY*/
								WHEN (extRetFlags & (262144)) <> 0		AND (T.retentionRules & 262144) <> 0 THEN 262144 	/*EXTENDED_GRACE_HOUR*/
								WHEN (extRetFlags & (2))<> 0			AND (T.retentionRules & 2) <> 0 THEN 2				/*EXTENDED_ALLFULL*/
								ELSE 0
							END)
		FROM	(SELECT copyId, SUM(retentionRule) AS retentionRules FROM #tempARExt GROUP BY copyId) T
		WHERE	#lastJobInCycle.copyId = T.copyId
			AND #lastJobInCycle.retentionDays >= 0 AND #lastJobInCycle.extRetFlags <> 0
		UPDATE	#lastJobInCycle
		SET		retentionDays = b.retentionDays
		FROM	#lastJobInCycle a, #tempARExt b
		WHERE	a.extRetFlags = b.retentionRule AND a.copyId = b.copyId
			AND a.retentionDays >= 0 AND (a.retentionDays < b.retentionDays OR b.retentionDays < 0)
END
IF @computeVSAJobRetention = 1
BEGIN
	/*
	Earlier query sets retention end time for jobs in #tempAFJob only if last job in cycle is a different job than this particular job
	If last job in cycle is same as the current job, it doesn't set retention time. (Look at the J.jobId <> LJ.jobId condition)
	So for last in cycle jobs this stored proc sends 0 as retention time (unless there is manual retention time).
	There is a code in cpp that sets retention end time based on retention days.
	For VM jobs we need retention end time set here so that we can calculate parent VSA job retention.
	Hence I'm making change in this query to remove the (J.jobId <> LJ.jobId) condition and setting retention end time accordingly.
	Ideally this change is ok for all jobs, not just VSA - but just to minimize regression, using this modified query only if this config param is enabled.
	*/
	UPDATE #tempAFJob SET pinEndTime = CASE WHEN pinEndTime = -1 OR J.retentionDays = -1 OR LJ.retentionDays = -1 THEN -1
										WHEN ((LJ.retentionDays*24*60*60) + LJ.jobStartTime) >= ((CAST(J.retentionDays AS BIGINT)*24*60*60) + J.jobStartTime)
												AND ((LJ.retentionDays*24*60*60) + LJ.jobStartTime) > pinEndTime
												THEN ((LJ.retentionDays*24*60*60) + LJ.jobStartTime)
										WHEN  ((CAST(J.retentionDays AS BIGINT)*24*60*60) + J.jobStartTime) >= ((LJ.retentionDays*24*60*60) + LJ.jobStartTime)
												AND ((CAST(J.retentionDays AS BIGINT)*24*60*60) + J.jobStartTime) > pinEndTime
												THEN ((CAST(J.retentionDays AS BIGINT)*24*60*60) + J.jobStartTime)
										ELSE pinEndTime END
	FROM #tempAFJob J INNER JOIN #lastJobInCycle LJ ON J.appId = LJ.appId AND J.fullCycleNum = LJ.fullCycleNum AND J.archCopyId = LJ.copyId
	AND J.jobDataFlags & 256 = 0
END
ELSE
BEGIN
	UPDATE #tempAFJob SET pinEndTime = CASE WHEN pinEndTime = -1 OR J.retentionDays = -1 THEN pinEndTime
										WHEN LJ.retentionDays = -1 THEN -1
										WHEN ((LJ.retentionDays*24*60*60) + LJ.jobStartTime) > ((CAST(J.retentionDays AS BIGINT)*24*60*60) + J.jobStartTime)
												AND ((LJ.retentionDays*24*60*60) + LJ.jobStartTime) > pinEndTime
												THEN ((LJ.retentionDays*24*60*60) + LJ.jobStartTime)
										ELSE pinEndTime END
	FROM #tempAFJob J INNER JOIN #lastJobInCycle LJ ON J.appId = LJ.appId AND J.fullCycleNum = LJ.fullCycleNum AND J.archCopyId = LJ.copyId AND J.jobId <> LJ.jobId
	AND J.jobDataFlags & 256 = 0
END
IF @computeVSAJobRetention = 1
BEGIN
	DECLARE @timeNow BIGINT = dbo.GetUnixTime(GETUTCDATE())
	--At this point VSA parent jobs should have only manual retention if set by user. If not set current time. Later we will override with child VM retention
	UPDATE #tempAFJob
	SET retentionDays = 0, pinEndTime = CASE WHEN pinEndTime = 0 THEN @timeNow ELSE pinEndTime END
	WHERE isVSAParentJob = 1
	IF OBJECT_ID('tempdb..#tblVSAJobAgingDate') IS NOT NULL DROP TABLE #tblVSAJobAgingDate
	CREATE TABLE #tblVSAJobAgingDate (
			ParentVSAJobId 	int,
			CommCellId 			int,
			CopyId 					int,
			EstAgingDate		bigint,
			PRIMARY KEY (ParentVSAJobId, CommCellId, CopyId)
			)
	--Set max of child job's retention on the parent job if parent job's existing retention (manual) is lesser
	INSERT INTO #tblVSAJobAgingDate
	SELECT a.jobId, a.commcellId, a.archCopyId, CASE WHEN MIN(b.pinEndTime) = -1 THEN -1 ELSE MAX(b.pinEndTime) END
	FROM #tempAFJob a INNER JOIN JMJobDataLink JDL WITH(NOLOCK) ON a.jobId = JDL.parentJobId AND a.commcellId = JDL.commcellId
	INNER JOIN #tempAFJob b ON JDL.childJobId = b.jobId AND JDL.commcellId = b.commcellId AND a.archCopyId = b.archCopyId
WHERE JDL.linkType IN (7, 8)
	AND a.jobDataFlags & 256 = 0
	AND b.jobDataFlags & 256 = 0
	GROUP BY a.jobId, a.commcellId, a.archCopyId
	UPDATE #tempAFJob
	SET pinEndTime = T.estAgingDate
	FROM  #tempAFJob a INNER JOIN #tblVSAJobAgingDate T ON a.jobId = T.ParentVSAJobId AND a.commcellId = T.commcellId AND a.archCopyId = T.copyId
	WHERE a.pinEndTime != -1 and (T.estAgingDate = -1 OR a.pinEndTime < T.estAgingDate)
	--Get rid of the child jobs we populated only for VSA parent retention calculation. We don't need them listed in view jobs
	DELETE #tempAFJob WHERE jobNotInMedia	= 1
	IF OBJECT_ID('tempdb..#tblVSAJobAgingDate') IS NOT NULL DROP TABLE #tblVSAJobAgingDate
END
declare @daysToRetainInvalidAFs int = 0
set @daysToRetainInvalidAFs = (select value from MMConfigs WITH(NOLOCK) where name = 'DA_CONFIG_DAYS_TO_KEEP_INVALID_ARCHIVES_FOR_VALID_JOBS')
UPDATE #tempAFJob SET retentionDays = (CASE WHEN jobStatus IN (1, 3, 14) THEN @daysToRetainInvalidAFs
										   WHEN jobStatus IN (2, 4) THEN 0
									  END),
					  pinEndTime = (CASE WHEN jobStatus IN (1, 3, 14) THEN @daysToRetainInvalidAFs*24*60*60
										   WHEN jobStatus IN (2, 4) THEN 0
									  END)
WHERE isValid < 1
--Set pinEndTime = -2 for aged jobs to show N\A in the GUI
UPDATE #tempAFJob
SET pinEndTime = -2
WHERE jobDataFlags & 256 > 0
--Set N\A for edge subclient jobs
UPDATE T
SET pinEndTime = -2
FROM #tempAFJob T INNER JOIN App_Application APP WITH(NOLOCK) ON T.appId = APP.id
WHERE APP.subclientStatus & 0x20000 > 0
-- First rows with jobId = 0:
-- o_archFileType for neededForAuxCopy,
-- o_sizeOnMedia for totalChunkSize of MediaSide,
-- o_archFileName for MediaSideName
SELECT	0 AS jobId, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, '', @l_neededForAuxCopy AS fileType, 0,
		0, (CASE WHEN @l_MediaTypeId = 10001 THEN @l_sizeOnDisk ELSE backupSize END) AS sizeOnMedia,
		(select sum(sizeOnMedia) FROM #tempAFJob), MS.mediaSideId,
		0,'', 0,'',	0,'', 0,'', 0,'', 0,'', 0,'',
		(SELECT SideName FROM MMMediaSide WITH (NOLOCK) WHERE MMMediaSide.MediaSideId = MS.mediaSideId),
		0
FROM	(SELECT mediaSideId, SUM(physicalSize) AS backupSize
		FROM	#tempChunk
		GROUP BY mediaSideId) MS
UNION
SELECT	jobId, backupLevel, fullCycleNum, cycleSeqNum, jobStartTime, jobStatus, jobDataStatus, jobDataFlags, retentionDays, pinEndTime,
		archFileId, T.name, fileType, CASE WHEN App.appTypeId IN (2,3,5,22,23,37,61,62,79,80,103) THEN cTime ELSE jobStartTime END,
		isValid, sizeOnMedia, backupSize, T.mediaSideId,
		App.clientId,  Cl.displayName,
		App.appTypeId, IDA.name,
		(case when T.instanceId > 0 then T.instanceId else App.instance end),
		(case when T.instanceId > 0 then (SELECT name FROM APP_InstanceName WITH (NOLOCK) WHERE id = T.instanceId) else ISN.name end),
		App.backupset, BS.name,
		App.id, APP.subClientName,
		AG.id, AG.name,
		AGC.id, AGC.name, MS.SideName, T.applicationSize
FROM	#tempAFJob AS T
 		INNER JOIN APP_Application		AS App	ON App.id = T.appId
		INNER JOIN APP_Client			AS Cl	ON Cl.id = App.clientId
		INNER JOIN APP_iDAType			AS IDA	ON IDA.type = App.appTypeId
		INNER JOIN APP_BackupSetName	AS BS	ON BS.id = App.backupSet
		INNER JOIN APP_InstanceName		AS ISN	ON ISN.id = App.instance
		INNER JOIN #tmpAssociatedSubClients AS TMPSL ON TMPSL.subClientId = App.id
		INNER JOIN archGroupCopy		AS AGC	ON AGC.id = T.archCopyId
		INNER JOIN #tmpAssociatedCopy   as TMPAGC ON AGC.id = TMPAGC.copyId
		INNER JOIN archGroup			AS AG	ON AG.id = T.archGroupId
		INNER JOIN MMMediaSide			AS MS	ON MS.MediaSideId = T.MediaSideId
ORDER BY jobId ASC, fileType ASC, mediaSideId ASC
if object_id('tempdb.dbo.#tempChunk') is not null DROP TABLE #tempChunk
if object_id('tempdb.dbo.#tempAFCopy') is not null DROP TABLE #tempAFCopy
if object_id('tempdb.dbo.#tempAFJob') is not null DROP TABLE #tempAFJob
if object_id('tempdb.dbo.#tempARExt') is not null DROP TABLE #tempARExt
if object_id('tempdb.dbo.#toBeCopiedJobs') is not null DROP TABLE #toBeCopiedJobs
if object_id('tempdb.dbo.#tmpAssociatedCopy') is not null DROP TABLE #tmpAssociatedCopy
if object_id('tempdb.dbo.#tmpAssociatedSubClients') is not null DROP TABLE #tmpAssociatedSubClients
IF OBJECT_ID('tempdb..#lastJobInCycle') IS NOT NULL
		DROP TABLE #lastJobInCycle
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetMediaContents')
	delete from GxQscripts where name = 'GetMediaContents'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetMediaContents')
	delete from GXDBVersions where aliasname = 'GetMediaContents'
GO

insert into GXDBVersions values(2, 'GetMediaContents',  '00010080003200110000', 'GetMediaContents', '00010080003200110000')
GO

