

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetMailboxAppIdsForAddin.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetMailboxAppIdsForAddin.sp,v $ $Id: GetMailboxAppIdsForAddin.sp,v 1.17.46.2 2018/03/20 00:43:07 jiechen Exp $";
-- =============================================
-- Author:		Anil Jaiswal
-- Create date: 14/11/2007
-- Description:	returns the mailboxes matching the given mailbox
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetMailboxAppIdsForAddin <<<'

IF EXISTS (select * from sysobjects where name='GetMailboxAppIdsForAddin')
	drop procedure GetMailboxAppIdsForAddin
IF EXISTS (select * from GxQscripts where name='GetMailboxAppIdsForAddin')
	delete from GxQscripts where name = 'GetMailboxAppIdsForAddin'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetMailboxAppIdsForAddin')
	delete from GXDBVersions where aliasname = 'GetMailboxAppIdsForAddin'
GO
print '... Creating Procedure: GetMailboxAppIdsForAddin'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetMailboxAppIdsForAddin
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @xmlText XML,
  @currentUser int
AS
SET NOCOUNT ON
DECLARE @mailbox nvarchar(1024)
DECLARE @_guid varchar(1024)
DECLARE @_fromTime integer
DECLARE @_endTime integer
DECLARE @_endUser integer
DECLARE @prefix varchar(5)
DECLARE @seper varchar(5)
DECLARE @source int	-- 2= Lotus Motes, 1 - Exchange
DECLARE @mailLike1 nvarchar(1024)
DECLARE @mailLike2 nvarchar(1024)
DECLARE @_instanceName varchar(1024)
DECLARE @_clientName varchar(1024)
declare @instanceLike nvarchar(1024)
--select xmltextData=@xmlText, userid=@currentUser
--into StuK
SET @_guid = ISNULL(( SELECT ref.value('@guid', 'varchar(1024)')
							FROM @xmlText.nodes('EVGui_MailboxAddInContextReq') R ( ref ) ),
						'')
SET @_fromTime = ISNULL(( SELECT ref.value('@fromTime', 'int')
							FROM @xmlText.nodes('EVGui_MailboxAddInContextReq') R ( ref ) ),
						0)
SET @_endTime = ISNULL(( SELECT ref.value('@toTime', 'int')
							FROM @xmlText.nodes('EVGui_MailboxAddInContextReq') R ( ref ) ),
						0)
SET @_endUser = ISNULL(( SELECT ref.value('@endUser', 'int')
							FROM @xmlText.nodes('EVGui_MailboxAddInContextReq') R ( ref ) ),
						0)
SET @_clientName = ISNULL(( SELECT ref.value('@clientName', 'varchar(1024)')
							FROM @xmlText.nodes('EVGui_MailboxAddInContextReq') R ( ref ) ),
						'')
SET @_instanceName = ISNULL(( SELECT ref.value('@instanceName', 'varchar(1024)')
							FROM @xmlText.nodes('EVGui_MailboxAddInContextReq') R ( ref ) ),
						'')
set  @prefix = '\MB\'
set  @seper = char(18)
DECLARE @CapMask1 bigint = POWER(2.0,13-1)
DECLARE @CapMask2 bigint = POWER(2.0,22-1)
DECLARE @CapMask3 bigint = POWER(2.0,20-1)
DECLARE @CapMask4 bigint = POWER(2.0,24-1)
create table  #mailBoxHistory1
   (
      mailBoxId		int	NOT null,
      backupSetId	int NOT null,
      fromTime		integer,
      endTime		integer,
      mailbox		nvarchar(512),
      mailboxGUID	nvarchar(1024),
    )
declare @mailBoxHistoryResult table
   (
       clientId int,
       apptypeId int,
       instanceId int,
       backupsetId int,
       clientName nvarchar(MAX),
       applicationName nvarchar(MAX),
       instanceName nvarchar(MAX),
       backupsetName nvarchar(MAX),
       mailbox nvarchar(MAX),
       created int,
       modified int
    )
IF( OBJECT_ID('tempdb.dbo.#tUserObjects') is not null )
	DROP TABLE #tUserObjects
CREATE TABLE #tUserObjects(	commCellId	integer,
		clientId	integer,
		appTypeId	integer,
		instanceId	integer,
		backupsetId	integer,
		subClientId	integer )
	IF object_id('tempdb.dbo.#GetMailboxAppIdsForAddin_UserObjects') is not null DROP TABLE #GetMailboxAppIdsForAddin_UserObjects
create table  #GetMailboxAppIdsForAddin_UserObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @currentUser, 2013, 0, '#GetMailboxAppIdsForAddin_UserObjects'
	INSERT INTO #tUserObjects
	SELECT DISTINCT commCellId, clientId, appTypeId, instanceId, backupsetId, subClientId
	FROM	#GetMailboxAppIdsForAddin_UserObjects
	WHERE 	((capabilities & @CapMask1)>1 OR (capabilities & @CapMask2)>1 OR (capabilities & @CapMask3)>1 OR (capabilities & @CapMask4)>1)
	DROP TABLE #GetMailboxAppIdsForAddin_UserObjects
set @mailbox=(select mailboxPath from AddInSessionInfo where guid= @_guid);
set @source = (select source from AddInSessionInfo where guid = @_guid)
if @_endUser <> 0
   BEGIN
	set @mailbox =@prefix+@seper+@seper+(select email from umusers where id=@currentUser)
   END
IF @source = 2			-- LOTUS NOTES
BEGIN
insert into #mailBoxHistory1
exec AppGetNotesMailboxHistory @mailbox,0,@_fromTime,@_endTime,@_instanceName ,@_clientName;
END
delete from addinsessioninfo where datediff(MINUTE,createtime,GETUTCDATE()) > 60
--select step='debug',* from StuK
--select step='debug1',guid=@_guid, fromtime=@_fromTime, mailbox=@mailbox
--select step='debug2',* from #mailBoxHistory1
IF @source IS NULL OR @source <> 2			-- LOTUS NOTES
BEGIN
insert into #mailBoxHistory1
exec AppGetExchangeMailboxHistory @mailbox,0,@_fromTime,@_endTime;
END
INSERT INTO @mailBoxHistoryResult
SELECT DISTINCT
	A.clientId			     ,
	A.apptypeId	             ,
	A.Instance	             ,
	A.backupSet	             ,
	(select C.name from app_client C where A.clientId=C.Id),
	(select APP.name from app_IDAType APP where APP.type=A.apptypeId),
	(select I.name from app_InstanceName I where I.id=A.Instance),
	(select B.name as backupsetName from app_backupSetName B where B.id=A.backupSet),
	M.mailbox,
	fromTime,
	endTime
    FROM #mailBoxHistory1 M INNER JOIN  App_Application A ON M.backupSetId=A.backupSet
						INNER JOIN #tUserObjects T ON
										(T.clientId = 0 OR T.clientId = A.clientId) AND
										(T.appTypeId = 0 OR T.appTypeId = A.appTypeId) AND
										(T.instanceId = 0 OR T.instanceId = A.instance) AND
										(T.backupsetId = 0 OR T.backupsetId = A.backupset) AND
										(T.subClientId = 0 OR T.subClientId = A.id)
	ORDER BY A.backupSet, fromTime DESC
select 1   as   TAG,
       null as  Parent,
       @mailbox as  [EVGui_MailboxAddInContextResp!1!sourceMailbox],
       null as [appIds!2!clientId],
       null as [appIds!2!apptypeId],
       null as [appIds!2!instanceId],
       null as [appIds!2!backupsetId],
       null as [appIds!2!clientName],
       null as [appIds!2!applicationName],
       null as [appIds!2!instanceName],
       null as [appIds!2!backupsetName],
       null as [appIds!2!mailbox],
       null as [appIds!2!created],
       null as [appIds!2!modified],
       null as [appIds!2]
UNIon
SELECT
	2			             as TAG,
    1		                 as Parent,
    null                     ,
    clientId ,
    apptypeId ,
    instanceId ,
    backupsetId ,
    clientName ,
    applicationName ,
    instanceName ,
    backupsetName ,
    mailbox ,
    created ,
    modified,
	''
	FROM @mailBoxHistoryResult
	ORDER BY [appIds!2!backupsetId], [appIds!2!created] DESC
    FOR XML EXPLICIT
/*select distinct A.clientId,A.apptypeId,A.Instance,A.backupSet,
(select B.name as backupsetName from app_backupSetName B where B.id=A.backupSet),
(select I.name as instanceName from app_InstanceName I where I.id=A.Instance),
(select APP.name as applicationName from app_IDAType APP where APP.type=A.apptypeId),
(select C.name as ClientName from app_client C where A.clientId=C.Id),
M.mailbox from #mailBoxHistory1 M ,APP_application A
where M.backupSetId=A.backupSet;*/
drop table #mailBoxHistory1;
IF( OBJECT_ID('tempdb.dbo.#tUserObjects') is not null )
	DROP TABLE #tUserObjects
GO

IF EXISTS (select * from GxQscripts where name = 'GetMailboxAppIdsForAddin')
	delete from GxQscripts where name = 'GetMailboxAppIdsForAddin'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetMailboxAppIdsForAddin')
	delete from GXDBVersions where aliasname = 'GetMailboxAppIdsForAddin'
GO

insert into GXDBVersions values(2, 'GetMailboxAppIdsForAddin',  '00010017004600020000', 'GetMailboxAppIdsForAddin', '00010017004600020000')
GO

