

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetMailBoxPath.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- 	+-----------------------------------------------------------------------+
--	| 			Procedure : "GetMailBoxPath"	|
--	|This Procedure is used to get browse path by given userId or mailboxguid.	|
-- 	+-----------------------------------------------------------------------+
-- Following Line Indicates new Class.  It should be identical to filename+revision!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetMailBoxPath <<<'

IF EXISTS (select * from sysobjects where name='GetMailBoxPath')
	drop procedure GetMailBoxPath
IF EXISTS (select * from GxQscripts where name='GetMailBoxPath')
	delete from GxQscripts where name = 'GetMailBoxPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetMailBoxPath')
	delete from GXDBVersions where aliasname = 'GetMailBoxPath'
GO
print '... Creating Procedure: GetMailBoxPath'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetMailBoxPath
  @i_userId integer =0,
  @i_mailboxGuid nvarchar(255) = ''
--	The next lines are the columns, in order, that will be in the
--  result set for this cursor.  EXTREME CAUTION must be exercised to
--  ensure that these match up with the result set in terms of type, size,
--  and order!
--************************************************************************
--	NEW ITEMS MAY ONLY BE ADDED AT THE END OF THE :OUT LIST!!!!!!!!!!!!!!
--	This is because some code (myIndicator) uses a hardcoded index # into
--	this list for certain items, so if an item is inserted before them,
--	the index # will reference the wrong item and we will get the wrong
--	data to send to the GUI!
--************************************************************************
AS
  DECLARE @o_path VARCHAR(MAX)
  DECLARE @o_mailboxGuid VARCHAR(MAX)
	DECLARE @email nvarchar(255) = ''
	DECLARE @userGuid as nvarchar(255) = ''
	IF(@i_userId <> 0)
	BEGIN
		SET @userGuid = (SELECT top 1 userGuid FROM UMUsers WHERE id = @i_userId)
		SET @email= (SELECT TOP 1 email FROM UMUsers where id = @i_userId)
		SET  @o_mailboxGuid = '{' +  REPLACE(@userGuid,'-','X') + '}'
	END
	ELSE
	BEGIN
		SET  @userGuid = REPLACE(REPLACE(REPLACE(@i_mailboxGuid,'X','-'),'{',''),'}','')
		SET @o_mailboxGuid = @i_mailboxGuid
		SET @email= (SELECT TOP 1 email FROM UMUsers where userGuid = @userGuid)
	END
 SELECT @o_path = attrName
      FROM App_ComponentProp cp
    INNER JOIN APP_SubClientProp sp on sp.id = cp.componentId and sp.modified = 0
 WHERE  stringVal  = @email and cp.modified = 0
SELECT 	@o_path as o_path ,@o_mailboxGuid as o_mailboxGuid
SET NOCOUNT OFF
GO
-- Tell the AWK processor that there are no more input lines to scan

IF EXISTS (select * from GxQscripts where name = 'GetMailBoxPath')
	delete from GxQscripts where name = 'GetMailBoxPath'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetMailBoxPath')
	delete from GXDBVersions where aliasname = 'GetMailBoxPath'
GO

insert into GXDBVersions values(2, 'GetMailBoxPath',  '00000000000000000000', 'GetMailBoxPath', '00000000000000000000')
GO

