

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetMIFIDMonitoringPolicyProp.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetMIFIDMonitoringPolicyProp.sp,v $ $Id: GetMIFIDMonitoringPolicyProp.sp,v 1.1.2.6 2018/02/16 06:34:34 bkharabe Exp $";
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: GetMIFIDMonitoringPolicyProp <<<'

IF EXISTS (select * from sysobjects where name='GetMIFIDMonitoringPolicyProp')
	drop procedure GetMIFIDMonitoringPolicyProp
IF EXISTS (select * from GxQscripts where name='GetMIFIDMonitoringPolicyProp')
	delete from GxQscripts where name = 'GetMIFIDMonitoringPolicyProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetMIFIDMonitoringPolicyProp')
	delete from GXDBVersions where aliasname = 'GetMIFIDMonitoringPolicyProp'
GO
print '... Creating Procedure: GetMIFIDMonitoringPolicyProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure GetMIFIDMonitoringPolicyProp
  @i_subclientId INTEGER
AS
  DECLARE @r_xml varchar(MAX)
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @errorCode INT = 0
DECLARE @monitoringPolicyId INT= (Select top 1 attrval from App_subclientPRop where componentNameId=@i_subclientId and attrName ='AnalyticsMonitoringPolicyId' and modified=0)
IF(@monitoringPolicyId IS NULL)
	RETURN
DECLARE @archGroupId INTEGER=(SELECT dataArchGrpID from APP_Application  where id=@i_subclientId)
DECLARE @clientId INTEGER = (SELECT clientId from DM2SearchServerCoreInfo WHERE cloudId = (select cloudId from archContentIndexingRules WHERE archGroupId=@archGroupId AND operationType = 1))
DECLARE @cloudId INTEGER =(SELECT S.cloudId from DM2SearchServerCoreInfo S
												JOIN DM2CloudCoreRole ON S.CloudId=DM2CloudCoreRole.CloudId and roleId=3
								where clientId=@clientId )
DECLARE @archiveSubclientId INTEGER = (select attrVal from APP_MonitoringPolicyProp where monitorPolicyId=@monitoringPolicyId and attrName = 'SubClient Id')
DECLARE @stublocation NVARCHAR(MAX) = (Select fileName FROM APP_ScFilterFile where componentNameId=@archiveSubclientId and modified=0)
DECLARE @LMpolicyFactor INTEGER = ISNULL((select attrVal from APP_MonitoringPolicyProp where monitorPolicyId=@monitoringPolicyId and attrName='Factor'),1)
DECLARE @AgeCIdataDays INTEGER =  (select attrVal from APP_MonitoringPolicyProp where monitorPolicyId=@monitoringPolicyId and attrName = 'age ci data after days')
--Copied code from  LMGetUnloadedCoresTimeInterval.sp. any change in that stored proc should be taken care
DECLARE @midNightDate DATETIME
SET @midNightDate = ( SELECT Convert(DATETIME, DATEDIFF(DAY, 0,GETUTCDATE())))
SELECT CAST((SELECT @cloudId as '@cloudId',
										(
SELECT monitorPolicyId as'@monitoringPolicyid',MonitorPolicyName as '@monitoringPolicyName',@LMpolicyFactor as '@factor',
					@stublocation as '@dumpLocation',
					@archiveSubclientId as '@subClientId',
	(SELECT   templateXml as '@LMTemplateXML',
		(SELECT APP_Template.templateId as '@templateId',templateName as '@templateName'
				FOR XML PATH('LMTemplateEntity'),TYPE)
	 FROM APP_Template JOIN APP_MonitorTemplateAssoc ON APP_Template.templateId=APP_MonitorTemplateAssoc.templateId where monitorPolicyId=@monitoringPolicyId
	 FOR XML PATH('LMTemplatesXml'),TYPE),
	  (SELECT @AgeCIdataDays as '@ageCIDataAfterDays'
		FOR XML PATH('dataCapturingOptions'),TYPE),
		(SELECT requestedTbl.StartTime AS '@startPeriod', requestedTbl.endTime AS '@endPeriod'
            FROM
            (
                SELECT startTime,
                        endTime
                FROM App_LmCoreReqInfo reqTbl
                WHERE reqTbl.policyId = @monitoringPolicyId
                UNION all
                SELECT dbo.GetUnixTime( dateadd(day, - CONVERT(INT,propTbl.attrVal),@midNightDate)) as startTime,
                       dbo.GetUnixTime(@midNightDate) as endTime
                FROM APP_MonitoringPolicyProp propTbl WITH(NOLOCK)
                WHERE propTbl.attrName LIKE 'age ci data after days' AND propTbl.monitorPolicyId = @monitoringPolicyId
            ) AS requestedTbl
            order by requestedTbl.StartTime asc
			 FOR XML PATH('requestedTimeRange'),TYPE)
FROM APP_MonitoringPolicy where monitorPolicyId= @monitoringPolicyId
FOR XML PATH('policy'),TYPE) ,
(SELECT  APP_client.id as '@clientId' ,name as '@clientName'
	 FROM APP_client where APP_client.id=(SELECT clientId from APP_application where id=@i_subclientId)
	FOR XML PATH('client'),TYPE
)
FOR XML PATH('MIFID_policyResponse')) AS VARCHAR(MAX))
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'GetMIFIDMonitoringPolicyProp')
	delete from GxQscripts where name = 'GetMIFIDMonitoringPolicyProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetMIFIDMonitoringPolicyProp')
	delete from GXDBVersions where aliasname = 'GetMIFIDMonitoringPolicyProp'
GO

insert into GXDBVersions values(2, 'GetMIFIDMonitoringPolicyProp',  '00010001000200060000', 'GetMIFIDMonitoringPolicyProp', '00010001000200060000')
GO

