

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetLogOnlyAndDefaultSC.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 2014  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
--		  Procedure Name :GetLogOnlyAndDefaultSC
--		  Get Log Only and default subclient IDs for a given client ID.
--
-- ----------------------------------------------------------------------*/
 SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='GetLogOnlyAndDefaultSC')
BEGIN
	print '>>> Drop Stored Procedure: GetLogOnlyAndDefaultSC <<<'
	drop procedure GetLogOnlyAndDefaultSC
END
IF EXISTS (select * from GxQscripts where name='GetLogOnlyAndDefaultSC')
	delete from GxQscripts where name = 'GetLogOnlyAndDefaultSC'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetLogOnlyAndDefaultSC')
	delete from GXDBVersions where aliasname = 'GetLogOnlyAndDefaultSC'
GO
print '... Creating Procedure: GetLogOnlyAndDefaultSC'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure GetLogOnlyAndDefaultSC
  @xmlText XML
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @xmlResult		XML
	DECLARE @clientId		INT
	DECLARE	@appTypeId		INT
	DECLARE @instanceId		INT
	--SET @xmlText = N'<Ida_GetLogOnlyAndDefaultSubclientReq><instance _type_="5" applicationId="61" clientId="4" instanceId="5"/></Ida_GetLogOnlyAndDefaultSubclientReq>'
	SET @clientId =    ISNULL((SELECT  ref.value('@clientId', 'int')
							 FROM    @xmlText.nodes('Ida_GetLogOnlyAndDefaultSubclientReq/instance') R ( ref )),0)
	SET @appTypeId =	ISNULL((SELECT ref.value('@applicationId', 'int')
								FROM	@xmlText.nodes('Ida_GetLogOnlyAndDefaultSubclientReq/instance') R(ref)), 0)
	SET @instanceId =	ISNULL((SELECT ref.value('@instanceId', 'int')
								FROM	@xmlText.nodes('Ida_GetLogOnlyAndDefaultSubclientReq/instance') R(ref)), 0)
	IF @clientId = 0 OR @appTypeId = 0
	BEGIN
		SET @xmlResult = '<Ida_GetLogOnlyAndDefaultSubclientResp/>'
	END
	ELSE
	BEGIN
		DECLARE @SCTable TABLE (instanceID INT, logOnlyScID INT, defaultScId INT, clientID INT, backupsetID INT, appTypeId INT)
		DECLARE @NoContentSCs TABLE (scID INT)
		DECLARE @RACNodePrecedence TABLE (instanceId INT, subClientId INT, clientID INT, racMapId INT, streams INT,
											precedence INT, clientMangledName nvarchar(MAX) )
		DECLARE @subclientPriority TABLE (clientID INT, instanceID INT, backupsetID INT, subclientID INT, priority INT, subclientStatus INT)
		INSERT INTO @SCTable (instanceID, clientID, backupsetID, appTypeId)
		SELECT	DISTINCT I.id, A.clientId, A.backupSet, A.appTypeId
		FROM	APP_InstanceName I
				INNER JOIN APP_Application A ON I.id = A.instance
		WHERE	A.clientId = @clientId
AND	A.appTypeId  IN (3, 22, 61, 80, 64)
			AND	((@instanceId = 0 AND @appTypeId = A.appTypeId) OR I.id = @instanceId)
AND ((I.status & 0x00010) != 0x00010) AND ((I.status & 0x00004) != 0x00004) AND ((I.status & 0x00002) != 0x00002)
			--AND ((I.status & 0x00010) != 0x00010) AND ((I.status & 0x00004) != 0x00004) AND ((I.status & 0x00002) != 0x00002)
		INSERT INTO @SCTable (instanceID, clientID, backupsetID, appTypeId)
		SELECT	DISTINCT I.id, A.clientId, A.backupSet, A.appTypeId
		FROM	APP_InstanceName I
			INNER JOIN APP_Application A ON I.id = A.instance
			INNER JOIN APP_VMToPMMap M ON A.clientId = M.VMClientId
		WHERE	M.PMClientId = @clientId
AND	 A.appTypeId IN (3, 22, 61, 80, 64)
			AND	((@instanceId = 0 AND @appTypeId = A.appTypeId) OR I.id = @instanceId)
AND ((I.status & 0x00010) != 0x00010) AND ((I.status & 0x00004) != 0x00004) AND ((I.status & 0x00002) != 0x00002)
			--AND ((I.status & 0x00010) != 0x00010) AND ((I.status & 0x00004) != 0x00004) AND ((I.status & 0x00002) != 0x00002)
		-- Set the correct appTypeId. During restore, Oracle may not have the correct appTypeId of the source and always defaults to CV_APPTYPE_ORACLE8
		-- Following will ensure that we always use the appTypeId corresponding to instance and thus ensuring SP will send the results cotrrectly
		IF @instanceId <> 0
		BEGIN
			SELECT TOP 1 @appTypeId = ISNULL(appTypeId,0) from @SCTable
		END
		-- Oracle RAC
IF @appTypeId = 80
		BEGIN
			INSERT INTO @SCTable (instanceID, clientID, backupsetID, appTypeId)
			SELECT	DISTINCT I.id, A.clientId, A.backupSet, A.appTypeId
			FROM	APP_OracleRacInstance O
				INNER JOIN APP_InstanceName I ON O.instaceId = I.id
				INNER JOIN APP_Application A ON I.id = A.instance
			WHERE	O.clientId = @clientId
				AND	A.appTypeId = @appTypeId
				AND	(@instanceId = 0 OR I.id = @instanceId)
AND ((I.status & 0x00010) != 0x00010) AND ((I.status & 0x00004) != 0x00004) AND ((I.status & 0x00002) != 0x00002)
				--AND ((I.status & 0x00010) != 0x00010) AND ((I.status & 0x00004) != 0x00004) AND ((I.status & 0x00002) != 0x00002)
		END
		-- MongoDB Big Data Apps
IF @appTypeId = 64
		BEGIN
			INSERT INTO @SCTable (instanceID, clientID, backupsetID, appTypeId)
			SELECT	DISTINCT I.id, A.clientId, A.backupSet, A.appTypeId
			FROM	APP_MongoDbAssociation O
				INNER JOIN APP_InstanceName I ON O.instanceId = I.id
				INNER JOIN APP_Application A ON I.id = A.instance
			WHERE	O.clientId = @clientId
				AND	A.appTypeId = @appTypeId
				AND	(@instanceId = 0 OR I.id = @instanceId)
AND ((I.status & 0x00010) != 0x00010) AND ((I.status & 0x00004) != 0x00004) AND ((I.status & 0x00002) != 0x00002)
				--AND ((I.status & 0x00010) != 0x00010) AND ((I.status & 0x00004) != 0x00004) AND ((I.status & 0x00002) != 0x00002)
		END
-- SAP HANA
IF @appTypeId = 135
	-- For HANA we should include only subclients that are either Indexing V2 enabled or can be upgraded to Indexing V2.
	-- So we compute a list of clients that are using Indexing V1 and check how many of these have snap enabled.
	-- All the clients that use IndexingV1 and have snap enabled are populated in #invalidHANAClientList and are excluded from the result.
	BEGIN
		IF OBJECT_ID(N'tempdb.dbo.#invalidHANAClientList') IS NOT NULL DROP TABLE #invalidHANAClientList
		IF OBJECT_ID(N'tempdb.dbo.#HANAClientList') IS NOT NULL DROP TABLE #HANAClientList
		CREATE TABLE #invalidHANAClientList (ClientId INT)
		CREATE TABLE #HANAClientList (ClientId INT)
		-- Insert all HANA pseudo clients to #HANAClientList
		INSERT INTO #HANAClientList
		SELECT  DISTINCT C.id as 'ClientId'
		FROM
			APP_Client C WITH (NOLOCK)
			INNER JOIN APP_Application A WITH (NOLOCK) ON A.clientId = C.id
			INNER JOIN APP_InstanceName I WITH (NOLOCK) ON A.instance = I.id
			INNER JOIN APP_InstanceProp IP WITH (NOLOCK)
				ON I.id = IP.componentNameId
			CROSS APPLY dbo.SplitString(IP.attrVal, '+') S
				WHERE IP.attrName = N'Database Clients' AND IP.modified = 0 AND S.Data = @clientId
AND ((I.status & 0x00010) != 0x00010) AND ((I.status & 0x00004) != 0x00004) AND ((I.status & 0x00002) != 0x00002)
				-- AND ((I.status & 0x00010) != 0x00010) AND ((I.status & 0x00004) != 0x00004) AND ((I.status & 0x00002) != 0x00002)
		-- Check which of these clients has snap enabled
		INSERT INTO #invalidHANAClientList
			SELECT DISTINCT APP.clientId FROM APP_Application APP WITH(NOLOCK)
			INNER JOIN APP_SubClientProp SCP WITH(NOLOCK) ON SCP.componentNameId = APP.id
			INNER JOIN #HANAClientList HCL WITH(NOLOCK) ON HCL.ClientId = APP.clientId
WHERE APP.appTypeId = 135 AND SCP.attrName = N'Enable Snap Backups' AND SCP.modified = 0
				AND SCP.cs_attrName = CHECKSUM(N'Enable Snap Backups') AND SCP.attrVal = 1
		-- Check which of the Snap enabled clients have indexing V2 enabled and delete them from invalid list.
		DELETE FROM #invalidHANAClientList WHERE ClientId IN
		(
	 		SELECT HCL.CLientId FROM #invalidHANAClientList HCL
	 		INNER JOIN APP_ClientProp CP
	 		ON CP.componentNameId = HCL.ClientId
	 		WHERE AttrName = N'IndexingV2_SAPHANA' AND attrVal=1 AND modified=0
		)
		DELETE FROM #HANAClientList WHERE ClientId IN (SELECT ClientId FROM #invalidHANAClientList)
		INSERT INTO @SCTable (instanceID, clientID, backupsetID, appTypeId)
		SELECT  DISTINCT A.instance, A.clientId, A.backupSet, A.appTypeId
		FROM	#HANAClientList HCL
		INNER JOIN APP_Application A ON A.clientId = HCL.ClientId
WHERE A.appTypeId = @appTypeId AND @appTypeId = 135
AND ((A.subclientStatus & 0x1000) = 0x1000) AND ((A.subclientStatus & 0x00020) != 0x00020)
		-- AND ((A.subclientStatus & 0x1000)= 0x1000) AND ((A.subclientStatus & 0x00020) != 0x00020)
		DROP TABLE #HANAClientList
		DROP TABLE #invalidHANAClientList
	END
		--Get the list of eligible subclient ids
		INSERT	INTO @subclientPriority (clientID, instanceID, backupsetID, subclientID, priority, subclientStatus)
		SELECT	A.clientId, A.instance, A.backupSet, A.id, 0, A.subclientStatus
		FROM	APP_Application A
			INNER JOIN @SCTable SC
				ON A.instance = SC.instanceID AND A.clientId = SC.clientID
			LEFT OUTER JOIN APP_SubClientProp SCP
				ON (A.id = SCP.componentNameId AND SCP.attrName = 'Is Turbo Subclient' AND SCP.modified = 0)
		WHERE	ISNULL(SCP.attrVal, '0') <> '1'
AND	((A.subclientStatus & 0x00010) != 0x00010) AND ((A.subclientStatus & 0x00004) != 0x00004) AND ((A.subclientStatus & 0x00002) != 0x00002)
AND ( @appTypeId <> 3  OR (A.subclientStatus & 0x0040) = 0x0040 ) --fetch only commandline subclients for Informix appType
		--Get default subclient id
		UPDATE	@SCTable
		SET		defaultScId = A.subclientID
		FROM	@SCTable S
			INNER JOIN @subclientPriority A
				ON S.backupsetID = A.backupsetID
WHERE	(A.subclientStatus & 0x00008) = 0x00008		--0x00008
OR 	( @appTypeId = 3 AND (A.subclientStatus & 0x0040) = 0x0040  )  --0x0040
		INSERT INTO @NoContentSCs
		SELECT	A.subclientID
		FROM	@subclientPriority A
			INNER JOIN APP_InstanceName I
				ON A.instanceID = I.id
			INNER JOIN @SCTable S
				ON I.id = S.instanceId
			LEFT OUTER JOIN oracleObjects O
				ON O.subClientId = A.subclientID
		WHERE	O.id IS NULL
		/*******************************************************************************************
			For Informix we will discard OSC if instance or client not associated but only associated with
			a particular subclient like default or user created subclient
			OSC logs with sweep are only supported when schedule is associated iwth instance
		**********************************************************************************************/
IF @appTypeId = 3
		BEGIN
			DELETE @SCTable
				FROM   @SCTable SC
						INNER JOIN TM_AssocEntity TA
							ON TA.clientId = SC.clientID AND TA.instanceId = SC.instanceId AND TA.exclude = 0
						INNER JOIN TM_Task T
							ON TA.taskId = T.taskId AND T.deleted = 0 AND T.invalid = 0 AND T.uninstalled = 0 AND T.disabled = 0
						INNER JOIN TM_SubTask S
							ON T.taskId = S.taskId
						INNER JOIN TM_PatternAssoc PA
							ON PA.subTaskId = S.subTaskId
						INNER JOIN TM_Pattern P
							ON PA.patternId = P.patternId AND P.freq_type = 1024
						INNER JOIN TM_SubTaskOptions SO ON S.subTaskId = SO.subTaskId AND SO.optionId = 458405394 --BACKUPOPTION_BACKUP_LEVEL
				WHERE SO.value <> '4' AND TA.subclientId <> 0 AND SC.defaultScId <> TA.subclientId
		END
		/*
			Rules to calculate subclient priority:
			1. Subclients which are directly associated to the subclient policy at the subclient level have the highest priority
				a. If multiple subclients are associated 'ArchiveLog' subclient to be assumed high priority
				b. If single subclient, it will be picked up for processing.
			2. If ArchiveLog subclient exists, that will be picked up next.
			3. If schedule policy is not associated at the subclient level and there is no ArchiveLog subclient
				a. If there are any 'Log only' subclients, they will be picked up.
				b. If there are no 'Log only' subclients, default subclient will be picked up.
		*/
		UPDATE	@subclientPriority
		SET		priority = 10
		FROM	@subclientPriority SC
			INNER JOIN TM_Associations TA -- Use view to get plan level associations
				ON TA.clientId = SC.clientID AND TA.instanceId = SC.instanceId AND TA.subclientId = SC.subclientID AND TA.exclude = 0
			INNER JOIN TM_Task T
				ON TA.taskId = T.taskId AND T.deleted = 0 AND T.invalid = 0 AND T.uninstalled = 0 AND T.disabled = 0
			INNER JOIN TM_SubTask S
				ON T.taskId = S.taskId
			INNER JOIN TM_PatternAssoc PA
				ON PA.subTaskId = S.subTaskId
			INNER JOIN TM_Pattern P
				ON PA.patternId = P.patternId AND P.freq_type = 1024
			LEFT OUTER JOIN TM_SubTaskOptions SO ON S.subTaskId = SO.subTaskId AND SO.optionId = 458405394 --BACKUPOPTION_BACKUP_LEVEL
		WHERE SO.value <> '4'
		UPDATE	@subclientPriority
		SET		priority = priority + 5
		FROM	@subclientPriority
WHERE	(subclientStatus & 0x40000) = 0x40000
OR (@appTypeId = 135 AND (subclientStatus & 0x1000) = 0x1000 AND ((subclientStatus & 0x00020) != 0x00020))
OR (@appTypeId = 3 AND (subclientStatus & 0x0040) = 0x0040)
		UPDATE	@subclientPriority
		SET		priority = priority + 1
		FROM	@subclientPriority S
				INNER JOIN @NoContentSCs N ON S.subclientId = N.scID
				INNER JOIN APP_SubClientProp SC1
					ON S.subclientId = SC1.componentNameId AND SC1.attrName = 'Oracle Backup Mode'
				LEFT OUTER JOIN APP_SubClientProp SC2
					ON S.subclientId = SC2.componentNameId AND SC2.attrName = 'Backup Archive Log'
		WHERE	SC1.attrVal = '1' AND SC1.modified = 0
			AND	ISNULL(SC2.attrVal, '1') = '1' AND ISNULL(SC2.modified, 0) = 0
		UPDATE	@SCTable
		SET		logOnlyScID = S.subclientId
		FROM	@SCTable SC
			INNER JOIN (SELECT SP.clientID, SP.instanceID, SP.backupsetID, SP.subclientID, ROW_NUMBER() over (partition by SP.clientId, SP.instanceId, SP.backupsetID order by SP.priority desc, subclientID asc) as rowId FROM @subclientPriority SP) S
				ON SC.clientId = S.clientID AND SC.instanceId = S.instanceId AND SC.backupsetID = S.backupsetID AND S.rowId = 1
		-- Calculate RAC Node precedence for each instance
		IF @instanceId <> 0
		BEGIN
			INSERT INTO @RACNodePrecedence(instanceId, subclientId, racMapId, streams, precedence)
			SELECT	IT.instanceId,
					IT.subClientId,
					SUM(CASE WHEN IT.ID2 = 1 THEN CAST(IT.Data AS INT) ELSE 0 END) AS racMapId,
					SUM(CASE WHEN IT.ID2 = 2 THEN CAST(IT.Data AS INT) ELSE 0 END) AS streams,
					SUM(CASE WHEN IT.ID2 = 3 THEN CAST(IT.Data AS INT) ELSE 0 END) AS precedence
			FROM
			(
				SELECT	DISTINCT I.instanceId, CASE WHEN (ISNULL(I.logOnlyScID, 0) = 0) THEN I.defaultScId ELSE I.logOnlyScID END as subClientId, E.Id as ID1, P.Id AS ID2, P.Data
				FROM	@SCTable I
						INNER JOIN APP_Application A ON I.instanceId = A.instance
								AND A.id = (CASE WHEN (ISNULL(I.logOnlyScID, 0) = 0) THEN I.defaultScId ELSE I.logOnlyScID END)
						INNER JOIN APP_SubClientProp S ON A.id = S.componentNameId
						CROSS APPLY dbo.SplitString(S.attrVal, '+') E
						CROSS APPLY dbo.SplitString(E.Data, ' ') P
				WHERE	A.appTypeId = 80
					AND	S.attrName = 'Oracle RAC Log Properties'
					AND	S.modified = 0
			) AS IT
			GROUP BY IT.instanceId, IT.subClientId, IT.ID1
			UPDATE	R
			SET		R.clientID = O.clientId,
					R.clientMangledName = c.net_hostname + N'*' + c.name + N'*' +
								CAST(c.cvdPort AS NVARCHAR(8)) + N'*' + CAST(c.evmgrcPort as NVARCHAR(8))
			FROM	@RACNodePrecedence R
					INNER JOIN APP_OracleRacInstance O ON O.id = R.racMapId
					INNER JOIN APP_Client c ON c.id = O.clientID
		END
		SET @xmlResult = ( SELECT	S.clientID 'client/@clientId',
									S.instanceId 'instance/@instanceId',
									ISNULL(S.logOnlyScID, 0) 'logOnlySubclient/@subclientId',
									ISNULL(S.defaultScId, 0) 'defaultSubclient/@subclientId',
									(	SELECT R.clientId '@clientID', R.streams '@streams',
											R.precedence '@precedence', R.clientMangledName '@clientMangledName'
										FROM @RACNodePrecedence R
										WHERE R.instanceId = S.instanceId
											AND R.subclientId = (CASE WHEN ISNULL(S.logOnlyScID, 0) = 0 THEN
													S.defaultScId ELSE S.logOnlyScID END)
										FOR XML PATH('racNodes'), TYPE )
							FROM	@SCTable S
							FOR XML PATH('subclients'),
							ROOT ('Ida_GetLogOnlyAndDefaultSubclientResp'))
		IF @xmlResult IS NULL
			SET @xmlResult = '<Ida_GetLogOnlyAndDefaultSubclientResp/>'
	END
	SELECT @xmlResult AS ReturnResult
END
GO

IF EXISTS (select * from GxQscripts where name = 'GetLogOnlyAndDefaultSC')
	delete from GxQscripts where name = 'GetLogOnlyAndDefaultSC'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetLogOnlyAndDefaultSC')
	delete from GXDBVersions where aliasname = 'GetLogOnlyAndDefaultSC'
GO

insert into GXDBVersions values(2, 'GetLogOnlyAndDefaultSC',  '00000000000000000000', 'GetLogOnlyAndDefaultSC', '00000000000000000000')
GO

