

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/GetLogArchGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/GetLogArchGroup.sp,v $ $Id: GetLogArchGroup.sp,v 1.1.2.2 2019/03/20 22:03:33 prasanthm Exp $";
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='GetLogArchGroup')
BEGIN
	print '>>> Drop Stored Procedure: GetLogArchGroup <<<'
	drop procedure GetLogArchGroup
END
IF EXISTS (select * from GxQscripts where name='GetLogArchGroup')
	delete from GxQscripts where name = 'GetLogArchGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetLogArchGroup')
	delete from GXDBVersions where aliasname = 'GetLogArchGroup'
GO
print '... Creating Procedure: GetLogArchGroup'
GO
SET QUOTED_IDENTIFIER OFF
GO
create procedure GetLogArchGroup
  @i_OldDataArchGroupId int,
  @i_NewDataArchGroupId int,
  @i_oldLogArchGroupIdAPPLevel int = 0
AS
  DECLARE @o_logArchGroupId int
DECLARE @logSPAtOldSPLevel INT = 0
DECLARE @logSPAtNewSPLevel INT = 0
DECLARE @ResultLogSP INT = 0
SELECT @logSPAtNewSPLevel = logSP FROM archGroup WITH (NOLOCK) where id = @i_NewDataArchGroupId
SELECT @logSPAtOldSPLevel = logSP FROM archGroup WITH (NOLOCK) where id = @i_OldDataArchGroupId
/*
		1) If new data storage policy is not associated with log sp then keep the old log SP as it is.
		2) If Log SP selected in application level and old data SP level are different then the log SP is changed from Application level intentionally, so keep old log SP as it is.
		3) If Log SP selected in application level and old data SP level are same and new data SP associated with different log SP then return new log SP
*/
IF @logSPAtNewSPLevel > 0 AND ( @logSPAtOldSPLevel = @i_oldLogArchGroupIdAPPLevel  OR @i_oldLogArchGroupIdAPPLevel = @i_OldDataArchGroupId)
BEGIN
	SET @ResultLogSP = @logSPAtNewSPLevel
END
ELSE IF @logSPAtOldSPLevel <> @i_oldLogArchGroupIdAPPLevel AND @i_oldLogArchGroupIdAPPLevel <> @i_OldDataArchGroupId
BEGIN
	SET @ResultLogSP = @i_oldLogArchGroupIdAPPLevel
END
ELSE
BEGIN
	SET @ResultLogSP = @i_NewDataArchGroupId
END
SELECT @ResultLogSP
GO

IF EXISTS (select * from GxQscripts where name = 'GetLogArchGroup')
	delete from GxQscripts where name = 'GetLogArchGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='GetLogArchGroup')
	delete from GXDBVersions where aliasname = 'GetLogArchGroup'
GO

insert into GXDBVersions values(2, 'GetLogArchGroup',  '00010001000200020000', 'GetLogArchGroup', '00010001000200020000')
GO

